/*
 * Decompiled with CFR 0.152.
 */
package drivers.tecnofire;

import com.hsyco.Configuration;
import com.hsyco.user;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

class TecnoOut {
    private String serverName = null;
    private String userCode;
    private byte[] ive;
    private byte[] ivd;
    private int bye = 0;
    private int byd = 0;
    private InetSocketAddress address = null;
    private byte[] passPhrase = new byte[16];
    private Cipher cipher = null;
    private Cipher decipher = null;
    private Socket sock = null;
    private BufferedInputStream bin = null;
    private BufferedOutputStream bout = null;
    private boolean log = false;
    private static final int[] CRCTABLE;

    static {
        int[] nArray = new int[256];
        nArray[1] = 49345;
        nArray[2] = 49537;
        nArray[3] = 320;
        nArray[4] = 49921;
        nArray[5] = 960;
        nArray[6] = 640;
        nArray[7] = 49729;
        nArray[8] = 50689;
        nArray[9] = 1728;
        nArray[10] = 1920;
        nArray[11] = 51009;
        nArray[12] = 1280;
        nArray[13] = 50625;
        nArray[14] = 50305;
        nArray[15] = 1088;
        nArray[16] = 52225;
        nArray[17] = 3264;
        nArray[18] = 3456;
        nArray[19] = 52545;
        nArray[20] = 3840;
        nArray[21] = 53185;
        nArray[22] = 52865;
        nArray[23] = 3648;
        nArray[24] = 2560;
        nArray[25] = 51905;
        nArray[26] = 52097;
        nArray[27] = 2880;
        nArray[28] = 51457;
        nArray[29] = 2496;
        nArray[30] = 2176;
        nArray[31] = 51265;
        nArray[32] = 55297;
        nArray[33] = 6336;
        nArray[34] = 6528;
        nArray[35] = 55617;
        nArray[36] = 6912;
        nArray[37] = 56257;
        nArray[38] = 55937;
        nArray[39] = 6720;
        nArray[40] = 7680;
        nArray[41] = 57025;
        nArray[42] = 57217;
        nArray[43] = 8000;
        nArray[44] = 56577;
        nArray[45] = 7616;
        nArray[46] = 7296;
        nArray[47] = 56385;
        nArray[48] = 5120;
        nArray[49] = 54465;
        nArray[50] = 54657;
        nArray[51] = 5440;
        nArray[52] = 55041;
        nArray[53] = 6080;
        nArray[54] = 5760;
        nArray[55] = 54849;
        nArray[56] = 53761;
        nArray[57] = 4800;
        nArray[58] = 4992;
        nArray[59] = 54081;
        nArray[60] = 4352;
        nArray[61] = 53697;
        nArray[62] = 53377;
        nArray[63] = 4160;
        nArray[64] = 61441;
        nArray[65] = 12480;
        nArray[66] = 12672;
        nArray[67] = 61761;
        nArray[68] = 13056;
        nArray[69] = 62401;
        nArray[70] = 62081;
        nArray[71] = 12864;
        nArray[72] = 13824;
        nArray[73] = 63169;
        nArray[74] = 63361;
        nArray[75] = 14144;
        nArray[76] = 62721;
        nArray[77] = 13760;
        nArray[78] = 13440;
        nArray[79] = 62529;
        nArray[80] = 15360;
        nArray[81] = 64705;
        nArray[82] = 64897;
        nArray[83] = 15680;
        nArray[84] = 65281;
        nArray[85] = 16320;
        nArray[86] = 16000;
        nArray[87] = 65089;
        nArray[88] = 64001;
        nArray[89] = 15040;
        nArray[90] = 15232;
        nArray[91] = 64321;
        nArray[92] = 14592;
        nArray[93] = 63937;
        nArray[94] = 63617;
        nArray[95] = 14400;
        nArray[96] = 10240;
        nArray[97] = 59585;
        nArray[98] = 59777;
        nArray[99] = 10560;
        nArray[100] = 60161;
        nArray[101] = 11200;
        nArray[102] = 10880;
        nArray[103] = 59969;
        nArray[104] = 60929;
        nArray[105] = 11968;
        nArray[106] = 12160;
        nArray[107] = 61249;
        nArray[108] = 11520;
        nArray[109] = 60865;
        nArray[110] = 60545;
        nArray[111] = 11328;
        nArray[112] = 58369;
        nArray[113] = 9408;
        nArray[114] = 9600;
        nArray[115] = 58689;
        nArray[116] = 9984;
        nArray[117] = 59329;
        nArray[118] = 59009;
        nArray[119] = 9792;
        nArray[120] = 8704;
        nArray[121] = 58049;
        nArray[122] = 58241;
        nArray[123] = 9024;
        nArray[124] = 57601;
        nArray[125] = 8640;
        nArray[126] = 8320;
        nArray[127] = 57409;
        nArray[128] = 40961;
        nArray[129] = 24768;
        nArray[130] = 24960;
        nArray[131] = 41281;
        nArray[132] = 25344;
        nArray[133] = 41921;
        nArray[134] = 41601;
        nArray[135] = 25152;
        nArray[136] = 26112;
        nArray[137] = 42689;
        nArray[138] = 42881;
        nArray[139] = 26432;
        nArray[140] = 42241;
        nArray[141] = 26048;
        nArray[142] = 25728;
        nArray[143] = 42049;
        nArray[144] = 27648;
        nArray[145] = 44225;
        nArray[146] = 44417;
        nArray[147] = 27968;
        nArray[148] = 44801;
        nArray[149] = 28608;
        nArray[150] = 28288;
        nArray[151] = 44609;
        nArray[152] = 43521;
        nArray[153] = 27328;
        nArray[154] = 27520;
        nArray[155] = 43841;
        nArray[156] = 26880;
        nArray[157] = 43457;
        nArray[158] = 43137;
        nArray[159] = 26688;
        nArray[160] = 30720;
        nArray[161] = 47297;
        nArray[162] = 47489;
        nArray[163] = 31040;
        nArray[164] = 47873;
        nArray[165] = 31680;
        nArray[166] = 31360;
        nArray[167] = 47681;
        nArray[168] = 48641;
        nArray[169] = 32448;
        nArray[170] = 32640;
        nArray[171] = 48961;
        nArray[172] = 32000;
        nArray[173] = 48577;
        nArray[174] = 48257;
        nArray[175] = 31808;
        nArray[176] = 46081;
        nArray[177] = 29888;
        nArray[178] = 30080;
        nArray[179] = 46401;
        nArray[180] = 30464;
        nArray[181] = 47041;
        nArray[182] = 46721;
        nArray[183] = 30272;
        nArray[184] = 29184;
        nArray[185] = 45761;
        nArray[186] = 45953;
        nArray[187] = 29504;
        nArray[188] = 45313;
        nArray[189] = 29120;
        nArray[190] = 28800;
        nArray[191] = 45121;
        nArray[192] = 20480;
        nArray[193] = 37057;
        nArray[194] = 37249;
        nArray[195] = 20800;
        nArray[196] = 37633;
        nArray[197] = 21440;
        nArray[198] = 21120;
        nArray[199] = 37441;
        nArray[200] = 38401;
        nArray[201] = 22208;
        nArray[202] = 22400;
        nArray[203] = 38721;
        nArray[204] = 21760;
        nArray[205] = 38337;
        nArray[206] = 38017;
        nArray[207] = 21568;
        nArray[208] = 39937;
        nArray[209] = 23744;
        nArray[210] = 23936;
        nArray[211] = 40257;
        nArray[212] = 24320;
        nArray[213] = 40897;
        nArray[214] = 40577;
        nArray[215] = 24128;
        nArray[216] = 23040;
        nArray[217] = 39617;
        nArray[218] = 39809;
        nArray[219] = 23360;
        nArray[220] = 39169;
        nArray[221] = 22976;
        nArray[222] = 22656;
        nArray[223] = 38977;
        nArray[224] = 34817;
        nArray[225] = 18624;
        nArray[226] = 18816;
        nArray[227] = 35137;
        nArray[228] = 19200;
        nArray[229] = 35777;
        nArray[230] = 35457;
        nArray[231] = 19008;
        nArray[232] = 19968;
        nArray[233] = 36545;
        nArray[234] = 36737;
        nArray[235] = 20288;
        nArray[236] = 36097;
        nArray[237] = 19904;
        nArray[238] = 19584;
        nArray[239] = 35905;
        nArray[240] = 17408;
        nArray[241] = 33985;
        nArray[242] = 34177;
        nArray[243] = 17728;
        nArray[244] = 34561;
        nArray[245] = 18368;
        nArray[246] = 18048;
        nArray[247] = 34369;
        nArray[248] = 33281;
        nArray[249] = 17088;
        nArray[250] = 17280;
        nArray[251] = 33601;
        nArray[252] = 16640;
        nArray[253] = 33217;
        nArray[254] = 32897;
        nArray[255] = 16448;
        CRCTABLE = nArray;
    }

    public TecnoOut(String serverName, InetSocketAddress address, byte[] passPhrase, String code) {
        this.serverName = serverName;
        this.address = address;
        this.userCode = code;
        if (passPhrase != null) {
            this.passPhrase = passPhrase;
        }
        this.log = Configuration.verboseLog;
    }

    boolean connect() {
        try {
            byte[] a2;
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            this.ivd = iv;
            this.ive = iv;
            this.bye = 0;
            this.byd = 0;
            SecretKeySpec keySpec = new SecretKeySpec(this.passPhrase, "AES");
            this.cipher = Cipher.getInstance("AES");
            this.cipher.init(1, keySpec);
            this.decipher = Cipher.getInstance("AES");
            this.decipher.init(1, keySpec);
            this.sock = new Socket();
            this.sock.connect(this.address, 6000);
            this.sock.setSoTimeout(6000);
            this.bin = new BufferedInputStream(this.sock.getInputStream());
            this.bout = new BufferedOutputStream(this.sock.getOutputStream());
            this.skip();
            this.bout.write(iv);
            this.bout.flush();
            if (this.log) {
                StringBuffer sb = new StringBuffer();
                sb.append("TECNO OUT DRIVER [");
                sb.append(this.serverName);
                sb.append("] - SEND [ ");
                int i2 = 0;
                while (i2 < iv.length) {
                    sb.append(Integer.toHexString(iv[i2] & 0xFF).toUpperCase());
                    sb.append(' ');
                    ++i2;
                }
                sb.append("] -> [ ");
                i2 = 0;
                while (i2 < iv.length) {
                    sb.append(Integer.toHexString(iv[i2] & 0xFF).toUpperCase());
                    sb.append(' ');
                    ++i2;
                }
                sb.append("]");
                user.messageLog(sb.toString());
            }
            return (a2 = this.requestSystemStatus(1)) != null && a2.length == 31 && a2[7] == 20;
        }
        catch (Exception e2) {
            if (this.log) {
                user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - CONNECTION EXCEPTION: " + e2.getLocalizedMessage());
            }
            return false;
        }
    }

    void disconnect() {
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void skip() {
        try {
            if (this.bin.available() > 0) {
                if (this.log) {
                    user.messageLog("TECNO OUT DRIVER [" + this.serverName + "] - SKIPPING NEXT RECEIVED BLOCK...");
                }
                this.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] read() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 22[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized byte[] requestClockStatus(int address) {
        byte[] bytes = this.commandFrame(address, 73);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                if (ret.length == 17 && ret[5] == 0 && ret[6] == (byte)(address - 1)) {
                    return ret;
                }
                if (this.log) {
                    user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - INCONSISTENT REPLY [49H]");
                }
                Thread.sleep(300L);
                return null;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestSystemStatus(int address) {
        byte[] bytes = this.commandFrame(address, 64);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                if (ret.length == 31 && ret[5] == 0 && ret[6] == (byte)(address - 1)) {
                    return ret;
                }
                if (this.log) {
                    user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - INCONSISTENT REPLY [40H]");
                }
                Thread.sleep(300L);
                return null;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestModulesStatus(int address, int line, int from, int to) {
        byte[] data = new byte[]{(byte)(line & 0xFF), (byte)(from & 0xFF), (byte)(line & 0xFF), (byte)(to & 0xFF)};
        byte[] bytes = this.commandFrame(address, 66, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                if (ret.length == 2 * (to - from + 1) + 11 && ret[5] == 0 && ret[6] == (byte)(address - 1)) {
                    return ret;
                }
                if (this.log) {
                    user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - INCONSISTENT REPLY [42H]");
                }
                Thread.sleep(300L);
                return null;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestRepeatersStatus(int address, int from, int to) {
        byte[] data = new byte[]{(byte)(from & 0xFF), (byte)(to & 0xFF)};
        byte[] bytes = this.commandFrame(address, 68, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                if (ret.length == 2 * (to - from + 1) + 11 && ret[5] == 0 && ret[6] == (byte)(address - 1)) {
                    return ret;
                }
                if (this.log) {
                    user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - INCONSISTENT REPLY [44H]");
                }
                Thread.sleep(300L);
                return null;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestSensorsStatus(int address, int line, int from, int to) {
        byte[] data = new byte[]{(byte)(line & 0xFF), (byte)(from & 0xFF), (byte)(line & 0xFF), (byte)(to & 0xFF)};
        byte[] bytes = this.commandFrame(address, 65, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                if (ret.length == 2 * (to - from + 1) + 11 && ret[5] == 0 && ret[6] == (byte)(address - 1)) {
                    return ret;
                }
                if (this.log) {
                    user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - INCONSISTENT REPLY [41H]");
                }
                Thread.sleep(300L);
                return null;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestSlavesStatus(int address, int from, int to) {
        byte[] data = new byte[]{(byte)(from & 0xFF), (byte)(to & 0xFF)};
        byte[] bytes = this.commandFrame(address, 67, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                if (ret.length == 2 * (to - from + 1) + 11 && ret[5] == 0 && ret[6] == (byte)(address - 1)) {
                    return ret;
                }
                if (this.log) {
                    user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - INCONSISTENT REPLY [43H]");
                }
                Thread.sleep(300L);
                return null;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestZonesStatus(int address, int from, int to) {
        byte[] data = new byte[]{(byte)(from & 0xFF), (byte)(from >>> 8 & 0xFF), (byte)(to & 0xFF), (byte)(to >>> 8 & 0xFF)};
        byte[] bytes = this.commandFrame(address, 69, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                if (ret.length == 2 * (to - from + 1) + 11 && ret[5] == 0 && ret[6] == (byte)(address - 1)) {
                    return ret;
                }
                if (this.log) {
                    user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - INCONSISTENT REPLY [45H]");
                }
                Thread.sleep(300L);
                return null;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized int requestLogIndex() {
        byte[] bytes = this.commandFrame(1, 70);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                if (ret.length == 13 && ret[5] == 0 && ret[6] == 0) {
                    return (ret[9] & 0xFF) + 256 * (ret[10] & 0xFF);
                }
                if (this.log) {
                    user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - INCONSISTENT REPLY [46H]");
                }
                Thread.sleep(300L);
                return -1;
            }
            return -1;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    synchronized byte[] requestLog(int index) {
        byte[] data = new byte[]{(byte)(index & 0xFF), (byte)(index >>> 8 & 0xFF)};
        byte[] bytes = this.commandFrame(1, 71, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                if (ret[5] == 0 && ret[6] == 0) {
                    return ret;
                }
                if (this.log) {
                    user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - INCONSISTENT REPLY [47H]");
                }
                Thread.sleep(300L);
                return null;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized boolean commandSensorExcluded(int address, int line, int sensor, boolean exclude) {
        byte[] data = new byte[]{(byte)(line & 0xFF), (byte)(sensor & 0xFF), (byte)(exclude ? 1 : 0)};
        byte[] bytes = this.commandFrame(address, 80, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            return this.crccheck(ret) && ret[4] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized boolean commandModuleExcluded(int address, int line, int module, boolean exclude) {
        byte[] data = new byte[]{(byte)(line & 0xFF), (byte)(module & 0xFF), (byte)(exclude ? 1 : 0)};
        byte[] bytes = this.commandFrame(address, 81, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            return this.crccheck(ret) && ret[4] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized boolean commandLineExcluded(int address, int line, boolean exclude) {
        byte[] data = new byte[]{(byte)(line & 0xFF), (byte)(exclude ? 1 : 0)};
        byte[] bytes = this.commandFrame(address, 82, data);
        try {
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            return this.crccheck(ret) && ret[4] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized boolean commandSlaveExcluded(int address, int slave, boolean exclude) {
        byte[] data = new byte[]{(byte)(slave & 0xFF), (byte)(exclude ? 1 : 0)};
        byte[] bytes = this.commandFrame(address, 83, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            return this.crccheck(ret) && ret[4] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized boolean commandRepeaterExcluded(int address, int repeater, boolean exclude) {
        byte[] data = new byte[]{(byte)(repeater & 0xFF), (byte)(exclude ? 1 : 0)};
        byte[] bytes = this.commandFrame(address, 84, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            return this.crccheck(ret) && ret[4] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized boolean commandZoneExcluded(int address, int zone, boolean exclude) {
        byte[] data = new byte[]{(byte)(zone & 0xFF), (byte)(zone >>> 8 & 0xFF), (byte)(exclude ? 1 : 0)};
        byte[] bytes = this.commandFrame(address, 85, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            return this.crccheck(ret) && ret[4] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized boolean commandPanelRepeaterExcluded(int address, boolean exclude) {
        byte[] data = new byte[]{(byte)(exclude ? 1 : 0)};
        byte[] bytes = this.commandFrame(address, 86, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            return this.crccheck(ret) && ret[4] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized boolean commandClock(int address, int year, int month, int day, int hour, int minutes, int seconds) {
        byte[] data = new byte[]{(byte)(seconds & 0xFF), (byte)(minutes & 0xFF), (byte)(hour & 0xFF), (byte)(day & 0xFF), (byte)(month & 0xFF), (byte)(year & 0xFF)};
        byte[] bytes = this.commandFrame(address, 87, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            return this.crccheck(ret) && ret[4] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized int commandSilence(int address, String code) {
        byte[] data = this.operatorCommandCodeBytes(code);
        byte[] bytes = this.commandFrame(address, 88, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                if (ret[9] == 6) {
                    return ret[10];
                }
                return ret[9];
            }
            return -1;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    synchronized int commandEvacuation(int address, String code) {
        byte[] data = this.operatorCommandCodeBytes(code);
        byte[] bytes = this.commandFrame(address, 89, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                return ret[9];
            }
            return -1;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    synchronized int commandSystemReset(int address, String code) {
        byte[] data = this.operatorCommandCodeBytes(code);
        byte[] bytes = this.commandFrame(address, 90, data);
        try {
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                return ret[9];
            }
            return -1;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    synchronized int commandSirensSilenced(int address, String code, boolean silenced) {
        try {
            byte[] data = Arrays.copyOf(this.operatorCommandCodeBytes(code), 6);
            data[5] = (byte)(silenced ? 1 : 0);
            byte[] bytes = this.commandFrame(address, 91, data);
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                return ret[9];
            }
            return -1;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    synchronized int commandAttended(int address, String code, boolean attended) {
        try {
            byte[] data = Arrays.copyOf(this.operatorCommandCodeBytes(code), 6);
            data[5] = (byte)(attended ? 1 : 0);
            byte[] bytes = this.commandFrame(address, 92, data);
            this.skip();
            this.bout.write(this.encrypt(bytes));
            this.bout.flush();
            byte[] ret = this.read();
            if (this.crccheck(ret) && ret[4] == 6) {
                return ret[9];
            }
            return -1;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    private byte[] commandFrame(int address, int command) {
        byte[] frame = new byte[11];
        try {
            frame[0] = -126;
            System.arraycopy(this.userCodeBytes(this.userCode), 0, frame, 1, 3);
            frame[4] = (byte)command;
            frame[5] = 0;
            frame[6] = (byte)(address - 1);
            frame[7] = 0;
            frame[8] = 0;
            this.crcfiller(frame);
            return frame;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private byte[] commandFrame(int address, int command, byte[] data) {
        byte[] frame = new byte[data.length + 11];
        try {
            frame[0] = -126;
            System.arraycopy(this.userCodeBytes(this.userCode), 0, frame, 1, 3);
            frame[4] = (byte)command;
            frame[5] = 0;
            frame[6] = (byte)(address - 1);
            frame[7] = (byte)(data.length & 0xFF);
            frame[8] = (byte)(data.length >>> 8 & 0xFF);
            System.arraycopy(data, 0, frame, 9, data.length);
            this.crcfiller(frame);
            return frame;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private boolean crccheck(byte[] data) {
        int crc = -1;
        int i2 = 0;
        while (i2 < data.length - 2) {
            crc = (crc & 0xFFFF) >>> 8 ^ CRCTABLE[(crc & 0xFF ^ data[i2]) & 0xFF];
            ++i2;
        }
        return data[data.length - 2] == (byte)(crc & 0xFF) && data[data.length - 1] == (byte)(crc >>> 8 & 0xFF);
    }

    private void crcfiller(byte[] data) {
        int crc = -1;
        int i2 = 0;
        while (i2 < data.length - 2) {
            crc = (crc & 0xFFFF) >>> 8 ^ CRCTABLE[(crc & 0xFF ^ data[i2]) & 0xFF];
            ++i2;
        }
        data[data.length - 2] = (byte)(crc & 0xFF);
        data[data.length - 1] = (byte)(crc >>> 8 & 0xFF);
    }

    private byte[] operatorCommandCodeBytes(String code) {
        byte[] bytes = new byte[5];
        int i2 = 0;
        while (i2 < bytes.length && i2 < code.length()) {
            bytes[i2] = (byte)(code.charAt(i2) - 48);
            ++i2;
        }
        return bytes;
    }

    private byte[] userCodeBytes(String code) {
        byte[] bytes = new byte[3];
        StringBuffer sb = new StringBuffer();
        if (code != null) {
            sb.append(code);
        }
        int i2 = sb.length();
        while (i2 < 6) {
            sb.append('0');
            ++i2;
        }
        bytes[0] = (byte)((sb.charAt(1) - 48 << 4) + (sb.charAt(0) - 48));
        bytes[1] = (byte)((sb.charAt(3) - 48 << 4) + (sb.charAt(2) - 48));
        bytes[2] = (byte)((sb.charAt(5) - 48 << 4) + (sb.charAt(4) - 48));
        return bytes;
    }

    private byte[] encrypt(byte[] data) {
        try {
            byte[] ret = new byte[data.length];
            int i2 = 0;
            while (i2 < data.length) {
                if (this.bye == 0) {
                    this.ive = this.cipher.doFinal(this.ive);
                    this.bye = 16;
                }
                int n2 = 16 - this.bye;
                this.ive[n2] = (byte)(this.ive[n2] ^ data[i2]);
                ret[i2] = this.ive[16 - this.bye];
                --this.bye;
                ++i2;
            }
            if (this.log) {
                StringBuffer sb = new StringBuffer();
                sb.append("TECNO OUT DRIVER [");
                sb.append(this.serverName);
                sb.append("] - SEND [ ");
                int i3 = 0;
                while (i3 < data.length) {
                    sb.append(Integer.toHexString(data[i3] & 0xFF).toUpperCase());
                    sb.append(' ');
                    ++i3;
                }
                sb.append("] -> [ ");
                i3 = 0;
                while (i3 < ret.length) {
                    sb.append(Integer.toHexString(ret[i3] & 0xFF).toUpperCase());
                    sb.append(' ');
                    ++i3;
                }
                sb.append("]");
                user.messageLog(sb.toString());
            }
            return ret;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private byte decrypt(byte data) throws Exception {
        if (this.byd == 0) {
            this.ivd = this.decipher.doFinal(this.ivd);
            this.byd = 16;
        }
        byte ret = (byte)(this.ivd[16 - this.byd] ^ data);
        this.ivd[16 - this.byd] = data;
        --this.byd;
        return ret;
    }
}

