/*
 * Decompiled with CFR 0.152.
 */
package drivers.tecnofire;

import com.hsyco.driverBase;
import com.hsyco.hsyco;
import drivers.tecnofire.TecnoOut;
import java.net.InetSocketAddress;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 80;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private String name;
    private TecnoOut driver = null;
    private InetSocketAddress address = null;
    private int pollingTimeMillis = 1000;
    private byte[] pass = null;
    private String userCodeDefault = null;
    private int logSize = 50;
    private boolean userLogs = true;
    private boolean genEvents = false;
    private int panelLoopIndex = 1;
    private static final int PANEL_LOG_QUEUE_SIZE = 4096;
    private DecimalFormat decimalNumberFormatter = new DecimalFormat("0.#");
    private int[][] c40 = new int[16][20];
    private int[][][] c41 = new int[16][4][398];
    private int[][][] c42 = new int[16][4][198];
    private int[] c43 = new int[30];
    private int[][] c44 = new int[16][32];
    private int[][] c45 = new int[16][602];
    private int[] c49 = new int[16];
    private LinkedList<String> logQueue = new LinkedList();
    private int[] numberOfLoops = new int[16];
    private int[] numberOfRepeaters = new int[16];
    private int numberOfSlaves;
    private int[] numberOfZones = new int[16];
    private int[][] sensorMin = new int[16][4];
    private int[][] sensorMax = new int[16][4];
    private int[][] moduleMin = new int[16][4];
    private int[][] moduleMax = new int[16][4];
    private int[] repeaterMin = new int[16];
    private int[] repeaterMax = new int[16];
    private int slaveMin = -1;
    private int slaveMax = -1;
    private int logIndex = -1;
    private boolean connectionStatus = false;

    public boolean init(String name, HashMap<String, String> config) {
        int i2;
        int j2;
        super.init(name);
        this.name = name;
        int k2 = 0;
        while (k2 < this.c40.length) {
            j2 = 0;
            while (j2 < this.c40[k2].length) {
                this.c40[k2][j2] = -1;
                ++j2;
            }
            ++k2;
        }
        k2 = 0;
        while (k2 < this.sensorMin.length) {
            j2 = 0;
            while (j2 < this.sensorMin[k2].length) {
                this.sensorMax[k2][j2] = -1;
                this.sensorMin[k2][j2] = -1;
                ++j2;
            }
            ++k2;
        }
        k2 = 0;
        while (k2 < this.moduleMin.length) {
            j2 = 0;
            while (j2 < this.moduleMin[k2].length) {
                this.moduleMax[k2][j2] = -1;
                this.moduleMin[k2][j2] = -1;
                ++j2;
            }
            ++k2;
        }
        k2 = 0;
        while (k2 < this.repeaterMin.length) {
            this.repeaterMax[k2] = -1;
            this.repeaterMin[k2] = -1;
            ++k2;
        }
        String s = config.get("host");
        if (s == null) {
            this.errorLog("unrecoverable error: host not set");
            return false;
        }
        try {
            i2 = Integer.parseInt(config.get("port"));
            if (i2 < 1 || i2 > 65535) {
                throw new Exception();
            }
        }
        catch (Exception e2) {
            this.errorLog("unrecoverable error: invalid port");
            return false;
        }
        try {
            this.address = new InetSocketAddress(s, i2);
        }
        catch (Exception e3) {
            this.errorLog("unrecoverable error: host address or port error");
            return false;
        }
        s = config.get("polltime");
        if (s != null) {
            try {
                this.pollingTimeMillis = Integer.parseInt(s);
                if (i2 < 100) {
                    throw new Exception();
                }
            }
            catch (Exception e4) {
                this.errorLog("format error: polltime ignored");
            }
        }
        s = config.get("pass");
        try {
            this.pass = new byte[16];
            int j3 = 0;
            while (j3 < this.pass.length) {
                try {
                    this.pass[j3] = (byte)s.charAt(j3);
                }
                catch (Exception e5) {
                    this.pass[j3] = 0;
                }
                ++j3;
            }
        }
        catch (Exception e6) {
            this.errorLog("format error: pass ignored");
        }
        this.userCodeDefault = config.get("code");
        s = config.get("logsize");
        if (s != null) {
            try {
                int l2 = Integer.parseInt(s);
                if (l2 < 0) {
                    throw new Exception();
                }
                this.logSize = l2;
            }
            catch (Exception e7) {
                this.errorLog("format error: logsize ignored");
            }
        }
        if ((s = config.get("userlogs")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.userLogs = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.userLogs = false;
            } else {
                this.errorLog("format error: userlogs ignored");
            }
        }
        if ((s = config.get("startupevents")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.genEvents = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.genEvents = false;
            } else {
                this.errorLog("format error: startupevents ignored");
            }
        }
        this.driver = new TecnoOut(name, this.address, this.pass, this.userCodeDefault);
        return this.driver.connect();
    }

    public boolean loop() {
        long ts = System.currentTimeMillis();
        try {
            int lognewindex = this.driver.requestLogIndex();
            if (lognewindex > 0) {
                if (this.logIndex == -1) {
                    this.logIndex = lognewindex - this.logSize;
                    if (this.logIndex < 0) {
                        this.logIndex += 4096;
                    }
                }
                if (lognewindex != this.logIndex) {
                    int delta = lognewindex - this.logIndex;
                    if (delta < 0) {
                        delta += 4096;
                    }
                    int deltamin = delta <= 20 ? 0 : delta - 20;
                    StringBuffer sb = new StringBuffer();
                    boolean logsAvailable = false;
                    int i2 = delta;
                    while (i2 > deltamin) {
                        if (this.processLog(this.driver.requestLog(i2))) {
                            logsAvailable = true;
                        }
                        --i2;
                    }
                    this.logIndex += delta - deltamin;
                    if (this.userLogs && logsAvailable) {
                        int l2 = 0;
                        while (l2 < this.logQueue.size()) {
                            if (l2 > 0) {
                                sb.append(',');
                            }
                            sb.append(this.logQueue.get(l2).replaceAll(",", " "));
                            ++l2;
                        }
                        this.uiSet("log", "parameters", sb.toString());
                    }
                }
            }
            if (this.numberOfSlaves > 0) {
                if (this.slaveMin == -1) {
                    this.processSlavesStatus(this.driver.requestSlavesStatus(1, 2, this.numberOfSlaves + 1), 2);
                } else if (this.slaveMin >= 2) {
                    this.processSlavesStatus(this.driver.requestSlavesStatus(1, this.slaveMin, this.slaveMax), this.slaveMin);
                }
            }
            if (this.panelLoopIndex > (this.slaveMax < 2 ? 1 : this.slaveMax)) {
                this.panelLoopIndex = 1;
            }
            this.processClockStatus(this.driver.requestClockStatus(this.panelLoopIndex));
            this.processSystemStatus(this.driver.requestSystemStatus(this.panelLoopIndex));
            switch (this.numberOfZones[this.panelLoopIndex - 1]) {
                case 300: {
                    this.processZonesStatus(this.driver.requestZonesStatus(this.panelLoopIndex, 151, 300), 151);
                }
                case 150: {
                    this.processZonesStatus(this.driver.requestZonesStatus(this.panelLoopIndex, 0, 150), 0);
                }
            }
            int line = 1;
            while (line <= this.numberOfLoops[this.panelLoopIndex - 1]) {
                if (this.sensorMin[this.panelLoopIndex - 1][line - 1] == -1) {
                    this.processSensorsStatus(this.driver.requestSensorsStatus(this.panelLoopIndex, line, 1, 199), line, 1);
                } else if (this.sensorMin[this.panelLoopIndex - 1][line - 1] > 0) {
                    this.processSensorsStatus(this.driver.requestSensorsStatus(this.panelLoopIndex, line, this.sensorMin[this.panelLoopIndex - 1][line - 1], this.sensorMax[this.panelLoopIndex - 1][line - 1]), line, this.sensorMin[this.panelLoopIndex - 1][line - 1]);
                }
                if (this.moduleMin[this.panelLoopIndex - 1][line - 1] == -1) {
                    this.processModulesStatus(this.driver.requestModulesStatus(this.panelLoopIndex, line, 1, 99), line, 1);
                } else if (this.moduleMin[this.panelLoopIndex - 1][line - 1] > 0) {
                    this.processModulesStatus(this.driver.requestModulesStatus(this.panelLoopIndex, line, this.moduleMin[this.panelLoopIndex - 1][line - 1], this.moduleMax[this.panelLoopIndex - 1][line - 1]), line, this.moduleMin[this.panelLoopIndex - 1][line - 1]);
                }
                ++line;
            }
            if (this.numberOfRepeaters[this.panelLoopIndex - 1] > 0) {
                if (this.repeaterMin[this.panelLoopIndex - 1] == -1) {
                    this.processRepeatersStatus(this.driver.requestRepeatersStatus(this.panelLoopIndex, 1, this.numberOfRepeaters[this.panelLoopIndex - 1]), 1);
                } else if (this.repeaterMin[this.panelLoopIndex - 1] > 0) {
                    this.processRepeatersStatus(this.driver.requestRepeatersStatus(this.panelLoopIndex, this.repeaterMin[this.panelLoopIndex - 1], this.repeaterMax[this.panelLoopIndex - 1]), this.repeaterMin[this.panelLoopIndex - 1]);
                }
            }
            ++this.panelLoopIndex;
            if (!this.connectionStatus) {
                this.ioWrite("connection", "online");
                this.connectionStatus = true;
                this.genEvents = true;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
        finally {
            long now = System.currentTimeMillis();
            if (now - ts < (long)this.pollingTimeMillis) {
                this.sleep((long)this.pollingTimeMillis - now + ts);
            } else {
                this.sleep(100L);
            }
        }
    }

    public boolean end() {
        this.ioWrite("connection", "offline");
        this.driver.disconnect();
        return true;
    }

    public void command(String name, String value) {
        String[] lname = name.toLowerCase().split("[.]", 5);
        try {
            if (lname[1].equals("sensor")) {
                if (lname[4].equals("excluded")) {
                    if (value.equals("0")) {
                        this.driver.commandSensorExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[2]), Integer.parseInt(lname[3]), false);
                    } else if (value.equals("1")) {
                        this.driver.commandSensorExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[2]), Integer.parseInt(lname[3]), true);
                    }
                }
            } else if (lname[1].equals("input") || lname[1].equals("output")) {
                if (lname[4].equals("excluded")) {
                    if (value.equals("0")) {
                        this.driver.commandModuleExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[2]), Integer.parseInt(lname[3]), false);
                    } else if (value.equals("1")) {
                        this.driver.commandModuleExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[2]), Integer.parseInt(lname[3]), true);
                    }
                }
            } else if (lname[1].equals("system")) {
                if (lname[2].equals("line") && lname[4].equals("excluded")) {
                    if (value.equals("0")) {
                        this.driver.commandLineExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[3]), false);
                    } else if (value.equals("1")) {
                        this.driver.commandLineExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[3]), true);
                    }
                }
            } else if (lname[1].equals("slave")) {
                if (lname[3].equals("excluded")) {
                    if (value.equals("0")) {
                        this.driver.commandSlaveExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[2]), false);
                    } else if (value.equals("1")) {
                        this.driver.commandSlaveExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[2]), true);
                    }
                }
            } else if (lname[1].equals("repeater")) {
                if (lname[3].equals("excluded")) {
                    if (value.equals("0")) {
                        this.driver.commandRepeaterExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[2]), false);
                    } else if (value.equals("1")) {
                        this.driver.commandRepeaterExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[2]), true);
                    }
                }
            } else if (lname[1].equals("zone")) {
                if (lname[3].equals("excluded")) {
                    if (value.equals("0")) {
                        this.driver.commandZoneExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[2]), false);
                    } else if (value.equals("1")) {
                        this.driver.commandZoneExcluded(Integer.parseInt(lname[0]), Integer.parseInt(lname[2]), true);
                    }
                }
            } else if (lname[1].equals("clock")) {
                if (value.equalsIgnoreCase("sync")) {
                    Calendar cal = Calendar.getInstance();
                    this.driver.commandClock(Integer.parseInt(lname[0]), cal.get(1) - 2000, cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
                }
            } else if (lname[1].equals("silence")) {
                if (value.equalsIgnoreCase("1")) {
                    int r = this.driver.commandSilence(Integer.parseInt(lname[0]), lname.length == 3 ? lname[2] : this.userCodeDefault);
                    switch (r) {
                        case 1: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".silence", "fire.alarm");
                            break;
                        }
                        case 2: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".silence", "fire.prealarm");
                            break;
                        }
                        case 3: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".silence", "tech.alarm");
                            break;
                        }
                        case 4: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".silence", "fault");
                            break;
                        }
                        case 5: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".silence", "test.alarm");
                            break;
                        }
                        case 21: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".silence", "error");
                            break;
                        }
                        case 0: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".silence", "null");
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (lname[1].equals("evacuation")) {
                if (value.equalsIgnoreCase("1")) {
                    int r = this.driver.commandEvacuation(Integer.parseInt(lname[0]), lname.length == 3 ? lname[2] : this.userCodeDefault);
                    switch (r) {
                        case 6: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".evacuation", "ack");
                            break;
                        }
                        case 21: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".evacuation", "error");
                            break;
                        }
                        case 0: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".evacuation", "null");
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (lname[1].equals("reset")) {
                if (value.equalsIgnoreCase("1")) {
                    int r = this.driver.commandSystemReset(Integer.parseInt(lname[0]), lname.length == 3 ? lname[2] : this.userCodeDefault);
                    switch (r) {
                        case 6: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".reset", "ack");
                            break;
                        }
                        case 21: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".reset", "error");
                            break;
                        }
                        case 0: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".reset", "null");
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (lname[1].equals("sirens")) {
                if (lname[2].equals("silence")) {
                    int r = -1;
                    if (value.equals("0")) {
                        r = this.driver.commandSirensSilenced(Integer.parseInt(lname[0]), lname.length == 4 ? lname[3] : this.userCodeDefault, false);
                    } else if (value.equals("1")) {
                        r = this.driver.commandSirensSilenced(Integer.parseInt(lname[0]), lname.length == 4 ? lname[3] : this.userCodeDefault, true);
                    }
                    switch (r) {
                        case 6: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".sirens.silence", "ack");
                            break;
                        }
                        case 21: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".sirens.silence", "error");
                            break;
                        }
                        case 0: {
                            this.ioWriteForced(String.valueOf(lname[0]) + ".sirens.silence", "null");
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (lname[1].equals("attended")) {
                int r = -1;
                if (value.equals("0")) {
                    r = this.driver.commandAttended(Integer.parseInt(lname[0]), lname.length == 3 ? lname[2] : this.userCodeDefault, false);
                } else if (value.equals("1")) {
                    r = this.driver.commandAttended(Integer.parseInt(lname[0]), lname.length == 3 ? lname[2] : this.userCodeDefault, true);
                }
                switch (r) {
                    case 6: {
                        this.ioWriteForced(String.valueOf(lname[0]) + ".attended", "ack");
                        break;
                    }
                    case 21: {
                        this.ioWriteForced(String.valueOf(lname[0]) + ".attended", "error");
                        break;
                    }
                    case 0: {
                        this.ioWriteForced(String.valueOf(lname[0]) + ".attended", "null");
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    private void ioWriteCE(String datapoint, String value) {
        if (this.genEvents) {
            this.ioWrite(datapoint, value);
        } else {
            this.ioWriteNoEvents(datapoint, value);
        }
    }

    private void processClockStatus(byte[] data) throws Exception {
        int address;
        StringBuffer sb = new StringBuffer();
        if (data != null && data[4] == 6 && (0xFF & data[10]) != this.c49[address = 0xFF & data[6]]) {
            this.c49[address] = 0xFF & data[10];
            Calendar cal = Calendar.getInstance();
            sb.append(cal.get(1) / 100);
            if ((data[14] & 0xFF) < 10) {
                sb.append('0');
            }
            sb.append(data[14] & 0xFF);
            sb.append('-');
            if ((data[13] & 0xFF) < 10) {
                sb.append('0');
            }
            sb.append(data[13] & 0xFF);
            sb.append('-');
            if ((data[12] & 0xFF) < 10) {
                sb.append('0');
            }
            sb.append(data[12] & 0xFF);
            sb.append(' ');
            if ((data[11] & 0xFF) < 10) {
                sb.append('0');
            }
            sb.append(data[11] & 0xFF);
            sb.append(':');
            if ((data[10] & 0xFF) < 10) {
                sb.append('0');
            }
            sb.append(data[10] & 0xFF);
            this.ioWriteCE(String.valueOf(address + 1) + ".clock", sb.toString());
        }
    }

    private boolean processLog(byte[] data) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (data != null && data[4] == 6) {
            int i2 = 9;
            while (i2 < data.length - 2) {
                sb.append((char)data[i2]);
                ++i2;
            }
            if (sb.length() > 0) {
                String log = sb.toString();
                hsyco.securityLog(String.valueOf(this.name) + " - " + log);
                this.ioWriteCE("lastlog", log);
                if (this.userLogs) {
                    this.uiSet("lastlog", "text", sb.toString());
                    if (this.logQueue.size() >= this.logSize) {
                        this.logQueue.removeLast();
                    }
                    this.logQueue.addFirst(log.trim());
                }
                return true;
            }
        }
        return false;
    }

    private void processModulesStatus(byte[] data, int line, int from) throws Exception {
        int min = 0;
        int max = 0;
        if (data != null && data[4] == 6) {
            int address = 0xFF & data[6];
            int datalen = (0xFF & data[7]) + (0xFF & data[8]) * 256;
            int i2 = 0;
            while (i2 < datalen) {
                boolean input;
                boolean bl = input = (0x80 & data[10 + i2]) == 0;
                if (data[9 + i2] != 0 || data[10 + i2] != 0) {
                    if (min == 0) {
                        min = from + i2 / 2;
                    }
                    max = from + i2 / 2;
                }
                if ((0xFF & data[9 + i2]) != this.c42[address][line - 1][i2] || (0xFF & data[10 + i2]) != this.c42[address][line - 1][i2 + 1]) {
                    byte b2;
                    String addressPrefix = String.valueOf(address + 1) + (input ? ".input." : ".output.") + line + "." + (from + i2 / 2) + ".";
                    this.c42[address][line - 1][i2] = 0xFF & data[9 + i2];
                    this.c42[address][line - 1][i2 + 1] = 0xFF & data[10 + i2];
                    if (input) {
                        b2 = data[9 + i2];
                        this.ioWriteCE(String.valueOf(addressPrefix) + "fire.alarm", (1 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "tech.alarm", (2 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "test.alarm", (4 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "fault", (8 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "battery.low", (0x10 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "battery.fault", (0x20 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "nopower", (0x40 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "supply.fault", (0x80 & b2) != 0 ? "1" : "0");
                        b2 = data[10 + i2];
                        this.ioWriteCE(String.valueOf(addressPrefix) + "earth.fault", (1 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "excluded", (2 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "fire.prealarm", (4 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "tech.prealarm", (8 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "present", (0x10 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "lost", (0x20 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "test", (0x40 & b2) != 0 ? "1" : "0");
                    } else {
                        b2 = data[9 + i2];
                        this.ioWriteCE(String.valueOf(addressPrefix) + "active", (1 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "fault", (8 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "battery.low", (0x10 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "battery.fault", (0x20 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "nopower", (0x40 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "supply.fault", (0x80 & b2) != 0 ? "1" : "0");
                        b2 = data[10 + i2];
                        this.ioWriteCE(String.valueOf(addressPrefix) + "earth.fault", (1 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "excluded", (2 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "present", (0x10 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "lost", (0x20 & b2) != 0 ? "1" : "0");
                        this.ioWriteCE(String.valueOf(addressPrefix) + "test", (0x40 & b2) != 0 ? "1" : "0");
                    }
                }
                i2 += 2;
            }
            if (this.moduleMin[address][line - 1] == -1) {
                this.moduleMin[address][line - 1] = min;
                this.moduleMax[address][line - 1] = max;
            }
        }
    }

    private void processRepeatersStatus(byte[] data, int from) throws Exception {
        int min = 0;
        int max = 0;
        if (data != null && data[4] == 6) {
            int address = 0xFF & data[6];
            int datalen = (0xFF & data[7]) + (0xFF & data[8]) * 256;
            int i2 = 0;
            while (i2 < datalen) {
                if ((0xFC & data[9 + i2]) != 0 || (0x73 & data[10 + i2]) != 0) {
                    if (min == 0) {
                        min = from + i2 / 2;
                    }
                    max = from + i2 / 2;
                }
                if ((0xFC & data[9 + i2]) != this.c44[address][i2] || (0x73 & data[10 + i2]) != this.c44[address][i2 + 1]) {
                    String addressPrefix = String.valueOf(address + 1) + ".repeater." + (from + i2 / 2) + ".";
                    byte b2 = data[9 + i2];
                    this.c44[address][i2] = 0xFC & b2;
                    this.ioWriteCE(String.valueOf(addressPrefix) + "fault", (8 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "battery.low", (0x10 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "battery.fault", (0x20 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "nopower", (0x40 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "supply.fault", (0x80 & b2) != 0 ? "1" : "0");
                    b2 = data[10 + i2];
                    this.c44[address][i2 + 1] = 0x73 & b2;
                    this.ioWriteCE(String.valueOf(addressPrefix) + "earth.fault", (1 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "excluded", (2 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "present", (0x10 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "lost", (0x20 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "test", (0x40 & b2) != 0 ? "1" : "0");
                }
                i2 += 2;
            }
            if (this.repeaterMin[address] == -1) {
                this.repeaterMin[address] = min;
                this.repeaterMax[address] = max;
            }
        }
    }

    private void processSensorsStatus(byte[] data, int line, int from) throws Exception {
        int min = 0;
        int max = 0;
        if (data != null && data[4] == 6) {
            int address = 0xFF & data[6];
            int datalen = (0xFF & data[7]) + (0xFF & data[8]) * 256;
            int i2 = 0;
            while (i2 < datalen) {
                if (data[9 + i2] != 0 || (0x7F & data[10 + i2]) != 0) {
                    if (min == 0) {
                        min = from + i2 / 2;
                    }
                    max = from + i2 / 2;
                }
                if ((0xFF & data[9 + i2]) != this.c41[address][line - 1][i2] || (0x7F & data[10 + i2]) != this.c41[address][line - 1][i2 + 1]) {
                    String addressPrefix = String.valueOf(address + 1) + ".sensor." + line + "." + (from + i2 / 2) + ".";
                    byte b2 = data[9 + i2];
                    this.c41[address][line - 1][i2] = 0xFF & b2;
                    this.ioWriteCE(String.valueOf(addressPrefix) + "fire.alarm", (1 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "tech.alarm", (2 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "test.alarm", (4 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "fault", (8 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "battery.low", (0x10 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "battery.fault", (0x20 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "nopower", (0x40 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "supply.fault", (0x80 & b2) != 0 ? "1" : "0");
                    b2 = data[10 + i2];
                    this.c41[address][line - 1][i2 + 1] = 0x7F & b2;
                    this.ioWriteCE(String.valueOf(addressPrefix) + "earth.fault", (1 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "excluded", (2 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "fire.prealarm", (4 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "tech.prealarm", (8 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "present", (0x10 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "lost", (0x20 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "test", (0x40 & b2) != 0 ? "1" : "0");
                }
                i2 += 2;
            }
            if (this.sensorMin[address][line - 1] == -1) {
                this.sensorMin[address][line - 1] = min;
                this.sensorMax[address][line - 1] = max;
            }
        }
    }

    private void processSlavesStatus(byte[] data, int from) throws Exception {
        int min = 0;
        int max = 0;
        if (data != null && data[4] == 6) {
            int address = 0xFF & data[6];
            int datalen = (0xFF & data[7]) + (0xFF & data[8]) * 256;
            int i2 = 0;
            while (i2 < datalen) {
                if ((0xFC & data[9 + i2]) != 0 || (0x73 & data[10 + i2]) != 0) {
                    if (min == 0) {
                        min = from + i2 / 2;
                    }
                    max = from + i2 / 2;
                }
                if ((0xFC & data[9 + i2]) != this.c43[i2] || (0x73 & data[10 + i2]) != this.c43[i2 + 1]) {
                    String addressPrefix = String.valueOf(address + 1) + ".slave." + (from + i2 / 2) + ".";
                    byte b2 = data[9 + i2];
                    this.c43[i2] = 0xFC & b2;
                    this.ioWriteCE(String.valueOf(addressPrefix) + "fault", (8 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "battery.low", (0x10 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "battery.fault", (0x20 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "nopower", (0x40 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "supply.fault", (0x80 & b2) != 0 ? "1" : "0");
                    b2 = data[10 + i2];
                    this.c43[i2 + 1] = 0x73 & b2;
                    this.ioWriteCE(String.valueOf(addressPrefix) + "earth.fault", (1 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "excluded", (2 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "present", (0x10 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "lost", (0x20 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "test", (0x40 & b2) != 0 ? "1" : "0");
                }
                i2 += 2;
            }
            if (this.slaveMin == -1) {
                this.slaveMin = min;
                this.slaveMax = max;
            }
        }
    }

    private void processZonesStatus(byte[] data, int from) throws Exception {
        if (data != null && data[4] == 6) {
            int address = 0xFF & data[6];
            int datalen = (0xFF & data[7]) + (0xFF & data[8]) * 256;
            int i2 = 0;
            while (i2 < datalen) {
                if ((0x3F & data[9 + i2]) != this.c45[address][from + i2] || (1 & data[10 + i2]) != this.c45[address][from + i2 + 1]) {
                    String addressPrefix = String.valueOf(address + 1) + ".zone." + (from + i2 / 2) + ".";
                    byte b2 = data[9 + i2];
                    this.c45[address][from + i2] = 0x3F & b2;
                    this.ioWriteCE(String.valueOf(addressPrefix) + "fire.alarm", (1 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "tech.alarm", (2 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "test.alarm", (4 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "fire.prealarm", (8 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "fault", (0x10 & b2) != 0 ? "1" : "0");
                    this.ioWriteCE(String.valueOf(addressPrefix) + "tech.prealarm", (0x20 & b2) != 0 ? "1" : "0");
                    b2 = data[10 + i2];
                    this.c45[address][from + i2 + 1] = 1 & b2;
                    this.ioWriteCE(String.valueOf(addressPrefix) + "excluded", (1 & b2) != 0 ? "1" : "0");
                }
                i2 += 2;
            }
        }
    }

    private void processSystemStatus(byte[] data) throws Exception {
        if (data != null && data[4] == 6) {
            int address = 0xFF & data[6];
            String addressPrefix = String.valueOf(address + 1) + ".";
            if ((0xFF & data[9]) != this.c40[address][0]) {
                this.c40[address][0] = 0xFF & data[9];
                switch (this.c40[address][0]) {
                    case 27: {
                        this.ioWriteCE(String.valueOf(addressPrefix) + "system.model", "TFA4-1192");
                        this.numberOfLoops[address] = 4;
                        this.numberOfRepeaters[address] = 16;
                        this.numberOfSlaves = 15;
                        this.numberOfZones[address] = 300;
                        break;
                    }
                    case 28: {
                        this.ioWriteCE(String.valueOf(addressPrefix) + "system.model", "TFA2-596");
                        this.numberOfLoops[address] = 2;
                        this.numberOfRepeaters[address] = 16;
                        this.numberOfSlaves = 15;
                        this.numberOfZones[address] = 300;
                        break;
                    }
                    case 37: {
                        this.ioWriteCE(String.valueOf(addressPrefix) + "system.model", "TFA1-298");
                        this.numberOfLoops[address] = 1;
                        this.numberOfRepeaters[address] = 5;
                        this.numberOfSlaves = 0;
                        this.numberOfZones[address] = 150;
                        break;
                    }
                    case 51: {
                        this.ioWriteCE(String.valueOf(addressPrefix) + "system.model", "TFA4Plus");
                        this.numberOfLoops[address] = 4;
                        this.numberOfRepeaters[address] = 16;
                        this.numberOfSlaves = 15;
                        this.numberOfZones[address] = 300;
                        break;
                    }
                    case 52: {
                        this.ioWriteCE(String.valueOf(addressPrefix) + "system.model", "TFA2Plus");
                        this.numberOfLoops[address] = 2;
                        this.numberOfRepeaters[address] = 16;
                        this.numberOfSlaves = 15;
                        this.numberOfZones[address] = 300;
                        break;
                    }
                    case 53: {
                        this.ioWriteCE(String.valueOf(addressPrefix) + "system.model", "TFA1Plus");
                        this.numberOfLoops[address] = 1;
                        this.numberOfRepeaters[address] = 5;
                        this.numberOfSlaves = 0;
                        this.numberOfZones[address] = 150;
                        break;
                    }
                    case 54: {
                        this.ioWriteCE(String.valueOf(addressPrefix) + "system.model", "TSA1");
                        this.numberOfLoops[address] = 1;
                        this.numberOfRepeaters[address] = 5;
                        this.numberOfSlaves = 0;
                        this.numberOfZones[address] = 198;
                        break;
                    }
                    default: {
                        this.ioWriteCE(String.valueOf(addressPrefix) + "system.model", "unknown");
                        this.numberOfLoops[address] = 0;
                        this.numberOfRepeaters[address] = 0;
                        this.numberOfSlaves = 0;
                        this.numberOfZones[address] = 0;
                    }
                }
            }
            if ((0xFF & data[10]) != this.c40[address][1]) {
                this.c40[address][1] = 0xFF & data[10];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.acknowledge", Integer.toString(this.c40[address][1]));
            }
            if ((0xFF & data[11]) != this.c40[address][2] || (0xFF & data[12]) != this.c40[address][3] || (0xFF & data[13]) != this.c40[address][4]) {
                this.c40[address][2] = 0xFF & data[11];
                this.c40[address][3] = 0xFF & data[12];
                this.c40[address][4] = 0xFF & data[13];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.version", String.valueOf(this.c40[address][2]) + "/" + this.c40[address][3] + "/" + this.c40[address][4]);
            }
            if ((0xFF & data[16]) != this.c40[address][7]) {
                this.c40[address][7] = 0xFF & data[16];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.supply.voltage", this.decimalNumberFormatter.format((float)this.c40[address][7] * 0.2f));
            }
            if ((0xFF & data[17]) != this.c40[address][8]) {
                this.c40[address][8] = 0xFF & data[17];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.battery.voltage", this.decimalNumberFormatter.format((float)this.c40[address][8] * 0.2f));
            }
            if ((0xFF & data[19]) != this.c40[address][10]) {
                this.c40[address][10] = 0xFF & data[19];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.general.alarm", (1 & data[19]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.general.prealarm", (2 & data[19]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.tech.alarm", (4 & data[19]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.delayed.alarm", (8 & data[19]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.general.fault", (0x10 & data[19]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.testdevice.alarm", (0x20 & data[19]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.fault", (0x40 & data[19]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.evacuation", (0x80 & data[19]) != 0 ? "1" : "0");
            }
            if ((0xFF & data[20]) != this.c40[address][11]) {
                this.c40[address][11] = 0xFF & data[20];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.battery.low", (1 & data[20]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.battery.fault", (2 & data[20]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.nopower", (4 & data[20]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.supply.fault", (8 & data[20]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.earth.fault", (0x10 & data[20]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.siren.tamper", (0x20 & data[20]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.program.key", (0x40 & data[20]) != 0 ? "1" : "0");
            }
            if ((0xFF & data[21]) != this.c40[address][12]) {
                this.c40[address][12] = 0xFF & data[21];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.device.alarm", (1 & data[21]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.device.prealarm", (2 & data[21]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.device.alarm.tech", (4 & data[21]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.device.fault", (8 & data[21]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.device.fault.system", (0x10 & data[21]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.device.alarm.test", (0x20 & data[21]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.dialer.connection.confirmed", (0x40 & data[21]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.dialer.excluded", (0x80 & data[21]) != 0 ? "1" : "0");
            }
            if ((0xFF & data[22]) != this.c40[address][13]) {
                this.c40[address][13] = 0xFF & data[22];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.jumper.inserted", (0x40 & data[22]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.annunciator.test", (0x80 & data[22]) != 0 ? "1" : "0");
            }
            if ((0xFF & data[23]) != this.c40[address][14]) {
                this.c40[address][14] = 0xFF & data[23];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.object.excluded", (1 & data[23]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.outputs.excluded", (2 & data[23]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.zones.test", (4 & data[23]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.maintenance", (8 & data[23]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.panels.connected", (0x40 & data[23]) != 0 ? "1" : "0");
            }
            if ((0xFF & data[24]) != this.c40[address][15]) {
                this.c40[address][15] = 0xFF & data[24];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.voice.memory.expansion.available", (1 & data[24]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.access.code.denied", (2 & data[24]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.ok", (4 & data[24]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.loop.reset", (8 & data[24]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.bus.loop.open", (0x10 & data[24]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.sirens.silenced", (0x20 & data[24]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.attended", (0x40 & data[24]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.programming.accepted", (0x80 & data[24]) != 0 ? "1" : "0");
            }
            if ((0xFF & data[25]) != this.c40[address][16]) {
                this.c40[address][16] = 0xFF & data[25];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.siren.output.active", (1 & data[25]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.alarm.output.active", (2 & data[25]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.prealarm.output.active", (4 & data[25]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.tech.alarm.output.active", (8 & data[25]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.fault.alarm.output.active", (0x10 & data[25]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.reset.output.active", (0x20 & data[25]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.buzzer.silenced", (0x40 & data[25]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.dialer.fault", (0x80 & data[25]) != 0 ? "1" : "0");
            }
            if ((0xFF & data[26]) != this.c40[address][17]) {
                this.c40[address][17] = 0xFF & data[26];
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.line.1.excluded", (1 & data[26]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.line.2.excluded", (2 & data[26]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.line.3.excluded", (4 & data[26]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.line.4.excluded", (8 & data[26]) != 0 ? "1" : "0");
                this.ioWriteCE(String.valueOf(addressPrefix) + "system.tech.prealarm", (0x10 & data[26]) != 0 ? "1" : "0");
            }
        } else {
            throw new NullPointerException();
        }
    }
}

