/*
 * Decompiled with CFR 0.152.
 */
package drivers.sonos;

import com.hsyco.Configuration;
import com.hsyco.driverBase;
import drivers.sonos.Player;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private static final String BROADCAST_ADDR = "239.255.255.250";
    private static final int DISCOVER_PORT = 1900;
    private static final String SEARCH_TARGET = "urn:schemas-upnp-org:device:ZonePlayer:1";
    private static final String DISCOVER_MESSAGE = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:1900\r\nST: urn:schemas-upnp-org:device:ZonePlayer:1\r\nMAN: \"ssdp:discover\"\r\nMX: 2\r\n\r\n";
    static final int RESPONSE_TIMEOUT = 5000;
    static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    static final int EVENTS_LOCAL_PORT = 1077;
    private static final int POLL_TIME = 40000;
    private static final int DISCOVERY_INTERVAL = 600000;
    private String name;
    private boolean genEvent;
    String localHost;
    private ServerSocket eventsSocket;
    private long lastDiscovery;
    private long lastCommand;
    private int subscribeFails = 0;
    private Map<String, Player> players = new ConcurrentHashMap<String, Player>();

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            this.localHost = config.get("localhost");
            if (this.localHost == null) {
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                block8: while (nis.hasMoreElements() && this.localHost == null) {
                    for (InterfaceAddress ni : nis.nextElement().getInterfaceAddresses()) {
                        if (!ni.getAddress().isSiteLocalAddress()) continue;
                        this.localHost = ni.getAddress().getHostAddress();
                        continue block8;
                    }
                }
                if (this.localHost == null) {
                    throw new Exception("Warning: no valid localhost found.");
                }
            }
            this.messageLog("Using localhost: " + this.localHost);
            try {
                this.discover();
            }
            catch (IOException e2) {
                throw new Exception("Discovery error: " + e2);
            }
            if (this.players.isEmpty()) {
                throw new Exception("No player found");
            }
            for (Player p : this.players.values()) {
                this.messageLog("Found player: " + p.getId() + " (" + p.getBaseUrl() + ")");
            }
            this.genEvent = Boolean.parseBoolean(config.get("startupevents"));
            try {
                for (Player p : this.players.values()) {
                    p.getState();
                }
            }
            catch (Exception e3) {
                throw new Exception("Get state error: " + e3);
            }
            try {
                this.eventsSocket = new ServerSocket(1077);
                this.eventsSocket.setSoTimeout(40000);
            }
            catch (IOException e4) {
                throw new Exception("Error creating events socket: " + e4);
            }
            this.genEvent = true;
            this.ioWrite("connection", "online");
            return true;
        }
        catch (Exception e5) {
            this.errorLog("Initialization failed - " + e5.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    private void discover() throws IOException {
        if (Configuration.verboseLog) {
            this.messageLog("Looking for players...");
        }
        DatagramSocket sock = null;
        try {
            sock = new DatagramSocket();
            byte[] bytes = DISCOVER_MESSAGE.getBytes(Charset.forName("UTF-8"));
            DatagramPacket discoverPacket = new DatagramPacket(bytes, bytes.length);
            discoverPacket.setAddress(InetAddress.getByName(BROADCAST_ADDR));
            discoverPacket.setPort(1900);
            sock.send(discoverPacket);
            sock.setSoTimeout(5000);
            try {
                while (true) {
                    String baseUrl;
                    Player p;
                    String room;
                    byte[] buff = new byte[1536];
                    DatagramPacket respPacket = new DatagramPacket(buff, buff.length);
                    sock.receive(respPacket);
                    String location = this.getLocation(respPacket);
                    if (location == null || location.length() <= 8 || (room = this.getRoomName(location)) == null || this.players.containsKey((p = new Player(this, room, baseUrl = location.substring(0, location.indexOf(47, 8)))).getId())) continue;
                    this.players.put(p.getId(), p);
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.lastDiscovery = System.currentTimeMillis();
            }
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getLocation(DatagramPacket packet) {
        String[] lines;
        String data = new String(packet.getData(), Charset.forName("UTF-8"));
        String location = null;
        String st = null;
        String[] stringArray = lines = data.split("\n");
        int n2 = lines.length;
        int n3 = 0;
        while (n3 < n2) {
            String line = stringArray[n3];
            String lineLC = line.trim().toLowerCase();
            if (lineLC.startsWith("location:")) {
                try {
                    location = line.substring(line.indexOf(58) + 1).trim();
                }
                catch (Exception exception) {}
            } else if (lineLC.startsWith("st:")) {
                try {
                    st = line.substring(line.indexOf(58) + 1).trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n3;
        }
        if (location == null || st == null) {
            return null;
        }
        if (st.contains(":ZonePlayer:")) {
            return location;
        }
        return null;
    }

    private String getRoomName(String location) {
        HttpURLConnection connection = null;
        XMLEventReader eventReader = null;
        BufferedReader reader = null;
        try {
            connection = (HttpURLConnection)new URL(location).openConnection();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
            eventReader = XML_INPUT_FACTORY.createXMLEventReader(reader);
            String roomName = null;
            boolean hasMediaRenderer = false;
            boolean inDevice = false;
            boolean inDeviceList = false;
            while (eventReader.hasNext()) {
                EndElement endElement;
                String tag;
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    tag = startElement.getName().getLocalPart();
                    if (inDevice) {
                        if (roomName == null && tag.equalsIgnoreCase("roomName") && eventReader.hasNext() && (event = eventReader.nextEvent()).isCharacters()) {
                            roomName = event.asCharacters().getData();
                        }
                        if (inDeviceList) {
                            if (!tag.equalsIgnoreCase("deviceType") || !eventReader.hasNext() || !(event = eventReader.nextEvent()).isCharacters() || !event.asCharacters().getData().contains(":MediaRenderer:")) continue;
                            hasMediaRenderer = true;
                            break;
                        }
                        if (!tag.equalsIgnoreCase("deviceList")) continue;
                        inDeviceList = true;
                        continue;
                    }
                    if (!tag.equalsIgnoreCase("device")) continue;
                    inDevice = true;
                    continue;
                }
                if (!inDevice || !event.isEndElement() || !(tag = (endElement = event.asEndElement()).getName().getLocalPart()).equalsIgnoreCase("deviceList")) continue;
                inDeviceList = false;
            }
            if (hasMediaRenderer) {
                String string = roomName;
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (eventReader != null) {
                try {
                    eventReader.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    public boolean loop() {
        Socket sock = null;
        try {
            if (this.lastDiscovery < System.currentTimeMillis() - 600000L) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Driver.this.discover();
                        }
                        catch (Exception e2) {
                            Driver.this.errorLog("Discovery error: " + e2);
                        }
                    }
                }.start();
            }
            if (this.subscribeFails < 4) {
                try {
                    for (Player p : this.players.values()) {
                        p.subscribe();
                    }
                    try {
                        sock = this.eventsSocket.accept();
                        BufferedWriter bw = null;
                        try {
                            bw = new BufferedWriter(new OutputStreamWriter(sock.getOutputStream(), Charset.forName("UTF-8")));
                            bw.write("HTTP/1.1 200 OK\r\n");
                            bw.write("\r\n");
                            bw.flush();
                        }
                        finally {
                            if (bw != null) {
                                try {
                                    bw.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    catch (SocketTimeoutException bw) {
                    }
                }
                catch (Exception e2) {
                    ++this.subscribeFails;
                    this.sleep(1000L);
                }
            } else if (this.lastCommand < System.currentTimeMillis() - 3000L) {
                this.sleep(1000L);
            } else {
                this.sleep(300L);
            }
            for (Player p : this.players.values()) {
                try {
                    p.getState();
                }
                catch (Exception e3) {
                    if (Configuration.verboseLog) {
                        this.errorLog("Error getting '" + p.getId() + "' player state: " + e3);
                    }
                    p.setReachable(false);
                }
            }
            return true;
        }
        catch (Exception e4) {
            this.errorLog("Error in loop: " + e4);
            this.sleep(1000L);
            return false;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean end() {
        if (this.eventsSocket != null) {
            try {
                this.eventsSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ioWrite("connection", "offline");
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        try {
            int sep = id.indexOf(46, id.indexOf(46) + 1);
            String cmd = id.substring(0, sep);
            String value = id.substring(sep + 1);
            this.command(cmd, value);
        }
        catch (Exception e2) {
            this.errorLog("Error executing user command '" + id + "': " + e2.getLocalizedMessage());
        }
        return "";
    }

    public void command(String name, String value) {
        try {
            if (Configuration.verboseLog) {
                this.messageLog("Command: " + name + " = " + value);
            }
            Player p = null;
            int dot = name.indexOf(46);
            String cmd = null;
            if (dot > 0) {
                String id = name.substring(0, dot);
                cmd = name.substring(dot + 1);
                p = this.players.get(id);
            }
            if (p == null) {
                throw new Exception("unknown command");
            }
            p.command(cmd, value);
            this.lastCommand = System.currentTimeMillis();
        }
        catch (Exception e2) {
            this.errorLog("Error executing command '" + name + " = " + value + "': " + e2.getLocalizedMessage());
        }
    }

    @Override
    public void ioWrite(String name, String value) {
        if (this.genEvent) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
    }

    @Override
    public void uiSet(String id, String attr, String value) {
        super.uiSet(id, attr, value);
    }

    @Override
    public void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    public void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }
}

