/*
 * Decompiled with CFR 0.152.
 */
package drivers.smtpserver;

import com.hsyco.hsyco;
import drivers.smtpserver.Driver;
import drivers.smtpserver.RequestProcessor;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

class SMTPServer
extends Thread {
    static final int MAX_BODY_LINES = 64;
    private static boolean processorsInitialized = false;
    private int numThreads;
    private Driver driver;
    private ServerSocket server;
    private boolean stop = false;

    SMTPServer(Driver driver, int port, int numThreads) throws Exception {
        this.driver = driver;
        this.server = new ServerSocket(port);
        this.numThreads = numThreads;
    }

    @Override
    public void run() {
        if (!processorsInitialized) {
            int i2 = 0;
            while (i2 < this.numThreads) {
                Thread t = new Thread(new RequestProcessor(this.driver));
                t.start();
                ++i2;
            }
            processorsInitialized = true;
        }
        hsyco.messageLog("SMTP server accepting connections on port: " + this.server.getLocalPort());
        while (!this.stop) {
            try {
                this.server.setSoTimeout(2000);
                Socket request = this.server.accept();
                request.setSoTimeout(60000);
                RequestProcessor.processRequest(request);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void quit() {
        this.stop = true;
    }
}

