/*
 * Decompiled with CFR 0.152.
 */
package drivers.smtpserver;

import com.hsyco.driverBase;
import com.hsyco.hsyco;
import drivers.smtpserver.SMTPServer;
import java.util.HashMap;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 25;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    public static final int DEFAULTTHREADS = 4;
    public static final int DEFAULTINBOXSIZE = 32;
    boolean rawBody = false;
    private int port = 25;
    private int threads = 4;
    private SMTPServer smtpserver = null;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        try {
            this.port = Integer.parseInt(config.get("port"));
            if (this.port < 1 || this.port > 65535) {
                this.port = 25;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.rawBody = Boolean.parseBoolean(config.get("rawbody"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.threads = Integer.parseInt(config.get("threads"));
            if (this.threads < 1) {
                this.port = 25;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hsyco.messageLog("Starting SMTP Server");
        try {
            this.smtpserver = new SMTPServer(this, this.port, this.threads);
            this.smtpserver.setDaemon(true);
            this.smtpserver.start();
            return true;
        }
        catch (Exception e2) {
            hsyco.errorLog("SMTP server not started because of: " + e2.getClass() + " - " + e2.getLocalizedMessage());
            return false;
        }
    }

    public boolean loop() {
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.smtpserver.isAlive();
    }

    public boolean end() {
        this.smtpserver.quit();
        return true;
    }

    void ioWriteInternal(String name, String value) {
        this.ioWriteForced(name, value);
    }
}

