/*
 * Decompiled with CFR 0.152.
 */
package drivers.sigfox;

import com.hsyco.userBase;
import drivers.sigfox.Driver;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;

public class CallbackThread
extends Thread {
    private Socket connectionSocket;
    private Driver driver;

    public CallbackThread(Socket s, Driver d2) {
        this.connectionSocket = s;
        this.driver = d2;
    }

    @Override
    public void run() {
        BufferedReader in = null;
        DataOutputStream out = null;
        try {
            in = new BufferedReader(new InputStreamReader(this.connectionSocket.getInputStream()));
            out = new DataOutputStream(this.connectionSocket.getOutputStream());
            String URL2 = in.readLine().split(" ")[1];
            String path = URL2.split("\\?")[0];
            if (!path.equals(this.driver.callbackPath)) {
                String response = "HTTP/1.1 404 path not found\r\n";
                out.write(response.getBytes("UTF-8"));
                out.close();
                return;
            }
            try {
                String response;
                String body = URL2.split("\\?")[1];
                String[] fields = body.split("&");
                String id = null;
                String timestamp = null;
                String seqNumber = null;
                String data = null;
                String batt = null;
                String temp = null;
                String key = null;
                String lqi = null;
                String deviceTypeId = null;
                String[] stringArray = fields;
                int n2 = fields.length;
                int n3 = 0;
                while (n3 < n2) {
                    String field = stringArray[n3];
                    String fieldId = field.split("=")[0];
                    String fieldValue = field.split("=")[1];
                    if (fieldId.equals("id")) {
                        id = fieldValue;
                    } else if (fieldId.equals("data")) {
                        data = fieldValue;
                    } else if (fieldId.equals("time")) {
                        timestamp = fieldValue;
                    } else if (fieldId.equals("seqNumber")) {
                        seqNumber = fieldValue;
                    } else if (fieldId.equals("batt")) {
                        batt = fieldValue;
                    } else if (fieldId.equals("temp")) {
                        temp = fieldValue;
                    } else if (fieldId.equals("key")) {
                        key = fieldValue;
                    } else if (fieldId.equals("lqi")) {
                        lqi = this.convertLqi(fieldValue);
                    } else if (fieldId.equals("deviceTypeId")) {
                        deviceTypeId = fieldValue;
                    }
                    ++n3;
                }
                if (key == null || !key.equals(this.driver.callbackkey)) {
                    response = "HTTP/1.1 401 Unauthorized\r\n";
                } else if (id == null) {
                    response = "HTTP/1.1 400 Format error: device id must not be empty\r\n";
                } else {
                    long newTimestamp = timestamp != null ? Long.parseLong(timestamp) * 1000L : System.currentTimeMillis();
                    this.driver.updateMsg(id, seqNumber, data, newTimestamp, temp, batt, lqi, deviceTypeId);
                    response = "HTTP/1.1 200 OK\r\n";
                }
                out.write(response.getBytes("UTF-8"));
                out.flush();
                out.close();
            }
            catch (SocketException e2) {
                userBase.errorLog("connection problems with Sigfox cloud - " + e2.getMessage());
            }
            catch (Exception f2) {
                userBase.errorLog("error processing incoming callback request - " + f2.getMessage());
            }
        }
        finally {
            try {
                this.connectionSocket.close();
            }
            catch (Exception exception) {}
        }
    }

    public String convertLqi(String val) {
        String value = val.toLowerCase();
        if (value.equals("limit")) {
            return "0";
        }
        if (value.equals("average")) {
            return "1";
        }
        if (value.equals("good")) {
            return "2";
        }
        if (value.equals("excellent")) {
            return "3";
        }
        return "4";
    }
}

