/*
 * Decompiled with CFR 0.152.
 */
package drivers.satel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogEvent {
    static final Map<Integer, Map<Integer, String>> LOG_EVENTS_TEXT_CACHE = new HashMap<Integer, Map<Integer, String>>();
    final String date;
    final String extras;
    boolean extrasOk;
    String message;
    final int code;
    final int restore;

    public LogEvent(List<Integer> data, boolean integra256, boolean integra24_32) {
        int b2 = data.get(1);
        int kkk = b2 >>> 5 & 7;
        int day = b2 & 0x1F;
        b2 = data.get(2);
        int month = b2 >>> 4 & 0xF;
        int T2 = b2 & 0xF;
        int t = data.get(3);
        int minutes = (T2 << 8) + t;
        int hh = minutes / 60;
        int mm = minutes % 60;
        b2 = data.get(4);
        int partition = (b2 >>> 3 & 0x1F) + 1;
        this.restore = b2 >>> 2 & 1;
        int C = b2 & 3;
        int c2 = data.get(5);
        this.code = (C << 8) + c2;
        int source = data.get(6);
        b2 = data.get(7);
        int userControl = b2 & 0x1F;
        StringBuilder sb = new StringBuilder();
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        sb.append('-');
        if (day < 10) {
            sb.append('0');
        }
        sb.append(day);
        sb.append(' ');
        if (hh < 10) {
            sb.append('0');
        }
        sb.append(hh);
        sb.append(':');
        if (mm < 10) {
            sb.append('0');
        }
        sb.append(mm);
        this.date = sb.toString();
        sb = new StringBuilder();
        this.extrasOk = true;
        switch (kkk) {
            case 0: 
            case 3: {
                sb.append("Part: ");
                sb.append(partition);
                sb.append(" - ");
                sb.append(this.getSource(source, userControl, integra256, integra24_32));
                break;
            }
            case 1: 
            case 5: {
                sb.append(this.getSource(source, userControl, integra256, integra24_32));
                break;
            }
            case 2: {
                sb.append("Part: ");
                sb.append(partition);
                sb.append(" - User: ");
                sb.append(source);
                break;
            }
            case 6: {
                sb.append("User: ");
                sb.append(source);
                break;
            }
            default: {
                this.extrasOk = false;
                sb.append("KKK: ");
                sb.append(kkk);
                sb.append(" - Part: ");
                sb.append(partition);
                sb.append(" - Source: ");
                sb.append(source);
            }
        }
        this.extras = sb.toString();
        Map<Integer, String> rs = LOG_EVENTS_TEXT_CACHE.get(this.code);
        if (rs != null) {
            String text = rs.get(this.restore);
            if (text != null) {
                this.message = text;
            } else {
                this.message = null;
                rs.put(this.restore, "");
            }
        } else {
            this.message = null;
            LOG_EVENTS_TEXT_CACHE.put(this.code, new HashMap());
        }
    }

    private String getSource(int source, int userControl, boolean integra256, boolean integra24_32) {
        if (source >= 1 && source <= 128) {
            if (integra256 && userControl == 1) {
                source += 128;
            }
            return "Zone: " + source;
        }
        if (source >= 129 && source <= 192) {
            return "Exp: " + (source - 129);
        }
        if (integra24_32) {
            if (source >= 193 && source <= 196) {
                return "Module: " + (source - 193);
            }
            if (source >= 197 && source <= 200) {
                return "Keypad: " + (source - 197);
            }
            if (source == 201) {
                return "DloadX Keypad RS";
            }
            if (source == 202) {
                return "DloadX Keypad TEL";
            }
        } else {
            if (source >= 193 && source <= 200) {
                return "Module: " + (source - 193);
            }
            if (source >= 201 && source <= 208) {
                return "Keypad: " + (source - 201);
            }
            if (source == 209) {
                return "DloadX Keypad RS";
            }
            if (source == 210) {
                return "DloadX Keypad TEL";
            }
        }
        return "Source: " + source;
    }
}

