/*
 * Decompiled with CFR 0.152.
 */
package drivers.redscan;

import drivers.redscan.Driver;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class UDPEventsListener
extends Thread {
    private final Driver driver;
    private DatagramSocket serverSocket;
    private final int port;
    private final String host;
    private boolean run;

    public UDPEventsListener(Driver driver, int port, String host) {
        this.driver = driver;
        this.port = port;
        this.host = host;
    }

    @Override
    public synchronized void start() {
        this.run = true;
        super.start();
    }

    @Override
    public void run() {
        try {
            try {
                this.serverSocket = new DatagramSocket(this.port);
                byte[] event = new byte[128];
                while (this.run) {
                    String data;
                    DatagramPacket dp = new DatagramPacket(event, event.length);
                    this.serverSocket.receive(dp);
                    String addr = dp.getAddress().getHostAddress();
                    if (!addr.equals(this.host) || !(data = new String(dp.getData(), "ASCII")).startsWith("RLS")) continue;
                    int offset = 0;
                    String area = null;
                    if (data.startsWith("MO", 6)) {
                        area = data.substring(8, 10);
                        char c2 = data.charAt(10);
                        if (c2 == '1' || c2 == '2') {
                            area = String.valueOf(area) + c2;
                            offset = 1;
                        }
                    } else if (data.startsWith("CL", 6)) {
                        area = "";
                    }
                    if (area != null) {
                        this.driver.ioWrite("alarm.latest", area);
                    }
                    String dq = data.substring(14 + offset, 16 + offset);
                    String ar = data.substring(16 + offset, 18 + offset);
                    String am = data.substring(18 + offset, 20 + offset);
                    String tr = data.substring(20 + offset, 22 + offset);
                    String so = data.substring(22 + offset, 24 + offset);
                    String ta = data.substring(24 + offset, 26 + offset);
                    this.driver.ioWrite("alarm.disq", dq.equals("DQ") ? "1" : "0");
                    this.driver.ioWrite("alarm.antirot", ar.equals("AR") ? "1" : "0");
                    this.driver.ioWrite("alarm.antimask", am.equals("AM") ? "1" : "0");
                    this.driver.ioWrite("alarm.sensor", tr.equals("TR") ? "1" : "0");
                    this.driver.ioWrite("alarm.dirt", so.equals("SO") ? "1" : "0");
                    this.driver.ioWrite("alarm.tamper", ta.equals("TA") ? "1" : "0");
                }
            }
            catch (Exception e2) {
                this.driver.errorLog("Events listener error: " + e2);
                this.end();
            }
        }
        finally {
            this.end();
        }
    }

    void end() {
        this.run = false;
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    boolean isRunning() {
        return this.run;
    }
}

