/*
 * Decompiled with CFR 0.152.
 */
package drivers.redscan;

import com.hsyco.driverBase;
import drivers.redscan.UDPEventsListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final String[] WEBOBJECTS = new String[0];
    private static final int MAX_AREA_SIZE = 500;
    private static final int MAX_RESP_BUFFER = 1200;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte[] REQ_START = new byte[]{79, 80, 84, 69, 88, 10, 42, 10, 42, 10, 42, 10, 42, 10};
    private static final byte[] REQ_END = new byte[]{10, 10, 13};
    private static final byte[] REQ_VERSION = new byte[]{48, 50};
    private final byte[] REQ_DETECTED_OBJS = new byte[]{48, 54, 49, 53, 48, 48, 48, 48, 48};
    private String name;
    private Socket sock;
    private BufferedInputStream in;
    private OutputStream out;
    private UDPEventsListener eventsListener;
    private Integer areaX1;
    private Integer areaY1;
    private Integer areaX2;
    private Integer areaY2;
    private boolean flipX = false;
    private boolean flipY = false;
    private Float areaScaling = null;
    private int areaWidth;
    private int areaHeight;
    private String borderColor = "red";
    private String fillColor = "white";
    private int b;
    private int ri;
    private int state = 0;
    private char[] cmd = new char[2];
    private char[] err = new char[2];
    private int[] resp = new int[1200];

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            String fc;
            int eventsPort;
            String host = config.get("host");
            int port = Integer.parseInt(config.get("port"));
            try {
                eventsPort = Integer.parseInt(config.get("eventsport"));
            }
            catch (Exception e2) {
                eventsPort = 1234;
            }
            try {
                this.areaX1 = Integer.parseInt(config.get("areax1"));
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.areaY1 = Integer.parseInt(config.get("areay1"));
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.areaX2 = Integer.parseInt(config.get("areax2"));
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.areaY2 = Integer.parseInt(config.get("areay2"));
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.flipX = Boolean.parseBoolean(config.get("flipx"));
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.flipY = Boolean.parseBoolean(config.get("flipy"));
            }
            catch (Exception e2) {
                // empty catch block
            }
            String bc = config.get("bordercolor");
            if (bc != null) {
                this.borderColor = bc.replace(':', ',');
            }
            if ((fc = config.get("fillcolor")) != null) {
                this.fillColor = fc.replace(':', ',');
            }
            if (this.areaX1 != null && this.areaY1 != null && this.areaX2 != null && this.areaY2 != null) {
                this.areaWidth = this.areaX2 - this.areaX1;
                this.areaHeight = this.areaY2 - this.areaY1;
                if (this.areaWidth > this.areaHeight) {
                    this.areaScaling = Float.valueOf(500.0f / (float)this.areaWidth);
                    this.areaWidth = 500;
                    this.areaHeight = (int)((float)this.areaHeight * this.areaScaling.floatValue());
                } else {
                    this.areaScaling = Float.valueOf(500.0f / (float)this.areaHeight);
                    this.areaHeight = 500;
                    this.areaWidth = (int)((float)this.areaWidth * this.areaScaling.floatValue());
                }
            }
            String detectionInterval = config.get("detectioninterval");
            int di = -1;
            try {
                di = Integer.parseInt(detectionInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (di < 0 || di > 100) {
                detectionInterval = "10";
                di = 10;
            }
            int i2 = 0;
            while (i2 < 4 - detectionInterval.length()) {
                this.REQ_DETECTED_OBJS[5 + i2] = 48;
                ++i2;
            }
            int j2 = 0;
            while (j2 < detectionInterval.length()) {
                this.REQ_DETECTED_OBJS[5 + i2 + j2] = (byte)detectionInterval.charAt(j2);
                ++j2;
            }
            if (di == 0) {
                this.REQ_DETECTED_OBJS[4] = 48;
                this.REQ_DETECTED_OBJS[3] = 48;
            }
            InetSocketAddress addr = new InetSocketAddress(host, port);
            this.sock = new Socket();
            this.sock.connect(addr, 5000);
            if (di > 0) {
                int timeout = di * 50 * 2;
                if (timeout < 10000) {
                    timeout = 10000;
                }
                this.sock.setSoTimeout(timeout);
            }
            this.in = new BufferedInputStream(this.sock.getInputStream());
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.messageLog("Connected to " + addr);
            this.eventsListener = new UDPEventsListener(this, eventsPort, host);
            this.eventsListener.start();
            this.commandRequest(new byte[][]{REQ_VERSION});
            return true;
        }
        catch (Exception e3) {
            this.errorLog("Initialization failed - " + e3.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    public boolean loop() {
        block4: {
            if (!this.eventsListener.isRunning()) {
                this.eventsListener.end();
                throw new RuntimeException("Event listner stopped");
            }
            try {
                this.b = this.in.read();
                if (this.b >= 0) break block4;
                return false;
            }
            catch (Exception e2) {
                this.errorLog("Loop error: " + e2);
                return false;
            }
        }
        return this.processByte();
    }

    private boolean processByte() throws Exception {
        switch (this.state) {
            case 0: 
            case 1: 
            case 2: {
                if (this.b != 10) break;
                ++this.state;
                break;
            }
            case 3: {
                this.cmd[0] = (char)this.b;
                ++this.state;
                break;
            }
            case 4: {
                this.cmd[1] = (char)this.b;
                ++this.state;
                break;
            }
            case 5: {
                this.err[0] = (char)this.b;
                ++this.state;
                break;
            }
            case 6: {
                this.err[1] = (char)this.b;
                ++this.state;
                break;
            }
            case 7: {
                this.ri = -1;
                if (this.b == 10) {
                    if (this.err[0] != '0' || this.err[1] != '0') {
                        this.errorLog("Command " + this.cmd[0] + this.cmd[1] + " error: " + this.err[0] + this.err[1]);
                    } else {
                        this.ri = 0;
                    }
                }
                this.state = -1;
                break;
            }
            case -2: 
            case -1: {
                if (this.ri >= 0 && this.ri < this.resp.length) {
                    this.resp[this.ri++] = this.b;
                }
                if (this.b == 10) {
                    --this.state;
                    break;
                }
                this.state = -1;
                break;
            }
            default: {
                if (this.ri >= 0) {
                    if (this.ri < this.resp.length) {
                        this.resp[this.ri++] = this.b;
                    } else {
                        this.ri = -1;
                        this.errorLog("Message exceeded buffer size");
                    }
                }
                if (this.b == 13) {
                    this.state = 0;
                    if (this.ri < 0) break;
                    return this.processMessage();
                }
                if (this.b == 10) break;
                this.state = -1;
            }
        }
        return false;
    }

    private void commandRequest(byte[] ... cmds) throws IOException {
        this.out.write(REQ_START);
        boolean first = true;
        byte[][] byArray = cmds;
        int n2 = cmds.length;
        int n3 = 0;
        while (n3 < n2) {
            byte[] cmd = byArray[n3];
            if (first) {
                first = false;
            } else {
                this.out.write(13);
            }
            this.out.write(cmd);
            ++n3;
        }
        this.out.write(REQ_END);
        this.out.flush();
    }

    private boolean processMessage() throws Exception {
        if (this.ri < 3 || this.resp[this.ri - 3] != 10 || this.resp[this.ri - 2] != 10 || this.resp[this.ri - 1] != 13) {
            this.errorLog("Message format error");
            return false;
        }
        if (this.cmd[0] == '0') {
            if (this.cmd[1] == '2') {
                StringBuilder sb = new StringBuilder();
                int i2 = 0;
                while (i2 < this.ri - 3) {
                    sb.append((char)this.resp[i2]);
                    ++i2;
                }
                this.ioWrite("version", sb.toString());
                this.ioWrite("connection", "online");
                this.commandRequest(new byte[][]{this.REQ_DETECTED_OBJS});
                return true;
            }
            if (this.cmd[1] == '6') {
                JSONArray array = null;
                if (this.ri == 3) {
                    array = new JSONArray();
                } else if (this.ri > 20) {
                    array = new JSONArray();
                    int i3 = 0;
                    while (i3 < this.ri - 3) {
                        JSONObject obj = new JSONObject();
                        int ox = (this.resp[i3] << 24) + (this.resp[i3 + 1] << 16) + (this.resp[i3 + 2] << 8) + this.resp[i3 + 3];
                        int oy = (this.resp[i3 + 4] << 24) + (this.resp[i3 + 5] << 16) + (this.resp[i3 + 6] << 8) + this.resp[i3 + 7];
                        int x = (this.resp[i3 + 8] << 24) + (this.resp[i3 + 9] << 16) + (this.resp[i3 + 10] << 8) + this.resp[i3 + 11];
                        int y = (this.resp[i3 + 12] << 24) + (this.resp[i3 + 13] << 16) + (this.resp[i3 + 14] << 8) + this.resp[i3 + 15];
                        int w = (this.resp[i3 + 16] << 24) + (this.resp[i3 + 17] << 16) + (this.resp[i3 + 18] << 8) + this.resp[i3 + 19];
                        obj.put("x", x);
                        obj.put("y", y);
                        obj.put("ox", ox);
                        obj.put("oy", oy);
                        obj.put("w", w);
                        array.put(obj);
                        i3 += 20;
                    }
                }
                if (array != null) {
                    this.ioWrite("detected", array.toString());
                    if (this.areaScaling != null) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("size(");
                        sb.append(this.areaWidth);
                        sb.append(",");
                        sb.append(this.areaHeight);
                        sb.append(");");
                        int i4 = 0;
                        while (i4 < array.length()) {
                            JSONObject obj = array.getJSONObject(i4);
                            float x = (float)(obj.getInt("x") - this.areaX1) * this.areaScaling.floatValue();
                            float y = (float)(obj.getInt("y") - this.areaY1) * this.areaScaling.floatValue();
                            float w = (float)obj.getInt("w") * this.areaScaling.floatValue();
                            if (this.flipX) {
                                x = (float)this.areaWidth - x;
                            }
                            if (this.flipY) {
                                y = (float)this.areaHeight - y;
                            }
                            sb.append("ellipse(");
                            sb.append(x);
                            sb.append(",");
                            sb.append(y);
                            sb.append(",");
                            sb.append(w);
                            sb.append(",");
                            sb.append(w);
                            sb.append(",");
                            sb.append(this.borderColor);
                            sb.append(",");
                            sb.append(this.fillColor);
                            sb.append(");");
                            ++i4;
                        }
                        this.uiSet("area", "draw", sb.toString());
                    }
                    return true;
                }
            } else {
                this.errorLog("Unknown message " + this.cmd[0] + this.cmd[1]);
            }
        } else {
            this.errorLog("Unknown message " + this.cmd[0] + this.cmd[1]);
        }
        return false;
    }

    public boolean end() {
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventsListener.end();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ioWrite("connection", "offline");
        return true;
    }

    @Override
    public void ioWrite(String name, String value) {
        super.ioWrite(name, value);
    }

    @Override
    public void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    public void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }
}

