/*
 * Decompiled with CFR 0.152.
 */
package drivers.protege;

import com.hsyco.driverBase;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import drivers.protege.Listener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class Driver
extends driverBase {
    public static final String VERSION = "1.29";
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    public boolean gui = true;
    private boolean startupevent = false;
    public boolean genEvent = false;
    public boolean debug = false;
    public boolean quit = false;
    private int readErrorCounter = 0;
    private long lastReadTs;
    private String host = "";
    private int port = 502;
    public String name = null;
    private static int READINITTIMEOUT = 60;
    private static int READTIMEOUT = 500;
    private static int READPAUSE = 100;
    private String pin = "1234";
    private List<Long> areaslist = new ArrayList<Long>();
    private List<Long> doorslist = new ArrayList<Long>();
    private List<Long> inputslist = new ArrayList<Long>();
    private List<Long> troubleinputslist = new ArrayList<Long>();
    private List<Long> outputslist = new ArrayList<Long>();
    public boolean isFirstLoop = true;
    public boolean endFirstLoop = false;
    private int writeErrorCounter = 0;
    public long areasLastIndex = 0L;
    public long inputsLastIndex = 0L;
    public long outputsLastIndex = 0L;
    public long doorsLastIndex = 0L;
    public long troubleInputsLastIndex = 0L;
    public int whichCase = -1;
    private Object pollingkLock = new Object();
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss dd/MM");
    private int logSize = 500;
    private List<String> logs = new ArrayList<String>();
    private String logVar;
    private byte[] LOGIN4;
    private byte[] LOGIN5;
    private byte[] LOGIN6;
    private byte[] AREYOUTHERE;
    private byte[] PANELDESCRIPTION;
    private byte[] STARTREQUESTEVENTS2;
    private byte[] STOPREQUESTEVENTS;
    private byte[] ACK;
    private byte[] ACKCONFIGURATION1;
    private byte[] ACKCONFIGURATION2;
    private byte[] REQAREASTATUS;
    private byte[] REQDOORSTATUS;
    private byte[] REQOUTPUTSTATUS;
    private byte[] REQINPUTSTATUS;
    private byte[] REQTROUBLEINPUTSTATUS;
    private byte[] DISARMAREA;
    private byte[] DISARMAREA24H;
    private byte[] DISARMALL;
    private byte[] ARMAREA;
    private byte[] ARMAREAFORCE;
    private byte[] ARMAREASTAY;
    private byte[] ARMAREAINSTANT;
    private byte[] OUTPUTOFF;
    private byte[] OUTPUTON;
    private byte[] OUTPUTONTIMED;
    private byte[] LOCKDOOR;
    private byte[] UNLOCKDOOR;
    private byte[] UNLOCKDOORLATCHED;
    private byte[] REMOVEINPUTBYPASS;
    private byte[] TEMPORARILYINPUTBYPASS;
    private byte[] PERMANENTLYINPUTBYPASS;
    private byte[] REMOVETROUBLEINPUTBYPASS;
    private byte[] TEMPORARILYTROUBLEINPUTBYPASS;
    private byte[] PERMANENTLYTROUBLEINPUTBYPASS;
    private byte[] GETVARIABLE;
    private byte[] SETVARIABLE;
    private Socket deviceSocket;
    private List<Byte> response;
    private Listener listener;
    public BufferedOutputStream dOut;
    public BufferedInputStream dIn;

    public Driver() {
        byte[] byArray = new byte[13];
        byArray[0] = 73;
        byArray[1] = 67;
        byArray[2] = 13;
        byArray[7] = 2;
        byArray[8] = 1;
        byArray[9] = 2;
        byArray[10] = 3;
        byArray[11] = 4;
        byArray[12] = -1;
        this.LOGIN4 = byArray;
        byte[] byArray2 = new byte[14];
        byArray2[0] = 73;
        byArray2[1] = 67;
        byArray2[2] = 13;
        byArray2[7] = 2;
        byArray2[8] = 1;
        byArray2[9] = 2;
        byArray2[10] = 3;
        byArray2[11] = 4;
        byArray2[12] = 5;
        byArray2[13] = -1;
        this.LOGIN5 = byArray2;
        byte[] byArray3 = new byte[14];
        byArray3[0] = 73;
        byArray3[1] = 67;
        byArray3[2] = 13;
        byArray3[7] = 2;
        byArray3[8] = 1;
        byArray3[9] = 2;
        byArray3[10] = 3;
        byArray3[11] = 4;
        byArray3[12] = 5;
        byArray3[13] = 6;
        this.LOGIN6 = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = 73;
        byArray4[1] = 67;
        byArray4[2] = 8;
        this.AREYOUTHERE = byArray4;
        byte[] byArray5 = new byte[8];
        byArray5[0] = 73;
        byArray5[1] = 67;
        byArray5[2] = 8;
        byArray5[7] = 1;
        this.PANELDESCRIPTION = byArray5;
        byte[] byArray6 = new byte[10];
        byArray6[0] = 73;
        byArray6[1] = 67;
        byArray6[2] = 10;
        byArray6[7] = 6;
        byArray6[8] = 1;
        this.STARTREQUESTEVENTS2 = byArray6;
        byte[] byArray7 = new byte[10];
        byArray7[0] = 73;
        byArray7[1] = 67;
        byArray7[2] = 10;
        byArray7[7] = 6;
        byArray7[9] = 1;
        this.STOPREQUESTEVENTS = byArray7;
        byte[] byArray8 = new byte[8];
        byArray8[0] = 73;
        byArray8[1] = 67;
        byArray8[2] = 8;
        byArray8[4] = -64;
        byArray8[6] = -1;
        this.ACK = byArray8;
        byte[] byArray9 = new byte[16];
        byArray9[0] = 73;
        byArray9[1] = 67;
        byArray9[2] = 16;
        byArray9[7] = 7;
        byArray9[8] = 1;
        byArray9[9] = 1;
        byArray9[10] = 1;
        this.ACKCONFIGURATION1 = byArray9;
        byte[] byArray10 = new byte[16];
        byArray10[0] = 73;
        byArray10[1] = 67;
        byArray10[2] = 16;
        byArray10[7] = 7;
        byArray10[8] = 1;
        this.ACKCONFIGURATION2 = byArray10;
        byte[] byArray11 = new byte[12];
        byArray11[0] = 73;
        byArray11[1] = 67;
        byArray11[2] = 12;
        byArray11[6] = 2;
        byArray11[7] = -128;
        byArray11[8] = 1;
        this.REQAREASTATUS = byArray11;
        byte[] byArray12 = new byte[12];
        byArray12[0] = 73;
        byArray12[1] = 67;
        byArray12[2] = 12;
        byArray12[6] = 1;
        byArray12[7] = -128;
        byArray12[8] = 1;
        this.REQDOORSTATUS = byArray12;
        byte[] byArray13 = new byte[12];
        byArray13[0] = 73;
        byArray13[1] = 67;
        byArray13[2] = 12;
        byArray13[6] = 3;
        byArray13[7] = -128;
        byArray13[8] = 1;
        this.REQOUTPUTSTATUS = byArray13;
        byte[] byArray14 = new byte[12];
        byArray14[0] = 73;
        byArray14[1] = 67;
        byArray14[2] = 12;
        byArray14[6] = 4;
        byArray14[7] = -128;
        byArray14[8] = 1;
        this.REQINPUTSTATUS = byArray14;
        byte[] byArray15 = new byte[12];
        byArray15[0] = 73;
        byArray15[1] = 67;
        byArray15[2] = 12;
        byArray15[6] = 6;
        byArray15[7] = -128;
        byArray15[8] = 1;
        this.REQTROUBLEINPUTSTATUS = byArray15;
        byte[] byArray16 = new byte[12];
        byArray16[0] = 73;
        byArray16[1] = 67;
        byArray16[2] = 12;
        byArray16[6] = 2;
        byArray16[8] = 1;
        this.DISARMAREA = byArray16;
        byte[] byArray17 = new byte[12];
        byArray17[0] = 73;
        byArray17[1] = 67;
        byArray17[2] = 12;
        byArray17[6] = 2;
        byArray17[7] = 1;
        byArray17[8] = 1;
        this.DISARMAREA24H = byArray17;
        byte[] byArray18 = new byte[12];
        byArray18[0] = 73;
        byArray18[1] = 67;
        byArray18[2] = 12;
        byArray18[6] = 2;
        byArray18[7] = 2;
        byArray18[8] = 1;
        this.DISARMALL = byArray18;
        byte[] byArray19 = new byte[12];
        byArray19[0] = 73;
        byArray19[1] = 67;
        byArray19[2] = 12;
        byArray19[6] = 2;
        byArray19[7] = 3;
        byArray19[8] = 1;
        this.ARMAREA = byArray19;
        byte[] byArray20 = new byte[12];
        byArray20[0] = 73;
        byArray20[1] = 67;
        byArray20[2] = 12;
        byArray20[6] = 2;
        byArray20[7] = 4;
        byArray20[8] = 1;
        this.ARMAREAFORCE = byArray20;
        byte[] byArray21 = new byte[12];
        byArray21[0] = 73;
        byArray21[1] = 67;
        byArray21[2] = 12;
        byArray21[6] = 2;
        byArray21[7] = 5;
        byArray21[8] = 1;
        this.ARMAREASTAY = byArray21;
        byte[] byArray22 = new byte[12];
        byArray22[0] = 73;
        byArray22[1] = 67;
        byArray22[2] = 12;
        byArray22[6] = 2;
        byArray22[7] = 6;
        byArray22[8] = 1;
        this.ARMAREAINSTANT = byArray22;
        byte[] byArray23 = new byte[12];
        byArray23[0] = 73;
        byArray23[1] = 67;
        byArray23[2] = 12;
        byArray23[6] = 3;
        byArray23[8] = 1;
        this.OUTPUTOFF = byArray23;
        byte[] byArray24 = new byte[12];
        byArray24[0] = 73;
        byArray24[1] = 67;
        byArray24[2] = 12;
        byArray24[6] = 3;
        byArray24[7] = 1;
        byArray24[8] = 1;
        this.OUTPUTON = byArray24;
        byte[] byArray25 = new byte[14];
        byArray25[0] = 73;
        byArray25[1] = 67;
        byArray25[2] = 12;
        byArray25[6] = 3;
        byArray25[7] = 2;
        byArray25[8] = 1;
        byArray25[12] = 1;
        byArray25[13] = 1;
        this.OUTPUTONTIMED = byArray25;
        byte[] byArray26 = new byte[12];
        byArray26[0] = 73;
        byArray26[1] = 67;
        byArray26[2] = 12;
        byArray26[6] = 1;
        byArray26[8] = 1;
        this.LOCKDOOR = byArray26;
        byte[] byArray27 = new byte[12];
        byArray27[0] = 73;
        byArray27[1] = 67;
        byArray27[2] = 12;
        byArray27[6] = 1;
        byArray27[7] = 1;
        byArray27[8] = 1;
        this.UNLOCKDOOR = byArray27;
        byte[] byArray28 = new byte[12];
        byArray28[0] = 73;
        byArray28[1] = 67;
        byArray28[2] = 12;
        byArray28[6] = 1;
        byArray28[7] = 2;
        byArray28[8] = 1;
        this.UNLOCKDOORLATCHED = byArray28;
        byte[] byArray29 = new byte[12];
        byArray29[0] = 73;
        byArray29[1] = 67;
        byArray29[2] = 12;
        byArray29[6] = 4;
        byArray29[8] = 1;
        this.REMOVEINPUTBYPASS = byArray29;
        byte[] byArray30 = new byte[12];
        byArray30[0] = 73;
        byArray30[1] = 67;
        byArray30[2] = 12;
        byArray30[6] = 4;
        byArray30[7] = 1;
        byArray30[8] = 1;
        this.TEMPORARILYINPUTBYPASS = byArray30;
        byte[] byArray31 = new byte[12];
        byArray31[0] = 73;
        byArray31[1] = 67;
        byArray31[2] = 12;
        byArray31[6] = 4;
        byArray31[7] = 2;
        byArray31[8] = 1;
        this.PERMANENTLYINPUTBYPASS = byArray31;
        byte[] byArray32 = new byte[12];
        byArray32[0] = 73;
        byArray32[1] = 67;
        byArray32[2] = 12;
        byArray32[6] = 6;
        byArray32[8] = 1;
        this.REMOVETROUBLEINPUTBYPASS = byArray32;
        byte[] byArray33 = new byte[12];
        byArray33[0] = 73;
        byArray33[1] = 67;
        byArray33[2] = 12;
        byArray33[6] = 6;
        byArray33[7] = 1;
        byArray33[8] = 1;
        this.TEMPORARILYTROUBLEINPUTBYPASS = byArray33;
        byte[] byArray34 = new byte[12];
        byArray34[0] = 73;
        byArray34[1] = 67;
        byArray34[2] = 12;
        byArray34[6] = 6;
        byArray34[7] = 2;
        byArray34[8] = 1;
        this.PERMANENTLYTROUBLEINPUTBYPASS = byArray34;
        byte[] byArray35 = new byte[12];
        byArray35[0] = 73;
        byArray35[1] = 67;
        byArray35[2] = 12;
        byArray35[6] = 5;
        byArray35[7] = -128;
        byArray35[8] = 1;
        this.GETVARIABLE = byArray35;
        byte[] byArray36 = new byte[14];
        byArray36[0] = 73;
        byArray36[1] = 67;
        byArray36[2] = 14;
        byArray36[6] = 5;
        byArray36[8] = 1;
        byArray36[12] = 52;
        byArray36[13] = 18;
        this.SETVARIABLE = byArray36;
        this.deviceSocket = new Socket();
        this.response = new ArrayList<Byte>();
        this.listener = new Listener(this);
        this.dOut = null;
        this.dIn = null;
    }

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            this.host = config.get("host");
            this.port = Integer.parseInt(config.get("port"));
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
        }
        String s = config.get("gui");
        if (s != null) {
            try {
                this.gui = Boolean.parseBoolean(s);
            }
            catch (Exception e3) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - gui ignored");
            }
        }
        if ((s = config.get("startupevents")) != null) {
            try {
                this.genEvent = this.startupevent = Boolean.parseBoolean(s);
            }
            catch (Exception e4) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - startupevents ignored");
            }
        }
        if ((s = config.get("debug")) != null) {
            try {
                this.debug = Boolean.parseBoolean(s);
            }
            catch (Exception e5) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - debug ignored");
            }
        }
        if ((s = config.get("readtime")) != null) {
            try {
                READINITTIMEOUT = Integer.parseInt(s);
                if (READINITTIMEOUT < 60) {
                    READINITTIMEOUT = 60;
                }
            }
            catch (Exception e6) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - readTime ignored");
            }
        }
        if ((s = config.get("pin")) != null) {
            try {
                this.pin = s;
            }
            catch (Exception e7) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - pin ignored");
            }
        }
        if ((s = config.get("areaslist")) != null) {
            try {
                this.areaslist = this.indexingCreator(s);
                this.areasLastIndex = this.areaslist.get(this.areaslist.size() - 1);
            }
            catch (Exception e8) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - areaslist default setting");
                this.areaslist = this.indexingCreator("0");
            }
        }
        if ((s = config.get("doorslist")) != null) {
            try {
                this.doorslist = this.indexingCreator(s);
                this.doorsLastIndex = this.doorslist.get(this.doorslist.size() - 1);
            }
            catch (Exception e9) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - doorslist ignored");
            }
        }
        if ((s = config.get("inputslist")) != null) {
            try {
                this.inputslist = this.indexingCreator(s);
                this.inputsLastIndex = this.inputslist.get(this.inputslist.size() - 1);
            }
            catch (Exception e10) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - inputslist ignored");
            }
        }
        if ((s = config.get("troubleinputslist")) != null) {
            try {
                this.troubleinputslist = this.indexingCreator(s);
                this.troubleInputsLastIndex = this.troubleinputslist.get(this.troubleinputslist.size() - 1);
            }
            catch (Exception e11) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - troubleinputslist ignored");
            }
        }
        if ((s = config.get("outputslist")) != null) {
            try {
                this.outputslist = this.indexingCreator(s);
                this.outputsLastIndex = this.outputslist.get(this.outputslist.size() - 1);
            }
            catch (Exception e12) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - outputslist ignored");
            }
        }
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(name) + " - PROTEGE DRIVER STARTUP, host:" + this.host + " | port: " + this.port + " | pin: " + this.pin + " | driver version: " + VERSION);
            this.messageLog(String.valueOf(name) + " - PROTEGE DRIVER STARTUP, areaslist: " + this.areaslist.toString());
            this.messageLog(String.valueOf(name) + " - PROTEGE DRIVER STARTUP, doorslist: " + this.doorslist.toString());
            this.messageLog(String.valueOf(name) + " - PROTEGE DRIVER STARTUP, inputslist: " + this.inputslist.toString());
            this.messageLog(String.valueOf(name) + " - PROTEGE DRIVER STARTUP, outputslist: " + this.outputslist.toString());
            this.messageLog(String.valueOf(name) + " - PROTEGE DRIVER STARTUP, troubleinputslist: " + this.troubleinputslist.toString());
            this.messageLog(String.valueOf(name) + " - PROTEGE DRIVER STARTUP, last indexes - a: " + this.areasLastIndex + " i: " + this.inputsLastIndex + " o: " + this.outputsLastIndex + " d: " + this.doorsLastIndex + " ti:" + this.troubleInputsLastIndex);
        }
        this.sleep(3000L);
        if (this.startUp()) {
            this.quit = false;
            return true;
        }
        return false;
    }

    private List<Long> indexingCreator(String list) {
        String[] spl1;
        ArrayList<Long> l2 = new ArrayList<Long>();
        list = list.replaceAll("\\s+", "");
        String[] stringArray = spl1 = list.split("\\;");
        int n2 = spl1.length;
        int n3 = 0;
        while (n3 < n2) {
            String addr = stringArray[n3];
            if (addr.contains("-")) {
                String[] spl2 = addr.split("\\-");
                Long startIndex = Long.valueOf(spl2[0]);
                Long endIndex = Long.valueOf(spl2[1]);
                Long i2 = startIndex;
                while (i2 <= endIndex) {
                    if (!l2.contains(i2)) {
                        l2.add(i2);
                    }
                    i2 = i2 + 1L;
                }
            } else {
                Long thisIndex = Long.valueOf(addr);
                if (!l2.contains(thisIndex)) {
                    l2.add(thisIndex);
                }
            }
            ++n3;
        }
        return l2;
    }

    public boolean end() {
        this.listener.run = false;
        try {
            try {
                this.genEvent = true;
                this.ioWrite("connection", "offline");
                this.securityLog("HSYCO OFFLINE");
                if (!this.deviceSocket.isClosed()) {
                    this.dOut.close();
                    this.dIn.close();
                    this.deviceSocket.close();
                }
            }
            catch (SocketException e2) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " - END - socket exception: " + e2.getMessage());
                }
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " - END - the driver will be restarted");
                }
            }
            catch (IOException e3) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " - END - io exception: " + e3.getMessage());
                }
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " - END - the driver will be restarted");
                }
            }
        }
        finally {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + " - END - the driver will be restarted");
            }
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        if (name.startsWith("a")) {
            byte[] byArray = new byte[4];
            byArray[0] = 1;
            byte[] aIndex = byArray;
            String sIndex = name.substring(1);
            aIndex = this.longToByteArray(Integer.parseInt(sIndex), aIndex);
            if (value.equals("arm")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - area " + sIndex + " arm");
                this.ARMAREA[8] = aIndex[0];
                this.ARMAREA[9] = aIndex[1];
                this.ARMAREA[10] = aIndex[2];
                this.ARMAREA[11] = aIndex[3];
                this.sendCommand(this.ARMAREA);
            } else if (value.equals("armforce")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - area " + sIndex + " armforce");
                this.ARMAREAFORCE[8] = aIndex[0];
                this.ARMAREAFORCE[9] = aIndex[1];
                this.ARMAREAFORCE[10] = aIndex[2];
                this.ARMAREAFORCE[11] = aIndex[3];
                this.sendCommand(this.ARMAREAFORCE);
            } else if (value.equals("armstay")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - area " + sIndex + " armstay");
                this.ARMAREASTAY[8] = aIndex[0];
                this.ARMAREASTAY[9] = aIndex[1];
                this.ARMAREASTAY[10] = aIndex[2];
                this.ARMAREASTAY[11] = aIndex[3];
                this.sendCommand(this.ARMAREASTAY);
            } else if (value.equals("arminstant")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - area " + sIndex + " arminstant");
                this.ARMAREAINSTANT[8] = aIndex[0];
                this.ARMAREAINSTANT[9] = aIndex[1];
                this.ARMAREAINSTANT[10] = aIndex[2];
                this.ARMAREAINSTANT[11] = aIndex[3];
                this.sendCommand(this.ARMAREAINSTANT);
            } else if (value.equals("disarm")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - area " + sIndex + " disarm");
                this.DISARMAREA[8] = aIndex[0];
                this.DISARMAREA[9] = aIndex[1];
                this.DISARMAREA[10] = aIndex[2];
                this.DISARMAREA[11] = aIndex[3];
                this.sendCommand(this.DISARMAREA);
            } else if (value.equals("disarm24h")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - area " + sIndex + " disarm24h");
                this.DISARMAREA24H[8] = aIndex[0];
                this.DISARMAREA24H[9] = aIndex[1];
                this.DISARMAREA24H[10] = aIndex[2];
                this.DISARMAREA24H[11] = aIndex[3];
                this.sendCommand(this.DISARMALL);
            } else if (value.equals("disarmall")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - area " + sIndex + " disarmall");
                this.DISARMALL[8] = aIndex[0];
                this.DISARMALL[9] = aIndex[1];
                this.DISARMALL[10] = aIndex[2];
                this.DISARMALL[11] = aIndex[3];
                this.sendCommand(this.DISARMALL);
            }
        } else if (name.startsWith("o")) {
            byte[] byArray = new byte[4];
            byArray[0] = 1;
            byte[] aIndex = byArray;
            String sIndex = name.substring(1);
            aIndex = this.longToByteArray(Integer.parseInt(sIndex), aIndex);
            if (value.equals("on")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - output " + sIndex + " on");
                this.OUTPUTON[8] = aIndex[0];
                this.OUTPUTON[9] = aIndex[1];
                this.OUTPUTON[10] = aIndex[2];
                this.OUTPUTON[11] = aIndex[3];
                this.sendCommand(this.OUTPUTON);
            } else if (value.equals("off")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - output " + sIndex + " off");
                this.OUTPUTOFF[8] = aIndex[0];
                this.OUTPUTOFF[9] = aIndex[1];
                this.OUTPUTOFF[10] = aIndex[2];
                this.OUTPUTOFF[11] = aIndex[3];
                this.sendCommand(this.OUTPUTOFF);
            } else if (value.startsWith("ontimed-")) {
                String[] spl2 = value.split("\\-");
                int interval = Integer.parseInt(spl2[1]);
                byte[] bIndex = new byte[2];
                this.intToByteArray(interval, bIndex);
                this.messageLog(String.valueOf(name) + " - COMMAND - output timed " + sIndex + " - interval: " + interval);
                this.OUTPUTONTIMED[8] = aIndex[0];
                this.OUTPUTONTIMED[9] = aIndex[1];
                this.OUTPUTONTIMED[10] = aIndex[2];
                this.OUTPUTONTIMED[11] = aIndex[3];
                this.OUTPUTONTIMED[12] = bIndex[0];
                this.OUTPUTONTIMED[13] = bIndex[1];
                this.sendCommand(this.OUTPUTONTIMED);
            }
        } else if (name.startsWith("d")) {
            byte[] byArray = new byte[4];
            byArray[0] = 1;
            byte[] aIndex = byArray;
            String sIndex = name.substring(1);
            aIndex = this.longToByteArray(Integer.parseInt(sIndex), aIndex);
            if (value.equals("lock")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - door " + sIndex + " lock");
                this.LOCKDOOR[8] = aIndex[0];
                this.LOCKDOOR[9] = aIndex[1];
                this.LOCKDOOR[10] = aIndex[2];
                this.LOCKDOOR[11] = aIndex[3];
                this.sendCommand(this.LOCKDOOR);
            } else if (value.equals("unlock")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - door " + sIndex + " unlock");
                this.UNLOCKDOOR[8] = aIndex[0];
                this.UNLOCKDOOR[9] = aIndex[1];
                this.UNLOCKDOOR[10] = aIndex[2];
                this.UNLOCKDOOR[11] = aIndex[3];
                this.sendCommand(this.UNLOCKDOOR);
            } else if (value.equals("unlocklatched")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - door " + sIndex + " unlocklatched");
                this.UNLOCKDOORLATCHED[8] = aIndex[0];
                this.UNLOCKDOORLATCHED[9] = aIndex[1];
                this.UNLOCKDOORLATCHED[10] = aIndex[2];
                this.UNLOCKDOORLATCHED[11] = aIndex[3];
                this.sendCommand(this.UNLOCKDOORLATCHED);
            }
        } else if (name.startsWith("i")) {
            byte[] byArray = new byte[4];
            byArray[0] = 1;
            byte[] aIndex = byArray;
            String sIndex = name.substring(1);
            aIndex = this.longToByteArray(Integer.parseInt(sIndex), aIndex);
            if (value.equals("removebypass")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - input " + sIndex + " remove bypass");
                this.REMOVEINPUTBYPASS[8] = aIndex[0];
                this.REMOVEINPUTBYPASS[9] = aIndex[1];
                this.REMOVEINPUTBYPASS[10] = aIndex[2];
                this.REMOVEINPUTBYPASS[11] = aIndex[3];
                this.sendCommand(this.REMOVEINPUTBYPASS);
            } else if (value.equals("tempbypass")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - input " + sIndex + " temporarily bypass");
                this.TEMPORARILYINPUTBYPASS[8] = aIndex[0];
                this.TEMPORARILYINPUTBYPASS[9] = aIndex[1];
                this.TEMPORARILYINPUTBYPASS[10] = aIndex[2];
                this.TEMPORARILYINPUTBYPASS[11] = aIndex[3];
                this.sendCommand(this.TEMPORARILYINPUTBYPASS);
            } else if (value.equals("bypass")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - input " + sIndex + " permanently bypass");
                this.PERMANENTLYINPUTBYPASS[8] = aIndex[0];
                this.PERMANENTLYINPUTBYPASS[9] = aIndex[1];
                this.PERMANENTLYINPUTBYPASS[10] = aIndex[2];
                this.PERMANENTLYINPUTBYPASS[11] = aIndex[3];
                this.sendCommand(this.PERMANENTLYINPUTBYPASS);
            }
        } else if (name.startsWith("ti")) {
            byte[] byArray = new byte[4];
            byArray[0] = 1;
            byte[] aIndex = byArray;
            String sIndex = name.substring(1);
            aIndex = this.longToByteArray(Integer.parseInt(sIndex), aIndex);
            if (value.equals("removebypass")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - trouble input " + sIndex + " remove bypass");
                this.REMOVETROUBLEINPUTBYPASS[8] = aIndex[0];
                this.REMOVETROUBLEINPUTBYPASS[9] = aIndex[1];
                this.REMOVETROUBLEINPUTBYPASS[10] = aIndex[2];
                this.REMOVETROUBLEINPUTBYPASS[11] = aIndex[3];
                this.sendCommand(this.REMOVETROUBLEINPUTBYPASS);
            } else if (value.equals("tempbypass")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - trouble input " + sIndex + " temporarily bypass");
                this.TEMPORARILYTROUBLEINPUTBYPASS[8] = aIndex[0];
                this.TEMPORARILYTROUBLEINPUTBYPASS[9] = aIndex[1];
                this.TEMPORARILYTROUBLEINPUTBYPASS[10] = aIndex[2];
                this.TEMPORARILYTROUBLEINPUTBYPASS[11] = aIndex[3];
                this.sendCommand(this.TEMPORARILYTROUBLEINPUTBYPASS);
            } else if (value.equals("bypass")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - trouble input " + sIndex + " permanently bypass");
                this.PERMANENTLYTROUBLEINPUTBYPASS[8] = aIndex[0];
                this.PERMANENTLYTROUBLEINPUTBYPASS[9] = aIndex[1];
                this.PERMANENTLYTROUBLEINPUTBYPASS[10] = aIndex[2];
                this.PERMANENTLYTROUBLEINPUTBYPASS[11] = aIndex[3];
                this.sendCommand(this.PERMANENTLYTROUBLEINPUTBYPASS);
            }
        } else if (name.startsWith("v")) {
            byte[] byArray = new byte[4];
            byArray[0] = 1;
            byte[] aIndex = byArray;
            String sIndex = name.substring(1);
            aIndex = this.longToByteArray(Integer.parseInt(sIndex), aIndex);
            if (value.equals("get")) {
                this.messageLog(String.valueOf(name) + " - COMMAND - variable " + sIndex + " get");
                this.GETVARIABLE[8] = aIndex[0];
                this.GETVARIABLE[9] = aIndex[1];
                this.GETVARIABLE[10] = aIndex[2];
                this.GETVARIABLE[11] = aIndex[3];
                this.sendCommand(this.GETVARIABLE);
            } else {
                this.messageLog(String.valueOf(name) + " - COMMAND - variable " + sIndex + " write value: " + value);
                this.SETVARIABLE[8] = aIndex[0];
                this.SETVARIABLE[9] = aIndex[1];
                this.SETVARIABLE[10] = aIndex[2];
                this.SETVARIABLE[11] = aIndex[3];
                int val = Integer.parseInt(value);
                byte[] bIndex = new byte[2];
                this.intToByteArray(val, bIndex);
                this.SETVARIABLE[12] = bIndex[0];
                this.SETVARIABLE[13] = bIndex[1];
                this.sendCommand(this.SETVARIABLE);
            }
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.genEvent) {
            super.ioWrite(name, value);
            if (!name.contains("log")) {
                this.addToLog(name, value);
            }
        } else {
            super.ioWriteNoEvents(name, value);
        }
        if (this.gui) {
            if (value.equals("1")) {
                this.uiSet(String.valueOf(name) + ".1", "visible", "true");
                this.uiSet(String.valueOf(name) + ".0", "visible", "false");
            } else if (value.equals("0")) {
                this.uiSet(String.valueOf(name) + ".1", "visible", "false");
                this.uiSet(String.valueOf(name) + ".0", "visible", "true");
            }
        }
    }

    @Override
    protected void ioWriteForced(String name, String value) {
        super.ioWriteForced(name, value);
    }

    @Override
    protected boolean isVerboseLog() {
        return super.isVerboseLog();
    }

    @Override
    protected void messageLog(String s) {
        super.messageLog(s);
    }

    @Override
    protected void uiSet(String id, String attr, String value) {
        super.uiSet(id, attr, value);
    }

    private boolean startUp() {
        block31: {
            block29: {
                block30: {
                    this.deviceSocket.connect(new InetSocketAddress(this.host, this.port), 3000);
                    this.deviceSocket.setSoTimeout(3000);
                    this.dOut = new BufferedOutputStream(this.deviceSocket.getOutputStream());
                    this.dIn = new BufferedInputStream(this.deviceSocket.getInputStream());
                    this.sendCommand(this.setPin());
                    this.response = this.readSomething(this.dIn);
                    if (this.response.size() <= 1) break block29;
                    if (this.response.get(0) != 73 || this.response.get(1) != 67 || this.response.get(6) != -1 || this.response.get(7) != 0) break block30;
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + " - STARTUP - login ack");
                    }
                    this.sendCommand(this.STOPREQUESTEVENTS);
                    this.response = this.readSomething(this.dIn);
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + " - STARTUP - request log events stop");
                    }
                    this.sendCommand(this.ACKCONFIGURATION2);
                    this.response = this.readSomething(this.dIn);
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + " - STARTUP - ack configuration");
                    }
                    this.sleep(READPAUSE);
                    this.sendCommand(this.ACK);
                    this.sleep(READPAUSE);
                    this.sendCommand(this.PANELDESCRIPTION);
                    long startTime = System.currentTimeMillis();
                    boolean read = true;
                    while (read && System.currentTimeMillis() - startTime < 10000L) {
                        this.response = this.readSomething(this.dIn);
                        if (this.response.get(4) == 1) {
                            byte[] arrB;
                            if (this.response.get(6) == 0 && this.response.get(8) == 4) {
                                arrB = new byte[]{this.response.get(12), this.response.get(11), this.response.get(10), this.response.get(9)};
                                this.ioWrite("panel.serial.number", Driver.bytesToHex(arrB));
                            } else if (this.isVerboseLog()) {
                                this.messageLog(String.valueOf(this.name) + " - STARTUP - panel serial number error");
                            }
                            if (this.response.get(13) == 1) {
                                arrB = new byte[]{this.response.get(16)};
                                this.ioWrite("panel.hardware.version", Driver.bytesToHex(arrB));
                            } else if (this.isVerboseLog()) {
                                this.messageLog(String.valueOf(this.name) + " - STARTUP - panel hardware number error");
                            }
                            if (this.response.get(17) == 2) {
                                this.ioWrite("panel.firmware.type", String.valueOf((char)this.response.get(20).byteValue()) + (char)this.response.get(21).byteValue());
                            } else if (this.isVerboseLog()) {
                                this.messageLog(String.valueOf(this.name) + " - STARTUP - panel firmware type error");
                            }
                            if (this.response.get(22) == 3) {
                                arrB = new byte[]{this.response.get(26), this.response.get(25)};
                                this.ioWrite("panel.firmware.version", Driver.bytesToHex(arrB));
                            } else if (this.isVerboseLog()) {
                                this.messageLog(String.valueOf(this.name) + " - STARTUP - panel firmware version error");
                            }
                            if (this.response.get(27) == 4) {
                                arrB = new byte[]{this.response.get(31), this.response.get(30)};
                                this.ioWrite("panel.firmware.build", Driver.bytesToHex(arrB));
                                read = false;
                            } else if (this.isVerboseLog()) {
                                this.messageLog(String.valueOf(this.name) + " - STARTUP - panel firmware build error");
                            }
                        }
                        this.sleep(READPAUSE);
                    }
                    this.sendCommand(this.STARTREQUESTEVENTS2);
                    this.response = this.readSomething(this.dIn);
                    this.openCSVFiles();
                    this.sleep(READPAUSE);
                    this.listener.start();
                    this.listener.run = true;
                    return true;
                }
                if (this.response.get(0) == 73 && this.response.get(1) == 67 && this.response.get(6) == -1 && this.response.get(7) == -1) {
                    this.readNack(this.response);
                    break block31;
                }
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " - STARTUP - bad response, driver restart");
                    this.genEvent = false;
                }
                return false;
            }
            try {
                this.messageLog(String.valueOf(this.name) + " - EXCEPTION - no response on login, set new ack configuration, restart and wait...");
                this.sendCommand(this.ACKCONFIGURATION1);
                return false;
            }
            catch (UnknownHostException e2) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " - EXCEPTION - UnknownHostException: don't know this host: " + e2.getMessage());
                }
                return false;
            }
            catch (IOException e3) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " - EXCEPTION - Caught IOException: couldn't get I/O for this connection: " + e3.getMessage());
                }
                return false;
            }
        }
        return false;
    }

    private byte[] setPin() {
        if (this.pin.length() == 4) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + " - PIN - 4 digits: " + this.pin);
            }
            this.LOGIN4[8] = (byte)(this.pin.charAt(0) - 48);
            this.LOGIN4[9] = (byte)(this.pin.charAt(1) - 48);
            this.LOGIN4[10] = (byte)(this.pin.charAt(2) - 48);
            this.LOGIN4[11] = (byte)(this.pin.charAt(3) - 48);
            return this.LOGIN4;
        }
        if (this.pin.length() == 5) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + " - PIN - 5 digits: " + this.pin);
            }
            this.LOGIN5[8] = (byte)(this.pin.charAt(0) - 48);
            this.LOGIN5[9] = (byte)(this.pin.charAt(1) - 48);
            this.LOGIN5[10] = (byte)(this.pin.charAt(2) - 48);
            this.LOGIN5[11] = (byte)(this.pin.charAt(3) - 48);
            this.LOGIN5[12] = (byte)(this.pin.charAt(4) - 48);
            return this.LOGIN5;
        }
        if (this.pin.length() == 6) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + " - PIN - 6 digits: " + this.pin);
            }
            this.LOGIN6[8] = (byte)(this.pin.charAt(0) - 48);
            this.LOGIN6[9] = (byte)(this.pin.charAt(1) - 48);
            this.LOGIN6[10] = (byte)(this.pin.charAt(2) - 48);
            this.LOGIN6[11] = (byte)(this.pin.charAt(3) - 48);
            this.LOGIN6[12] = (byte)(this.pin.charAt(4) - 48);
            this.LOGIN6[13] = (byte)(this.pin.charAt(5) - 48);
            return this.LOGIN6;
        }
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + " - PIN - error in digits number: " + this.pin);
        }
        return this.LOGIN4;
    }

    private void readNack(List<Byte> resp) {
        byte eventcode1 = this.response.get(9);
        byte eventcode2 = this.response.get(8);
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + " - NACK - eventcode: " + eventcode1 + ":" + eventcode2);
            this.ioWrite("last.nack.code", String.valueOf(eventcode1) + eventcode2);
            if (eventcode1 == 3 && eventcode2 == 2) {
                this.messageLog(String.valueOf(this.name) + " - NACK - a login was received but the PIN did not match a valid user");
            } else if (eventcode1 == 3 && eventcode2 == 1) {
                this.messageLog(String.valueOf(this.name) + " - NACK - a control command was received while no user was logged in");
            } else if (eventcode1 == 3 && eventcode2 == 0) {
                this.messageLog(String.valueOf(this.name) + " - NACK - a clogin command was received while a user was already logged in");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loop() {
        block39: {
            try {
                if (!this.listener.run || !this.isFirstLoop) break block39;
                byte[] byArray = new byte[4];
                byArray[0] = 1;
                byte[] index = byArray;
                for (long i2 : this.areaslist) {
                    index = this.longToByteArray(i2, index);
                    this.REQAREASTATUS[8] = index[0];
                    this.REQAREASTATUS[9] = index[1];
                    this.REQAREASTATUS[10] = index[2];
                    this.REQAREASTATUS[11] = index[3];
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + " - LOOP - request - areas status - index: " + i2);
                    }
                    this.sendCommand(this.REQAREASTATUS);
                    this.sleep(READINITTIMEOUT);
                }
                if (!this.inputslist.isEmpty()) {
                    for (long i2 : this.inputslist) {
                        index = this.longToByteArray(i2, index);
                        this.REQINPUTSTATUS[8] = index[0];
                        this.REQINPUTSTATUS[9] = index[1];
                        this.REQINPUTSTATUS[10] = index[2];
                        this.REQINPUTSTATUS[11] = index[3];
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + " - LOOP - request - input status - index: " + i2);
                        }
                        this.sendCommand(this.REQINPUTSTATUS);
                        this.sleep(READINITTIMEOUT);
                    }
                }
                if (!this.outputslist.isEmpty()) {
                    for (long i2 : this.outputslist) {
                        index = this.longToByteArray(i2, index);
                        this.REQOUTPUTSTATUS[8] = index[0];
                        this.REQOUTPUTSTATUS[9] = index[1];
                        this.REQOUTPUTSTATUS[10] = index[2];
                        this.REQOUTPUTSTATUS[11] = index[3];
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + " - LOOP - request - output status - index: " + i2);
                        }
                        this.sendCommand(this.REQOUTPUTSTATUS);
                        this.sleep(READINITTIMEOUT);
                    }
                }
                if (!this.doorslist.isEmpty()) {
                    for (long i2 : this.doorslist) {
                        index = this.longToByteArray(i2, index);
                        this.REQDOORSTATUS[8] = index[0];
                        this.REQDOORSTATUS[9] = index[1];
                        this.REQDOORSTATUS[10] = index[2];
                        this.REQDOORSTATUS[11] = index[3];
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + " - LOOP - request - door status - index: " + i2);
                        }
                        this.sendCommand(this.REQDOORSTATUS);
                        this.sleep(READINITTIMEOUT);
                    }
                }
                if (!this.troubleinputslist.isEmpty()) {
                    for (long i2 : this.troubleinputslist) {
                        index = this.longToByteArray(i2, index);
                        this.REQTROUBLEINPUTSTATUS[8] = index[0];
                        this.REQTROUBLEINPUTSTATUS[9] = index[1];
                        this.REQTROUBLEINPUTSTATUS[10] = index[2];
                        this.REQTROUBLEINPUTSTATUS[11] = index[3];
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + " - LOOP - request - trouble input status - index: " + i2);
                        }
                        this.sendCommand(this.REQTROUBLEINPUTSTATUS);
                        this.sleep(READINITTIMEOUT);
                    }
                }
                if (this.inputslist.isEmpty() && this.outputslist.isEmpty() && this.doorslist.isEmpty() && this.troubleinputslist.isEmpty()) {
                    this.endFirstLoop = true;
                    this.whichCase = 0;
                    if (this.isVerboseLog() && this.debug) {
                        this.messageLog(String.valueOf(this.name) + " - LOOP  - case 0");
                    }
                } else if (this.outputslist.isEmpty() && this.doorslist.isEmpty() && this.troubleinputslist.isEmpty()) {
                    this.endFirstLoop = true;
                    this.whichCase = 1;
                    if (this.isVerboseLog() && this.debug) {
                        this.messageLog(String.valueOf(this.name) + " - LOOP - case 1");
                    }
                } else if (this.doorslist.isEmpty() && this.troubleinputslist.isEmpty()) {
                    this.endFirstLoop = true;
                    this.whichCase = 2;
                    if (this.isVerboseLog() && this.debug) {
                        this.messageLog(String.valueOf(this.name) + " - LOOP - case 2");
                    }
                } else if (this.troubleinputslist.isEmpty()) {
                    this.endFirstLoop = true;
                    this.whichCase = 3;
                    if (this.isVerboseLog() && this.debug) {
                        this.messageLog(String.valueOf(this.name) + " - LOOP - case 3");
                    }
                } else {
                    this.endFirstLoop = true;
                    this.whichCase = 4;
                    if (this.isVerboseLog() && this.debug) {
                        this.messageLog(String.valueOf(this.name) + " - LOOP - case 4");
                    }
                }
                this.isFirstLoop = false;
                return !this.quit;
            }
            catch (Exception e2) {
                this.errorLog(String.valueOf(this.name) + " - LOOP - error in loop: " + e2);
                return false;
            }
        }
        if (this.listener.run && !this.isFirstLoop) {
            Object index = this.pollingkLock;
            synchronized (index) {
                block40: {
                    try {
                        this.pollingkLock.wait(10000L);
                    }
                    catch (InterruptedException e3) {
                        if (!this.isVerboseLog()) break block40;
                        this.messageLog(String.valueOf(this.name) + " - LOOP - polltime exception: " + e3.getMessage());
                    }
                }
            }
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + " - LOOP - sending ARE YOU THERE");
            }
            this.sendCommand(this.AREYOUTHERE);
            if (System.currentTimeMillis() - this.lastReadTs > 30000L) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " - LOOP - no communication for more than 30 seconds, quit driver. Last timestamp: " + this.lastReadTs);
                }
                this.quit = true;
            }
            return !this.quit;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public List<Byte> readSomething(BufferedInputStream dIn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Byte> readSomething2(BufferedInputStream dIn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j2 = 0;
        while (j2 < bytes.length) {
            int v = bytes[j2] & 0xFF;
            hexChars[j2 * 2] = hexArray[v >>> 4];
            hexChars[j2 * 2 + 1] = hexArray[v & 0xF];
            ++j2;
        }
        return new String(hexChars);
    }

    public synchronized void sendCommand(byte[] cmd) {
        block4: {
            try {
                this.dOut.write(cmd);
                this.dOut.flush();
                this.writeErrorCounter = 0;
            }
            catch (SocketException e2) {
                this.messageLog(String.valueOf(this.name) + " - EXCEPTION - io exc in sending command: " + e2.getMessage());
                ++this.writeErrorCounter;
                if (this.writeErrorCounter == 10) {
                    this.quit = true;
                }
            }
            catch (IOException e3) {
                this.messageLog(String.valueOf(this.name) + " - EXCEPTION - socket exc in sending command: " + e3.getMessage());
                ++this.writeErrorCounter;
                if (this.writeErrorCounter != 10) break block4;
                this.quit = true;
            }
        }
    }

    private byte[] longToByteArray(long l2, byte[] b2) {
        b2[0] = (byte)l2;
        b2[1] = (byte)(l2 >>>= 8);
        b2[2] = (byte)(l2 >>>= 8);
        b2[3] = (byte)(l2 >>>= 8);
        l2 >>>= 8;
        return b2;
    }

    private byte[] intToByteArray(int in, byte[] b2) {
        b2[0] = (byte)in;
        b2[1] = (byte)(in >>>= 8);
        return b2;
    }

    void securityLog(String message) {
        String entry;
        hsyco.securityLog(String.valueOf(this.name) + " - " + message);
        if (message.startsWith("HSYCO")) {
            entry = String.valueOf(this.dateFormat.format(new Date())) + " - " + message + "<br />";
        } else {
            int space = message.indexOf(32);
            space = message.indexOf(32, space + 1);
            entry = String.valueOf(this.dateFormat.format(new Date())) + " - " + message.substring(0, space) + message.substring(space + 1) + "<br />";
        }
        this.logs.add(0, entry);
        while (this.logs.size() > this.logSize) {
            this.logs.remove(this.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            entry = this.logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(entry).append("</div>");
            ++i2;
        }
        this.uiSet("log", "value", text.toString());
        this.saveLogs();
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                userBase.varSet(this.logVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    private void openCSVFiles() {
        boolean fileNotFound = false;
        String fileName = String.valueOf(this.name) + ".csv";
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + " - CSV IMPORT - file name  : " + fileName);
        }
        BufferedReader fileBuffer = null;
        ArrayList<List<String>> records = new ArrayList<List<String>>();
        try {
            try {
                fileBuffer = new BufferedReader(new FileReader("protege/csv/" + fileName));
                try {
                    String line;
                    while ((line = fileBuffer.readLine()) != null) {
                        String[] stringArray = line.split("\\,");
                        records.add(Arrays.asList(stringArray));
                    }
                    if (this.isVerboseLog() && this.debug) {
                        this.messageLog(String.valueOf(this.name) + " - CSV IMPORT - end : " + Arrays.toString(records.toArray()));
                    }
                    for (List list : records) {
                        String type = (String)list.get(0);
                        String id = "";
                        String desc = "";
                        if (type.equalsIgnoreCase("1")) {
                            id = (String)list.get(1);
                            desc = (String)list.get(list.size() - 1);
                            this.ioWriteNoEvents("d" + id + ".name", desc);
                            continue;
                        }
                        if (type.equalsIgnoreCase("2")) {
                            id = (String)list.get(1);
                            desc = (String)list.get(list.size() - 1);
                            this.ioWriteNoEvents("a" + id + ".name", desc);
                            continue;
                        }
                        if (type.equalsIgnoreCase("4")) {
                            id = (String)list.get(1);
                            desc = (String)list.get(list.size() - 1);
                            this.ioWriteNoEvents("i" + id + ".name", desc);
                            continue;
                        }
                        if (type.equalsIgnoreCase("3")) {
                            id = (String)list.get(1);
                            desc = (String)list.get(list.size() - 1);
                            this.ioWriteNoEvents("o" + id + ".name", desc);
                            continue;
                        }
                        if (!type.equalsIgnoreCase("6")) continue;
                        id = (String)list.get(1);
                        desc = (String)list.get(list.size() - 1);
                        this.ioWriteNoEvents("ti" + id + ".name", desc);
                    }
                }
                catch (IOException iOException) {
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + " - CSV IMPORT - exception : " + iOException.getMessage());
                    }
                }
            }
            catch (FileNotFoundException e3) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " - CSV IMPORT - exception : " + e3.getMessage());
                }
                fileNotFound = true;
                try {
                    if (!fileNotFound) {
                        fileBuffer.close();
                    }
                }
                catch (IOException e4) {
                    this.messageLog(String.valueOf(this.name) + " - CSV IMPORT - exception : " + e4.getMessage());
                }
            }
        }
        finally {
            try {
                if (!fileNotFound) {
                    fileBuffer.close();
                }
            }
            catch (IOException e5) {
                this.messageLog(String.valueOf(this.name) + " - CSV IMPORT - exception : " + e5.getMessage());
            }
        }
    }

    private void addToLog(String dp, String value) {
        String dpName = "";
        String newLogLine = "";
        try {
            String[] sp = dp.split("\\.");
            dpName = userBase.ioGet(String.valueOf(this.name) + "." + sp[0] + ".name");
        }
        catch (Exception e2) {
            this.messageLog(String.valueOf(this.name) + " - ADD TO LOG - exception : " + e2.getMessage());
        }
        if (dpName != null && !this.endFirstLoop && !dpName.equals("")) {
            if (dp.startsWith("o") && dp.endsWith(".state")) {
                newLogLine = "output " + dpName + " = " + value;
                this.ioWrite("log0", newLogLine);
                this.securityLog(newLogLine);
            } else if (dp.startsWith("i")) {
                if (dp.endsWith(".state")) {
                    newLogLine = "input " + dpName + " = " + value;
                    this.ioWrite("log0", newLogLine);
                    this.securityLog(newLogLine);
                } else if (dp.endsWith(".bypassed")) {
                    newLogLine = "input " + dpName + " bypassed = " + value;
                    this.ioWrite("log0", newLogLine);
                    this.securityLog(newLogLine);
                }
            } else if (dp.startsWith("a")) {
                if (dp.endsWith(".state") && !dp.endsWith("tamper.state")) {
                    newLogLine = "area " + dpName + " = " + value;
                    this.ioWrite("log0", newLogLine);
                    this.securityLog(newLogLine);
                }
            } else if (dp.startsWith("ti") && dp.endsWith(".state")) {
                if (dp.endsWith(".state")) {
                    newLogLine = "input " + dpName + " = " + value;
                    this.ioWrite("log0", newLogLine);
                    this.securityLog(newLogLine);
                } else if (dp.endsWith(".bypassed")) {
                    newLogLine = "input " + dpName + " bypassed = " + value;
                    this.ioWrite("log0", newLogLine);
                    this.securityLog(newLogLine);
                }
            }
        }
    }
}

