/*
 * Decompiled with CFR 0.152.
 */
package drivers.netatmo;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final int DEFAULTPOLLINTERVAL = 1000;
    public static final int DEFAULTLOGSIZE = 300;
    public static final int DEFAULTMAXAREAS = 8;
    private boolean startupevents;
    private boolean firstloop = true;
    private String name;
    private String host = "api.netatmo.com";
    private String username;
    private String password;
    private String clientId;
    private String clientSecret;
    private String accessToken;
    private String refreshToken;
    private int pollinterval = 1000;
    private HashMap<String, ArrayList<String>> homesMap = new HashMap();
    private long lastStatusTs;

    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            this.username = config.get("user");
            if (this.username == null) {
                throw new Exception(String.valueOf(name) + ": username not present");
            }
            this.password = config.get("password");
            if (this.password == null) {
                throw new Exception(String.valueOf(name) + ": password not present");
            }
            this.clientId = config.get("clientid");
            if (this.clientId == null) {
                throw new Exception(String.valueOf(name) + ": clientid not present");
            }
            this.clientSecret = config.get("clientsecret");
            if (this.clientSecret == null) {
                throw new Exception(String.valueOf(name) + ": clientsecret not present");
            }
            this.startupevents = Boolean.parseBoolean(config.get("startupevents"));
            try {
                int timer = Integer.parseInt(config.get("pollinterval"));
                if (timer >= 100 && timer <= 30000) {
                    this.pollinterval = timer;
                }
            }
            catch (Exception e2) {
                this.messageLog(String.valueOf(name) + ": pollinterval ignored");
            }
            this.lastStatusTs = System.currentTimeMillis();
            this.getToken(false);
            this.getConfiguration();
            this.getStatus();
            this.messageLog(String.valueOf(name) + " - driver started | username: " + this.username + " | password: " + this.password + " | startupevents: " + this.startupevents + " | pollinterval: " + this.pollinterval);
            return true;
        }
        catch (Exception e3) {
            this.errorLog("Initialization failed: " + name + " - " + e3.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    public boolean loop() {
        try {
            long actualTs = System.currentTimeMillis();
            if (actualTs - this.lastStatusTs > 15000L) {
                this.lastStatusTs = actualTs;
                this.getStatus();
            }
            if (this.firstloop) {
                this.firstloop = false;
                this.ioWrite("connection", "online");
            }
            this.sleep(this.pollinterval);
            return true;
        }
        catch (Exception e2) {
            block7: {
                if (this.isVerboseLog()) {
                    this.errorLog(String.valueOf(this.name) + ": Loop failed - " + e2.getMessage());
                }
                try {
                    this.getToken(true);
                }
                catch (Exception f2) {
                    if (!this.isVerboseLog()) break block7;
                    this.errorLog(String.valueOf(this.name) + " - " + f2.getMessage());
                }
            }
            this.sleep(1000L);
            return false;
        }
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return null;
    }

    public void command(String name, String value) {
        try {
            if (name.endsWith("settemp.manual")) {
                String[] fields = name.split("\\.");
                String homeId = fields[1];
                String roomId = fields[3];
                String[] vals = value.split("\\|");
                String temp = vals[0];
                String endtime = vals[1];
                this.sendCommand("temp", "manual", homeId, roomId, temp, endtime);
            } else if (name.endsWith("settemp.max")) {
                String[] fields = name.split("\\.");
                String homeId = fields[1];
                String roomId = fields[3];
                String endtime = value;
                this.sendCommand("temp", "max", homeId, roomId, null, endtime);
            } else if (name.endsWith("settemp") && value.equals("home")) {
                String[] fields = name.split("\\.");
                String homeId = fields[1];
                String roomId = fields[3];
                this.sendCommand("temp", "home", homeId, roomId, null, null);
            } else if (name.endsWith("setmode.schedule")) {
                String[] fields = name.split("\\.");
                String homeId = fields[1];
                this.sendCommand("mode", "schedule", homeId, value, null, null);
            } else if (name.endsWith("setmode.away")) {
                String[] fields = name.split("\\.");
                String homeId = fields[1];
                this.sendCommand("mode", "away", homeId, null, null, value);
            } else if (name.endsWith("setmode.hg")) {
                String[] fields = name.split("\\.");
                String homeId = fields[1];
                this.sendCommand("mode", "hg", homeId, null, null, value);
            }
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.name) + " - command error - " + name + " - " + value + " - " + e2.getMessage());
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.firstloop && !this.startupevents) {
            super.ioWriteNoEvents(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    @Override
    protected void ioWriteForced(String name, String value) {
        super.ioWriteForced(name, value);
    }

    private void getToken(boolean refresh) throws Exception {
        OutputStream os = null;
        BufferedReader in = null;
        try {
            try {
                String output;
                URL url = new URL("https://" + this.host + "/oauth2/token");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Accept", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                String body = refresh ? "grant_type=refresh_token&client_id=" + this.clientId + "&client_secret=" + this.clientSecret + "&refresh_token=" + this.refreshToken : "grant_type=password&client_id=" + this.clientId + "&client_secret=" + this.clientSecret + "&username=" + this.username + "&password=" + this.password + "&scope=read_station read_thermostat write_thermostat";
                os = conn.getOutputStream();
                os.write(body.getBytes());
                os.flush();
                int code = conn.getResponseCode();
                in = code == 200 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                StringBuffer response = new StringBuffer();
                while ((output = in.readLine()) != null) {
                    response.append(output);
                }
                JSONObject json = new JSONObject(response.toString());
                if (json.has("error")) {
                    String msg1 = json.getString("error");
                    String msg2 = json.getString("error_description");
                    throw new Exception(String.valueOf(msg1) + " - " + msg2);
                }
                this.accessToken = json.getString("access_token");
                this.refreshToken = json.getString("refresh_token");
            }
            catch (Exception e2) {
                String s = refresh ? "refreshing" : "retrieving";
                throw new Exception("error " + s + " token - " + e2.toString());
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    private void getConfiguration() throws Exception {
        BufferedReader in = null;
        try {
            try {
                String output;
                URL url = new URL("https://" + this.host + "/api/homesdata");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Authorization", "Bearer " + this.accessToken);
                conn.setDoOutput(true);
                conn.setRequestMethod("GET");
                int code = conn.getResponseCode();
                in = code == 200 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                StringBuffer response = new StringBuffer();
                while ((output = in.readLine()) != null) {
                    response.append(output);
                }
                JSONObject json = new JSONObject(response.toString());
                if (json.has("error")) {
                    JSONObject error = json.getJSONObject("error");
                    String msg = error.getString("message");
                    throw new Exception(msg);
                }
                JSONObject body = json.getJSONObject("body");
                JSONArray homes = body.getJSONArray("homes");
                int i2 = 0;
                while (i2 < homes.length()) {
                    String type;
                    int j2;
                    String name;
                    JSONObject home = homes.getJSONObject(i2);
                    String homeId = home.getString("id");
                    if (home.has("name")) {
                        name = home.getString("name");
                        this.ioWrite("home." + homeId + ".name", name);
                    }
                    if (home.has("rooms")) {
                        ArrayList<String> roomsId = new ArrayList<String>();
                        JSONArray rooms = home.getJSONArray("rooms");
                        j2 = 0;
                        while (j2 < rooms.length()) {
                            JSONObject room = rooms.getJSONObject(j2);
                            String roomId = room.getString("id");
                            roomsId.add(roomId);
                            if (room.has("name")) {
                                name = room.getString("name");
                                this.ioWrite("home." + homeId + ".room." + roomId + ".name", name);
                            }
                            if (room.has("type")) {
                                type = room.getString("type");
                                this.ioWrite("home." + homeId + ".room." + roomId + ".type", type);
                            }
                            ++j2;
                        }
                        this.homesMap.put(homeId, roomsId);
                    }
                    if (home.has("modules")) {
                        JSONArray modules = home.getJSONArray("modules");
                        j2 = 0;
                        while (j2 < modules.length()) {
                            JSONObject module = modules.getJSONObject(j2);
                            String moduleId = module.getString("id");
                            if (module.has("name")) {
                                name = module.getString("name");
                                this.ioWrite("home." + homeId + ".module." + moduleId + ".name", name);
                            }
                            if (module.has("type")) {
                                type = module.getString("type");
                                this.ioWrite("home." + homeId + ".module." + moduleId + ".type", type);
                            }
                            ++j2;
                        }
                    }
                    if (home.has("schedules")) {
                        JSONArray schedules = home.getJSONArray("schedules");
                        j2 = 0;
                        while (j2 < schedules.length()) {
                            JSONObject schedule = schedules.getJSONObject(j2);
                            String scheduleId = schedule.getString("id");
                            if (schedule.has("name")) {
                                name = schedule.getString("name");
                                this.ioWrite("home." + homeId + ".schedule." + scheduleId + ".name", name);
                            }
                            if (schedule.has("hg_temp")) {
                                double hgtemp = schedule.getDouble("hg_temp");
                                this.ioWrite("home." + homeId + ".schedule." + scheduleId + ".hgtemp", "" + hgtemp);
                            }
                            if (schedule.has("away_temp")) {
                                double awaytemp = schedule.getDouble("away_temp");
                                this.ioWrite("home." + homeId + ".schedule." + scheduleId + ".awaytemp", "" + awaytemp);
                            }
                            JSONArray zones = schedule.getJSONArray("zones");
                            int k2 = 0;
                            while (k2 < zones.length()) {
                                JSONObject zone = zones.getJSONObject(k2);
                                int zoneId = zone.getInt("id");
                                if (zone.has("name")) {
                                    name = zone.getString("name");
                                    this.ioWrite("home." + homeId + ".schedule." + scheduleId + ".zone." + zoneId + ".name", name);
                                }
                                ++k2;
                            }
                            ++j2;
                        }
                    }
                    ++i2;
                }
            }
            catch (Exception e2) {
                throw new Exception("error retrieving system configuration - " + e2.toString());
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void getStatus() throws Exception {
        BufferedReader in = null;
        try {
            try {
                for (String homeId : this.homesMap.keySet()) {
                    int i2;
                    JSONObject body;
                    String output;
                    URL url = new URL("https://" + this.host + "/api/homestatus?home_id=" + homeId);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestProperty("Authorization", "Bearer " + this.accessToken);
                    conn.setDoOutput(true);
                    conn.setRequestMethod("GET");
                    int code = conn.getResponseCode();
                    in = code == 200 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                    StringBuffer response = new StringBuffer();
                    while ((output = in.readLine()) != null) {
                        response.append(output);
                    }
                    JSONObject json = new JSONObject(response.toString());
                    if (json.has("error")) {
                        JSONObject error = json.getJSONObject("error");
                        String msg = error.getString("message");
                        throw new Exception(msg);
                    }
                    String status = json.getString("status");
                    this.ioWrite("home." + homeId + ".status", status);
                    if (!json.has("body") || !(body = json.getJSONObject("body")).has("home")) continue;
                    JSONObject home = body.getJSONObject("home");
                    if (home.has("rooms")) {
                        JSONArray rooms = home.getJSONArray("rooms");
                        i2 = 0;
                        while (i2 < rooms.length()) {
                            JSONObject room = rooms.getJSONObject(i2);
                            String roomId = room.getString("id");
                            if (room.has("therm_measured_temperature")) {
                                double tempMeasured = room.getDouble("therm_measured_temperature");
                                this.ioWrite("home." + homeId + ".room." + roomId + ".temp.measured", "" + tempMeasured);
                            }
                            if (room.has("therm_setpoint_temperature")) {
                                double tempSet = room.getDouble("therm_setpoint_temperature");
                                this.ioWrite("home." + homeId + ".room." + roomId + ".temp.set", "" + tempSet);
                            }
                            if (room.has("therm_setpoint_mode")) {
                                String termSetpointMode = room.getString("therm_setpoint_mode");
                                this.ioWrite("home." + homeId + ".room." + roomId + ".temp.mode", termSetpointMode);
                            }
                            if (room.has("therm_setpoint_start_time")) {
                                long starttime = room.getLong("therm_setpoint_start_time");
                                this.ioWrite("home." + homeId + ".room." + roomId + ".temp.setpoint.starttime", "" + starttime);
                            } else {
                                this.ioWrite("home." + homeId + ".room." + roomId + ".temp.setpoint.starttime", "");
                            }
                            if (room.has("therm_setpoint_end_time")) {
                                long endtime = room.getLong("therm_setpoint_end_time");
                                this.ioWrite("home." + homeId + ".room." + roomId + ".temp.setpoint.endtime", "" + endtime);
                            } else {
                                this.ioWrite("home." + homeId + ".room." + roomId + ".temp.setpoint.endtime", "");
                            }
                            ++i2;
                        }
                    }
                    if (!home.has("modules")) continue;
                    JSONArray modules = home.getJSONArray("modules");
                    i2 = 0;
                    while (i2 < modules.length()) {
                        JSONObject module = modules.getJSONObject(i2);
                        String moduleId = module.getString("id");
                        if (module.has("battery_level")) {
                            int batteryLevel = module.getInt("battery_level");
                            this.ioWrite("home." + homeId + ".module." + moduleId + ".battery", "" + batteryLevel);
                        }
                        ++i2;
                    }
                }
            }
            catch (Exception e2) {
                throw new Exception("error retrieving system state - " + e2.toString());
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void sendCommand(String cmd, String mode, String homeId, String id, String temp, String endtime) throws Exception {
        OutputStream os = null;
        BufferedReader in = null;
        String s = cmd.equals("temp") ? "/setroomthermpoint" : "/setthermmode";
        try {
            try {
                String output;
                URL url = new URL("https://" + this.host + "/api" + s);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Accept", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Authorization", "Bearer " + this.accessToken);
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                String idfield = "";
                if (id != null) {
                    idfield = cmd.equals("temp") ? "&room_id=" + id : "&schedule_id=" + id;
                }
                String t = temp != null ? "&temp=" + temp : "";
                String e2 = "";
                if (endtime != null) {
                    long ts = System.currentTimeMillis() / 1000L;
                    long increment = Integer.parseInt(endtime) * 3600;
                    e2 = "&time=" + (ts + increment);
                }
                String body = "home_id=" + homeId + idfield + "&mode=" + mode + t + e2;
                os = conn.getOutputStream();
                os.write(body.getBytes());
                os.flush();
                int code = conn.getResponseCode();
                in = code == 200 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                StringBuffer response = new StringBuffer();
                while ((output = in.readLine()) != null) {
                    response.append(output);
                }
                JSONObject json = new JSONObject(response.toString());
                if (json.has("error")) {
                    JSONObject error = json.getJSONObject("error");
                    String message = error.getString("message");
                    throw new Exception(message);
                }
            }
            catch (Exception e3) {
                throw new Exception("error in request " + s + " - " + e3.toString());
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }
}

