/*
 * Decompiled with CFR 0.152.
 */
package drivers.mqttclient;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;

public class Driver
extends driverBase
implements MqttCallback {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private String host;
    private boolean startupevents;
    private String name;
    private boolean online = false;
    private boolean resubscribe = false;
    private MqttClient client;
    private String username;
    private String password;
    private boolean cleanSession;
    private int connectTimeout = 30;
    private int keepAlive = 60;
    private int messageQos = 0;
    private boolean messageRetain;
    private HashMap<String, Integer> topicsList = new HashMap();
    MqttDefaultFilePersistence mdfp;

    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            try {
                InetAddress inet = InetAddress.getByName(config.get("host"));
                int port = Integer.parseInt(config.get("port"));
                this.host = String.valueOf(inet.getHostName()) + ":" + port;
            }
            catch (Exception e2) {
                throw new Exception(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            this.startupevents = Boolean.parseBoolean(config.get("startupevents"));
            this.username = config.get("user");
            this.password = config.get("password");
            this.cleanSession = Boolean.parseBoolean(config.get("cleansession"));
            String temp = config.get("connecttimeout");
            if (temp != null && Integer.parseInt(temp) >= 0) {
                this.connectTimeout = Integer.parseInt(temp);
            }
            if ((temp = config.get("keepalive")) != null && Integer.parseInt(temp) >= 0) {
                this.keepAlive = Integer.parseInt(temp);
            }
            this.mdfp = new MqttDefaultFilePersistence("qos2store/" + name + "-tcp" + this.host.replace(":", ""));
            this.client = new MqttClient("tcp://" + this.host, name, this.mdfp);
            MqttConnectOptions options = new MqttConnectOptions();
            if (this.username != null && this.password != null) {
                options.setUserName(this.username);
                options.setPassword(this.password.toCharArray());
            }
            options.setCleanSession(this.cleanSession);
            options.setAutomaticReconnect(true);
            options.setConnectionTimeout(this.connectTimeout);
            options.setKeepAliveInterval(this.keepAlive);
            this.client.setCallback(this);
            this.client.connect(options);
            HashMap<String, Integer> subsList = this.readSubsFile("mqttsubscriptions-" + name + ".ini");
            if (subsList != null) {
                this.topicsList = subsList;
                this.makeSubscriptions();
            }
            this.messageRetain = Boolean.parseBoolean(config.get("messageretain"));
            temp = config.get("messageqos");
            if (temp != null) {
                this.messageQos = Integer.parseInt(temp);
            }
            String[] splitPort = this.host.split(":");
            this.messageLog("MQTTCLIENT - driver started with ip: " + splitPort[0] + " | port: " + splitPort[1] + " | " + "startupevents: " + this.startupevents + " | cleansession: " + this.cleanSession + " | connecttimeout: " + this.connectTimeout + " | keepalive: " + this.keepAlive + " | messageretain: " + this.messageRetain + " | messageqos: " + this.messageQos);
            return true;
        }
        catch (Exception e3) {
            this.errorLog("Initialization failed - " + e3.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    public boolean loop() {
        if (!this.client.isConnected()) {
            this.resubscribe = true;
            return false;
        }
        if (this.resubscribe) {
            this.makeSubscriptions();
            this.resubscribe = false;
        }
        if (!this.online) {
            this.online = true;
            this.ioWrite("connection", "online");
            for (String topic : this.topicsList.keySet()) {
                this.ioWrite("subscribe." + topic.replace(" ", "_"), "" + this.topicsList.get(topic));
            }
        }
        this.sleep(1000L);
        return true;
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
        }
        try {
            this.client.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        try {
            if (name.startsWith("publish.")) {
                String topic = name.substring(8);
                MqttMessage message = new MqttMessage(value.getBytes());
                message.setRetained(this.messageRetain);
                message.setQos(this.messageQos);
                this.client.publish(topic, message);
                this.ioWriteForced("publish." + topic, message.toString());
            } else if (name.startsWith("subscribe.")) {
                String topic = name.substring(10);
                if (value.equals("0") || value.equals("1") || value.equals("2")) {
                    if (this.isRegularTopic(topic)) {
                        this.client.subscribe(topic, Integer.parseInt(value));
                        this.topicsList.put(topic, Integer.parseInt(value));
                        this.ioWrite("subscribe." + topic, "" + Integer.parseInt(value));
                    }
                } else if (value.equals("unsubscribe")) {
                    this.client.unsubscribe(topic);
                    if (this.topicsList.containsKey(topic)) {
                        this.ioWrite("subscribe." + topic, "unsubscribe");
                        this.topicsList.remove(topic);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (!this.online && !this.startupevents) {
            super.ioWriteNoEvents(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    /*
     * Loose catch block
     */
    public HashMap<String, Integer> readSubsFile(String filePath) throws Exception {
        BufferedReader br = null;
        try {
            String next;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
            while ((next = br.readLine()) != null) {
                String topic = next.substring(0, next.length() - 2);
                char qos = next.charAt(next.length() - 1);
                if (qos != '0' && qos != '1' && qos != '2') {
                    throw new Exception("invalid qos");
                }
                if (!this.isRegularTopic(topic)) continue;
                toReturn.put(topic.toLowerCase(), Integer.parseInt(String.valueOf(qos)));
            }
            HashMap<String, Integer> hashMap = toReturn;
            return hashMap;
        }
        catch (FileNotFoundException e2) {
            return null;
        }
        catch (Exception e3) {
            throw new Exception("exception while reading mqttsubscriptions.ini - " + e3.getLocalizedMessage());
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean isRegularTopic(String topic) {
        String[] levels = topic.split("/", -1);
        if (levels.length > 0 && levels[0].equals("$share") && (levels.length < 3 || levels[1].contains("+") || levels[1].contains("#"))) {
            return false;
        }
        int i2 = 0;
        while (i2 < levels.length) {
            if ((levels[i2].contains("+") || levels[i2].contains("#")) && levels[i2].length() > 1) {
                return false;
            }
            if (levels[i2].contains("#") && i2 < levels.length - 1) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void makeSubscriptions() {
        try {
            String[] topics = new String[this.topicsList.size()];
            int[] qos = new int[this.topicsList.size()];
            int i2 = 0;
            Iterator<String> iterator = this.topicsList.keySet().iterator();
            while (iterator.hasNext()) {
                String topic;
                topics[i2] = topic = iterator.next();
                qos[i2] = this.topicsList.get(topic);
                ++i2;
                this.topicsList.put(topic, this.topicsList.get(topic));
            }
            this.client.subscribe(topics, qos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void connectionLost(Throwable arg0) {
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken arg0) {
    }

    @Override
    public void messageArrived(String arg0, MqttMessage arg1) throws Exception {
        this.ioWrite("received." + arg0, arg1.toString());
    }
}

