/*
 * Decompiled with CFR 0.152.
 */
package drivers.mqttbroker;

import drivers.mqttbroker.MQTTPublishMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class MQTTClientSession {
    private HashMap<String, Integer> subscriptions = new HashMap();
    private HashMap<String, MQTTPublishMessage> msgs = new HashMap();

    public void addMessageToSession(String msgId, byte[] msg) {
        this.msgs.put(msgId, new MQTTPublishMessage(msg));
    }

    public void delMessageFromSession(String packetId) {
        this.msgs.remove(packetId);
    }

    public void addSubscriptionToSession(String topic, int maxQos) {
        this.subscriptions.put(topic, maxQos);
    }

    public int getMaxQos(String topic) {
        return this.subscriptions.get(topic);
    }

    public HashMap<String, MQTTPublishMessage> getMsgs() {
        return this.msgs;
    }

    public ArrayList<MQTTPublishMessage> getOrderedMessages() {
        Collection<MQTTPublishMessage> messages = this.msgs.values();
        ArrayList<MQTTPublishMessage> listOfValues = new ArrayList<MQTTPublishMessage>(messages);
        Collections.sort(listOfValues);
        return listOfValues;
    }
}

