/*
 * Decompiled with CFR 0.152.
 */
package drivers.mpower;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import com.hsyco.driverBase;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Vector;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 22;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    public static final String[] WEBOBJECTS = new String[]{"button", "buttonicon", "buttonimage"};
    private static int MAX_SOCKETS = 6;
    private static int MIN_POLL_TIME_MILLIS = 200;
    private String name = null;
    private String host = null;
    private Connection connection = null;
    private String user = null;
    private String password = null;
    private boolean outputdiscovery = true;
    private int outputs = 0;
    private boolean startupevents = false;
    private int decimals = 0;
    private boolean initialized = false;
    private String statuscommand = null;
    private String[][] state = new String[MAX_SOCKETS][6];

    public boolean init(String name, HashMap<String, String> config) {
        block9: {
            super.init(name);
            this.name = name;
            this.host = config.get("host");
            String s = config.get("user");
            this.user = s == null ? "ubnt" : s;
            s = config.get("password");
            this.password = s == null ? "ubnt" : s;
            s = config.get("outputdiscovery");
            if (s != null) {
                this.outputdiscovery = Boolean.parseBoolean(s);
            }
            if ((s = config.get("startupevents")) != null) {
                this.startupevents = Boolean.parseBoolean(s);
            }
            if ((s = config.get("decimals")) != null) {
                this.decimals = Integer.parseInt(s);
            }
            this.connection = new Connection(this.host, 22);
            this.connection.connect(null, 6000, 6000);
            if (!this.connection.authenticateWithPassword(this.user, this.password)) break block9;
            if (this.deviceDiscovery() && this.destroyAth1()) {
                return true;
            }
        }
        try {
            this.errorLog("ioMonitor - Authentication failed [" + name + "] - quit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loop() {
        Session session = null;
        InputStreamReader stdout = null;
        Vector<String> readings = new Vector<String>();
        try {
            long t = System.currentTimeMillis();
            Connection connection = this.connection;
            synchronized (connection) {
                block34: {
                    try {
                        try {
                            String line;
                            session = this.connection.openSession();
                            stdout = new InputStreamReader(session.getStdout(), "UTF-8");
                            session.execCommand(this.statuscommand);
                            while ((line = this.readOutLine(session, stdout)) != null) {
                                if (line.length() <= 0) continue;
                                readings.add(line);
                            }
                        }
                        catch (Exception exception) {
                            try {
                                stdout.close();
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            try {
                                session.close();
                            }
                            catch (Exception exception3) {}
                            break block34;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            stdout.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            session.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        stdout.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        session.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (readings.size() == this.outputs * 6) {
                long sleeptime;
                int o2 = 0;
                while (o2 < this.outputs) {
                    String value = this.round((String)readings.elementAt(o2 * 6));
                    if (!value.equals(this.state[o2][0])) {
                        this.ioWrite(this.initialized || this.startupevents, String.valueOf(o2 + 1) + ".power", value);
                    }
                    if (!(value = this.round((String)readings.elementAt(o2 * 6 + 1))).equals(this.state[o2][1])) {
                        this.ioWrite(this.initialized || this.startupevents, String.valueOf(o2 + 1) + ".energy", value);
                    }
                    if (!(value = this.round((String)readings.elementAt(o2 * 6 + 2))).equals(this.state[o2][2])) {
                        this.ioWrite(this.initialized || this.startupevents, String.valueOf(o2 + 1) + ".i", value);
                    }
                    if (!(value = this.round((String)readings.elementAt(o2 * 6 + 3))).equals(this.state[o2][3])) {
                        this.ioWrite(this.initialized || this.startupevents, String.valueOf(o2 + 1) + ".pf", value);
                    }
                    if (!(value = this.round((String)readings.elementAt(o2 * 6 + 4))).equals(this.state[o2][4])) {
                        this.ioWrite(this.initialized || this.startupevents, String.valueOf(o2 + 1) + ".v", value);
                    }
                    if (!(value = ((String)readings.elementAt(o2 * 6 + 5)).substring(0, 1)).equals(this.state[o2][5])) {
                        if (this.outputdiscovery) {
                            this.deviceSet(100, Integer.toString(o2 + 1), value, null);
                        }
                        this.ioWrite(this.initialized || this.startupevents, Integer.toString(o2 + 1), value);
                    }
                    ++o2;
                }
                if (!this.initialized) {
                    this.initialized = true;
                    this.ioWrite("connection", "online");
                }
                if ((sleeptime = (long)MIN_POLL_TIME_MILLIS - (System.currentTimeMillis() - t)) > 0L) {
                    this.sleep(sleeptime);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sleep(1000L);
        return false;
    }

    public boolean end() {
        if (this.initialized) {
            this.ioWrite("connection", "offline");
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String name, String value) {
        Session session = null;
        Connection connection = this.connection;
        synchronized (connection) {
            block21: {
                String v;
                int out;
                block23: {
                    block22: {
                        if (!this.initialized) break block21;
                        out = Integer.parseInt(name);
                        if (out >= 1 && out <= this.outputs) break block22;
                        this.errorLog("ioMonitor - command (" + name + "=" + value + ") execution error [" + this.name + "] - wrong output name");
                        try {
                            session.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    if (value.equals("1") || value.equals("on")) {
                        v = "1";
                        break block23;
                    }
                    if (value.equals("0") || value.equals("off")) {
                        v = "0";
                        break block23;
                    }
                    this.errorLog("ioMonitor - command (" + name + "=" + value + ") execution error [" + this.name + "] - wrong output value");
                    try {
                        session.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    try {
                        session = this.connection.openSession();
                        session.execCommand("echo " + v + " > /proc/power/relay" + out);
                    }
                    catch (Exception e2) {
                        this.errorLog("ioMonitor - command (" + name + "=" + value + ") execution exception [" + this.name + "] - " + e2.getLocalizedMessage());
                        try {
                            session.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    try {
                        session.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean deviceDiscovery() {
        StringBuffer sb;
        InputStreamReader stdout;
        Session session;
        block15: {
            String line;
            session = null;
            stdout = null;
            sb = new StringBuffer();
            session = this.connection.openSession();
            stdout = new InputStreamReader(session.getStdout(), "UTF-8");
            session.execCommand("ls /proc/power");
            while ((line = this.readOutLine(session, stdout)) != null) {
                int n2;
                if (!line.startsWith("relay") || (n2 = Integer.parseInt(line.substring(5))) <= this.outputs) continue;
                this.outputs = n2;
            }
            try {
                stdout.close();
            }
            catch (Exception n2) {
                // empty catch block
            }
            try {
                session.close();
            }
            catch (Exception n2) {
                // empty catch block
            }
            if (this.outputs != 0) break block15;
            this.errorLog("ioMonitor - handshake error [" + this.name + "] - quit");
            return false;
        }
        try {
            sb.append("cat");
            int i2 = 1;
            while (i2 <= this.outputs) {
                sb.append(" /proc/power/active_pwr");
                sb.append(i2);
                sb.append(" /proc/power/energy_sum");
                sb.append(i2);
                sb.append(" /proc/power/i_rms");
                sb.append(i2);
                sb.append(" /proc/power/pf");
                sb.append(i2);
                sb.append(" /proc/power/v_rms");
                sb.append(i2);
                sb.append(" /proc/power/relay");
                sb.append(i2);
                ++i2;
            }
            this.statuscommand = sb.toString();
            if (this.outputdiscovery) {
                this.enableSystemtopoDiscovery();
                i2 = 1;
                while (i2 <= this.outputs) {
                    this.deviceSet(100, Integer.toString(i2), null, "OUTPUT " + i2);
                    ++i2;
                }
            }
            return true;
        }
        catch (Exception e2) {
            try {
                stdout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * Loose catch block
     */
    private boolean destroyAth1() {
        Session session = null;
        session = this.connection.openSession();
        session.execCommand("wlanconfig ath1 destroy");
        try {
            session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
        catch (Exception e2) {
            try {
                session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
            catch (Throwable throwable) {
                try {
                    session.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private String readOutLine(Session session, InputStreamReader stdout) {
        StringBuffer sb = new StringBuffer();
        try {
            while (stdout.ready() || (session.waitForCondition(4, 3000L) & 4) != 0) {
                int ch = stdout.read();
                switch (ch) {
                    case -1: {
                        return sb.length() == 0 ? null : sb.toString();
                    }
                    case 10: {
                        return sb.toString();
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        sb.append((char)ch);
                    }
                }
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private void ioWrite(boolean events2, String name, String value) {
        if (events2) {
            this.ioWrite(name, value);
        } else {
            this.ioWriteNoEvents(name, value);
        }
    }

    private String round(String value) {
        try {
            if (this.decimals == 0) {
                return Long.toString(Math.round(Double.valueOf(value)));
            }
            return new BigDecimal(value).setScale(this.decimals, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
        }
        catch (Exception e2) {
            return value;
        }
    }
}

