/*
 * Decompiled with CFR 0.152.
 */
package drivers.masterbus;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 502;
    public static final int COMMANDSQUEUESIZE = 1024;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private static final long MINIMUMPOLLINGINTERVALMILLIS = 100L;
    private String name = null;
    private String modbusPortName = null;
    private DecimalFormat decimalFormat = new DecimalFormat("#.##");
    private boolean gui = false;
    private Hashtable<String, String> nameMap = new Hashtable();
    private Hashtable<String, pollingElement> pollingMap = new Hashtable();
    Enumeration<String> pollingMapEnumeration = null;
    long nextPollingTimestampMillis;
    long nextMinPollingTimestampMillis;
    long pollingStartTimestamp;

    /*
     * Unable to fully structure code
     */
    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        s = config.get("host");
        if (s != null && s.length() > 0) {
            try {
                p = Integer.parseInt(config.get("port"));
                if (p <= 0 || p >= 65536) ** GOTO lbl18
                this.modbusPortName = String.valueOf(s) + ":" + p;
            }
            catch (Exception e) {
                return false;
            }
        } else {
            s = config.get("comm");
            if (s != null && s.length() > 0) {
                this.modbusPortName = s;
            } else {
                return false;
            }
        }
lbl18:
        // 3 sources

        s = config.get("decimals");
        try {
            d = Integer.parseInt(s);
            if (d == 0) {
                this.decimalFormat = new DecimalFormat("#");
            } else if (d > 0 && d < 10) {
                sb = new StringBuffer("#.");
                i = 0;
                while (i < d) {
                    sb.append('#');
                    ++i;
                }
                this.decimalFormat = new DecimalFormat(sb.toString());
            }
        }
        catch (Exception var4_6) {
            // empty catch block
        }
        s = config.get("gui");
        try {
            this.gui = Boolean.parseBoolean(s);
        }
        catch (Exception var4_7) {
            // empty catch block
        }
        return true;
    }

    public boolean loop() {
        if (this.pollingMap.size() > 0) {
            if (this.pollingMapEnumeration == null) {
                this.pollingStartTimestamp = System.nanoTime() / 1000000L;
                this.nextMinPollingTimestampMillis = this.pollingStartTimestamp + 30000L;
                this.pollingMapEnumeration = this.pollingMap.keys();
            }
            int i2 = 0;
            while (i2 < 10) {
                if (!this.pollingMapEnumeration.hasMoreElements()) {
                    this.pollingMapEnumeration = null;
                    break;
                }
                long now = System.nanoTime() / 1000000L;
                String k2 = this.pollingMapEnumeration.nextElement();
                pollingElement pe = this.pollingMap.get(k2);
                if (pe != null) {
                    this.nextPollingTimestampMillis = pe.lastPollingTimestampMillis + pe.pollingIntervalMillis;
                    if (this.nextPollingTimestampMillis < now) {
                        this.nextPollingTimestampMillis = now + pe.pollingIntervalMillis;
                        pe.lastPollingTimestampMillis = now;
                        Float f2 = this.readMasterbus(pe.idal, pe.idb, pe.tab, pe.index);
                        String s = f2 == null ? "error" : (Float.isNaN(f2.floatValue()) ? "null" : this.decimalFormat.format(f2));
                        if (!s.equals(pe.value)) {
                            pe.value = s;
                            this.ioWrite(k2, s);
                            if (this.gui) {
                                this.uiSet(k2, "value", s.toUpperCase());
                            }
                        }
                    }
                    if (this.nextPollingTimestampMillis < this.nextMinPollingTimestampMillis) {
                        this.nextMinPollingTimestampMillis = this.nextPollingTimestampMillis;
                    }
                }
                ++i2;
            }
            if (this.pollingMapEnumeration == null) {
                long now = System.nanoTime() / 1000000L;
                if (this.nextMinPollingTimestampMillis - now > 10L) {
                    if (this.isVerboseLog()) {
                        this.messageLog("Polling idle time (ms): " + (this.nextMinPollingTimestampMillis - now) + " [" + this.name + "]");
                        this.messageLog("Polling time (ms): " + (this.nextMinPollingTimestampMillis - now) + " (idle), " + (now - this.pollingStartTimestamp) + " (total) [" + this.name + "]");
                    }
                    this.sleep(this.nextMinPollingTimestampMillis - now);
                } else {
                    if (this.isVerboseLog()) {
                        this.messageLog("Polling time (ms): 0 (idle), " + (now - this.pollingStartTimestamp) + " (total) [" + this.name + "]");
                    }
                    this.sleep(10L);
                }
            }
        } else {
            this.sleep(2000L);
        }
        return true;
    }

    public boolean end() {
        return true;
    }

    public void command(String name, String value) {
        String[] namea;
        String namel = name.trim().toLowerCase();
        value = value == null ? "" : value.trim().toLowerCase();
        String m2 = this.nameMap.get(namel);
        String[] stringArray = namea = m2 != null ? m2.split("[.]") : namel.split("[.]");
        if (namea.length == 4) {
            String nameio;
            int index;
            int tab;
            try {
                tab = Integer.parseInt(namea[2]);
                index = Integer.parseInt(namea[3]);
            }
            catch (NumberFormatException e2) {
                this.errorLog("Command syntax error: " + name + " [" + this.name + "]");
                return;
            }
            String string = nameio = m2 != null ? namel : String.valueOf(namea[0]) + "." + namea[1] + "." + tab + "." + index;
            if (value.equals("read")) {
                Float f2 = this.readMasterbus(namea[0], namea[1], tab, index);
                String s = f2 == null ? "error" : (Float.isNaN(f2.floatValue()) ? "null" : this.decimalFormat.format(f2));
                this.ioWrite(nameio, s);
                if (this.gui) {
                    this.uiSet(nameio, "value", s.toUpperCase());
                }
            } else {
                Float f3 = Driver.toFloat(value);
                if (f3 != null) {
                    String s = (f3 = this.writeMasterbus(namea[0], namea[1], tab, index, f3.floatValue())) == null ? "error" : (Float.isNaN(f3.floatValue()) ? "null" : this.decimalFormat.format(f3));
                    this.ioWrite(nameio, s);
                    if (this.gui) {
                        this.uiSet(nameio, "value", s.toUpperCase());
                    }
                } else if (value.startsWith("pollinterval:")) {
                    f3 = Driver.toFloat(value.substring(13));
                    if (f3 != null) {
                        long pollintervalmillis = (long)(f3.floatValue() * 1000.0f);
                        if (pollintervalmillis == 0L) {
                            this.pollingMap.remove(namel);
                        } else if (pollintervalmillis >= 100L) {
                            pollingElement e3 = this.pollingMap.get(namel);
                            if (e3 == null) {
                                e3 = new pollingElement(namea[0], namea[1], tab, index, pollintervalmillis);
                            } else {
                                e3.pollingIntervalMillis = pollintervalmillis;
                            }
                            this.pollingMap.put(namel, e3);
                        }
                    }
                } else if (value.length() == 0) {
                    Enumeration<String> e4 = this.nameMap.keys();
                    while (e4.hasMoreElements()) {
                        String k2 = e4.nextElement();
                        if (!this.nameMap.get(k2).equals(namel)) continue;
                        this.nameMap.remove(k2);
                        break;
                    }
                } else {
                    this.nameMap.put(value.trim().toLowerCase(), namel);
                }
            }
        }
    }

    private Float readMasterbus(String idal, String idb, int tab, int index) {
        byte[] w = new byte[12];
        try {
            byte[] idala = Driver.hexToBytes(idal);
            byte[] idba = Driver.hexToBytes(idb);
            if (idala.length == 1 && idba.length == 3) {
                w[0] = idala[0];
                w[1] = idba[0];
                w[2] = idba[1];
                w[3] = idba[2];
                w[5] = (byte)tab;
                w[7] = (byte)index;
                byte[] a2 = userBase.modbusReadWriteMultipleRegisters(this.modbusPortName, 1, 0, 6, 0, w);
                if (a2 != null && a2.length == 14 && a2[0] == 23 && a2[1] == 12) {
                    float f2 = Driver.decodeFloat(Arrays.copyOfRange(a2, 10, 14)).floatValue();
                    return Float.valueOf(f2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Float writeMasterbus(String idal, String idb, int tab, int index, float value) {
        byte[] w = new byte[12];
        try {
            byte[] idala = Driver.hexToBytes(idal);
            byte[] idba = Driver.hexToBytes(idb);
            if (idala.length == 1 && idba.length == 3) {
                byte[] v = Driver.encodeFloat(value);
                w[0] = idala[0];
                w[1] = idba[0];
                w[2] = idba[1];
                w[3] = idba[2];
                w[5] = (byte)tab;
                w[7] = (byte)index;
                w[8] = v[0];
                w[9] = v[1];
                w[10] = v[2];
                w[11] = v[3];
                byte[] a2 = userBase.modbusReadWriteMultipleRegisters(this.modbusPortName, 1, 0, 6, 1, w);
                if (a2 != null && a2.length == 14 && a2[0] == 23 && a2[1] == 12) {
                    float f2 = Driver.decodeFloat(Arrays.copyOfRange(a2, 10, 14)).floatValue();
                    return Float.valueOf(f2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Float decodeFloat(byte[] data) {
        try {
            return Float.valueOf(Float.intBitsToFloat((data[0] & 0xFF) + ((data[1] & 0xFF) << 8) + ((data[2] & 0xFF) << 16) + ((data[3] & 0xFF) << 24)));
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static byte[] encodeFloat(float value) {
        byte[] a2 = new byte[4];
        try {
            int i2 = Float.floatToIntBits(value);
            a2[0] = (byte)(i2 & 0xFF);
            a2[1] = (byte)(i2 >> 8 & 0xFF);
            a2[2] = (byte)(i2 >> 16 & 0xFF);
            a2[3] = (byte)(i2 >> 24 & 0xFF);
            return a2;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static byte[] hexToBytes(String s) throws Exception {
        byte[] ba = new byte[s.length() / 2];
        int i2 = 0;
        while (i2 < ba.length) {
            ba[i2] = (byte)Integer.parseInt(s.substring(i2 * 2, (i2 + 1) * 2), 16);
            ++i2;
        }
        return ba;
    }

    private static Float toFloat(String s) {
        try {
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (Exception e2) {
            return null;
        }
    }

    private class pollingElement {
        String idal;
        String idb;
        int tab;
        int index;
        long pollingIntervalMillis;
        long lastPollingTimestampMillis;
        String value;

        pollingElement(String idal, String idb, int tab, int index, long pollingIntervalMillis) {
            this.idal = new String(idal);
            this.idb = new String(idb);
            this.tab = tab;
            this.index = index;
            this.pollingIntervalMillis = pollingIntervalMillis;
            this.lastPollingTimestampMillis = 0L;
            this.value = null;
        }
    }
}

