/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan.model;

import drivers.lorawan.model.AesCmac;
import drivers.lorawan.model.FRMPayload;
import drivers.lorawan.model.MacPayload;
import drivers.lorawan.model.MalformedPacketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;

public class JoinRequestPayload
implements FRMPayload {
    private MacPayload mac;
    private byte[] appEUI = new byte[8];
    private byte[] devEUI = new byte[8];
    private byte[] devNonce = new byte[2];
    private byte[] appKey;

    public JoinRequestPayload(MacPayload _mac, ByteBuffer _raw) throws MalformedPacketException {
        if (_raw.remaining() < 22) {
            throw new MalformedPacketException("length");
        }
        this.mac = _mac;
        _raw.order(ByteOrder.LITTLE_ENDIAN);
        _raw.get(this.appEUI);
        _raw.get(this.devEUI);
        _raw.get(this.devNonce);
    }

    public JoinRequestPayload(MacPayload _mac) {
        this.mac = _mac;
    }

    public byte[] computeMic() {
        if (this.appKey == null) {
            throw new RuntimeException("undefined appKey");
        }
        ByteBuffer body = ByteBuffer.allocate(1 + this.length());
        body.order(ByteOrder.LITTLE_ENDIAN);
        body.put(this.mac.getPhyPayload().getMHDR());
        this.toRaw(body);
        try {
            AesCmac aesCmac = new AesCmac();
            aesCmac.init(new SecretKeySpec(this.appKey, "AES"));
            aesCmac.updateBlock(body.array());
            return Arrays.copyOfRange(aesCmac.doFinal(), 0, 4);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Could not compute AesCmac", ex);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Could not compute AesCmac", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new RuntimeException("Could not compute AesCmac", ex);
        }
    }

    @Override
    public int length() {
        return 18;
    }

    @Override
    public void toRaw(ByteBuffer _bb) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        _bb.put(this.getAppEUI());
        _bb.put(this.getDevEUI());
        _bb.put(this.getDevNonce());
    }

    public MacPayload getMac() {
        return this.mac;
    }

    public JoinRequestPayload setMac(MacPayload _mac) {
        this.mac = _mac;
        return this;
    }

    public byte[] getAppEUI() {
        return this.appEUI;
    }

    public JoinRequestPayload setAppEUI(byte[] _appEUI) {
        this.appEUI = _appEUI;
        return this;
    }

    public byte[] getDevEUI() {
        return this.devEUI;
    }

    public JoinRequestPayload setDevEUI(byte[] _devEUI) {
        this.devEUI = _devEUI;
        return this;
    }

    public byte[] getDevNonce() {
        return this.devNonce;
    }

    public JoinRequestPayload setDevNonce(byte[] _devNonce) {
        this.devNonce = _devNonce;
        return this;
    }

    public JoinRequestPayload setAppKey(byte[] _appKey) {
        this.appKey = _appKey;
        return this;
    }

    public byte[] getAppKey() {
        return this.appKey;
    }

    @Override
    public boolean validateMic(short fCntHighBits) {
        return Arrays.equals(this.computeMic(), this.mac.getPhyPayload().getMic());
    }
}

