/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan.model;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCmac {
    private static final byte CONSTANT = -121;
    private static final int BLOCK_SIZE = 16;
    private static final IvParameterSpec ZERO_IV = new IvParameterSpec(new byte[16]);
    private int macLength;
    private Cipher aesCipher;
    private byte[] buffer;
    private int bufferCount;
    private byte[] k1;
    private byte[] k2;

    public AesCmac() throws NoSuchAlgorithmException {
        this(16);
    }

    public AesCmac(int length) throws NoSuchAlgorithmException {
        if (length > 16) {
            throw new NoSuchAlgorithmException("AES CMAC maximum length is 16");
        }
        try {
            this.macLength = length;
            this.aesCipher = Cipher.getInstance("AES/CBC/NOPADDING");
            this.buffer = new byte[16];
        }
        catch (NoSuchPaddingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private byte[] doubleSubKey(byte[] k2) {
        byte[] ret = new byte[k2.length];
        boolean firstBitSet = (k2[0] & 0x80) != 0;
        int i2 = 0;
        while (i2 < k2.length) {
            ret[i2] = (byte)(k2[i2] << 1);
            if (i2 + 1 < k2.length && (k2[i2 + 1] & 0x80) != 0) {
                int n2 = i2;
                ret[n2] = (byte)(ret[n2] | 1);
            }
            ++i2;
        }
        if (firstBitSet) {
            int n3 = ret.length - 1;
            ret[n3] = (byte)(ret[n3] ^ 0xFFFFFF87);
        }
        return ret;
    }

    public final void init(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("Key is not of required type SecretKey.");
        }
        if (!((SecretKeySpec)key).getAlgorithm().equals("AES")) {
            throw new InvalidKeyException("Key is not an AES key.");
        }
        this.aesCipher.init(1, key, ZERO_IV);
        byte[] k0 = new byte[16];
        try {
            this.aesCipher.update(k0, 0, k0.length, k0, 0);
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
        this.k1 = this.doubleSubKey(k0);
        this.k2 = this.doubleSubKey(this.k1);
        this.aesCipher.init(1, key, ZERO_IV);
        this.bufferCount = 0;
    }

    public final void updateByte(byte b2) {
        this.updateBlock(new byte[]{b2});
    }

    public final void updateBlock(byte[] data) {
        int currentOffset = 0;
        if (data.length < 16 - this.bufferCount) {
            System.arraycopy(data, 0, this.buffer, this.bufferCount, data.length);
            this.bufferCount += data.length;
            return;
        }
        if (this.bufferCount > 0) {
            System.arraycopy(data, 0, this.buffer, this.bufferCount, 16 - this.bufferCount);
            try {
                this.aesCipher.update(this.buffer, 0, 16, this.buffer, 0);
            }
            catch (ShortBufferException shortBufferException) {
                // empty catch block
            }
            currentOffset += 16 - this.bufferCount;
            this.bufferCount = 0;
        }
        while (currentOffset + 16 < data.length) {
            try {
                this.aesCipher.update(data, currentOffset, 16, this.buffer, 0);
            }
            catch (ShortBufferException shortBufferException) {
                // empty catch block
            }
            currentOffset += 16;
        }
        if (currentOffset != data.length) {
            System.arraycopy(data, currentOffset, this.buffer, 0, data.length - currentOffset);
            this.bufferCount = data.length - currentOffset;
        }
    }

    public final byte[] doFinal() {
        int i22;
        byte[] subKey = this.k1;
        if (this.bufferCount < 16) {
            this.buffer[this.bufferCount] = -128;
            i22 = this.bufferCount + 1;
            while (i22 < 16) {
                this.buffer[i22] = 0;
                ++i22;
            }
            subKey = this.k2;
        }
        i22 = 0;
        while (i22 < 16) {
            int n2 = i22;
            this.buffer[n2] = (byte)(this.buffer[n2] ^ subKey[i22]);
            ++i22;
        }
        try {
            this.aesCipher.doFinal(this.buffer, 0, 16, this.buffer, 0);
        }
        catch (ShortBufferException i22) {
        }
        catch (IllegalBlockSizeException i22) {
        }
        catch (BadPaddingException i22) {
            // empty catch block
        }
        this.bufferCount = 0;
        byte[] mac = new byte[this.macLength];
        System.arraycopy(this.buffer, 0, mac, 0, this.macLength);
        return mac;
    }
}

