/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan;

import drivers.lorawan.Driver;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

abstract class CayenneFormat {
    private static final DecimalFormat DF = new DecimalFormat("##0.##", new DecimalFormatSymbols(Locale.US));
    private static final CayenneFormat DIGITAL_INPUT = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            return Integer.toString(data[i2] & 1);
        }

        @Override
        int getDataSize() {
            return 1;
        }
    };
    private static final CayenneFormat DIGITAL_OUTPUT = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            return Integer.toString(data[i2] & 1);
        }

        @Override
        int getDataSize() {
            return 1;
        }

        @Override
        String getDownlinkData(String value) throws Exception {
            int v = (int)Float.parseFloat(value);
            if (v == 1) {
                return "0001";
            }
            if (v == 0) {
                return "0000";
            }
            throw new Exception("Illegal value " + value);
        }
    };
    private static final CayenneFormat ANALOG_INPUT = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            short val = (short)(data[i2] << 8 | data[i2 + 1] & 0xFF);
            return DF.format((float)val * 0.01f);
        }

        @Override
        int getDataSize() {
            return 2;
        }
    };
    private static final CayenneFormat ANALOG_OUTPUT = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            short val = (short)(data[i2] << 8 | data[i2 + 1] & 0xFF);
            return DF.format((float)val * 0.01f);
        }

        @Override
        int getDataSize() {
            return 2;
        }

        @Override
        String getDownlinkData(String value) throws Exception {
            int iVal = (int)(Float.parseFloat(value) * 100.0f);
            if (iVal > Short.MAX_VALUE || iVal < Short.MIN_VALUE) {
                throw new Exception("Illegal value " + value);
            }
            return Driver.bytesToHex(new byte[]{(byte)(iVal >>> 8), (byte)iVal}, 0, 2);
        }
    };
    private static final CayenneFormat ILLUMINANCE_SENSOR = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            return Integer.toString((data[i2] & 0xFF) << 8 | data[i2 + 1] & 0xFF);
        }

        @Override
        int getDataSize() {
            return 2;
        }
    };
    private static final CayenneFormat PRESENCE_SENSOR = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            return Integer.toString(data[i2] & 1);
        }

        @Override
        int getDataSize() {
            return 1;
        }
    };
    private static final CayenneFormat TEMPERATURE_SENSOR = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            short val = (short)(data[i2] << 8 | data[i2 + 1] & 0xFF);
            return DF.format((float)val * 0.1f);
        }

        @Override
        int getDataSize() {
            return 2;
        }
    };
    private static final CayenneFormat HUMIDITY_SENSOR = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            return DF.format((float)(data[i2] & 0xFF) * 0.5f);
        }

        @Override
        int getDataSize() {
            return 1;
        }
    };
    private static final CayenneFormat ACCELEROMETER = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            short x = (short)(data[i2] << 8 | data[i2 + 1] & 0xFF);
            short y = (short)(data[i2 + 2] << 8 | data[i2 + 3] & 0xFF);
            short z = (short)(data[i2 + 4] << 8 | data[i2 + 5] & 0xFF);
            return "[" + Float.toString((float)x * 0.001f) + ", " + Float.toString((float)y * 0.001f) + ", " + Float.toString((float)z * 0.001f) + "]";
        }

        @Override
        int getDataSize() {
            return 6;
        }
    };
    private static final CayenneFormat BAROMETER = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            int val = (data[i2] & 0xFF) << 8 | data[i2 + 1] & 0xFF;
            return DF.format((float)val * 0.1f);
        }

        @Override
        int getDataSize() {
            return 2;
        }
    };
    private static final CayenneFormat GYROMETER = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            short x = (short)(data[i2] << 8 | data[i2 + 1] & 0xFF);
            short y = (short)(data[i2 + 2] << 8 | data[i2 + 3] & 0xFF);
            short z = (short)(data[i2 + 4] << 8 | data[i2 + 5] & 0xFF);
            return "[" + DF.format((float)x * 0.01f) + ", " + DF.format((float)y * 0.01f) + ", " + DF.format((float)z * 0.01f) + "]";
        }

        @Override
        int getDataSize() {
            return 6;
        }
    };
    private static final CayenneFormat GPS_LOCATION = new CayenneFormat(){

        @Override
        String getValue(byte[] data, int i2) {
            int lat = data[i2] << 16 | (data[i2 + 1] & 0xFF) << 8 | data[i2 + 2] & 0xFF;
            int lon = data[i2 + 3] << 16 | (data[i2 + 4] & 0xFF) << 8 | data[i2 + 5] & 0xFF;
            int alt = data[i2 + 6] << 16 | (data[i2 + 7] & 0xFF) << 8 | data[i2 + 8] & 0xFF;
            return "[" + Float.toString((float)lat * 1.0E-4f) + ", " + Float.toString((float)lon * 1.0E-4f) + ", " + Float.toString((float)alt * 0.01f) + "]";
        }

        @Override
        int getDataSize() {
            return 9;
        }
    };

    CayenneFormat() {
    }

    static CayenneFormat get(int type) {
        switch (type) {
            case 0: {
                return DIGITAL_INPUT;
            }
            case 1: {
                return DIGITAL_OUTPUT;
            }
            case 2: {
                return ANALOG_INPUT;
            }
            case 3: {
                return ANALOG_OUTPUT;
            }
            case 101: {
                return ILLUMINANCE_SENSOR;
            }
            case 102: {
                return PRESENCE_SENSOR;
            }
            case 103: {
                return TEMPERATURE_SENSOR;
            }
            case 104: {
                return HUMIDITY_SENSOR;
            }
            case 113: {
                return ACCELEROMETER;
            }
            case 115: {
                return BAROMETER;
            }
            case 134: {
                return GYROMETER;
            }
            case 136: {
                return GPS_LOCATION;
            }
        }
        return null;
    }

    abstract String getValue(byte[] var1, int var2);

    abstract int getDataSize();

    String getDownlinkData(String value) throws Exception {
        throw new Exception("Unsupported operation");
    }
}

