/*
 * Decompiled with CFR 0.152.
 */
package drivers.lares4;

import com.hsyco.userBase;
import drivers.lares4.Driver;
import java.net.URI;
import java.util.Map;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LaresClientEndpoint
extends WebSocketClient {
    private Driver driver;

    public LaresClientEndpoint(Driver driver, URI serverUri, Map<String, String> httpHeaders) {
        super(serverUri, httpHeaders);
        this.uri = serverUri;
        this.driver = driver;
    }

    public LaresClientEndpoint(URI serverUri) {
        super(serverUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(String message) {
        block17: {
            boolean payloadError = false;
            try {
                String cmd;
                JSONObject payload;
                String payRes;
                JSONObject json = new JSONObject(message);
                String payType = json.getString("PAYLOAD_TYPE");
                if (payType.equals("ERROR")) {
                    payloadError = true;
                }
                if ((payRes = (payload = json.getJSONObject("PAYLOAD")).getString("RESULT")).equals("FAIL")) {
                    payloadError = true;
                }
                if (payload.has("ID_LOGIN")) {
                    this.driver.setIdLogin(payload.getString("ID_LOGIN"));
                }
                if ((cmd = json.getString("CMD")).equals("READ_RES")) {
                    this.readAllStatuses(payload);
                } else if (cmd.equals("CMD_USR_RES")) {
                    this.driver.commandOk = !payloadError;
                } else if (cmd.equals("LOGS_RES")) {
                    this.driver.responseLogs = payload.getJSONArray("LOGS");
                }
                if (cmd.equals("CMD_USR_RES")) {
                    Object object = this.driver.commandLock;
                    synchronized (object) {
                        this.driver.commandLock.notifyAll();
                        break block17;
                    }
                }
                if (!cmd.equals("READ_RES") && !cmd.equals("LOGIN_RES") && !cmd.equals("LOGS_RES")) break block17;
                this.driver.isStatusOk = !payloadError;
                Object object = this.driver.readLock;
                synchronized (object) {
                    this.driver.readLock.notifyAll();
                }
            }
            catch (Exception e2) {
                if (!this.driver.isDriverInVerboseLog()) break block17;
                userBase.errorLog("exception in message receiving - " + e2.getMessage());
            }
        }
    }

    @Override
    public void onClose(int arg0, String arg1, boolean arg2) {
    }

    @Override
    public void onError(Exception arg0) {
    }

    @Override
    public void onOpen(ServerHandshake arg0) {
    }

    private void readAllStatuses(JSONObject payload) throws Exception {
        block33: {
            try {
                JSONObject output;
                String status;
                JSONObject zone;
                String tamper;
                String alarm;
                String desc;
                String id;
                JSONObject partition;
                JSONArray partitions = payload.getJSONArray("PARTITIONS");
                int i2 = 0;
                while (i2 < partitions.length()) {
                    partition = partitions.getJSONObject(i2);
                    id = partition.getString("ID");
                    desc = partition.getString("DES");
                    this.driver.ioWrite("p" + id + ".desc", desc);
                    ++i2;
                }
                partitions = payload.getJSONArray("STATUS_PARTITIONS");
                this.driver.partitionNum = partitions.length();
                i2 = 0;
                while (i2 < partitions.length()) {
                    partition = partitions.getJSONObject(i2);
                    id = partition.getString("ID");
                    String arm = partition.getString("ARM");
                    arm = arm.equals("DA") || arm.equals("IA") ? "1" : "0";
                    this.driver.ioWrite("p" + id + ".armed", arm);
                    alarm = partition.getString("AST");
                    alarm = alarm.equals("OK") ? "0" : (alarm.equals("AL") ? "1" : "mem");
                    this.driver.ioWrite("p" + id + ".alarm", alarm);
                    tamper = partition.getString("TST");
                    tamper = tamper.equals("OK") ? "0" : (tamper.equals("TAM") ? "1" : "mem");
                    this.driver.ioWrite("p" + id + ".tamper", tamper);
                    ++i2;
                }
                JSONArray zones = payload.getJSONArray("ZONES");
                int i3 = 0;
                while (i3 < zones.length()) {
                    zone = zones.getJSONObject(i3);
                    id = zone.getString("ID");
                    desc = zone.getString("DES");
                    this.driver.ioWrite("z" + id + ".desc", desc);
                    ++i3;
                }
                zones = payload.getJSONArray("STATUS_ZONES");
                StringBuilder values = new StringBuilder();
                StringBuilder labels = new StringBuilder();
                int i4 = 0;
                while (i4 < zones.length()) {
                    String error;
                    String mask;
                    zone = zones.getJSONObject(i4);
                    id = zone.getString("ID");
                    status = zone.getString("STA");
                    if (status.equals("R")) {
                        alarm = "0";
                        mask = "0";
                        error = "0";
                        tamper = "0";
                    } else if (status.equals("A")) {
                        alarm = "1";
                        mask = "0";
                        error = "0";
                        tamper = "0";
                    } else if (status.equals("FM")) {
                        alarm = "0";
                        mask = "1";
                        error = "0";
                        tamper = "0";
                    } else if (status.equals("T")) {
                        alarm = "0";
                        mask = "0";
                        error = "0";
                        tamper = "1";
                    } else {
                        alarm = "0";
                        mask = "0";
                        error = "1";
                        tamper = "0";
                    }
                    this.driver.ioWrite("z" + id + ".alarm", alarm);
                    this.driver.ioWrite("z" + id + ".mask", mask);
                    this.driver.ioWrite("z" + id + ".tamper", tamper);
                    this.driver.ioWrite("z" + id + ".error", error);
                    String bypass = zone.getString("BYP");
                    bypass = bypass.equals("NO") ? "0" : "1";
                    this.driver.ioWrite("z" + id + ".bypass", bypass);
                    values.append("," + (i4 + 1));
                    labels.append(",Zone " + (i4 + 1));
                    if (this.driver.gui) {
                        userBase.uiSet("z" + id + ".alarm", "visible", alarm.equals("1") ? "true" : "false");
                        userBase.uiSet("z" + id + ".mask", "visible", mask.equals("1") ? "true" : "false");
                        userBase.uiSet("z" + id + ".tamper", "visible", tamper.equals("1") ? "true" : "false");
                        userBase.uiSet("z" + id + ".error", "visible", error.equals("1") ? "true" : "false");
                        userBase.uiSet("z" + id + ".bypass", "visible", bypass.equals("1") ? "true" : "false");
                    }
                    ++i4;
                }
                if (values.length() > 0) {
                    userBase.uiSet(String.valueOf(Driver.UIPREFIX) + "zones.list", "values", values.substring(1));
                    userBase.uiSet(String.valueOf(Driver.UIPREFIX) + "zones.list", "labels", labels.substring(1));
                }
                JSONArray outputs = payload.getJSONArray("OUTPUTS");
                int i5 = 0;
                while (i5 < outputs.length()) {
                    output = outputs.getJSONObject(i5);
                    id = output.getString("ID");
                    desc = output.getString("DES");
                    this.driver.ioWrite("o" + id + ".desc", desc);
                    ++i5;
                }
                outputs = payload.getJSONArray("STATUS_OUTPUTS");
                i5 = 0;
                while (i5 < outputs.length()) {
                    output = outputs.getJSONObject(i5);
                    id = output.getString("ID");
                    status = output.getString("STA");
                    status = status.equals("ON") ? "1" : "0";
                    this.driver.ioWrite("o" + id, status);
                    ++i5;
                }
                this.driver.ioWrite("voltage.low", "0");
                this.driver.ioWrite("batt.low", "0");
                this.driver.ioWrite("batt.fault", "0");
                this.driver.ioWrite("pstn.fault", "0");
                this.driver.ioWrite("credit.low", "0");
                this.driver.ioWrite("system.fault", "0");
                this.driver.ioWrite("mobile.fault", "0");
                JSONObject system = payload.getJSONArray("STATUS_SYSTEM").getJSONObject(0);
                JSONArray faults = system.getJSONArray("FAULT");
                int i6 = 0;
                while (i6 < faults.length()) {
                    String fault = faults.getString(i6);
                    if (fault.equals("PS_LOW")) {
                        this.driver.ioWrite("voltage.low", "1");
                    } else if (fault.equals("LOW_BATT")) {
                        this.driver.ioWrite("batt.low", "1");
                    } else if (fault.equals("BAD_BATT")) {
                        this.driver.ioWrite("batt.fault", "1");
                    } else if (fault.equals("PSTN")) {
                        this.driver.ioWrite("pstn.fault", "1");
                    } else if (fault.equals("SIM_CRE")) {
                        this.driver.ioWrite("credit.low", "1");
                    } else if (fault.equals("SYSTEM")) {
                        this.driver.ioWrite("system.fault", "1");
                    } else if (fault.equals("MOBILE")) {
                        this.driver.ioWrite("mobile.fault", "1");
                    }
                    ++i6;
                }
                JSONArray scenes = payload.getJSONArray("SCENARIOS");
                int i7 = 0;
                while (i7 < scenes.length()) {
                    JSONObject scene = scenes.getJSONObject(i7);
                    id = scene.getString("ID");
                    desc = scene.getString("DES");
                    this.driver.ioWrite("s" + id + ".desc", desc);
                    ++i7;
                }
            }
            catch (JSONException e2) {
                if (!this.driver.isDriverInVerboseLog()) break block33;
                userBase.errorLog("error reading json device status - " + e2.getMessage());
            }
        }
    }
}

