/*
 * Decompiled with CFR 0.152.
 */
package drivers.lares4;

import com.hsyco.driverBase;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import drivers.lares4.LaresClientEndpoint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final int DEFAULTPOLLINTERVAL = 1000;
    public static final int DEFAULTLOGSIZE = 300;
    public static final int WEBSOCKETPORT = 80;
    public static String UIPREFIX;
    private String idLogin = "";
    public Object readLock = new Object();
    public Object commandLock = new Object();
    public boolean isStatusOk;
    public boolean commandOk;
    private boolean startupevents;
    private boolean firstloop = true;
    public boolean gui = true;
    private String name;
    private String username;
    private String password;
    private String host;
    private int pollinterval = 1000;
    private Thread currentThread;
    private int logSize = 300;
    private Vector<String> logs;
    private String logsVar;
    private String lastLogIndexVar;
    private long lastLogTs = 0L;
    private LaresClientEndpoint websocket = null;
    private final int SEME_CRC_16_JSON = 65535;
    private final int GEN_POLY_JSON = 4129;
    private int mostRecentLogIndex = 1;
    private ArrayList<String> templogs = new ArrayList();
    public JSONArray responseLogs;
    public int partitionNum = 1;
    private ArrayList<String> sessions = new ArrayList();
    private int sessionIndex = 0;
    private int maxPartitions = 3;
    public static final String[] WEBOBJECTS;

    static {
        WEBOBJECTS = new String[]{"lares4"};
    }

    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            UIPREFIX = String.valueOf(name) + ".";
            try {
                InetAddress inet = InetAddress.getByName(config.get("host"));
                this.host = String.valueOf(inet.getHostName()) + ":" + 80;
            }
            catch (Exception e2) {
                throw new Exception(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            this.username = config.get("user");
            if (this.username == null) {
                this.messageLog(String.valueOf(name) + ": username ignored");
            }
            this.password = config.get("password");
            if (this.password == null) {
                this.messageLog(String.valueOf(name) + ": password ignored");
            }
            this.startupevents = Boolean.parseBoolean(config.get("startupevents"));
            if (config.containsKey("gui")) {
                this.gui = Boolean.parseBoolean(config.get("gui"));
            }
            try {
                int timer = Integer.parseInt(config.get("pollinterval"));
                if (timer >= 1000 && timer <= 30000) {
                    this.pollinterval = timer;
                }
            }
            catch (Exception e3) {
                this.messageLog(String.valueOf(name) + ": pollinterval ignored");
            }
            try {
                int n2 = Integer.parseInt(config.get("logsize"));
                if (n2 >= 0) {
                    this.logSize = n2;
                }
            }
            catch (Exception e4) {
                this.messageLog(String.valueOf(name) + ": logsize ignored");
            }
            try {
                int n3 = Integer.parseInt(config.get("maxpartitions"));
                if (n3 >= 1 && n3 <= 30) {
                    this.maxPartitions = n3;
                }
            }
            catch (Exception e5) {
                this.messageLog(String.valueOf(name) + ": maxpartitions ignored");
            }
            this.loadLogs();
            try {
                HashMap<String, String> httpHeaders = new HashMap<String, String>();
                httpHeaders.put("Sec-WebSocket-Protocol", "KS_WSOCK");
                this.websocket = new LaresClientEndpoint(this, new URI("ws://" + this.host + "/KseniaWsock/"), httpHeaders);
                if (!this.websocket.connectBlocking()) {
                    throw new Exception("connection failed");
                }
            }
            catch (Exception e6) {
                throw new Exception("websocket connection error - " + e6.getMessage());
            }
            JSONKsenia json = this.createJSON("login", null, null, "USER");
            try {
                this.sendToLares(json);
            }
            catch (Exception e7) {
                throw new Exception("login error");
            }
            this.messageLog(String.valueOf(name) + " - driver started | username: " + this.username + " | password: " + this.password + " | startupevents: " + this.startupevents + " | pollinterval: " + this.pollinterval);
            return true;
        }
        catch (Exception e8) {
            this.errorLog("Initialization failed - " + name + " - " + e8.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    public boolean loop() {
        this.currentThread = Thread.currentThread();
        try {
            JSONKsenia json = this.createJSON("read", null, null, "ALL");
            this.sendToLares(json);
            this.readLogs();
            this.updatePartitionsUIStatus();
            for (String session : this.sessions) {
                this.updateZoneUIStatuses(session);
            }
            StringBuilder s = new StringBuilder();
            for (String log : this.logs) {
                s.append(String.valueOf(log) + "<br>");
            }
            userBase.uiSet(String.valueOf(UIPREFIX) + "log", "text", s.toString());
            if (this.firstloop) {
                this.firstloop = false;
                this.ioWrite("connection", "online");
                this.securityLog("HSYCO ONLINE");
                userBase.uiSet(String.valueOf(UIPREFIX) + "connection.online", "visible", "false");
                userBase.uiSet(String.valueOf(UIPREFIX) + "connection.panel", "visible", "false");
            }
            if (this.lastLogTs != 0L && System.currentTimeMillis() > this.lastLogTs + 5000L) {
                this.uiSet("log0", "value", "");
                this.lastLogTs = 0L;
            }
            this.sleep(this.pollinterval);
            return true;
        }
        catch (Exception e2) {
            if (this.isVerboseLog()) {
                this.errorLog(String.valueOf(this.name) + ": Loop failed - " + e2.getMessage());
            }
            this.sleep(1000L);
            return false;
        }
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.securityLog("HSYCO OFFLINE");
            userBase.uiSet(String.valueOf(UIPREFIX) + "connection.online", "visible", "true");
            userBase.uiSet(String.valueOf(UIPREFIX) + "connection.panel", "visible", "true");
        }
        try {
            this.websocket.closeBlocking();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        this.addSession(session);
        if (id.equals("partitions.armed.1")) {
            this.command("armed", "1");
            return "!";
        }
        if (id.equals("partitions.armed.0")) {
            this.command("armed", "0");
            return "!";
        }
        if (id.startsWith("partitions.list")) {
            String num = id.split("\\.")[2];
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "partition.internal", num);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "partition.sel.name", "value", "Partition " + num);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "partition.sel.cont", "visible", "true");
            return "!";
        }
        if (id.equals("partition.sel.close")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "partition.sel.cont", "visible", "false");
            return "!";
        }
        if (id.equals("subpartition.armed.1")) {
            String partition = userBase.uiGet(session, String.valueOf(UIPREFIX) + "partition.internal");
            this.command("p" + partition + ".armed", "1");
            return "!";
        }
        if (id.equals("subpartition.armed.0")) {
            String partition = userBase.uiGet(session, String.valueOf(UIPREFIX) + "partition.internal");
            this.command("p" + partition + ".armed", "0");
            return "!";
        }
        if (id.startsWith("zones.list")) {
            String num = id.split("\\.")[2];
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.internal", num);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.name", "value", "Zone " + num);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.cont", "visible", "true");
            this.updateZoneUIStatuses(session);
            return "!";
        }
        if (id.equals("zone.sel.close")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.cont", "visible", "false");
            return "!";
        }
        if (id.equals("zone.sel.bypass")) {
            String zone = userBase.uiGet(session, String.valueOf(UIPREFIX) + "zone.internal");
            this.command("z" + zone + ".bypass", "1");
            return "!";
        }
        if (id.equals("zone.sel.unbypass")) {
            String zone = userBase.uiGet(session, String.valueOf(UIPREFIX) + "zone.internal");
            this.command("z" + zone + ".bypass", "0");
            return "!";
        }
        return "";
    }

    public void command(String name, String value) {
        JSONKsenia msg = null;
        try {
            String id;
            JSONKsenia json;
            String id2;
            String[] fields;
            if (name.equals("armed")) {
                JSONKsenia json2 = new JSONKsenia();
                int i22 = 0;
                while (i22 < this.partitionNum) {
                    json2.put("ID", String.valueOf(i22 + 1));
                    json2.put("MOD", value.equals("1") ? "I" : "D");
                    msg = this.createJSON("command", json2, "PARTITION", "CMD_ARM_PARTITION");
                    boolean cmd = false;
                    int j2 = 0;
                    while (j2 < 5) {
                        if (this.tryCommandToLares(msg)) {
                            cmd = true;
                            break;
                        }
                        this.sleep(100L);
                        ++j2;
                    }
                    if (!cmd) {
                        throw new Exception("error arming/disarming all partitions");
                    }
                    ++i22;
                }
                try {
                    this.currentThread.interrupt();
                }
                catch (Exception i22) {
                    // empty catch block
                }
                return;
            }
            if (name.startsWith("p") && name.endsWith("armed")) {
                fields = name.split("\\.");
                id2 = fields[0].substring(1);
                json = new JSONKsenia();
                json.put("ID", id2);
                json.put("MOD", value.equals("1") ? "I" : "D");
                msg = this.createJSON("command", json, "PARTITION", "CMD_ARM_PARTITION");
            } else if (name.startsWith("z") && name.endsWith("bypass")) {
                fields = name.split("\\.");
                id2 = fields[0].substring(1);
                json = new JSONKsenia();
                json.put("ID", id2);
                json.put("BYP", value.equals("1") ? "ON" : "OFF");
                msg = this.createJSON("command", json, "ZONE", "CMD_BYP_ZONE");
            } else if (name.startsWith("o")) {
                id = name.substring(1);
                json = new JSONKsenia();
                json.put("ID", id);
                json.put("STA", value.equals("1") ? "ON" : "OFF");
                msg = this.createJSON("command", json, "OUTPUT", "CMD_SET_OUTPUT");
            } else if (name.startsWith("s") && value.equals("1")) {
                id = name.substring(1);
                json = new JSONKsenia();
                json.put("ID", id);
                msg = this.createJSON("command", json, "SCENARIO", "CMD_EXE_SCENARIO");
            } else {
                return;
            }
            int i2 = 0;
            while (i2 < 5) {
                if (this.tryCommandToLares(msg)) {
                    try {
                        this.currentThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                this.sleep(100L);
                ++i2;
            }
            throw new Exception("error executing command");
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.name) + " - command error - " + name + ": " + value + " - " + e2.getMessage());
            return;
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.firstloop && !this.startupevents) {
            super.ioWriteNoEvents(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    @Override
    protected void ioWriteForced(String name, String value) {
        super.ioWriteForced(name, value);
    }

    private void loadLogs() {
        block13: {
            this.logsVar = "__HSYCO__LARES4_" + this.name + ".log!";
            this.lastLogIndexVar = "__HSYCO__LARES4_" + this.name + ".last_log_index!";
            ObjectInputStream ois = null;
            try {
                try {
                    String s = userBase.varGet(this.logsVar);
                    if (s == null) {
                        this.logs = new Vector(this.logSize);
                    }
                    byte[] data = Base64.decodeBase64(s);
                    ois = new ObjectInputStream(new ByteArrayInputStream(data));
                    this.logs = (Vector)ois.readObject();
                }
                catch (Exception e2) {
                    this.logs = new Vector(this.logSize);
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    ois.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String ind = userBase.varGet(this.lastLogIndexVar);
        if (ind != null) {
            this.mostRecentLogIndex = Integer.parseInt(ind);
        }
    }

    void securityLog(String event) {
        String message = event;
        hsyco.securityLog(String.valueOf(this.name) + " - " + message);
        String guiEntry = "<div style=\"font-size:17px\">" + message + "</div>";
        this.logs.add(0, guiEntry);
        while (this.logs.size() > this.logSize) {
            this.logs.remove(this.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            guiEntry = this.logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(guiEntry).append("</div>");
            ++i2;
        }
        this.uiSet("log", "value", text.toString());
        this.uiSet("log0", "value", message);
        this.lastLogTs = System.currentTimeMillis();
        this.saveLogs();
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                userBase.varSet(this.logsVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    private String CRC_16_calculate(byte[] data) {
        int dataLen = data.length;
        int crc = 65535;
        int pData = 0;
        while (dataLen > 0) {
            int i_CRC = 128;
            while (i_CRC > 0) {
                boolean flag_CRC = (crc & 0x8000) != 0;
                crc <<= 1;
                if ((data[pData] & i_CRC) != 0) {
                    ++crc;
                }
                if (flag_CRC) {
                    crc ^= 0x1021;
                }
                i_CRC >>= 1;
            }
            --dataLen;
            ++pData;
        }
        String num = Integer.toHexString(crc & 0xFFFF);
        if (num.length() == 1) {
            num = "000" + num;
        } else if (num.length() == 2) {
            num = "00" + num;
        } else if (num.length() == 3) {
            num = "0" + num;
        }
        return "0x" + num;
    }

    private JSONKsenia createJSON(String cmd, JSONObject pay, String payName, String cmdType) throws Exception {
        try {
            JSONKsenia json = new JSONKsenia();
            json.put("SENDER", "0");
            json.put("RECEIVER", "");
            JSONKsenia payload = new JSONKsenia();
            if (cmd.equals("login")) {
                json.put("CMD", "LOGIN");
                json.put("ID", "0");
                json.put("PAYLOAD_TYPE", cmdType);
                payload.put("PIN", this.password);
            } else if (cmd.equals("read")) {
                json.put("CMD", "READ");
                json.put("ID", "0");
                json.put("PAYLOAD_TYPE", cmdType);
                payload.put("ID_LOGIN", this.idLogin);
                JSONArray range = new JSONArray();
                range.put("ALL");
                range.put("ALL");
                payload.put("ID_ITEMS_RANGE", range);
            } else if (cmd.equals("command")) {
                json.put("CMD", "CMD_USR");
                json.put("ID", "0");
                json.put("PAYLOAD_TYPE", cmdType);
                payload.put("ID_LOGIN", this.idLogin);
                payload.put("PIN", this.password);
                payload.put(payName, pay);
            } else if (cmd.equals("logs")) {
                json.put("CMD", "LOGS");
                json.put("ID", "0");
                json.put("PAYLOAD_TYPE", cmdType);
                payload.put("ID_LOGIN", this.idLogin);
                payload.put("PIN", this.password);
                payload.put("ID_LOG", "USER");
                payload.put("ITEMS_LOG", String.valueOf(300));
            }
            json.put("PAYLOAD", payload);
            json.put("TIMESTAMP", String.valueOf(System.currentTimeMillis()));
            String data = String.valueOf(json.toString().substring(0, json.toString().length() - 1)) + ",\"CRC_16\"";
            String crc_16 = this.CRC_16_calculate(data.getBytes());
            json.put("CRC_16", crc_16);
            return json;
        }
        catch (Exception e2) {
            throw new Exception(e2.getMessage());
        }
    }

    public void setIdLogin(String s) {
        this.idLogin = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToLares(JSONKsenia json) throws Exception {
        this.isStatusOk = false;
        Object object = this.readLock;
        synchronized (object) {
            this.websocket.send(json.toString());
            this.readLock.wait(15000L);
        }
        if (!this.isStatusOk) {
            throw new Exception("error retrieving device status");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryCommandToLares(JSONKsenia json) throws Exception {
        this.commandOk = false;
        Object object = this.commandLock;
        synchronized (object) {
            this.websocket.send(json.toString());
            this.commandLock.wait(15000L);
        }
        return this.commandOk;
    }

    private void readLogs() throws Exception {
        int logIndex;
        JSONObject jsonLog;
        this.templogs.clear();
        JSONKsenia json = this.createJSON("logs", null, null, "GET_LAST_LOGS");
        this.sendToLares(json);
        int startIndex = -1;
        int i2 = 0;
        while (i2 < this.responseLogs.length()) {
            jsonLog = this.responseLogs.getJSONObject(i2);
            logIndex = Integer.parseInt(jsonLog.getString("ID"));
            if (logIndex <= this.mostRecentLogIndex) break;
            ++startIndex;
            ++i2;
        }
        if (startIndex < 0) {
            return;
        }
        i2 = startIndex;
        while (i2 >= 0) {
            jsonLog = this.responseLogs.getJSONObject(i2);
            logIndex = Integer.parseInt(jsonLog.getString("ID"));
            if (logIndex > this.mostRecentLogIndex) {
                String time = String.valueOf(jsonLog.getString("DATA")) + " " + jsonLog.getString("TIME");
                String msg = this.replaceSpecialChars(String.valueOf(jsonLog.getString("EV")) + " - " + jsonLog.getString("I1"));
                this.templogs.add(String.valueOf(time) + " - " + msg);
            }
            --i2;
        }
        if (startIndex > -1) {
            this.mostRecentLogIndex = Integer.parseInt(this.responseLogs.getJSONObject(0).getString("ID"));
        }
        this.writeLogs();
    }

    private void writeLogs() {
        for (String log : this.templogs) {
            this.securityLog(log);
        }
        userBase.varSet(this.lastLogIndexVar, "" + this.mostRecentLogIndex);
    }

    private String replaceSpecialChars(String s) throws UnsupportedEncodingException {
        return URLDecoder.decode(s, "UTF-8");
    }

    public boolean isDriverInVerboseLog() {
        return this.isVerboseLog();
    }

    private void addSession(String session) {
        if (this.sessions.contains(session)) {
            return;
        }
        if (this.sessionIndex >= 10) {
            this.sessionIndex = 0;
        }
        this.sessions.add(this.sessionIndex++, session);
    }

    private void updatePartitionsUIStatus() {
        boolean tamper = false;
        int i2 = 1;
        while (i2 < this.maxPartitions) {
            String tmp = userBase.ioGet(String.valueOf(this.name) + ".p" + i2 + ".tamper");
            if (tmp != null && tmp.equals("1")) {
                tamper = true;
                break;
            }
            ++i2;
        }
        if (tamper) {
            userBase.uiSet(String.valueOf(UIPREFIX) + "partition.tamper.mem.label.1", "visible", "true");
        } else {
            userBase.uiSet(String.valueOf(UIPREFIX) + "partition.tamper.mem.label.1", "visible", "false");
        }
        boolean alarm = false;
        int i3 = 1;
        while (i3 < this.maxPartitions) {
            String alm = userBase.ioGet(String.valueOf(this.name) + ".p" + i3 + ".alarm");
            if (alm != null && alm.equals("1")) {
                alarm = true;
                break;
            }
            ++i3;
        }
        if (alarm) {
            userBase.uiSet(String.valueOf(UIPREFIX) + "partition.alarm.mem.label.1", "visible", "true");
        } else {
            userBase.uiSet(String.valueOf(UIPREFIX) + "partition.alarm.mem.label.1", "visible", "false");
        }
        String partVals = "";
        String partLabs = "";
        int i4 = 1;
        while (i4 <= this.maxPartitions) {
            partVals = String.valueOf(partVals) + "," + i4;
            String armed = userBase.ioGet(String.valueOf(this.name) + ".p" + i4 + ".armed");
            partLabs = armed != null && armed.equals("1") ? String.valueOf(partLabs) + ",<img src=\"/blue/pic/inim/inim-lock.png\" width=\"25\" height=\"25\"> Partition " + i4 : String.valueOf(partLabs) + ",<img src=\"/blue/pic/inim/inim-unlock-tr.png\" width=\"25\" height=\"25\"> Partition " + i4;
            ++i4;
        }
        userBase.uiSet(String.valueOf(UIPREFIX) + "partitions.list", "values", partVals.substring(1));
        userBase.uiSet(String.valueOf(UIPREFIX) + "partitions.list", "labels", partLabs.substring(1));
    }

    private void updateZoneUIStatuses(String session) {
        String num = userBase.uiGet(session, String.valueOf(UIPREFIX) + "zone.internal");
        if (num == null) {
            return;
        }
        String alarm = userBase.ioGet(String.valueOf(this.name) + ".z" + num + ".alarm");
        if (alarm != null && alarm.equals("1")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.alarm.label", "visible", "true");
        } else {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.alarm.label", "visible", "false");
        }
        String tamper = userBase.ioGet(String.valueOf(this.name) + ".z" + num + ".tamper");
        if (tamper != null && tamper.equals("1")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.tamper.label", "visible", "true");
        } else {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.tamper.label", "visible", "false");
        }
        String bypass = userBase.ioGet(String.valueOf(this.name) + ".z" + num + ".bypass");
        if (bypass != null && bypass.equals("1")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.bypassed.label", "visible", "true");
        } else {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.bypassed.label", "visible", "false");
        }
        String error = userBase.ioGet(String.valueOf(this.name) + ".z" + num + ".error");
        if (error != null && error.equals("1")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.error.label", "visible", "true");
        } else {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.error.label", "visible", "false");
        }
    }

    private class JSONKsenia
    extends JSONObject {
        private JSONKsenia() {
        }

        @Override
        public JSONObject put(String key, Object value) throws JSONException {
            try {
                Field map = JSONObject.class.getDeclaredField("map");
                map.setAccessible(true);
                Object mapValue = map.get(this);
                if (!(mapValue instanceof LinkedHashMap)) {
                    map.set(this, new LinkedHashMap());
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            return super.put(key, value);
        }
    }
}

