/*
 * Decompiled with CFR 0.152.
 */
package drivers.ionopi;

import cc.sferalabs.libs.iono_pi.DigitalInputListener;
import cc.sferalabs.libs.iono_pi.IonoPi;
import cc.sferalabs.libs.iono_pi.onewire.OneWireBusDevice;
import cc.sferalabs.libs.iono_pi.wiegand.WiegandListener;
import drivers.ionopi.Driver;
import drivers.ionopi.IonoPiWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class LocalIonoPiWrapper
extends IonoPiWrapper {
    private static final long ONE_WIRE_READ_INTERVAL = 2000L;
    private static final long INPUTS_OUTPUTS_READ_INTERVAL = 300000L;
    private static final long DIGITAL_INPUTS_FAST_POLLING_PERIOD = 3000L;
    private final DigitalInputListener digitalInputslistener = new DigitalInputListener(){

        @Override
        public void onChange(IonoPi.DigitalInput di, boolean high) {
            LocalIonoPiWrapper.this.digitalInterruptsTs.put(di, System.currentTimeMillis());
            LocalIonoPiWrapper.this.digitalInterruptsQueue.offer(di);
        }
    };
    private final WiegandListener wiegandListener = new WiegandListener(){

        @Override
        public boolean onData(IonoPi.Wiegand wi, int count, long data) {
            String val = Long.toHexString(data);
            if (LocalIonoPiWrapper.this.wiegandBits) {
                val = String.valueOf(count) + "/" + val;
            }
            LocalIonoPiWrapper.this.driver.doIoWrite(true, "wiegand." + (wi.ordinal() + 1), val);
            return true;
        }
    };
    private final ConcurrentHashMap<IonoPi.DigitalInput, Long> digitalInterruptsTs = new ConcurrentHashMap();
    private final ArrayBlockingQueue<Object> digitalInterruptsQueue = new ArrayBlockingQueue(1);
    private boolean digitalInputs = true;
    private boolean oneWireBus;
    private boolean oneWireMax = false;
    private List<IonoPi.DigitalIO> oneWireMaxPins;
    private long readInterval = 2000L;
    private float analogMinVariation = 0.1f;
    private long lastAnalogRead;
    private long lastInputsOutputsRead;
    private long lastOneWireRead;
    private final Map<IonoPi.AnalogInput, Float> lastAnalogValues = new HashMap<IonoPi.AnalogInput, Float>();
    private boolean ok = true;

    @Override
    void init(Driver driver, String name, HashMap<String, String> config) throws Exception {
        super.init(driver, name, config);
        IonoPi.init();
        try {
            this.readInterval = Long.parseLong(config.get("readinterval"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.analogMinVariation = Float.parseFloat(config.get("analogminvariation")) / 1000.0f;
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean w1 = Boolean.parseBoolean(config.get("wiegand1"));
        boolean w2 = Boolean.parseBoolean(config.get("wiegand2"));
        try {
            IonoPi.OneWire.getBusDevices();
            this.oneWireBus = true;
        }
        catch (Exception e2) {
            this.oneWireBus = false;
        }
        String owb = config.get("onewirebus");
        if (owb != null && !owb.isEmpty()) {
            if (owb.equalsIgnoreCase("true")) {
                this.oneWireBus = true;
            } else if (owb.equalsIgnoreCase("false")) {
                this.oneWireBus = false;
            }
        }
        this.oneWireMax = false;
        if (w1) {
            if (this.oneWireBus) {
                throw new Exception("Cannot use Wiegand 1 while 1-Wire bus is enabled");
            }
            if (this.oneWireMax && (this.oneWireMaxPins.contains((Object)IonoPi.DigitalIO.TTL1) || this.oneWireMaxPins.contains((Object)IonoPi.DigitalIO.TTL2))) {
                throw new Exception("Cannot use both Wiegand and 1-Wire max on TTL1 and TTL2");
            }
        }
        if (w2 && this.oneWireMax && (this.oneWireMaxPins.contains((Object)IonoPi.DigitalIO.TTL3) || this.oneWireMaxPins.contains((Object)IonoPi.DigitalIO.TTL4))) {
            throw new Exception("Cannot use both Wiegand and 1-Wire max on TTL3 and TTL4");
        }
        if (this.oneWireBus && this.oneWireMax && this.oneWireMaxPins.contains((Object)IonoPi.DigitalIO.TTL1)) {
            throw new Exception("Cannot use both 1-Wire bus and 1-Wire max on TTL1");
        }
        String dis = config.get("digitalinputs");
        if ("false".equalsIgnoreCase(dis)) {
            this.digitalInputs = false;
        }
        if (this.digitalInputs) {
            int debounce;
            try {
                debounce = Integer.parseInt(config.get("digitaldebounce"));
            }
            catch (Exception e3) {
                debounce = 30;
            }
            IonoPi.DigitalInput[] digitalInputArray = IonoPi.DigitalInput.values();
            int n2 = digitalInputArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IonoPi.DigitalInput di = digitalInputArray[n3];
                di.setDebounce(debounce);
                di.setListener(this.digitalInputslistener);
                ++n3;
            }
        }
        if (w1) {
            new WiegandMonitor(IonoPi.Wiegand.W1).start();
        }
        if (w2) {
            new WiegandMonitor(IonoPi.Wiegand.W2).start();
        }
    }

    private static float toVoltage(IonoPi.AnalogInput input, int value) {
        float factor = input == IonoPi.AnalogInput.AI1 || input == IonoPi.AnalogInput.AI2 ? 0.007319f : 7.25E-4f;
        return (float)value * factor;
    }

    @Override
    boolean loop() throws Exception {
        long wait;
        int n2;
        Object object;
        long now = System.currentTimeMillis();
        if (this.readInterval > 0L && now > this.lastAnalogRead + this.readInterval) {
            object = IonoPi.AnalogInput.values();
            int n3 = ((IonoPi.AnalogInput[])object).length;
            n2 = 0;
            while (n2 < n3) {
                Enum ai = object[n2];
                float voltVal = LocalIonoPiWrapper.toVoltage((IonoPi.AnalogInput)ai, ((IonoPi.AnalogInput)ai).read());
                Float lastVal = this.lastAnalogValues.get(ai);
                boolean changed = false;
                if (lastVal == null) {
                    changed = true;
                } else if (this.analogMinVariation == 0.0f) {
                    changed = lastVal.floatValue() != voltVal;
                } else {
                    boolean bl = changed = Math.abs(lastVal.floatValue() - voltVal) >= this.analogMinVariation;
                }
                if (changed) {
                    this.driver.doIoWrite(false, ai.toString().toLowerCase(), "" + voltVal);
                    this.lastAnalogValues.put((IonoPi.AnalogInput)ai, Float.valueOf(voltVal));
                }
                ++n2;
            }
            this.lastAnalogRead = now;
        }
        if (now > this.lastInputsOutputsRead + 300000L) {
            object = IonoPi.Output.values();
            int n3 = ((IonoPi.Output[])object).length;
            n2 = 0;
            while (n2 < n3) {
                Enum o2 = object[n2];
                this.driver.doIoWrite(false, o2.toString().toLowerCase(), ((IonoPi.Output)o2).isClosed() ? "1" : "0");
                ++n2;
            }
            if (this.digitalInputs) {
                object = IonoPi.DigitalInput.values();
                int n4 = ((IonoPi.DigitalInput[])object).length;
                n2 = 0;
                while (n2 < n4) {
                    Object di = object[n2];
                    this.driver.doIoWrite(false, ((Enum)di).toString().toLowerCase(), ((IonoPi.DigitalInput)((Object)di)).isHigh() ? "1" : "0");
                    ++n2;
                }
            }
            this.driver.doIoWrite(false, "led", IonoPi.LED.isOn() ? "1" : "0");
            this.lastInputsOutputsRead = now;
        }
        if ((this.oneWireBus || this.oneWireMax) && now > this.lastOneWireRead + 2000L) {
            new Thread("IonoPi1WireMonitor-"){

                @Override
                public void run() {
                    if (LocalIonoPiWrapper.this.oneWireBus) {
                        try {
                            for (OneWireBusDevice d2 : IonoPi.OneWire.getBusDevices()) {
                                LocalIonoPiWrapper.this.driver.doIoWrite(false, "onewire.bus.d" + d2.getId().replace('-', '_'), "" + (double)d2.readTemperature(3) / 1000.0);
                            }
                        }
                        catch (Exception d2) {
                            // empty catch block
                        }
                    }
                    if (LocalIonoPiWrapper.this.oneWireMax) {
                        for (IonoPi.DigitalIO dio : LocalIonoPiWrapper.this.oneWireMaxPins) {
                            try {
                                int[] t_rh = IonoPi.OneWire.maxDetectRead(dio, 7);
                                if (t_rh == null) continue;
                                LocalIonoPiWrapper.this.driver.doIoWrite(false, "onewire.max." + dio.toString().toLowerCase() + ".temp", "" + (double)t_rh[0] / 10.0);
                                LocalIonoPiWrapper.this.driver.doIoWrite(false, "onewire.max." + dio.toString().toLowerCase() + ".rh", "" + (double)t_rh[1] / 10.0);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }.start();
            this.lastOneWireRead = now;
        }
        long l2 = wait = this.readInterval > 0L ? this.readInterval : 2000L;
        if (this.digitalInterruptsQueue.poll(wait, TimeUnit.MILLISECONDS) != null) {
            for (Map.Entry entry : this.digitalInterruptsTs.entrySet()) {
                long ts = (Long)entry.getValue();
                if (now >= ts + 3000L) continue;
                IonoPi.DigitalInput di = (IonoPi.DigitalInput)((Object)entry.getKey());
                this.driver.doIoWrite(false, di.toString().toLowerCase(), di.isHigh() ? "1" : "0");
                this.digitalInterruptsQueue.offer((Object)di);
            }
            Thread.sleep(1L);
        }
        return this.ok;
    }

    @Override
    void end() {
        IonoPi.shutdown();
    }

    @Override
    void command(String name, String value) throws Exception {
        boolean val;
        if (value.equals("1") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on")) {
            val = true;
        } else if (value.equals("0") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off")) {
            val = false;
        } else {
            throw new Exception("illegal value");
        }
        if (name.equalsIgnoreCase("led")) {
            IonoPi.LED.set(val);
            this.driver.doIoWrite(false, "led", val ? "1" : "0");
        } else if (name.equalsIgnoreCase("o1")) {
            IonoPi.Output.O1.set(val);
            this.driver.doIoWrite(false, IonoPi.Output.O1.toString().toLowerCase(), val ? "1" : "0");
        } else if (name.equalsIgnoreCase("o2")) {
            IonoPi.Output.O2.set(val);
            this.driver.doIoWrite(false, IonoPi.Output.O2.toString().toLowerCase(), val ? "1" : "0");
        } else if (name.equalsIgnoreCase("o3")) {
            IonoPi.Output.O3.set(val);
            this.driver.doIoWrite(false, IonoPi.Output.O3.toString().toLowerCase(), val ? "1" : "0");
        } else if (name.equalsIgnoreCase("o4")) {
            IonoPi.Output.O4.set(val);
            this.driver.doIoWrite(false, IonoPi.Output.O4.toString().toLowerCase(), val ? "1" : "0");
        } else if (name.equalsIgnoreCase("oc1")) {
            IonoPi.Output.OC1.set(val);
            this.driver.doIoWrite(false, IonoPi.Output.OC1.toString().toLowerCase(), val ? "1" : "0");
        } else if (name.equalsIgnoreCase("oc2")) {
            IonoPi.Output.OC2.set(val);
            this.driver.doIoWrite(false, IonoPi.Output.OC2.toString().toLowerCase(), val ? "1" : "0");
        } else if (name.equalsIgnoreCase("oc3")) {
            IonoPi.Output.OC3.set(val);
            this.driver.doIoWrite(false, IonoPi.Output.OC3.toString().toLowerCase(), val ? "1" : "0");
        } else {
            throw new Exception("command format error");
        }
    }

    private class WiegandMonitor
    extends Thread {
        private final IonoPi.Wiegand wi;

        WiegandMonitor(IonoPi.Wiegand wi) {
            this.wi = wi;
        }

        @Override
        public void run() {
            try {
                this.wi.monitor(LocalIonoPiWrapper.this.wiegandListener);
            }
            catch (Exception e2) {
                LocalIonoPiWrapper.this.ok = false;
            }
        }
    }
}

