/*
 * Decompiled with CFR 0.152.
 */
package drivers.ionopi;

import com.hsyco.driverBase;
import drivers.ionopi.IonoPiWrapper;
import drivers.ionopi.LocalIonoPiWrapper;
import drivers.ionopi.RemoteIonoPiWrapper;
import java.util.HashMap;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 80;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    public static final String[] WEBOBJECTS = new String[]{"button", "buttonicon", "buttonimage"};
    private String serverName = null;
    private boolean events = false;
    private IonoPiWrapper ionoPi;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.serverName = name;
        try {
            String host = config.get("host");
            if (host == null || host.isEmpty() || host.equals("127.0.0.1") || host.equals("localhost")) {
                this.ionoPi = new LocalIonoPiWrapper();
                this.messageLog(String.valueOf(this.serverName) + ": local driver started");
            } else {
                this.ionoPi = new RemoteIonoPiWrapper();
                this.messageLog(String.valueOf(this.serverName) + ": remote driver started");
            }
            try {
                this.events = Boolean.parseBoolean(config.get("startupevents"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ionoPi.init(this, name, config);
            this.enableSystemtopoDiscovery();
            if (!this.loop()) {
                throw new Exception("first loop failed");
            }
            this.events = true;
            this.ioWrite("connection", "online");
            return true;
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.serverName) + ": Initialization failed - " + e2.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    public boolean loop() {
        try {
            return this.ionoPi.loop();
        }
        catch (Exception e2) {
            this.sleep(1000L);
            if (this.isVerboseLog()) {
                this.errorLog(String.valueOf(this.serverName) + ": Loop exception - " + e2.getLocalizedMessage());
            }
            return false;
        }
    }

    public boolean end() {
        this.ionoPi.end();
        this.ioWrite("connection", "offline");
        return true;
    }

    public void command(String name, String value) {
        try {
            this.ionoPi.command(name, value);
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.serverName) + ": Error executing command " + name + "=" + value + ": " + e2.getLocalizedMessage());
        }
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        int sep = id.lastIndexOf(46);
        String cmd = id.substring(0, sep);
        String value = id.substring(sep + 1);
        this.command(cmd, value);
        return "";
    }

    protected void doIoWrite(boolean forced, String dp, String val) {
        if (this.events) {
            if (forced) {
                this.ioWriteForced(dp, val);
            } else {
                this.ioWrite(dp, val);
            }
        } else {
            this.ioWriteNoEvents(dp, val);
        }
        if (dp.startsWith("o") || dp.equals("led")) {
            this.deviceSet(1, dp, val, "Iono Pi - " + dp);
        }
    }
}

