/*
 * Decompiled with CFR 0.152.
 */
package drivers.iono;

import com.hsyco.driverBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final String[] WEBOBJECTS = new String[]{"button", "buttonicon", "buttonimage"};
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private int SUBSCRIBE_INTERVAL = 40000;
    private String name;
    private String getStateUrl;
    private String setCommandUrl;
    private boolean genEvent = true;
    private int pollInterval = 0;
    private int[] inputMode = new int[4];
    private float minVariation = 0.1f;
    private double[] lastVals = new double[]{-1.0, -1.0, -1.0, -1.0};
    private ServerSocket serverSocket;
    private long lastSubscribe;
    private Object lock = new Object();

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            String ip = config.get("host");
            if (ip == null) {
                throw new Exception("ip not specified");
            }
            try {
                int port = Integer.parseInt(config.get("port"));
                if (port > 0) {
                    ip = String.valueOf(ip) + ":" + port;
                }
            }
            catch (Exception port) {
                // empty catch block
            }
            try {
                this.pollInterval = Integer.parseInt(config.get("pollinterval")) * 1000;
            }
            catch (Exception port) {
                // empty catch block
            }
            String mode1 = config.get("input1");
            if (mode1 != null && mode1.startsWith("current")) {
                mode1 = "i";
                this.inputMode[0] = 3;
            } else if (mode1 != null && mode1.startsWith("voltage")) {
                mode1 = "v";
                this.inputMode[0] = 2;
            } else {
                mode1 = "d";
                this.inputMode[0] = 1;
            }
            String mode2 = config.get("input2");
            if (mode2 != null && mode2.startsWith("current")) {
                mode2 = "i";
                this.inputMode[1] = 3;
            } else if (mode2 != null && mode2.startsWith("voltage")) {
                mode2 = "v";
                this.inputMode[1] = 2;
            } else {
                mode2 = "d";
                this.inputMode[1] = 1;
            }
            String mode3 = config.get("input3");
            if (mode3 != null && mode3.startsWith("current")) {
                mode3 = "i";
                this.inputMode[2] = 3;
            } else if (mode3 != null && mode3.startsWith("voltage")) {
                mode3 = "v";
                this.inputMode[2] = 2;
            } else {
                mode3 = "d";
                this.inputMode[2] = 1;
            }
            String mode4 = config.get("input4");
            if (mode4 != null && mode4.equalsIgnoreCase("current")) {
                mode4 = "i";
                this.inputMode[3] = 3;
            } else if (mode4 != null && mode4.startsWith("voltage")) {
                mode4 = "v";
                this.inputMode[3] = 2;
            } else {
                mode4 = "d";
                this.inputMode[3] = 1;
            }
            try {
                this.minVariation = Float.parseFloat(config.get("minvariation"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.enableSystemtopoDiscovery();
            if (this.pollInterval <= 0) {
                this.subscribe(ip, config, mode1, mode2, mode3, mode4);
            } else {
                this.getStateUrl = "http://" + ip + "/api/state";
            }
            this.setCommandUrl = "http://" + ip + "/api/set?";
            String startupevents = config.get("startupevents");
            boolean bl = this.genEvent = startupevents == null || !startupevents.equalsIgnoreCase("false");
            if (!this.getState()) {
                throw new Exception("state request failed");
            }
            this.genEvent = true;
            this.ioWrite(true, "connection", "online");
            return true;
        }
        catch (Exception e2) {
            this.errorLog("Initialization failed - " + e2.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    private void subscribe(String ip, HashMap<String, String> config, String mode1, String mode2, String mode3, String mode4) throws Exception {
        int stableTime;
        try {
            stableTime = Integer.parseInt(config.get("stabletime"));
        }
        catch (Exception e2) {
            stableTime = 100;
        }
        String host = config.get("subscribehost");
        if (host == null) {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                for (InterfaceAddress ni : nis.nextElement().getInterfaceAddresses()) {
                    if (!ni.getAddress().isSiteLocalAddress()) continue;
                    host = ni.getAddress().getHostAddress();
                }
            }
            if (host == null) {
                this.messageLog("Warning: no valid localhost found. Using polling");
                this.pollInterval = 2;
                return;
            }
        }
        this.serverSocket = new ServerSocket(0);
        this.serverSocket.setSoTimeout(15000);
        int localport = this.serverSocket.getLocalPort();
        this.getStateUrl = "http://" + ip + "/api/subscribe?st=" + stableTime + "&mv=" + this.minVariation + "&host=" + host + "&port=" + localport + "&cmd=/iono&mode1=" + mode1 + "&mode2=" + mode2 + "&mode3=" + mode3 + "&mode4=" + mode4;
        this.messageLog("Subscribing " + host + ":" + localport);
    }

    public boolean loop() {
        try {
            if (this.pollInterval > 0) {
                return this.poll();
            }
            return this.acceptHTTPRequest();
        }
        catch (Throwable e2) {
            this.errorLog("Exception in loop: " + e2.getLocalizedMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean poll() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait(this.pollInterval);
        }
        return this.getState();
    }

    private boolean acceptHTTPRequest() throws IOException {
        boolean ok;
        block23: {
            ok = true;
            Socket clientSocket = null;
            BufferedReader in = null;
            try {
                try {
                    clientSocket = this.serverSocket.accept();
                    clientSocket.setSoTimeout(5000);
                    in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), UTF8));
                    String line = in.readLine();
                    if (line != null) {
                        String event = line.substring(10, line.indexOf(72) - 1);
                        String[] pin_val = event.split("=");
                        String pin = pin_val[0].toLowerCase();
                        String val = pin_val[1];
                        this.ioWrite(pin, val);
                        if (pin.startsWith("do")) {
                            this.deviceSet(1, pin, val, "iono - " + pin);
                        }
                    } else {
                        ok = false;
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        clientSocket.close();
                    }
                    catch (Exception exception) {}
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    clientSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                clientSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (System.currentTimeMillis() > this.lastSubscribe + (long)this.SUBSCRIBE_INTERVAL) {
            if (this.getState()) {
                this.lastSubscribe = System.currentTimeMillis();
            } else {
                ok = false;
            }
        }
        return ok;
    }

    private boolean getState() {
        String resp = Driver.urlGet(this.getStateUrl, null, null);
        if (resp == null) {
            return false;
        }
        int sepIdx = resp.indexOf(58);
        String code = resp.substring(0, sepIdx);
        if (!code.equals("200")) {
            return false;
        }
        String body = resp.substring(sepIdx + 1);
        try {
            JSONObject input;
            JSONObject state = new JSONObject(body);
            int i2 = 1;
            while (i2 <= 6) {
                String pin = "do" + i2;
                String val = "" + state.getInt("DO" + i2);
                this.ioWrite(pin, val);
                this.deviceSet(1, pin, val, "iono - " + pin);
                ++i2;
            }
            i2 = 1;
            while (i2 <= 4) {
                input = state.getJSONObject("I" + i2);
                int im = this.inputMode[i2 - 1];
                if (im == 1) {
                    this.ioWrite("di" + i2, "" + input.getInt("D"));
                } else {
                    String dp;
                    double val;
                    if (im == 2) {
                        val = input.getDouble("V");
                        dp = "av" + i2;
                    } else {
                        val = input.getDouble("I");
                        dp = "ai" + i2;
                    }
                    double lastVal = this.lastVals[i2 - 1];
                    if (lastVal < 0.0 || this.minVariation <= 0.0f || Math.abs(val - lastVal) >= (double)this.minVariation) {
                        this.lastVals[i2 - 1] = val;
                        this.ioWrite(dp, "" + val);
                    }
                }
                ++i2;
            }
            i2 = 5;
            while (i2 <= 6) {
                input = state.getJSONObject("I" + i2);
                this.ioWrite("di" + i2, "" + input.getInt("D"));
                ++i2;
            }
        }
        catch (JSONException e2) {
            return false;
        }
        return true;
    }

    public boolean end() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.ioWrite(true, "connection", "offline");
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        int sep = id.lastIndexOf(46);
        String cmd = id.substring(0, sep);
        String value = id.substring(sep + 1);
        this.command(cmd, value);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String name, String value) {
        try {
            String cmd = String.valueOf(name.toUpperCase()) + "=" + value;
            this.messageLog("Command: " + cmd);
            String resp = Driver.urlGet(String.valueOf(this.setCommandUrl) + cmd, null, null);
            if (resp == null) {
                throw new Exception("no response");
            }
            int sepIdx = resp.indexOf(58);
            String code = resp.substring(0, sepIdx);
            if (!code.equals("200")) {
                throw new Exception("response code error: " + code);
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        catch (Exception e2) {
            this.errorLog("Error executing command: " + e2.getLocalizedMessage());
        }
    }

    @Override
    public void ioWrite(String name, String value) {
        this.ioWrite(this.genEvent, name, value);
    }

    public void ioWrite(boolean event, String name, String value) {
        if (event) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
    }

    @Override
    public void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    public void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }
}

