/*
 * Decompiled with CFR 0.152.
 */
package drivers.hue;

import com.hsyco.Configuration;
import com.hsyco.user;
import com.hsyco.userBase;
import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.PHHueSDK;
import com.philips.lighting.hue.sdk.PHMessageType;
import com.philips.lighting.hue.sdk.PHSDKListener;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHHueParsingError;
import drivers.hue.Driver;
import java.util.HashMap;
import java.util.List;

public class BridgeListener
implements PHSDKListener {
    static final BridgeListener INSTANCE = new BridgeListener();
    private static final HashMap<String, Driver> registered = new HashMap();

    public synchronized void register(Driver driver, String macAddress) {
        if (macAddress != null) {
            registered.put(macAddress.toLowerCase(), driver);
        } else {
            registered.put(null, driver);
        }
    }

    public synchronized void unregister(PHBridge bridge) {
        registered.remove(bridge.getResourceCache().getBridgeConfiguration().getMacAddress().toLowerCase());
    }

    @Override
    public synchronized void onAccessPointsFound(List<PHAccessPoint> accessPoints) {
        for (PHAccessPoint accessPoint : accessPoints) {
            PHHueSDK phHueSDK;
            String mac = accessPoint.getMacAddress().toLowerCase();
            Driver driver = registered.get(mac);
            if (driver == null && (driver = registered.get(null)) != null) {
                registered.put(mac, driver);
            }
            if (driver == null || driver.getBridge() != null) continue;
            String username = userBase.varGet("__HSYCO__HUE_username_" + driver.getName() + "!");
            if (username != null && !username.isEmpty()) {
                accessPoint.setUsername(username);
            }
            if ((phHueSDK = driver.getPhHueSDK()).isAccessPointConnected(accessPoint)) continue;
            driver.messageLog("Connecting to AP '" + accessPoint.getMacAddress() + "'...");
            try {
                phHueSDK.connect(accessPoint);
            }
            catch (Exception e2) {
                driver.errorLog("Connection error: " + e2.getLocalizedMessage());
            }
        }
    }

    @Override
    public void onAuthenticationRequired(PHAccessPoint accessPoint) {
        Driver driver = registered.get(accessPoint.getMacAddress().toLowerCase());
        if (driver != null) {
            if (Configuration.verboseLog) {
                driver.messageLog("Authentication Required on AP - MAC: " + accessPoint.getMacAddress() + ", IP: " + accessPoint.getIpAddress() + ", User: " + accessPoint.getUsername());
            }
            driver.getPhHueSDK().startPushlinkAuthentication(accessPoint);
            driver.ioWrite(true, "authentication", "1");
        }
    }

    @Override
    public void onBridgeConnected(PHBridge bridge, String username) {
        Driver driver = registered.get(bridge.getResourceCache().getBridgeConfiguration().getMacAddress().toLowerCase());
        if (driver != null) {
            driver.setBridge(bridge);
            userBase.varSet("__HSYCO__HUE_username_" + driver.getName() + "!", username);
        }
    }

    @Override
    public void onCacheUpdated(List<Integer> cacheNotificationsList, PHBridge bridge) {
        Driver driver = registered.get(bridge.getResourceCache().getBridgeConfiguration().getMacAddress().toLowerCase());
        if (driver != null) {
            if (Configuration.verboseLog) {
                driver.messageLog("Cache Update");
            }
            if (cacheNotificationsList.contains(PHMessageType.LIGHTS_CACHE_UPDATED)) {
                driver.updateLigthsState();
            }
        }
    }

    @Override
    public void onConnectionResumed(PHBridge bridge) {
        Driver driver = registered.get(bridge.getResourceCache().getBridgeConfiguration().getMacAddress().toLowerCase());
        if (driver != null) {
            driver.setBridge(bridge);
            driver.quit = false;
        }
    }

    @Override
    public void onConnectionLost(PHAccessPoint accessPoint) {
        Driver driver = registered.get(accessPoint.getMacAddress().toLowerCase());
        if (driver != null) {
            driver.errorLog("Connection lost");
            driver.quit = true;
        }
    }

    @Override
    public void onError(int code, String message) {
        if (Configuration.verboseLog) {
            user.errorLog("Hue driver Warning - Listner error: " + code + " - " + message);
        }
    }

    @Override
    public void onParsingErrors(List<PHHueParsingError> parsingErrorsList) {
        if (Configuration.verboseLog) {
            user.messageLog("Hue driver Warning - Parsing Errors");
        }
    }
}

