/*
 * Decompiled with CFR 0.152.
 */
package drivers.googlecal;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.EventDateTime;
import com.google.api.services.calendar.model.Events;
import com.hsyco.Configuration;
import com.hsyco.driverBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private static final String APPLICATION_NAME = "HSYCO - Google Calendar driver";
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/calendar");
    private static final String DATA_DIR = "google-calendar/";
    private String name;
    private com.google.api.services.calendar.Calendar cal;
    private List<String> calendars;
    private long pollInterval = 10000L;
    private boolean preEvents = false;
    private boolean jsonEvents = false;
    private long pre = 1000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean init(String name, HashMap<String, String> config) {
        GoogleClientSecrets clientSecrets;
        super.init(name);
        this.name = name;
        try {
            InputStream in = this.getClass().getResourceAsStream("/google-calendar/client_secret.json");
            if (in == null) {
                this.errorLog("File 'google-calendar/client_secret.json' missing");
                return false;
            }
            clientSecrets = GoogleClientSecrets.load(JSON_FACTORY, new InputStreamReader(in));
        }
        catch (Exception e2) {
            this.errorLog("Error loading file 'google-calendar/client_secret.json': " + e2);
            return false;
        }
        String cals = config.get("calendars");
        if (cals == null || cals.isEmpty()) {
            cals = "primary";
        }
        this.calendars = Arrays.asList(cals.split(";"));
        try {
            this.pollInterval = Integer.parseInt(config.get("pollinterval")) * 1000;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String pr = config.get("pre");
        if (pr != null) {
            try {
                this.pre = (long)Integer.parseInt(pr) * 60000L;
                this.preEvents = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.jsonEvents = Boolean.parseBoolean(config.get("jsonevents"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            FileDataStoreFactory dataStoreFactory = new FileDataStoreFactory(new File(DATA_DIR + name + "/"));
            GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(httpTransport, JSON_FACTORY, clientSecrets, SCOPES).setDataStoreFactory(dataStoreFactory).setAccessType("offline").build();
            Credential credential = flow.loadCredential("user");
            if (credential == null || credential.getRefreshToken() == null && credential.getExpiresInSeconds() <= 60L) {
                String code = config.get("code");
                if (code == null || code.isEmpty()) {
                    GoogleAuthorizationCodeRequestUrl authorizationUrl = flow.newAuthorizationUrl().setRedirectUri("urn:ietf:wg:oauth:2.0:oob");
                    this.messageLog("Go to '" + authorizationUrl.toString() + "', grant access and copy the obtained code " + "in the 'code' parameter of the driver options");
                    this.ioWrite("auth", authorizationUrl.toString());
                    return false;
                }
                GoogleTokenResponse response = flow.newTokenRequest(code).setRedirectUri("urn:ietf:wg:oauth:2.0:oob").execute();
                credential = flow.createAndStoreCredential(response, "user");
            }
            this.cal = new Calendar.Builder(httpTransport, JSON_FACTORY, credential).setApplicationName(APPLICATION_NAME).build();
        }
        catch (Exception e3) {
            this.errorLog("Authorization error: " + e3);
            return false;
        }
        try {
            this.poll();
        }
        catch (Exception e4) {
            this.errorLog("Polling error: " + e4);
            return false;
        }
        this.ioWrite("connection", "online");
        return true;
    }

    public boolean loop() {
        try {
            this.poll();
            return true;
        }
        catch (Exception e2) {
            this.errorLog("Error in loop: " + e2);
            return false;
        }
        finally {
            this.sleep(this.pollInterval);
        }
    }

    private void poll() throws IOException {
        long ts = System.currentTimeMillis();
        DateTime startMax = new DateTime(ts + this.pre);
        DateTime endMin = new DateTime(ts);
        for (String calendarId : this.calendars) {
            Events events2 = (Events)this.cal.events().list(calendarId).setTimeMax(startMax).setTimeMin(endMin).setSingleEvents(true).execute();
            String calendarName = events2.getSummary().toLowerCase().replace(' ', '-');
            List<Event> items = events2.getItems();
            StringBuilder summaries = new StringBuilder();
            StringBuilder summariesPre = new StringBuilder();
            JSONArray summariesJson = null;
            JSONArray summariesPreJson = null;
            if (this.jsonEvents) {
                summariesJson = new JSONArray();
                if (this.preEvents) {
                    summariesPreJson = new JSONArray();
                }
            }
            for (Event event : items) {
                String sum = event.getSummary().replace(";", "");
                EventDateTime start = event.getStart();
                if (start == null) continue;
                long startTs = -1L;
                DateTime startDateTime = start.getDateTime();
                if (startDateTime != null) {
                    startTs = startDateTime.getValue();
                } else {
                    DateTime startDate = start.getDate();
                    if (startDate != null) {
                        startTs = startDate.getValue();
                    }
                }
                if (startTs < 0L) continue;
                if (!this.preEvents || startTs <= ts) {
                    if (summaries.length() != 0) {
                        summaries.append(';');
                    }
                    summaries.append(sum);
                    if (!this.jsonEvents) continue;
                    summariesJson.put(event);
                    continue;
                }
                if (summariesPre.length() != 0) {
                    summariesPre.append(';');
                }
                summariesPre.append(sum);
                if (!this.jsonEvents) continue;
                summariesPreJson.put(event);
            }
            this.ioWrite(calendarName, summaries.toString());
            if (this.preEvents) {
                this.ioWrite(String.valueOf(calendarName) + ".pre", summariesPre.toString());
            }
            if (!this.jsonEvents) continue;
            this.ioWrite(String.valueOf(calendarName) + ".json", summariesJson.toString());
            if (!this.preEvents) continue;
            this.ioWrite(String.valueOf(calendarName) + ".pre.json", summariesPreJson.toString());
        }
    }

    public void command(String name, String value) {
        try {
            if (Configuration.verboseLog) {
                this.messageLog("Command: " + name + " = " + value);
            }
            JSONObject o2 = new JSONObject(value);
            this.addEvent(name, o2.getString("title"), o2.getString("start"), o2.getString("end"));
        }
        catch (Exception e2) {
            this.errorLog("Error executing command '" + name + " = " + value + "': " + e2.getLocalizedMessage());
        }
    }

    public static String getCurrentTimezoneOffset() {
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        String offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
        offset = String.valueOf(offsetInMillis >= 0 ? "+" : "-") + offset;
        return offset;
    }

    private void addEvent(String calendarId, String summary, String startString, String endString) throws IOException {
        Event event = new Event();
        event.setSummary(summary);
        if (!startString.contains("+")) {
            startString = String.valueOf(startString) + Driver.getCurrentTimezoneOffset();
        }
        if (!endString.contains("+")) {
            endString = String.valueOf(endString) + Driver.getCurrentTimezoneOffset();
        }
        DateTime startDateTime = new DateTime(startString);
        EventDateTime start = new EventDateTime();
        start.setDateTime(startDateTime);
        event.setStart(start);
        DateTime endDateTime = new DateTime(endString);
        EventDateTime end = new EventDateTime();
        end.setDateTime(endDateTime);
        event.setEnd(end);
        this.cal.events().insert(calendarId, event).execute();
    }

    public boolean end() {
        this.ioWrite("connection", "offline");
        return true;
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }
}

