/*
 * Decompiled with CFR 0.152.
 */
package drivers.fias;

import com.hsyco.driverBase;
import drivers.fias.Record;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONException;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 80;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private static final int STX = 2;
    private static final int ETX = 3;
    private static final String MSG_LD_VN = "1.00";
    private static final String MSG_LD_IF = "MS";
    private static final String MSG_LD_RT = "255";
    private static final String MSG_LD_SUFFIX = "|V#1.00|IFMS|RT255|";
    private String serverName = null;
    private boolean rawMessages = false;
    private String hostname;
    private int port;
    private Socket clientSocket;
    private BufferedWriter clientOut;
    private BufferedReader clientIn;
    private boolean linkStartReceived = false;
    private static final boolean debug = false;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.serverName = name;
        try {
            this.hostname = config.get("host");
            if (this.hostname == null || this.hostname.isEmpty()) {
                throw new Exception("unknown host name");
            }
            try {
                this.port = Integer.parseInt(config.get("port"));
            }
            catch (Exception e2) {
                throw new Exception("port not specified");
            }
            this.rawMessages = Boolean.parseBoolean(config.get("rawmessages"));
            this.connect();
            return true;
        }
        catch (Exception e3) {
            this.errorLog("Initialization failed - " + e3.getMessage());
            this.end();
            return false;
        }
    }

    private void connect() throws IOException {
        this.messageLog("Connecting to " + this.hostname + ":" + this.port);
        try {
            this.clientSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clientSocket = new Socket();
        this.clientSocket.connect(new InetSocketAddress(this.hostname, this.port), 10000);
        this.clientSocket.setSoTimeout(3000);
        this.clientOut = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream(), "ASCII"));
        this.clientIn = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream(), "ASCII"));
        this.linkStartReceived = false;
    }

    public boolean end() {
        try {
            this.clientSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ioWrite("connection", "offline");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loop() {
        try {
            StringBuilder msg = null;
            try {
                while (true) {
                    int c2;
                    if ((c2 = this.clientIn.read()) < 0) {
                        throw new Exception("stream closed");
                    }
                    if (c2 == 2) {
                        msg = new StringBuilder();
                        continue;
                    }
                    if (msg == null) continue;
                    if (c2 == 3) {
                        this.processMsg(msg.toString().trim());
                        return true;
                    }
                    if (c2 < 32) continue;
                    msg.append((char)c2);
                }
            }
            catch (SocketTimeoutException e2) {
                String[] date_time = this.getDateAndTime();
                if (!this.linkStartReceived) {
                    this.write("LS|DA" + date_time[0] + "|TI" + date_time[1] + "|");
                    return true;
                }
                this.clientSocket.setSoTimeout(30000);
                this.write("LA|DA" + date_time[0] + "|TI" + date_time[1] + "|");
                return true;
            }
        }
        catch (Exception e3) {
            this.errorLog("Loop exception - " + e3.getLocalizedMessage());
            this.sleep(1000L);
            try {
                this.connect();
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }

    private void processMsg(String msg) throws IOException, JSONException {
        if (this.isVerboseLog()) {
            this.messageLog("<<< " + msg);
        }
        if (this.rawMessages) {
            this.ioWriteForced("msg", msg);
        }
        Record r = Record.parse(msg);
        if ("LS".equals(r.type)) {
            this.linkStartReceived = true;
            String[] date_time = this.getDateAndTime();
            this.write("LD|DA" + date_time[0] + "|TI" + date_time[1] + MSG_LD_SUFFIX);
            this.write("LR|RIGI|FLRNG#GNGLGVGGGSSF|");
            this.write("LR|RIGC|FLRNG#GNGLGVGGGSRO|");
            this.write("LR|RIGO|FLRNG#GSSF|");
            this.write("LA|DA" + date_time[0] + "|TI" + date_time[1] + "|");
        } else if ("LA".equals(r.type)) {
            this.ioWrite("connection", "online");
        } else if ("GI".equals(r.type) || "GC".equals(r.type)) {
            String evName;
            r.renameField("G#", "reservationNumber").renameField("RN", "room").renameField("GS", "share").renameField("CS", "classOfService").renameField("DA", "date").renameField("G+", "profileNumber").renameField("GA", "arrivalDate").renameField("GD", "departureDate").renameField("GF", "firstName").renameField("GG", "groupNumber").renameField("GL", "language").renameField("GN", "name").renameField("GT", "title").renameField("GV", "vip").renameField("MR", "minibarRights").renameField("TI", "time").renameField("TV", "tvRights").renameField("VR", "videoRights").renameField("WS", "workstationId");
            boolean swap = r.has("SF");
            String string = evName = "GI".equals(r.type) ? "guest.in" : "guest.change";
            if (swap) {
                evName = String.valueOf(evName) + ".dbswap";
            }
            if (r.has("share")) {
                String share = r.getString("share");
                r.put("share", share.equalsIgnoreCase("Y"));
            }
            this.ioWriteForced(evName, r.toString());
        } else if ("GO".equals(r.type)) {
            r.renameField("G#", "reservationNumber").renameField("RN", "room").renameField("GS", "share").renameField("DA", "date").renameField("TI", "time").renameField("WS", "workstationId");
            boolean swap = r.has("SF");
            String evName = "guest.out";
            if (swap) {
                evName = String.valueOf(evName) + ".dbswap";
            }
            if (r.has("share")) {
                String share = r.getString("share");
                r.put("share", share.equalsIgnoreCase("Y"));
            }
            this.ioWriteForced(evName, r.toString());
        } else if ("NS".equals(r.type)) {
            this.ioWrite("nightaudit", "start");
        } else if ("NE".equals(r.type)) {
            this.ioWrite("nightaudit", "end");
        }
    }

    private void write(String msg) throws IOException {
        if (this.isVerboseLog()) {
            this.messageLog(">>> " + msg);
        }
        this.clientOut.write(2);
        this.clientOut.write(msg);
        this.clientOut.write(3);
        this.clientOut.flush();
    }

    private String[] getDateAndTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("YYMMdd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HHmmss");
        Date d2 = new Date();
        return new String[]{dateFormat.format(d2), timeFormat.format(d2)};
    }

    public void command(String name, String value) {
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        int sep = id.lastIndexOf(46);
        String cmd = id.substring(0, sep);
        String value = id.substring(sep + 1);
        this.command(cmd, value);
        return "";
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog("[" + this.serverName + "] " + message);
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog("[" + this.serverName + "] " + message);
    }
}

