/*
 * Decompiled with CFR 0.152.
 */
package drivers.exosensepi;

import ch.ethz.ssh2.Connection;
import com.hsyco.SSHutil;
import com.hsyco.driverBase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private static final int SSH_TIMEOUT_SECONDS = 3;
    private static final long TEMPERATURE_INTERVAL_MILLIS = 1000L;
    private static final File sysfs = new File("/sys/devices/virtual/exosensepi");
    private int sysfsPathnameLength = 0;
    private boolean startupEvents = false;
    private long pollIntervalMillis = 200L;
    private long loopTimestamp = 0L;
    private boolean genEvents = false;
    private String[] dataPointsSkipList = null;
    private ArrayList<File> files = new ArrayList();
    private boolean localMode = true;
    SSHutil ssh;
    Connection connection = null;
    String[] sshReadOnlyFiles = null;
    String[] sshReadWriteFiles = null;
    String[] sshPollingDataPoints = null;
    HashSet<String> sshReadWriteDataPoints = new HashSet();
    HashSet<String> sshWriteOnlyDataPoints = new HashSet();
    String sshPollingCommand = null;
    private int temperatureValue = -1;
    private long temperatureTimestamp = 0L;
    private String name = null;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        String host = config.get("host");
        if (host == null || host.isEmpty() || host.equals("127.0.0.1") || host.equals("localhost")) {
            this.localMode = true;
        } else {
            int port;
            try {
                port = Integer.parseInt(config.get("port"));
                if (port == 0) {
                    port = 22;
                }
            }
            catch (NumberFormatException e2) {
                this.errorLog("Exo Sense Pi Driver - option error [" + name + "] - port");
                return false;
            }
            String user2 = config.get("user");
            if (user2 == null || user2.length() == 0) {
                this.errorLog("Exo Sense Pi Driver - option error [" + name + "] - user");
                return false;
            }
            String password = config.get("password");
            if (password == null || password.length() == 0) {
                this.errorLog("Exo Sense Pi Driver - option error [" + name + "] - password");
                return false;
            }
            this.localMode = false;
            this.ssh = new SSHutil();
            try {
                this.connection = this.ssh.connect(host, port, user2, password);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.connection == null) {
                this.errorLog("Exo Sense Pi Driver - initialization error [" + name + "] - connection failed");
                return false;
            }
        }
        String s = config.get("pollinterval");
        if (s != null) {
            try {
                int i2 = Integer.parseInt(s);
                if (i2 < 10 || i2 > 30000) {
                    throw new Exception();
                }
                this.pollIntervalMillis = i2;
            }
            catch (Exception e3) {
                this.errorLog("Exo Sense Pi Driver - option error [" + name + "] - pollintervalmillis ignored");
            }
        }
        if ((s = config.get("startupevents")) != null) {
            try {
                this.startupEvents = Boolean.parseBoolean(s);
            }
            catch (Exception e4) {
                this.errorLog("Exo Sense Pi Driver - option error [" + name + "] - startupevents ignored");
            }
        }
        this.genEvents = this.startupEvents;
        s = config.get("skip");
        if (s != null) {
            try {
                Vector<String> v = new Vector<String>();
                String[] a2 = s.split("[ ,;]");
                int i3 = 0;
                while (i3 < a2.length) {
                    String dp = a2[i3].trim();
                    if (dp.length() > 0) {
                        v.add(dp);
                    }
                    ++i3;
                }
                this.dataPointsSkipList = v.toArray(new String[v.size()]);
            }
            catch (Exception e5) {
                this.errorLog("Exo Sense Pi Driver - option error [" + name + "] - skip ignored");
            }
        }
        if (this.localMode) {
            if (sysfs.isDirectory()) {
                this.sysfsPathnameLength = sysfs.getAbsolutePath().length();
                boolean b2 = this.scanDirectory(sysfs, 1);
                if (b2) {
                    this.ioWrite("connection", "online");
                }
                return b2;
            }
            return false;
        }
        if (this.initSSH()) {
            this.ioWrite("connection", "online");
            return true;
        }
        this.ssh.disconnect();
        this.errorLog("Exo Sense Pi Driver - initialization error [" + name + "] - connection failed (stage 2)");
        return false;
    }

    public boolean loop() {
        boolean r = false;
        long ts = System.nanoTime() / 1000000L;
        long loopInterval = ts - this.loopTimestamp;
        if (loopInterval < this.pollIntervalMillis) {
            this.sleep(this.pollIntervalMillis - loopInterval);
            this.loopTimestamp += this.pollIntervalMillis;
        } else {
            this.sleep(20L);
            this.loopTimestamp = ts + 20L;
        }
        if (!this.localMode) {
            r = this.pollSSH(this.genEvents);
            if (r && !this.genEvents) {
                this.genEvents = true;
            }
            return r;
        }
        if (this.loopTimestamp - this.temperatureTimestamp > 1000L) {
            this.temperatureTimestamp = this.loopTimestamp;
            this.temperature(this.genEvents);
        }
        int i2 = 0;
        while (i2 < this.files.size()) {
            r |= this.readFile(this.files.get(i2), this.genEvents);
            this.sleep(10L);
            ++i2;
        }
        if (r && !this.genEvents) {
            this.genEvents = true;
        }
        return r;
    }

    public boolean end() {
        if (!this.localMode) {
            this.ssh.disconnect();
        }
        this.ioWrite("connection", "offline");
        return true;
    }

    public void command(String name, String value) {
        try {
            if (!this.localMode) {
                if (this.sshReadWriteDataPoints.contains(name) || this.sshWriteOnlyDataPoints.contains(name)) {
                    this.writeSSH(name, value);
                }
                return;
            }
            this.writeSysFs(name, value);
        }
        catch (Exception e2) {
            this.errorLog("Exo Sense Pi Driver - shutdown command [" + this.name + "] - exception [" + name + " = " + value + "]: " + e2.getLocalizedMessage());
        }
    }

    private boolean scanDirectory(File d2, int depth) {
        String fn = null;
        boolean success = false;
        int sysfslen = sysfs.getPath().length() + 1;
        try {
            File[] fa = d2.listFiles();
            int i2 = 0;
            while (i2 < fa.length) {
                block20: {
                    fn = fa[i2].getName();
                    if (!(Files.isSymbolicLink(fa[i2].toPath()) || fn.startsWith(".") || fn.equals("uevent"))) {
                        if (fa[i2].isDirectory() && depth > 0) {
                            success |= this.scanDirectory(fa[i2], depth - 1);
                        } else if (fa[i2].canRead()) {
                            BufferedReader in = null;
                            try {
                                try {
                                    in = new BufferedReader(new FileReader(fa[i2]));
                                    String value = in.readLine();
                                    if (value != null) {
                                        if (!this.skipDataPoint(fa[i2].getPath().substring(sysfslen).replace('/', '.'))) {
                                            this.files.add(fa[i2]);
                                        }
                                        success = true;
                                    }
                                }
                                catch (Exception exception) {
                                    try {
                                        in.close();
                                    }
                                    catch (Exception exception2) {}
                                    break block20;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    in.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                in.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                ++i2;
            }
            return success;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean writeSysFs(String name, String value) {
        try {
            File f2 = new File(sysfs, name.toLowerCase().replace('.', '/'));
            if (f2.canWrite()) {
                BufferedWriter out = new BufferedWriter(new FileWriter(f2));
                out.write(value);
                out.close();
                this.readFile(f2, true);
                return true;
            }
        }
        catch (Exception e2) {
            this.errorLog("Exo Sense Pi Driver - SysFS command [" + this.name + "] - exception [" + name + " = " + value + "]: " + e2.getLocalizedMessage());
            return false;
        }
        this.errorLog("Exo Sense Pi Driver - SysFS command [" + this.name + "] - error [" + name + " = " + value + "]");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readFile(File f2, boolean events2) {
        try {
            if (!f2.canRead()) return false;
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(f2));
                String value = in.readLine();
                if (value != null) {
                    String dp = f2.getAbsolutePath().substring(this.sysfsPathnameLength + 1).replace('/', '.');
                    if (events2) {
                        this.ioWrite(dp, value);
                        return true;
                    }
                    this.ioWriteNoEvents(dp, value);
                    return true;
                }
                this.errorLog("Exo Sense Pi Driver - kernel module [" + this.name + "] - error reading " + f2.getAbsolutePath());
                return false;
            }
            catch (Exception exception) {
                return false;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean temperature(boolean events2) {
        try {
            FileReader tempfr = new FileReader(new File("/sys/class/thermal/thermal_zone0/temp"));
            BufferedReader tempbr = new BufferedReader(tempfr);
            int value = Math.round(Integer.parseInt(tempbr.readLine()) / 1000);
            tempbr.close();
            tempfr.close();
            if (this.temperatureValue != value) {
                this.temperatureValue = value;
                if (events2) {
                    this.ioWrite("cpu.temperature", Integer.toString(value));
                } else {
                    this.ioWriteNoEvents("cpu.temperature", Integer.toString(value));
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean initSSH() {
        StringBuffer sb = new StringBuffer();
        try {
            String file;
            String[] data = this.ssh.execToStringArray(sysfs.getPath(), "find . -mindepth 2 -maxdepth 2 -perm 220 -name \"*\" -print", 3);
            int i2 = 0;
            while (i2 < data.length) {
                this.sshWriteOnlyDataPoints.add(data[i2].substring(2).replace('/', '.'));
                ++i2;
            }
            data = this.ssh.execToStringArray(sysfs.getPath(), "find . -mindepth 2 -maxdepth 2 -perm 440 -name \"*\" -print -o -perm 640 -name \"*\" -print", 3);
            Vector<String> v = new Vector<String>();
            i2 = 0;
            while (i2 < data.length) {
                file = data[i2].substring(2);
                if (!this.skipDataPoint(file.replace('/', '.'))) {
                    v.add(file);
                }
                ++i2;
            }
            this.sshReadOnlyFiles = v.toArray(new String[v.size()]);
            data = this.ssh.execToStringArray(sysfs.getPath(), "find . -mindepth 2 -maxdepth 2 -perm 660 -name \"*\" -print", 3);
            v = new Vector();
            i2 = 0;
            while (i2 < data.length) {
                file = data[i2].substring(2);
                if (!this.skipDataPoint(file.replace('/', '.'))) {
                    v.add(file);
                }
                ++i2;
            }
            this.sshReadWriteFiles = v.toArray(new String[v.size()]);
            this.sshPollingDataPoints = new String[this.sshReadOnlyFiles.length + this.sshReadWriteFiles.length];
            sb.append("cat");
            i2 = 0;
            while (i2 < this.sshReadOnlyFiles.length) {
                this.sshPollingDataPoints[i2] = this.sshReadOnlyFiles[i2].replace('/', '.');
                sb.append(' ');
                sb.append(this.sshReadOnlyFiles[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.sshReadWriteFiles.length) {
                String dp;
                this.sshPollingDataPoints[this.sshReadOnlyFiles.length + i2] = dp = this.sshReadWriteFiles[i2].replace('/', '.');
                this.sshReadWriteDataPoints.add(dp);
                sb.append(' ');
                sb.append(this.sshReadWriteFiles[i2]);
                ++i2;
            }
            sb.append(" 2>&1");
            this.sshPollingCommand = sb.toString();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean pollSSH(boolean events2) {
        try {
            String[] data = this.ssh.execToStringArray(sysfs.getPath(), this.sshPollingCommand, 3);
            if (data.length == this.sshPollingDataPoints.length) {
                int i2 = 0;
                while (i2 < data.length) {
                    if (!data[i2].startsWith("cat: ")) {
                        if (events2) {
                            this.ioWrite(this.sshPollingDataPoints[i2], data[i2]);
                        } else {
                            this.ioWriteNoEvents(this.sshPollingDataPoints[i2], data[i2]);
                        }
                    }
                    ++i2;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean writeSSH(String name, String value) {
        try {
            String file = name.replace('.', '/');
            String command = "echo \"" + value.replaceAll("\"", "\\\"") + "\" > " + file + "; cat " + file;
            String[] data = this.ssh.execToStringArray(sysfs.getPath(), command, 3);
            if (data.length == 1 && data[0].length() > 0) {
                this.ioWrite(name, data[0]);
            }
            return true;
        }
        catch (Exception exception) {
            this.errorLog("Exo Sense Pi Driver - SSH command [" + this.name + "] - error [" + name + " = " + value + "]");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean skipDataPoint(String name) {
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= this.dataPointsSkipList.length) {
                    return false;
                }
                if (name.startsWith(this.dataPointsSkipList[i2])) {
                    return true;
                }
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

