/*
 * Decompiled with CFR 0.152.
 */
package drivers.detnov;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Scanner;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 502;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private String host = null;
    private int unitid = 1;
    private boolean gui = true;
    private boolean startupevent = true;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private String name = null;
    private int online = -1;
    private static int pollingtime = 3000;
    private Boolean[] loopsActive = new Boolean[8];
    private int loopErrorCounter = 0;
    private int loopErrorThreshold = 5;
    private int loopErrors = 0;
    static String FILE1 = "./detnov.ini";

    public boolean init(String name, HashMap<String, String> config) {
        block17: {
            super.init(name);
            this.name = name;
            try {
                this.host = String.valueOf(config.get("host")) + ":" + config.get("port");
            }
            catch (Exception e2) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            String s = config.get("unitid");
            if (s != null) {
                try {
                    this.unitid = Integer.parseInt(s);
                }
                catch (NumberFormatException e3) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - unitid ignored");
                }
            }
            if ((s = config.get("gui")) != null) {
                try {
                    this.gui = Boolean.parseBoolean(s);
                }
                catch (Exception e4) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - gui ignored");
                }
            }
            if ((s = config.get("startupevents")) != null) {
                try {
                    this.startupevent = Boolean.parseBoolean(s);
                }
                catch (Exception e5) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - startupevents ignored");
                }
            }
            if ((s = config.get("pollingtime")) != null) {
                try {
                    pollingtime = Integer.parseInt(s);
                    if (pollingtime < 3000) {
                        pollingtime = 3000;
                    }
                }
                catch (Exception e6) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - pollingtime ignored");
                }
            }
            Arrays.fill((Object[])this.loopsActive, Boolean.FALSE);
            try {
                this.loadNames();
            }
            catch (FileNotFoundException e7) {
                if (!this.isVerboseLog()) break block17;
                this.messageLog(String.valueOf(name) + ": cannot load detnov.ini file...");
            }
        }
        this.readGeneralPanelInfo();
        this.readLoopStatus();
        return true;
    }

    public boolean loop() {
        this.readGeneralPanelStatus();
        this.readZonesStatus();
        this.readDeviceStatus();
        this.readDeviceAvValue();
        this.readDeviceType();
        if (this.loopErrorCounter == 0) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": end of loop ok ");
            }
            this.loopErrors = 0;
            if (this.online <= 0) {
                this.online = 1;
                this.ioWrite("connection", "online");
                if (this.gui) {
                    this.uiSet("connection", "visible", "false");
                }
                try {
                    this.loadNames();
                }
                catch (FileNotFoundException e2) {
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ": cannot load detnov.ini file...");
                    }
                }
            }
        } else {
            ++this.loopErrors;
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": number of loops with error " + this.loopErrors);
            }
            if (this.loopErrors >= this.loopErrorThreshold) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": too many read errors, quit driver ");
                }
                this.loopErrors = 0;
            }
            return false;
        }
        this.loopErrorCounter = 0;
        this.sleep(pollingtime);
        return true;
    }

    public boolean end() {
        if (this.online != 0) {
            this.online = 0;
            this.ioWrite("connection", "offline");
            if (this.gui) {
                this.uiSet("connection", "visible", "true");
            }
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        byte[] cmd;
        String loopIndex;
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(name) + ": command: " + name + " / value: " + value);
        }
        if (value.equalsIgnoreCase("enable")) {
            loopIndex = name.split("\\.")[0];
            loopIndex = loopIndex.replace("l", "");
            String deviceIndex = name.split("\\.")[1];
            deviceIndex = deviceIndex.replace("d", "");
            int loopIndexInt = Integer.valueOf(loopIndex);
            int deviceIndexInt = Integer.valueOf(deviceIndex);
            int register = 16384 + 256 * (loopIndexInt - 1) + (deviceIndexInt - 1);
            byte[] byArray = new byte[2];
            byArray[1] = 1;
            byte[] cmd2 = byArray;
            userBase.modbusWriteMultipleRegisters(this.host, this.unitid, register, cmd2);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(name) + ": enable command, loop | " + loopIndex + " device | " + deviceIndex + " | register | " + register);
            }
        } else if (value.equalsIgnoreCase("disable")) {
            loopIndex = name.split("\\.")[0];
            loopIndex = loopIndex.replace("l", "");
            String deviceIndex = name.split("\\.")[1];
            deviceIndex = deviceIndex.replace("d", "");
            int loopIndexInt = Integer.valueOf(loopIndex);
            int deviceIndexInt = Integer.valueOf(deviceIndex);
            int register = 16384 + 256 * (loopIndexInt - 1) + (deviceIndexInt - 1);
            byte[] cmd3 = new byte[2];
            userBase.modbusWriteMultipleRegisters(this.host, this.unitid, register, cmd3);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(name) + ": disable command, loop | " + loopIndex + " device | " + deviceIndex + " | register | " + register);
            }
        }
        if (name.equalsIgnoreCase("reset")) {
            byte[] byArray = new byte[2];
            byArray[1] = 1;
            cmd = byArray;
            userBase.modbusWriteMultipleRegisters(this.host, this.unitid, 36, cmd);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(name) + ": reset command");
            }
        } else if (name.equalsIgnoreCase("mute")) {
            byte[] byArray = new byte[2];
            byArray[1] = 2;
            cmd = byArray;
            userBase.modbusWriteMultipleRegisters(this.host, this.unitid, 36, cmd);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(name) + ": mute command");
            }
        } else if (name.equalsIgnoreCase("sounderson")) {
            byte[] byArray = new byte[2];
            byArray[1] = 3;
            cmd = byArray;
            userBase.modbusWriteMultipleRegisters(this.host, this.unitid, 36, cmd);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(name) + ": sounders on command");
            }
        } else if (name.equalsIgnoreCase("soundersoff")) {
            byte[] byArray = new byte[2];
            byArray[1] = 4;
            cmd = byArray;
            userBase.modbusWriteMultipleRegisters(this.host, this.unitid, 36, cmd);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(name) + ": sounders off command");
            }
        }
    }

    private void readGeneralPanelInfo() {
        byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, 0, 5);
        if (response != null) {
            String responseHex = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  global status read: " + responseHex);
            }
            if (responseHex.startsWith("04")) {
                int val = 0;
                val = Driver.hex2decimal(responseHex.substring(7, 8));
                this.ioWrite("info.modbus.status", String.valueOf(val));
                val = Driver.hex2decimal(responseHex.substring(11, 12));
                this.ioWrite("info.panel.type", String.valueOf(val));
                val = Driver.hex2decimal(responseHex.substring(13, 16));
                this.ioWrite("info.panel.version", String.valueOf(val));
                val = Driver.hex2decimal(responseHex.substring(17, 20));
                this.ioWrite("info.panel.network.version", String.valueOf(val));
                val = Driver.hex2decimal(responseHex.substring(21, 24));
                this.ioWrite("info.panel.modbus.version", String.valueOf(val));
            } else if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex);
                if (this.online != 0) {
                    this.online = 0;
                    this.ioWrite("connection", "offline");
                    if (this.gui) {
                        this.uiSet("connection", "visible", "true");
                    }
                }
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
            }
            if (this.online != 0) {
                this.online = 0;
                this.ioWrite("connection", "offline");
                if (this.gui) {
                    this.uiSet("connection", "visible", "true");
                }
            }
        }
    }

    private void readGeneralPanelStatus() {
        byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, 32, 12);
        if (response != null) {
            String responseHex2 = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  general panel status read: " + responseHex2);
            }
            if (responseHex2.startsWith("04")) {
                int relStatus;
                boolean bit7;
                byte myByte = response[3];
                boolean bit0 = (myByte & 1) != 0;
                boolean bit1 = (myByte & 2) != 0;
                boolean bit2 = (myByte & 4) != 0;
                boolean bit3 = (myByte & 8) != 0;
                boolean bit4 = (myByte & 0x10) != 0;
                boolean bit5 = (myByte & 0x20) != 0;
                boolean bit6 = (myByte & 0x40) != 0;
                boolean bl = bit7 = (myByte & 0x80) != 0;
                if (this.startupevent) {
                    this.ioWrite("global.mute", bit0 ? "1" : "0");
                    this.ioWrite("global.sounders", bit1 ? "1" : "0");
                    this.ioWrite("global.sounders.silenced", bit2 ? "1" : "0");
                    this.ioWrite("intest.zone.exists", bit3 ? "1" : "0");
                    this.ioWrite("disabled.zone.exists", bit4 ? "1" : "0");
                    this.ioWrite("output.disabled", bit5 ? "1" : "0");
                    this.ioWrite("sounders.disabled", bit6 ? "1" : "0");
                    this.ioWrite("sounders.delayed", bit7 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("global.mute", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("global.sounders", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("global.sounders.silenced", bit2 ? "1" : "0");
                    this.ioWriteNoEvents("zone.exists", bit3 ? "1" : "0");
                    this.ioWriteNoEvents("disabled.zone.exists", bit4 ? "1" : "0");
                    this.ioWriteNoEvents("output.disabled", bit5 ? "1" : "0");
                    this.ioWriteNoEvents("sounders.disabled", bit6 ? "1" : "0");
                    this.ioWriteNoEvents("sounders.delayed", bit7 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("global.mute", "visible", bit0 ? "true" : "false");
                    this.uiSet("global.sounder", "visible", bit1 ? "true" : "false");
                    this.uiSet("global.sounders.silenced", "visible", bit2 ? "true" : "false");
                    this.uiSet("intest.zone.exists", "visible", bit3 ? "true" : "false");
                    this.uiSet("disabled.zone.exists", "visible", bit4 ? "true" : "false");
                    this.uiSet("output.disabled", "visible", bit5 ? "true" : "false");
                    this.uiSet("sounders.disabled", "visible", bit6 ? "true" : "false");
                    this.uiSet("sounders.delayed", "visible", bit7 ? "true" : "false");
                }
                bit0 = ((myByte = response[5]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                boolean bl2 = bit4 = (myByte & 0x10) != 0;
                if (this.startupevent) {
                    this.ioWrite("global.panel.fault", bit0 ? "1" : "0");
                    this.ioWrite("global.power.fault", bit1 ? "1" : "0");
                    this.ioWrite("global.pcb.fault", bit2 ? "1" : "0");
                    this.ioWrite("global.loops.fault", bit3 ? "1" : "0");
                    this.ioWrite("global.device.fault", bit4 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("global.panel.fault", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("global.power.fault", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("global.pcb.fault", bit2 ? "1" : "0");
                    this.ioWriteNoEvents("global.loops.fault", bit3 ? "1" : "0");
                    this.ioWriteNoEvents("global.device.fault", bit4 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("global.panel.fault", "visible", bit0 ? "true" : "false");
                    this.uiSet("global.power.faultr", "visible", bit1 ? "true" : "false");
                    this.uiSet("global.pcb.fault", "visible", bit2 ? "true" : "false");
                    this.uiSet("global.loops.faults", "visible", bit3 ? "true" : "false");
                    this.uiSet("global.device.fault", "visible", bit4 ? "true" : "false");
                }
                bit0 = ((myByte = response[7]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                boolean bl3 = bit2 = (myByte & 4) != 0;
                if (this.startupevent) {
                    this.ioWrite("global.alarm", bit0 ? "1" : "0");
                    this.ioWrite("global.alarm.from.network", bit1 ? "1" : "0");
                    this.ioWrite("global.mcp.alarm", bit2 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("global.alarm", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("global.alarm.from.network", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("global.mcp.alarm", bit2 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("global.alarm", "visible", bit0 ? "true" : "false");
                    this.uiSet("global.alarm.from.network", "visible", bit1 ? "true" : "false");
                    this.uiSet("global.mcp.alarm", "visible", bit2 ? "true" : "false");
                }
                bit0 = ((myByte = response[11]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                boolean bl4 = bit3 = (myByte & 8) != 0;
                if (this.startupevent) {
                    this.ioWrite("global.reset", bit0 ? "1" : "0");
                    this.ioWrite("global.mute", bit1 ? "1" : "0");
                    this.ioWrite("global.sounders.on", bit2 ? "1" : "0");
                    this.ioWrite("global.sounders.off", bit3 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("global.reset", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("global.mute", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("global.sounders.on", bit2 ? "1" : "0");
                    this.ioWriteNoEvents("global.sounders.off", bit3 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("global.reset", "visible", bit0 ? "true" : "false");
                    this.uiSet("global.mute", "visible", bit1 ? "true" : "false");
                    this.uiSet("global.sounders.on", "visible", bit2 ? "true" : "false");
                    this.uiSet("global.sounders.off", "visible", bit3 ? "true" : "false");
                }
                bit0 = ((myByte = response[13]) & 1) != 0;
                boolean bl5 = bit1 = (myByte & 2) != 0;
                if (this.startupevent) {
                    this.ioWrite("global.main.supply.fault", bit0 ? "1" : "0");
                    this.ioWrite("global.ground.fault", bit1 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("global.main.supply.fault", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("global.ground.fault", bit1 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("global.main.supply.fault", "visible", bit0 ? "true" : "false");
                    this.uiSet("global.ground.fault", "visible", bit1 ? "true" : "false");
                }
                myByte = response[15];
                int soundersStatus = myByte;
                if (this.startupevent) {
                    switch (soundersStatus) {
                        case 0: {
                            this.ioWrite("global.sounder1.short.cut", "1");
                            this.ioWrite("global.sounder1.quiescent", "0");
                            this.ioWrite("global.sounder1.short.fault", "0");
                            this.ioWrite("global.sounder1.sounders.on", "0");
                            break;
                        }
                        case 1: {
                            this.ioWrite("global.sounder1.short.cut", "0");
                            this.ioWrite("global.sounder1.quiescent", "1");
                            this.ioWrite("global.sounder1.short.fault", "0");
                            this.ioWrite("global.sounder1.sounders.on", "0");
                            break;
                        }
                        case 2: {
                            this.ioWrite("global.sounder1.short.cut", "0");
                            this.ioWrite("global.sounder1.quiescent", "0");
                            this.ioWrite("global.sounder1.short.fault", "1");
                            this.ioWrite("global.sounder1.sounders.on", "0");
                            break;
                        }
                        case 3: {
                            this.ioWrite("global.sounder1.short.cut", "0");
                            this.ioWrite("global.sounder1.quiescent", "0");
                            this.ioWrite("global.sounder1.short.fault", "0");
                            this.ioWrite("global.sounder1.sounders.on", "1");
                            break;
                        }
                    }
                } else {
                    switch (soundersStatus) {
                        case 0: {
                            this.ioWriteNoEvents("global.sounder1.short.cut", "1");
                            this.ioWriteNoEvents("global.sounder1.quiescent", "0");
                            this.ioWriteNoEvents("global.sounder1.short.fault", "0");
                            this.ioWriteNoEvents("global.sounder1.sounders.on", "0");
                            break;
                        }
                        case 1: {
                            this.ioWriteNoEvents("global.sounder1.short.cut", "0");
                            this.ioWriteNoEvents("global.sounder1.quiescent", "1");
                            this.ioWriteNoEvents("global.sounder1.short.fault", "0");
                            this.ioWriteNoEvents("global.sounder1.sounders.on", "0");
                            break;
                        }
                        case 2: {
                            this.ioWriteNoEvents("global.sounder1.short.cut", "0");
                            this.ioWriteNoEvents("global.sounder1.quiescent", "0");
                            this.ioWriteNoEvents("global.sounder1.short.fault", "1");
                            this.ioWriteNoEvents("global.sounder1.sounders.on", "0");
                            break;
                        }
                        case 3: {
                            this.ioWriteNoEvents("global.sounder1.short.cut", "0");
                            this.ioWriteNoEvents("global.sounder1.quiescent", "0");
                            this.ioWriteNoEvents("global.sounder1.short.fault", "0");
                            this.ioWriteNoEvents("global.sounder1.sounders.on", "1");
                            break;
                        }
                    }
                }
                if (this.gui) {
                    switch (soundersStatus) {
                        case 0: {
                            this.uiSet("global.sounder1.short.fault", "visible", "true");
                            this.uiSet("global.sounder1.quiescent", "visible", "false");
                            this.uiSet("global.sounder1.sounders.off", "visible", "false");
                            this.uiSet("global.sounder1.sounders.on", "visible", "false");
                            break;
                        }
                        case 1: {
                            this.uiSet("global.sounder1.short.fault", "visible", "false");
                            this.uiSet("global.sounder1.quiescent", "visible", "true");
                            this.uiSet("global.sounder1.sounders.off", "visible", "false");
                            this.uiSet("global.sounder1.sounders.on", "visible", "false");
                            break;
                        }
                        case 2: {
                            this.uiSet("global.sounder1.short.fault", "visible", "false");
                            this.uiSet("global.sounder1.quiescent", "visible", "false");
                            this.uiSet("global.sounder1.sounders.off", "visible", "true");
                            this.uiSet("global.sounder1.sounders.on", "visible", "false");
                            break;
                        }
                        case 3: {
                            this.uiSet("global.sounder1.short.fault", "visible", "false");
                            this.uiSet("global.sounder1.quiescent", "visible", "false");
                            this.uiSet("global.sounder1.sounders.off", "visible", "false");
                            this.uiSet("global.sounder1.sounders.on", "visible", "true");
                            break;
                        }
                    }
                }
                myByte = response[17];
                soundersStatus = myByte;
                if (this.startupevent) {
                    switch (soundersStatus) {
                        case 0: {
                            this.ioWrite("global.sounder2.short.cut", "1");
                            this.ioWrite("global.sounder2.quiescent", "0");
                            this.ioWrite("global.sounder2.short.fault", "0");
                            this.ioWrite("global.sounder2.sounders.on", "0");
                            break;
                        }
                        case 1: {
                            this.ioWrite("global.sounder2.short.cut", "0");
                            this.ioWrite("global.sounder2.quiescent", "1");
                            this.ioWrite("global.sounder2.short.fault", "0");
                            this.ioWrite("global.sounder2.sounders.on", "0");
                            break;
                        }
                        case 2: {
                            this.ioWrite("global.sounder2.short.cut", "0");
                            this.ioWrite("global.sounder2.quiescent", "0");
                            this.ioWrite("global.sounder2.short.fault", "1");
                            this.ioWrite("global.sounder2.sounders.on", "0");
                            break;
                        }
                        case 3: {
                            this.ioWrite("global.sounder2.short.cut", "0");
                            this.ioWrite("global.sounder2.quiescent", "0");
                            this.ioWrite("global.sounder2.short.fault", "0");
                            this.ioWrite("global.sounder2.sounders.on", "1");
                            break;
                        }
                    }
                } else {
                    switch (soundersStatus) {
                        case 0: {
                            this.ioWriteNoEvents("global.sounder2.short.cut", "1");
                            this.ioWriteNoEvents("global.sounder2.quiescent", "0");
                            this.ioWriteNoEvents("global.sounder2.short.fault", "0");
                            this.ioWriteNoEvents("global.sounder2.sounders.on", "0");
                            break;
                        }
                        case 1: {
                            this.ioWriteNoEvents("global.sounder2.short.cut", "0");
                            this.ioWriteNoEvents("global.sounder2.quiescent", "1");
                            this.ioWriteNoEvents("global.sounder2.short.fault", "0");
                            this.ioWriteNoEvents("global.sounder2.sounders.on", "0");
                            break;
                        }
                        case 2: {
                            this.ioWriteNoEvents("global.sounder2.short.cut", "0");
                            this.ioWriteNoEvents("global.sounder2.quiescent", "0");
                            this.ioWriteNoEvents("global.sounder2.short.fault", "1");
                            this.ioWriteNoEvents("global.sounder2.sounders.on", "0");
                            break;
                        }
                        case 3: {
                            this.ioWriteNoEvents("global.sounder2.short.cut", "0");
                            this.ioWriteNoEvents("global.sounder2.quiescent", "0");
                            this.ioWriteNoEvents("global.sounder2.short.fault", "0");
                            this.ioWriteNoEvents("global.sounder2.sounders.on", "1");
                            break;
                        }
                    }
                }
                if (this.gui) {
                    switch (soundersStatus) {
                        case 0: {
                            this.uiSet("global.sounder2.short.fault", "visible", "true");
                            this.uiSet("global.sounder2.quiescent", "visible", "false");
                            this.uiSet("global.sounder2.sounders.off", "visible", "false");
                            this.uiSet("global.sounder2.sounders.on", "visible", "false");
                            break;
                        }
                        case 1: {
                            this.uiSet("global.sounder2.short.fault", "visible", "false");
                            this.uiSet("global.sounder2.quiescent", "visible", "true");
                            this.uiSet("global.sounder2.sounders.off", "visible", "false");
                            this.uiSet("global.sounder2.sounders.on", "visible", "false");
                            break;
                        }
                        case 2: {
                            this.uiSet("global.sounder2.short.fault", "visible", "false");
                            this.uiSet("global.sounder2.quiescent", "visible", "false");
                            this.uiSet("global.sounder2.sounders.off", "visible", "true");
                            this.uiSet("global.sounder2.sounders.on", "visible", "false");
                            break;
                        }
                        case 3: {
                            this.uiSet("global.sounder2.short.fault", "visible", "false");
                            this.uiSet("global.sounder2.quiescent", "visible", "false");
                            this.uiSet("global.sounder2.sounders.off", "visible", "false");
                            this.uiSet("global.sounder2.sounders.on", "visible", "true");
                            break;
                        }
                    }
                }
                boolean status = (relStatus = Integer.valueOf(myByte = response[21]).intValue()) >= 1;
                if (this.startupevent) {
                    this.ioWrite("global.relay.fault", status ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("global.relay.fault", status ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("global.relay.fault", "visible", status ? "true" : "false");
                }
                status = (relStatus = Integer.valueOf(myByte = response[19]).intValue()) >= 1;
                if (this.startupevent) {
                    this.ioWrite("global.relay.alarm", status ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("global.relay.alarm", status ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("global.relay.alarm", "visible", status ? "true" : "false");
                }
                myByte = response[23];
                String s = String.valueOf(myByte);
                if (this.startupevent) {
                    this.ioWrite("global.faults.counter", s);
                } else {
                    this.ioWriteNoEvents("global.faults.counter", s);
                }
                if (this.gui) {
                    this.uiSet("global.faults.counter", "value", s);
                }
                myByte = response[23];
                s = String.valueOf(myByte);
                if (this.startupevent) {
                    this.ioWrite("global.alarms.counter", s);
                } else {
                    this.ioWriteNoEvents("global.alarms.counter", s);
                }
                if (this.gui) {
                    this.uiSet("global.alarms.counter", "value", s);
                }
            } else if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex2);
                ++this.loopErrorCounter;
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
            }
            ++this.loopErrorCounter;
        }
    }

    private void readLoopStatus() {
        byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, 80, 8);
        if (response != null) {
            String responseHex3 = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  loop status read: " + responseHex3);
            }
            if (responseHex3.startsWith("04")) {
                boolean bit2;
                byte myByte = response[3];
                boolean bit0 = (myByte & 1) != 0;
                boolean bit1 = (myByte & 2) != 0;
                boolean bl = bit2 = (myByte & 4) != 0;
                if (bit0) {
                    this.loopsActive[0] = true;
                }
                if (this.startupevent) {
                    this.ioWrite("loop.1.active", bit0 ? "1" : "0");
                    this.ioWrite("loop.1.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWrite("loop.1.comm.fault", bit2 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("loop.1.active", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("loop.1.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("loop.1.comm.fault", bit2 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("loop.1.active", "visible", bit0 ? "true" : "false");
                    this.uiSet("loop.1.shortopen.fault", "visible", bit1 ? "true" : "false");
                    this.uiSet("loop.1.comm.fault", "visible", bit2 ? "true" : "false");
                }
                bit0 = ((myByte = response[5]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                boolean bl2 = bit2 = (myByte & 4) != 0;
                if (bit0) {
                    this.loopsActive[1] = true;
                }
                if (this.startupevent) {
                    this.ioWrite("loop.2.active", bit0 ? "1" : "0");
                    this.ioWrite("loop.2.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWrite("loop.2.comm.fault", bit2 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("loop.2.active", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("loop.2.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("loop.2.comm.fault", bit2 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("loop.2.active", "visible", bit0 ? "true" : "false");
                    this.uiSet("loop.2.shortopen.fault", "visible", bit1 ? "true" : "false");
                    this.uiSet("loop.2.comm.fault", "visible", bit2 ? "true" : "false");
                }
                bit0 = ((myByte = response[7]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                boolean bl3 = bit2 = (myByte & 4) != 0;
                if (bit0) {
                    this.loopsActive[2] = true;
                }
                if (this.startupevent) {
                    this.ioWrite("loop.3.active", bit0 ? "1" : "0");
                    this.ioWrite("loop.3.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWrite("loop.3.comm.fault", bit2 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("loop.3.active", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("loop.3.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("loop.3.comm.fault", bit2 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("loop.3.active", "visible", bit0 ? "true" : "false");
                    this.uiSet("loop.3.shortopen.fault", "visible", bit1 ? "true" : "false");
                    this.uiSet("loop.3.comm.fault", "visible", bit2 ? "true" : "false");
                }
                bit0 = ((myByte = response[9]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                boolean bl4 = bit2 = (myByte & 4) != 0;
                if (bit0) {
                    this.loopsActive[3] = true;
                }
                if (this.startupevent) {
                    this.ioWrite("loop.4.active", bit0 ? "1" : "0");
                    this.ioWrite("loop.4.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWrite("loop.4.comm.fault", bit2 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("loop.4.active", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("loop.4.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("loop.4.comm.fault", bit2 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("loop.4.active", "visible", bit0 ? "true" : "false");
                    this.uiSet("loop.4.shortopen.fault", "visible", bit1 ? "true" : "false");
                    this.uiSet("loop.4.comm.fault", "visible", bit2 ? "true" : "false");
                }
                bit0 = ((myByte = response[11]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                boolean bl5 = bit2 = (myByte & 4) != 0;
                if (bit0) {
                    this.loopsActive[4] = true;
                }
                if (this.startupevent) {
                    this.ioWrite("loop.5.active", bit0 ? "1" : "0");
                    this.ioWrite("loop.5.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWrite("loop.5.comm.fault", bit2 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("loop.5.active", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("loop.5.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("loop.5.comm.fault", bit2 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("loop.5.active", "visible", bit0 ? "true" : "false");
                    this.uiSet("loop.5.shortopen.fault", "visible", bit1 ? "true" : "false");
                    this.uiSet("loop.5.comm.fault", "visible", bit2 ? "true" : "false");
                }
                bit0 = ((myByte = response[13]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                boolean bl6 = bit2 = (myByte & 4) != 0;
                if (bit0) {
                    this.loopsActive[5] = true;
                }
                if (this.startupevent) {
                    this.ioWrite("loop.6.active", bit0 ? "1" : "0");
                    this.ioWrite("loop.6.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWrite("loop.6.comm.fault", bit2 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("loop.6.active", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("loop.6.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("loop.6.comm.fault", bit2 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("loop.6.active", "visible", bit0 ? "true" : "false");
                    this.uiSet("loop.6.shortopen.fault", "visible", bit1 ? "true" : "false");
                    this.uiSet("loop.6.comm.fault", "visible", bit2 ? "true" : "false");
                }
                bit0 = ((myByte = response[15]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                boolean bl7 = bit2 = (myByte & 4) != 0;
                if (bit0) {
                    this.loopsActive[6] = true;
                }
                if (this.startupevent) {
                    this.ioWrite("loop.7.active", bit0 ? "1" : "0");
                    this.ioWrite("loop.7.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWrite("loop.7.comm.fault", bit2 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("loop.7.active", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("loop.7.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("loop.7.comm.fault", bit2 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("loop.7.active", "visible", bit0 ? "true" : "false");
                    this.uiSet("loop.7.shortopen.fault", "visible", bit1 ? "true" : "false");
                    this.uiSet("loop.7.comm.fault", "visible", bit2 ? "true" : "false");
                }
                bit0 = ((myByte = response[17]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                boolean bl8 = bit2 = (myByte & 4) != 0;
                if (bit0) {
                    this.loopsActive[7] = true;
                }
                if (this.startupevent) {
                    this.ioWrite("loop.8.active", bit0 ? "1" : "0");
                    this.ioWrite("loop.8.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWrite("loop.8.comm.fault", bit2 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("loop.8.active", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("loop.8.shortopen.fault", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("loop.8.comm.fault", bit2 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("loop.8.active", "visible", bit0 ? "true" : "false");
                    this.uiSet("loop.8.shortopen.fault", "visible", bit1 ? "true" : "false");
                    this.uiSet("loop.8.comm.fault", "visible", bit2 ? "true" : "false");
                }
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": loops active status: " + Arrays.toString((Object[])this.loopsActive));
                }
            } else if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex3);
            }
        }
    }

    private void readZonesStatus() {
        int zoneIndex = 1;
        int nextZoneIndex = 0;
        byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, 256, 100);
        nextZoneIndex = this.readZonesStatusGroup(response, zoneIndex);
        response = userBase.modbusReadInputRegisters(this.host, this.unitid, 356, 100);
        nextZoneIndex = this.readZonesStatusGroup(response, nextZoneIndex);
        response = userBase.modbusReadInputRegisters(this.host, this.unitid, 456, 50);
        this.readZonesStatusGroup(response, nextZoneIndex);
    }

    private int readZonesStatusGroup(byte[] response, int zoneIndex) {
        if (response != null) {
            String responseHex4 = Driver.bytesToHex(response);
            if (responseHex4.startsWith("04")) {
                int i2 = 2;
                while (i2 < response.length) {
                    boolean bit1L;
                    byte myByteH = response[i2];
                    byte myByteL = response[i2 + 1];
                    int zoneStatus = myByteH;
                    boolean bit0L = (myByteL & 1) != 0;
                    boolean bl = bit1L = (myByteL & 2) != 0;
                    if (this.startupevent) {
                        this.ioWrite("z" + zoneIndex + ".fault", bit0L ? "1" : "0");
                        this.ioWrite("z" + zoneIndex + ".alarm", bit1L ? "1" : "0");
                        switch (zoneStatus) {
                            case 0: {
                                this.ioWrite("z" + zoneIndex + ".normal", "1");
                                this.ioWrite("z" + zoneIndex + ".disabled", "0");
                                this.ioWrite("z" + zoneIndex + ".test", "0");
                                break;
                            }
                            case 1: {
                                this.ioWrite("z" + zoneIndex + ".normal", "0");
                                this.ioWrite("z" + zoneIndex + ".disabled", "1");
                                this.ioWrite("z" + zoneIndex + ".test", "0");
                                break;
                            }
                            case 2: {
                                this.ioWrite("z" + zoneIndex + ".normal", "0");
                                this.ioWrite("z" + zoneIndex + ".disabled", "0");
                                this.ioWrite("z" + zoneIndex + ".test", "1");
                                break;
                            }
                        }
                    } else {
                        this.ioWriteNoEvents("z" + zoneIndex + ".fault", bit0L ? "1" : "0");
                        this.ioWriteNoEvents("z" + zoneIndex + ".alarm", bit1L ? "1" : "0");
                        switch (zoneStatus) {
                            case 0: {
                                this.ioWrite("z" + zoneIndex + ".normal", "1");
                                this.ioWrite("z" + zoneIndex + ".disabled", "0");
                                this.ioWrite("z" + zoneIndex + ".test", "0");
                                break;
                            }
                            case 1: {
                                this.ioWrite("z" + zoneIndex + ".normal", "0");
                                this.ioWrite("z" + zoneIndex + ".disabled", "1");
                                this.ioWrite("z" + zoneIndex + ".test", "0");
                                break;
                            }
                            case 2: {
                                this.ioWrite("z" + zoneIndex + ".normal", "0");
                                this.ioWrite("z" + zoneIndex + ".disabled", "0");
                                this.ioWrite("z" + zoneIndex + ".test", "1");
                                break;
                            }
                        }
                    }
                    if (this.gui) {
                        this.uiSet("z" + zoneIndex + ".fault", "visible", bit0L ? "true" : "false");
                        this.uiSet("z" + zoneIndex + ".alarm", "visible", bit1L ? "true" : "false");
                        switch (zoneStatus) {
                            case 0: {
                                this.uiSet("z" + zoneIndex + ".normal", "visible", "true");
                                this.uiSet("z" + zoneIndex + ".disabled", "visible", "false");
                                this.uiSet("z" + zoneIndex + ".test", "visible", "false");
                                break;
                            }
                            case 1: {
                                this.uiSet("z" + zoneIndex + ".normal", "visible", "false");
                                this.uiSet("z" + zoneIndex + ".disabled", "visible", "true");
                                this.uiSet("z" + zoneIndex + ".test", "visible", "false");
                                break;
                            }
                            case 2: {
                                this.uiSet("z" + zoneIndex + ".normal", "visible", "false");
                                this.uiSet("z" + zoneIndex + ".disabled", "visible", "false");
                                this.uiSet("z" + zoneIndex + ".test", "visible", "true");
                                break;
                            }
                        }
                    }
                    ++zoneIndex;
                    ++i2;
                    ++i2;
                }
            } else {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex4);
                }
                ++this.loopErrorCounter;
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
            }
            ++this.loopErrorCounter;
        }
        return zoneIndex;
    }

    private void readDeviceStatus() {
        int startingAddr = 512;
        int i2 = 0;
        while (i2 < this.loopsActive.length) {
            int deviceIndex = 1;
            if (this.loopsActive[i2].booleanValue()) {
                startingAddr = 512 + i2 * 256;
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": device status read | loop | " + (i2 + 1) + " | starting address: " + startingAddr);
                }
                int nextDeviceIndex = 0;
                byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, startingAddr, 100);
                nextDeviceIndex = this.readDeviceStatusSingleGroup(response, deviceIndex, i2);
                response = userBase.modbusReadInputRegisters(this.host, this.unitid, startingAddr + 100, 100);
                nextDeviceIndex = this.readDeviceStatusSingleGroup(response, nextDeviceIndex, i2);
                response = userBase.modbusReadInputRegisters(this.host, this.unitid, startingAddr + 200, 50);
                this.readDeviceStatusSingleGroup(response, nextDeviceIndex, i2);
            }
            ++i2;
        }
    }

    private int readDeviceStatusSingleGroup(byte[] response, int deviceIndex, int i2) {
        if (response != null) {
            String responseHex5 = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  device status read: " + responseHex5);
            }
            if (responseHex5.startsWith("04")) {
                int j2 = 2;
                while (j2 < response.length) {
                    boolean bit1L;
                    byte myByteH = response[j2];
                    byte myByteL = response[j2 + 1];
                    int deviceStatus = myByteH;
                    boolean bit0L = (myByteL & 1) != 0;
                    boolean bl = bit1L = (myByteL & 2) != 0;
                    if (this.startupevent) {
                        this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".fault", bit0L ? "1" : "0");
                        this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".alarm", bit1L ? "1" : "0");
                        switch (deviceStatus) {
                            case 0: {
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".normal", "1");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".disabled", "0");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".test", "0");
                                break;
                            }
                            case 1: {
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".normal", "0");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".disabled", "1");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".test", "0");
                                break;
                            }
                            case 2: {
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".normal", "0");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".disabled", "0");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".test", "1");
                                break;
                            }
                        }
                    } else {
                        this.ioWriteNoEvents("l" + (i2 + 1) + ".d" + deviceIndex + ".fault", bit0L ? "1" : "0");
                        this.ioWriteNoEvents("l" + (i2 + 1) + ".d" + deviceIndex + ".alarm", bit1L ? "1" : "0");
                        switch (deviceStatus) {
                            case 0: {
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".normal", "1");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".disabled", "0");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".test", "0");
                                break;
                            }
                            case 1: {
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".normal", "0");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".disabled", "1");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".test", "0");
                                break;
                            }
                            case 2: {
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".normal", "0");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".disabled", "0");
                                this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".test", "1");
                                break;
                            }
                        }
                    }
                    if (this.gui) {
                        this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".fault", "visible", bit0L ? "true" : "false");
                        this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".alarm", "visible", bit1L ? "true" : "false");
                        switch (deviceStatus) {
                            case 0: {
                                this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".normal", "visible", "true");
                                this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".disabled", "visible", "false");
                                this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".test", "visible", "false");
                                break;
                            }
                            case 1: {
                                this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".normal", "visible", "false");
                                this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".disabled", "visible", "true");
                                this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".test", "visible", "false");
                                break;
                            }
                            case 2: {
                                this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".normal", "visible", "false");
                                this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".disabled", "visible", "false");
                                this.uiSet("l" + (i2 + 1) + ".d" + deviceIndex + ".test", "visible", "true");
                                break;
                            }
                        }
                    }
                    ++deviceIndex;
                    ++j2;
                    ++j2;
                }
            } else {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex5);
                }
                ++this.loopErrorCounter;
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
            }
            ++this.loopErrorCounter;
        }
        return deviceIndex;
    }

    private void readDeviceAvValue() {
        int startingAddr = 4096;
        int i2 = 0;
        while (i2 < this.loopsActive.length) {
            int deviceIndex = 1;
            if (this.loopsActive[i2].booleanValue()) {
                startingAddr = 4096 + i2 * 256;
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": device analog value read | loop | " + (i2 + 1) + " | starting address: " + startingAddr);
                }
                int nextDeviceIndex = 0;
                byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, startingAddr, 100);
                nextDeviceIndex = this.readDeviceAvValueSingleGroup(response, deviceIndex, i2);
                response = userBase.modbusReadInputRegisters(this.host, this.unitid, startingAddr + 100, 100);
                nextDeviceIndex = this.readDeviceAvValueSingleGroup(response, nextDeviceIndex, i2);
                response = userBase.modbusReadInputRegisters(this.host, this.unitid, startingAddr + 200, 50);
                this.readDeviceAvValueSingleGroup(response, nextDeviceIndex, i2);
            }
            ++i2;
        }
    }

    private int readDeviceAvValueSingleGroup(byte[] response, int deviceIndex, int i2) {
        if (response != null) {
            String responseHex6 = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  device analog value read: " + responseHex6);
            }
            if (responseHex6.startsWith("04")) {
                int j2 = 2;
                while (j2 < response.length) {
                    byte myByteH = response[j2];
                    byte myByteL = response[j2 + 1];
                    if (this.startupevent) {
                        this.ioWrite("l" + (i2 + 1) + ".a" + deviceIndex + ".av1", String.valueOf(myByteL));
                        this.ioWrite("l" + (i2 + 1) + ".a" + deviceIndex + ".av2", String.valueOf(myByteH));
                    } else {
                        this.ioWriteNoEvents("l" + (i2 + 1) + ".a" + deviceIndex + ".av1", String.valueOf(myByteL));
                        this.ioWriteNoEvents("l" + (i2 + 1) + ".a" + deviceIndex + ".av2", String.valueOf(myByteH));
                    }
                    if (this.gui) {
                        this.uiSet("l" + (i2 + 1) + ".a" + deviceIndex + ".av1", "value", String.valueOf(myByteL));
                        this.uiSet("l" + (i2 + 1) + ".a" + deviceIndex + ".av2", "value", String.valueOf(myByteH));
                    }
                    ++deviceIndex;
                    ++j2;
                    ++j2;
                }
            } else {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex6);
                }
                ++this.loopErrorCounter;
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
            }
            ++this.loopErrorCounter;
        }
        return deviceIndex;
    }

    private void readDeviceType() {
        int startingAddr = 8192;
        int i2 = 0;
        while (i2 < this.loopsActive.length) {
            int deviceIndex = 1;
            if (this.loopsActive[i2].booleanValue()) {
                startingAddr = 4096 + i2 * 256;
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": device type read | loop | " + (i2 + 1) + " | starting address: " + startingAddr);
                }
                int nextDeviceIndex = 0;
                byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, startingAddr, 100);
                nextDeviceIndex = this.readDeviceTypeSingleGroup(response, deviceIndex, i2);
                response = userBase.modbusReadInputRegisters(this.host, this.unitid, startingAddr + 100, 100);
                nextDeviceIndex = this.readDeviceTypeSingleGroup(response, nextDeviceIndex, i2);
                response = userBase.modbusReadInputRegisters(this.host, this.unitid, startingAddr + 200, 50);
                this.readDeviceTypeSingleGroup(response, nextDeviceIndex, i2);
            }
            ++i2;
        }
    }

    private int readDeviceTypeSingleGroup(byte[] response, int deviceIndex, int i2) {
        if (response != null) {
            String responseHex7 = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  device type read: " + responseHex7);
            }
            if (responseHex7.startsWith("04")) {
                int j2 = 2;
                while (j2 < response.length) {
                    byte myByteH = response[j2];
                    byte myByteL = response[j2 + 1];
                    int type = myByteH;
                    int zone = myByteL;
                    String typedesc = "";
                    switch (type) {
                        case 0: {
                            typedesc = "empty";
                            break;
                        }
                        case 1: {
                            typedesc = "optic";
                            break;
                        }
                        case 2: {
                            typedesc = "heat";
                            break;
                        }
                        case 3: {
                            typedesc = "opto-heat";
                            break;
                        }
                        case 4: {
                            typedesc = "manual call point";
                            break;
                        }
                        case 5: {
                            typedesc = "zone module";
                            break;
                        }
                        case 6: {
                            typedesc = "input";
                            break;
                        }
                        case 7: {
                            typedesc = "output";
                            break;
                        }
                        case 8: {
                            typedesc = "buzzer";
                            break;
                        }
                        case 9: {
                            typedesc = "panel";
                            break;
                        }
                        case 10: {
                            typedesc = "gas";
                            break;
                        }
                    }
                    if (this.startupevent) {
                        this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".typenum", String.valueOf(type));
                        this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".type", typedesc);
                        this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".zone", String.valueOf(zone));
                    } else {
                        this.ioWriteNoEvents("l" + (i2 + 1) + ".d" + deviceIndex + ".typenum", String.valueOf(type));
                        this.ioWrite("l" + (i2 + 1) + ".d" + deviceIndex + ".type", typedesc);
                        this.ioWriteNoEvents("l" + (i2 + 1) + ".d" + deviceIndex + ".zone", String.valueOf(zone));
                    }
                    if (this.gui) {
                        this.uiSet("l" + (i2 + 1) + ".a" + deviceIndex + ".typenum", "value", String.valueOf(type));
                        this.uiSet("l" + (i2 + 1) + ".a" + deviceIndex + ".type", "value", typedesc);
                        this.uiSet("l" + (i2 + 1) + ".a" + deviceIndex + ".zone", "value", String.valueOf(zone));
                    }
                    ++deviceIndex;
                    ++j2;
                    ++j2;
                }
            } else {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex7);
                }
                ++this.loopErrorCounter;
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
            }
            ++this.loopErrorCounter;
        }
        return deviceIndex;
    }

    private void loadNames() throws FileNotFoundException {
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + ":  loading detnov.ini file");
        }
        Scanner sc = new Scanner(new File(FILE1));
        sc.useDelimiter("(\\n)");
        while (sc.hasNext()) {
            String next = sc.next();
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  line: " + next);
            }
            String[] spl = next.split("=");
            String dp = spl[0].replaceAll("\\s+", "");
            String n2 = spl[1].trim();
            String[] spl2 = dp.split("\\.");
            if (!this.name.equalsIgnoreCase(spl2[0])) continue;
            dp = dp.replace(String.valueOf(this.name) + ".", "");
            this.ioWriteNoEvents(String.valueOf(dp) + ".name", n2);
            if (!this.gui) continue;
            this.uiSet(String.valueOf(dp) + ".name", "value", n2);
        }
        sc.close();
    }

    public static String removeLastChars(String str, int chars) {
        return str.substring(0, str.length() - chars);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j2 = 0;
        while (j2 < bytes.length) {
            int v = bytes[j2] & 0xFF;
            hexChars[j2 * 2] = hexArray[v >>> 4];
            hexChars[j2 * 2 + 1] = hexArray[v & 0xF];
            ++j2;
        }
        return new String(hexChars);
    }

    public static String hexToAscii(String hex) {
        StringBuilder output = new StringBuilder();
        int i2 = 0;
        while (i2 < hex.length()) {
            String str = hex.substring(i2, i2 + 2);
            output.append((char)Integer.parseInt(str, 16));
            i2 += 2;
        }
        return output.toString();
    }

    public static int hex2decimal(String s) {
        String digits = "0123456789ABCDEF";
        s = s.toUpperCase();
        int val = 0;
        int i2 = 0;
        while (i2 < s.length()) {
            char c2 = s.charAt(i2);
            int d2 = digits.indexOf(c2);
            val = 16 * val + d2;
            ++i2;
        }
        return val;
    }
}

