/*
 * Decompiled with CFR 0.152.
 */
package drivers.daikinrc;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class Driver
extends driverBase {
    public static final int COMMANDSQUEUESIZE = 64;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final int DEFAULT_POLL_INTERVAL = 5000;
    public static final int TURBO_POLL_WINDOW = 3000;
    public static final int UDP_DISCOVERY_INTERVAL = 30000;
    private static final int UDP_DISCOVERY_PORT = 30050;
    private static final byte[] UDP_DISCOVERY_MESSAGE = "DAIKIN_UDP/common/basic_info".getBytes();
    private static final int BASIC_INFO = 1;
    private static final int CONTROL_INFO = 2;
    private static final int SENSOR_INFO = 3;
    private DatagramSocket serverSocket;
    private InetSocketAddress broadcastSocketAddress;
    private Server UDPServer = null;
    private Hashtable<String, String> unitsByAddress = new Hashtable();
    private Hashtable<String, String> unitsById = new Hashtable();
    private Hashtable<String, Unit> unitsData = new Hashtable();
    private Hashtable<String, Boolean> unitsOnline = new Hashtable();
    private Iterator<String> unitsByAddressIterator = null;
    private String driverName;
    private int pollinterval = 5000;
    private long loopTimemillis = 0L;
    private long commandTimemillis = 0L;
    private long lastDiscoveryRequestTimeMillis = 0L;
    private Thread currentThread;
    public static final String[] WEBOBJECTS = new String[]{"daikinrc"};

    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.driverName = name;
            try {
                int timer = Integer.parseInt(config.get("pollinterval"));
                if (timer >= 1000 && timer <= 30000) {
                    this.pollinterval = timer;
                }
            }
            catch (Exception e2) {
                this.messageLog(String.valueOf(this.driverName) + ": pollinterval ignored");
            }
            this.UDPServer = new Server();
            this.serverSocket = new DatagramSocket(30050);
            this.serverSocket.setSoTimeout(10000);
            new Thread(this.UDPServer).start();
            this.broadcastSocketAddress = new InetSocketAddress("255.255.255.255", 30050);
            this.messageLog(String.valueOf(this.driverName) + ": UDP server accepting packets on port: " + 30050);
            return true;
        }
        catch (Exception e3) {
            this.errorLog(String.valueOf(this.driverName) + ": Initialization failed - " + e3.getLocalizedMessage() + " - " + name);
            this.end();
            return false;
        }
    }

    public boolean loop() {
        block17: {
            String id;
            String address;
            block16: {
                block15: {
                    long sleepTime;
                    long now = System.currentTimeMillis();
                    int numberOfUnits = this.unitsByAddress.size();
                    long l2 = sleepTime = numberOfUnits > 0 ? (this.loopTimemillis + (long)this.pollinterval - now) / (long)numberOfUnits : this.loopTimemillis + (long)this.pollinterval - now;
                    if (sleepTime > 0L && now > this.commandTimemillis + 3000L) {
                        this.sleep(sleepTime);
                        this.loopTimemillis = now = System.currentTimeMillis();
                    } else {
                        this.loopTimemillis = now;
                    }
                    this.currentThread = Thread.currentThread();
                    try {
                        if (now > this.lastDiscoveryRequestTimeMillis + 30000L) {
                            this.lastDiscoveryRequestTimeMillis = now;
                            this.serverSocket.send(new DatagramPacket(UDP_DISCOVERY_MESSAGE, UDP_DISCOVERY_MESSAGE.length, this.broadcastSocketAddress));
                        }
                    }
                    catch (Exception e2) {
                        if (!this.isVerboseLog()) break block15;
                        this.errorLog(String.valueOf(this.driverName) + ": Polling error - " + e2.getMessage());
                    }
                }
                try {
                    if (this.unitsByAddressIterator == null) {
                        this.unitsByAddressIterator = this.unitsByAddress.keySet().iterator();
                    }
                    if (this.unitsByAddressIterator.hasNext()) {
                        address = this.unitsByAddressIterator.next();
                        id = this.unitsByAddress.get(address);
                        break block16;
                    }
                    this.unitsByAddressIterator = null;
                    return true;
                }
                catch (Exception e3) {
                    this.unitsByAddressIterator = null;
                    return true;
                }
            }
            try {
                String resp = Driver.urlGet("http://" + address + "/aircon/get_control_info", null, null);
                if (resp == null || !resp.startsWith("200")) {
                    throw new Exception("server error @ get_control_info");
                }
                this.decode(2, address, resp.substring(4));
                resp = Driver.urlGet("http://" + address + "/aircon/get_sensor_info", null, null);
                if (resp == null || !resp.startsWith("200")) {
                    throw new Exception("server error @ get_sensor_info");
                }
                this.decode(3, address, resp.substring(4));
                if (!this.unitsOnline.get(id).booleanValue()) {
                    this.unitsOnline.put(id, true);
                    this.ioWrite(String.valueOf(id) + ".connection", "online");
                }
            }
            catch (Exception e4) {
                if (this.unitsOnline.get(id).booleanValue()) {
                    this.unitsOnline.put(id, false);
                    this.ioWrite(String.valueOf(id) + ".connection", "offline");
                }
                if (!this.isVerboseLog()) break block17;
                this.errorLog(String.valueOf(this.driverName) + ": Polling error - " + e4.getMessage());
            }
        }
        return true;
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.driverName) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
        }
        this.UDPServer.terminate();
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        block7: {
            if (fields == null) {
                try {
                    int i2 = id.lastIndexOf(46);
                    String name = id.substring(0, i2);
                    String value = id.substring(i2 + 1);
                    if (name.endsWith(".power") || name.endsWith(".mode")) {
                        this.command(name, value);
                        break block7;
                    }
                    if (name.endsWith(".tempset")) {
                        this.command(name.replace(".tempset", ".temp.setpoint"), value);
                        break block7;
                    }
                    if (name.endsWith(".fanrate")) {
                        this.command(name.replace(".fanrate", ".fan.rate"), value);
                        break block7;
                    }
                    if (name.endsWith(".fandir")) {
                        this.command(name.replace(".fandir", ".fan.direction"), value);
                        break block7;
                    }
                    throw new Exception("unknown name");
                }
                catch (Exception e2) {
                    this.errorLog(String.valueOf(this.driverName) + ": User command error - " + id);
                }
            }
        }
        return "";
    }

    public void command(String name, String value) {
        try {
            int i2 = name.indexOf(46);
            String id = name.substring(0, i2).toLowerCase();
            String command = name.substring(i2 + 1).toLowerCase();
            Unit unit = this.unitsData.get(id);
            String address = this.unitsById.get(id);
            if (address == null) {
                throw new Exception("unit [" + id + "] not found");
            }
            StringBuffer buffer = new StringBuffer("http://" + address + "/aircon/set_control_info?");
            if (command.equalsIgnoreCase("power")) {
                int v;
                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    v = 1;
                } else if (value.equals("0") || value.equalsIgnoreCase("off")) {
                    v = 0;
                } else if (value.equalsIgnoreCase("flip")) {
                    v = unit.pow.equals("1") ? 0 : 1;
                } else {
                    throw new Exception("invalid value");
                }
                buffer.append("&pow=");
                buffer.append(v);
                buffer.append("&mode=");
                buffer.append(unit.mode_r);
                buffer.append("&stemp=");
                buffer.append(unit.stemp_r);
                buffer.append("&shum=");
                buffer.append(unit.shum_r);
                buffer.append("&f_rate=");
                buffer.append(unit.f_rate_r);
                buffer.append("&f_dir=");
                buffer.append(unit.f_dir_r);
            } else if (command.equalsIgnoreCase("mode")) {
                int v;
                if (value.equalsIgnoreCase("auto")) {
                    v = 7;
                } else if (value.equalsIgnoreCase("dehum")) {
                    v = 2;
                } else if (value.equalsIgnoreCase("cooling")) {
                    v = 3;
                } else if (value.equalsIgnoreCase("heating")) {
                    v = 4;
                } else if (value.equalsIgnoreCase("fan")) {
                    v = 6;
                } else {
                    throw new Exception("invalid value");
                }
                buffer.append("&pow=");
                buffer.append(unit.pow_r);
                buffer.append("&mode=");
                buffer.append(v);
                buffer.append("&stemp=");
                buffer.append(unit.stemp_r);
                buffer.append("&shum=");
                buffer.append(unit.shum_r);
                buffer.append("&f_rate=");
                buffer.append(unit.f_rate_r);
                buffer.append("&f_dir=");
                buffer.append(unit.f_dir_r);
            } else if (command.equalsIgnoreCase("temp.setpoint")) {
                double v;
                try {
                    v = value.equalsIgnoreCase("up") ? Double.parseDouble(unit.stemp_r) + 0.5 : (value.equalsIgnoreCase("down") ? Double.parseDouble(unit.stemp_r) - 0.5 : Double.parseDouble(value));
                }
                catch (Exception e2) {
                    throw new Exception("invalid value");
                }
                buffer.append("&pow=");
                buffer.append(unit.pow_r);
                buffer.append("&mode=");
                buffer.append(unit.mode_r);
                buffer.append("&stemp=");
                buffer.append(v);
                buffer.append("&shum=");
                buffer.append(unit.shum_r);
                buffer.append("&f_rate=");
                buffer.append(unit.f_rate_r);
                buffer.append("&f_dir=");
                buffer.append(unit.f_dir_r);
            } else if (command.equalsIgnoreCase("humidity.setpoint")) {
                double v;
                try {
                    v = value.equalsIgnoreCase("up") ? Double.parseDouble(unit.shum_r) + 10.0 : (value.equalsIgnoreCase("down") ? Double.parseDouble(unit.shum_r) - 10.0 : Double.parseDouble(value));
                }
                catch (Exception e3) {
                    throw new Exception("invalid value");
                }
                buffer.append("&pow=");
                buffer.append(unit.pow_r);
                buffer.append("&mode=");
                buffer.append(unit.mode_r);
                buffer.append("&stemp=");
                buffer.append(unit.stemp_r);
                buffer.append("&shum=");
                buffer.append(v);
                buffer.append("&f_rate=");
                buffer.append(unit.f_rate_r);
                buffer.append("&f_dir=");
                buffer.append(unit.f_dir_r);
            } else if (command.equalsIgnoreCase("fan.rate")) {
                try {
                    int v = value.equalsIgnoreCase("auto") ? 65 : (value.equalsIgnoreCase("silence") ? 66 : 50 + Integer.parseInt(value));
                    buffer.append("&pow=");
                    buffer.append(unit.pow_r);
                    buffer.append("&mode=");
                    buffer.append(unit.mode_r);
                    buffer.append("&stemp=");
                    buffer.append(unit.stemp_r);
                    buffer.append("&shum=");
                    buffer.append(unit.shum_r);
                    buffer.append("&f_rate=");
                    buffer.append((char)v);
                    buffer.append("&f_dir=");
                    buffer.append(unit.f_dir_r);
                }
                catch (Exception e4) {
                    throw new Exception("invalid value");
                }
            } else if (command.equalsIgnoreCase("fan.direction")) {
                int v;
                if (value.equalsIgnoreCase("off") || value.equals("0")) {
                    v = 0;
                } else if (value.equalsIgnoreCase("v")) {
                    v = 1;
                } else if (value.equalsIgnoreCase("h")) {
                    v = 2;
                } else if (value.equalsIgnoreCase("vh") || value.equalsIgnoreCase("hv")) {
                    v = 3;
                } else {
                    throw new Exception("invalid value");
                }
                buffer.append("&pow=");
                buffer.append(unit.pow_r);
                buffer.append("&mode=");
                buffer.append(unit.mode_r);
                buffer.append("&stemp=");
                buffer.append(unit.stemp_r);
                buffer.append("&shum=");
                buffer.append(unit.shum_r);
                buffer.append("&f_rate=");
                buffer.append(unit.f_rate_r);
                buffer.append("&f_dir=");
                buffer.append(v);
            } else {
                throw new Exception("unknown name");
            }
            String resp = Driver.urlGet(buffer.toString(), null, null);
            if (!resp.startsWith("200")) {
                throw new Exception("server error");
            }
            this.commandTimemillis = System.currentTimeMillis();
            try {
                this.currentThread.interrupt();
            }
            catch (Exception exception) {}
        }
        catch (Exception e5) {
            this.errorLog(String.valueOf(this.driverName) + ": Command error - " + name + " = " + value + " - " + e5.getMessage());
        }
    }

    private Hashtable<String, String> decode(int type, String address, String data) throws Exception {
        Hashtable<String, String> params = new Hashtable<String, String>();
        try {
            String[] sa = data.split(",");
            int i2 = 0;
            while (i2 < sa.length) {
                int eq = sa[i2].indexOf(61);
                if (eq > 0) {
                    params.put(sa[i2].substring(0, eq).trim(), sa[i2].substring(eq + 1).trim());
                }
                ++i2;
            }
            switch (type) {
                case 1: {
                    String v = URLDecoder.decode(params.get("name"), "UTF-8");
                    String id = v.toLowerCase().replaceAll("\\W", "_");
                    params.put("name", v);
                    this.ioWrite(String.valueOf(id) + ".name", v);
                    v = params.get("mac");
                    StringBuffer sb = new StringBuffer();
                    i2 = 0;
                    while (i2 <= v.length() - 2) {
                        if (i2 > 0) {
                            sb.append(':');
                        }
                        sb.append(v.charAt(i2));
                        sb.append(v.charAt(i2 + 1));
                        i2 += 2;
                    }
                    v = sb.toString().toLowerCase();
                    params.put("mac", v);
                    this.ioWrite(String.valueOf(id) + ".mac", v);
                    this.ioWrite(String.valueOf(id) + ".version", params.get("ver").replaceAll("_", "."));
                    break;
                }
                case 2: {
                    String id = this.unitsByAddress.get(address);
                    Unit unit = this.unitsData.get(id);
                    String string = params.get("pow");
                    unit.pow_r = string;
                    String v = string;
                    if (!v.equals(unit.pow)) {
                        unit.pow = v;
                        if (v.equals("1")) {
                            this.ioWrite(String.valueOf(id) + ".power", "on");
                            this.uiSet(id, "power", "on");
                        } else {
                            this.ioWrite(String.valueOf(id) + ".power", "off");
                            this.uiSet(id, "power", "off");
                        }
                    }
                    unit.mode_r = params.get("mode");
                    switch (Integer.parseInt(unit.mode_r)) {
                        case 0: 
                        case 1: 
                        case 7: {
                            v = "auto";
                            break;
                        }
                        case 2: {
                            v = "dehum";
                            break;
                        }
                        case 3: {
                            v = "cooling";
                            break;
                        }
                        case 4: {
                            v = "heating";
                            break;
                        }
                        case 6: {
                            v = "fan";
                            break;
                        }
                        default: {
                            v = "";
                        }
                    }
                    if (!v.equals(unit.mode)) {
                        unit.mode = v;
                        this.ioWrite(String.valueOf(id) + ".mode", v);
                        this.uiSet(id, "mode", v);
                    }
                    if ((v = params.get("stemp")).equals("--")) {
                        v = "";
                    } else {
                        unit.stemp_r = v;
                    }
                    if (!v.equals(unit.stemp)) {
                        unit.stemp = v;
                        this.ioWrite(String.valueOf(id) + ".temp.setpoint", v);
                        this.uiSet(id, "tempset", v);
                    }
                    if ((v = params.get("shum")).equals("--")) {
                        v = "";
                    } else {
                        unit.shum_r = v;
                    }
                    if (!v.equals(unit.shum)) {
                        unit.shum = v;
                        this.ioWrite(String.valueOf(id) + ".humidity.setpoint", v);
                    }
                    unit.f_rate_r = params.get("f_rate");
                    switch (unit.f_rate_r.charAt(0)) {
                        case 'A': {
                            v = "auto";
                            break;
                        }
                        case 'B': {
                            v = "silence";
                            break;
                        }
                        case '3': {
                            v = "1";
                            break;
                        }
                        case '4': {
                            v = "2";
                            break;
                        }
                        case '5': {
                            v = "3";
                            break;
                        }
                        case '6': {
                            v = "4";
                            break;
                        }
                        case '7': {
                            v = "5";
                            break;
                        }
                        default: {
                            v = "";
                        }
                    }
                    if (!v.equals(unit.f_rate)) {
                        unit.f_rate = v;
                        this.ioWrite(String.valueOf(id) + ".fan.rate", v);
                        this.uiSet(id, "fanrate", v);
                    }
                    unit.f_dir_r = params.get("f_dir");
                    switch (Integer.parseInt(unit.f_dir_r)) {
                        case 0: {
                            v = "off";
                            break;
                        }
                        case 1: {
                            v = "v";
                            break;
                        }
                        case 2: {
                            v = "h";
                            break;
                        }
                        case 3: {
                            v = "vh";
                            break;
                        }
                        default: {
                            v = "";
                        }
                    }
                    if (v.equals(unit.f_dir)) break;
                    unit.f_dir = v;
                    this.ioWrite(String.valueOf(id) + ".fan.direction", v);
                    this.uiSet(id, "fandir", v);
                    break;
                }
                case 3: {
                    String id = this.unitsByAddress.get(address);
                    Unit unit = this.unitsData.get(id);
                    String v = params.get("htemp");
                    if (v.equals("-") || v.equals("--")) {
                        v = "";
                    }
                    if (!v.equals(unit.htemp)) {
                        unit.htemp = v;
                        this.ioWrite(String.valueOf(id) + ".temp.current", v);
                        this.uiSet(id, "temp", v);
                    }
                    if ((v = params.get("hhum")).equals("-") || v.equals("--")) {
                        v = "";
                    }
                    if (!v.equals(unit.hhum)) {
                        unit.hhum = v;
                        this.ioWrite(String.valueOf(id) + ".humidity.current", v);
                    }
                    if ((v = params.get("otemp")).equals("-") || v.equals("--")) {
                        v = "";
                    }
                    if (v.equals(unit.otemp)) break;
                    unit.otemp = v;
                    this.ioWrite(String.valueOf(id) + ".temp.outside", v);
                }
            }
            return params;
        }
        catch (Exception e2) {
            throw new Exception("Response format error");
        }
    }

    private class Server
    implements Runnable {
        byte[] buffer = new byte[2048];
        boolean quit = false;

        private Server() {
        }

        private void addUnit(String id, String address, String mac, String name) {
            Driver.this.unitsByAddress.put(address, id);
            Driver.this.unitsById.put(id, address);
            Driver.this.unitsData.put(id, new Unit());
            Driver.this.unitsOnline.put(id, true);
            Driver.this.ioWrite(String.valueOf(id) + ".address", address);
            Driver.this.ioWrite(String.valueOf(id) + ".connection", "online");
            Driver.this.messageLog(String.valueOf(Driver.this.driverName) + ": Unit discovery: " + address + " (" + mac + ") " + name);
        }

        public void terminate() {
            this.quit = true;
        }

        @Override
        public void run() {
            while (!this.quit) {
                DatagramPacket in = new DatagramPacket(this.buffer, this.buffer.length);
                try {
                    Driver.this.serverSocket.receive(in);
                    String data = new String(in.getData(), "UTF-8");
                    String address = in.getAddress().getHostAddress();
                    Hashtable params = Driver.this.decode(1, address, data);
                    String unitName = (String)params.get("name");
                    String id = unitName.toLowerCase().replaceAll("\\W", "_");
                    if (!"OK".equals(params.get("ret"))) continue;
                    if (Driver.this.unitsById.containsKey(id)) {
                        String currentAddress = (String)Driver.this.unitsById.get(id);
                        if (currentAddress.equals(address)) continue;
                        Driver.this.unitsByAddress.remove(currentAddress);
                        this.addUnit(id, address, (String)params.get("mac"), unitName);
                        continue;
                    }
                    this.addUnit(id, address, (String)params.get("mac"), unitName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Driver.this.serverSocket.disconnect();
                Driver.this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class Unit {
        private String pow = null;
        private String mode = null;
        private String stemp = null;
        private String shum = null;
        private String f_rate = null;
        private String f_dir = null;
        private String pow_r = null;
        private String mode_r = null;
        private String stemp_r = "23";
        private String shum_r = "50";
        private String f_rate_r = null;
        private String f_dir_r = null;
        private String htemp = null;
        private String hhum = null;
        private String otemp = null;

        private Unit() {
        }
    }
}

