/*
 * Decompiled with CFR 0.152.
 */
package drivers.boschmap;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.LocalPortForwarder;
import com.hsyco.Configuration;
import com.hsyco.driverBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private static final String BOSCHMAP_INI_FILE = "boschmap.ini";
    private static final int DEFAULT_PORT = 6793;
    private static final String USER = "000003";
    private static final String DEFAULT_PASSWORD = "0999999";
    private static final int HEARTBEAT_TIMEOUT = 20000;
    private String name;
    private Monitor monitor;
    private boolean quit = false;
    private boolean genEvent;
    private LocalPortForwarder sshConnection;
    private Socket clientSocket;
    private OutputStream outputStream;
    private InputStream inputStram;
    private long lastHeartbeat;
    private long lastAreasStatusRequest;
    private List<Area> areas = new ArrayList<Area>();
    private List<Point> points = new ArrayList<Point>();
    private Boolean authenticated;
    private int alarm = -1;
    private int trouble = -1;
    private int tamper = -1;
    private int userTamper = -1;
    private ArrayBlockingQueue<Byte> respQ = new ArrayBlockingQueue(10);

    public boolean init(String name, HashMap<String, String> config) {
        String host;
        block18: {
            super.init(name);
            this.name = name;
            host = config.get("host");
            if (host != null && host.length() != 0) break block18;
            this.errorLog("host not specified");
            this.end();
            return false;
        }
        try {
            String password;
            int port = 0;
            try {
                port = Integer.parseInt(config.get("port"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (port == 0) {
                port = 6793;
            }
            if ((password = config.get("password")) == null) {
                password = DEFAULT_PASSWORD;
            }
            this.genEvent = Boolean.parseBoolean(config.get("startupevents"));
            this.loadConfiguration();
            this.createSshPortForwarder(host, port);
            this.clientSocket = new Socket("127.0.0.1", port);
            this.outputStream = new BufferedOutputStream(this.clientSocket.getOutputStream());
            this.inputStram = new BufferedInputStream(this.clientSocket.getInputStream());
            this.monitor = new Monitor();
            this.monitor.start();
            this.authenticate(USER, password);
            for (Area a2 : this.areas) {
                if (Configuration.verboseLog) {
                    this.messageLog("Requesting status of area: " + a2.siidString);
                }
                this.send(114, a2.siid, true);
                this.send(126, a2.siid, true);
                this.send(127, a2.siid, true);
            }
            for (Area a2 : this.areas) {
                if (Configuration.verboseLog) {
                    this.messageLog("Requesting pending alarms for area: " + a2.siidString);
                }
                this.send(116, a2.siid, false);
                Thread.sleep(100L);
            }
            for (Point p : this.points) {
                this.requestPointStatus(p);
            }
            for (Point p : this.points) {
                if (p.bypassed == -1) {
                    p.setBypassed(0);
                }
                if (p.blocked != -1) continue;
                p.setBlocked(0);
            }
            this.genEvent = true;
            this.ioWrite("connection", "online");
            this.lastAreasStatusRequest = this.lastHeartbeat = System.currentTimeMillis();
            return true;
        }
        catch (Exception e2) {
            this.errorLog("Initialization failed - " + e2.getLocalizedMessage());
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.inputStram.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.end();
            return false;
        }
    }

    private void createSshPortForwarder(String host, int port) throws Exception {
        Connection conn = new Connection(host, 22);
        conn.connect(null, 30000, 30000);
        if (!conn.authenticateWithNone("rps")) {
            throw new Exception("SSH authentication failed");
        }
        this.sshConnection = conn.createLocalPortForwarder(port, host, port);
    }

    private void loadConfiguration() throws IOException {
        this.messageLog("loading 'boschmap.ini'");
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(BOSCHMAP_INI_FILE), "UTF-8"));
            int l2 = 1;
            Area currArea = null;
            while ((line = br.readLine()) != null) {
                try {
                    line = line.trim();
                    if (line.length() > 0 && line.startsWith(String.valueOf(this.name) + ".")) {
                        String[] siid_name = line.split("=");
                        String siid = siid_name[0].trim().substring(this.name.length() + 1).toLowerCase();
                        String name = siid_name[1].trim();
                        if (siid.contains("area")) {
                            currArea = new Area(siid, name);
                            this.areas.add(currArea);
                        } else if (siid.contains("point")) {
                            Point p = new Point(siid, name, currArea.siid);
                            this.points.add(p);
                        }
                    }
                }
                catch (Exception e2) {
                    this.errorLog("error in 'boschmap.ini', line " + l2 + ": " + e2);
                }
                ++l2;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void authenticate(String user2, String password) throws Exception {
        byte[] userBytes = user2.getBytes(Charset.forName("UTF-8"));
        byte[] passwordBytes = password.getBytes(Charset.forName("UTF-8"));
        if (userBytes.length > 16) {
            throw new Exception("username too long: max 16 bytes");
        }
        if (passwordBytes.length > 16) {
            throw new Exception("password too long: max 16 bytes");
        }
        byte[] data = new byte[userBytes.length + passwordBytes.length + 2];
        int i2 = 0;
        while (i2 < userBytes.length) {
            data[i2] = userBytes[i2];
            ++i2;
        }
        data[userBytes.length] = 0;
        i2 = 0;
        while (i2 < passwordBytes.length) {
            data[userBytes.length + 1 + i2] = passwordBytes[i2];
            ++i2;
        }
        data[data.length - 1] = 0;
        this.send(118, data, false);
        long end = System.currentTimeMillis() + 20000L;
        while (this.authenticated == null && System.currentTimeMillis() < end) {
            Thread.sleep(500L);
        }
        if (this.authenticated == null || !this.authenticated.booleanValue()) {
            throw new Exception("authentication failed");
        }
        this.messageLog("authenticated");
    }

    private synchronized void send(int type, byte[] data, boolean waitForResponse) throws Exception {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        buff.write(126);
        this.stuffAndWrite(type >>> 8, buff);
        this.stuffAndWrite(type, buff);
        if (data != null) {
            this.stuffAndWrite(data.length >>> 8, buff);
            this.stuffAndWrite(data.length, buff);
            byte[] byArray = data;
            int n2 = data.length;
            int n3 = 0;
            while (n3 < n2) {
                byte b2 = byArray[n3];
                this.stuffAndWrite(b2, buff);
                ++n3;
            }
        } else {
            buff.write(0);
            buff.write(0);
        }
        buff.write(125);
        buff.write(32);
        buff.flush();
        byte[] toSend = buff.toByteArray();
        if (Configuration.verboseLog) {
            StringBuilder sb = new StringBuilder(">>");
            byte[] byArray = toSend;
            int n4 = toSend.length;
            int n5 = 0;
            while (n5 < n4) {
                byte b3 = byArray[n5];
                sb.append(" ");
                sb.append(Integer.toHexString(b3 & 0xFF | 0x100).substring(1));
                ++n5;
            }
            this.messageLog(sb.toString());
        }
        this.outputStream.write(toSend);
        this.outputStream.flush();
        if (waitForResponse) {
            int i2 = 0;
            while (i2 < 4) {
                Byte resp = this.respQ.poll(10L, TimeUnit.SECONDS);
                if (resp == null) {
                    this.errorLog("No response received");
                    return;
                }
                if (resp == (byte)type) {
                    return;
                }
                ++i2;
            }
            this.errorLog("Response error");
        }
    }

    private void stuffAndWrite(int b2, ByteArrayOutputStream buff) throws IOException {
        switch (b2 &= 0xFF) {
            case 126: {
                buff.write(125);
                buff.write(94);
                break;
            }
            case 125: {
                buff.write(125);
                buff.write(93);
                break;
            }
            default: {
                buff.write(b2);
            }
        }
    }

    public boolean loop() {
        block9: {
            Thread.sleep(10000L);
            if (this.lastHeartbeat < System.currentTimeMillis() - 20000L) {
                this.send(102, null, false);
            }
            if (this.lastHeartbeat >= System.currentTimeMillis() - 60000L) break block9;
            return false;
        }
        try {
            if (this.lastAreasStatusRequest < System.currentTimeMillis() - 600000L) {
                for (Area a2 : this.areas) {
                    if (Configuration.verboseLog) {
                        this.messageLog("Requesting status of area: " + a2.siidString);
                    }
                    this.send(114, a2.siid, true);
                    if (Configuration.verboseLog) {
                        this.messageLog("Requesting pending alarms for area: " + a2.siidString);
                    }
                    this.send(116, a2.siid, false);
                    Thread.sleep(100L);
                }
                this.lastAreasStatusRequest = System.currentTimeMillis();
            }
            for (Point p : this.points) {
                this.requestPointStatus(p);
            }
            return !this.quit;
        }
        catch (Exception e2) {
            this.errorLog("exception in loop - " + e2);
            return false;
        }
    }

    private void requestPointStatus(Point p) throws Exception {
        if (p.readable) {
            if (Configuration.verboseLog) {
                this.messageLog("Requesting status of point: " + p.siidString);
            }
            this.send(112, p.siid, true);
        }
    }

    private String siidToString(byte[] message, int shift) {
        int net1 = message[shift] & 0xFF;
        int net2 = message[shift + 1] & 0xFF;
        int typeM = message[shift + 2] & 0xFF;
        int typeL = message[shift + 3] & 0xFF;
        String type = null;
        if (typeM == 16) {
            switch (typeL) {
                case 1: {
                    type = "panel";
                    break;
                }
                case 2: {
                    type = "manager";
                    break;
                }
                case 3: {
                    type = "container";
                    break;
                }
                case 4: {
                    type = "transient";
                    break;
                }
                case 5: {
                    type = "group";
                    break;
                }
                case 6: {
                    type = "module";
                    break;
                }
                case 7: {
                    type = "point";
                    break;
                }
                case 8: {
                    type = "mhapi";
                    break;
                }
                case 9: {
                    type = "area";
                    break;
                }
                case 10: {
                    type = "detectorzone";
                    break;
                }
                case 11: {
                    type = "controlpanelarea";
                    break;
                }
                case 12: {
                    type = "resetgroup";
                    break;
                }
                case 13: {
                    type = "communicator";
                    break;
                }
                case 14: {
                    type = "output";
                    break;
                }
                case 15: {
                    type = "peripheralbus";
                    break;
                }
                case 16: {
                    type = "gateway";
                    break;
                }
                case 17: {
                    type = "system";
                    break;
                }
                case 18: {
                    type = "userinterface";
                    break;
                }
                case 19: {
                    type = "systemkeypad";
                    break;
                }
                case 20: {
                    type = "simulator";
                    break;
                }
                case 21: {
                    type = "armingdevice";
                    break;
                }
                case 22: {
                    type = "coordinator";
                    break;
                }
                case 23: {
                    type = "schedule";
                    break;
                }
                case 24: {
                    type = "timewindow";
                    break;
                }
                case 25: {
                    type = "powersupply";
                    break;
                }
                case 26: {
                    type = "printer";
                    break;
                }
                case 27: {
                    type = "lpr";
                    break;
                }
                case 28: {
                    type = "internalprogram";
                    break;
                }
                case 29: {
                    type = "keyswitch";
                    break;
                }
            }
        }
        if (type == null) {
            type = "unknown";
        }
        int numM = message[shift + 4] & 0xFF;
        int numL = message[shift + 5] & 0xFF;
        int num = (numM << 8) + numL;
        int subNumM = message[shift + 6] & 0xFF;
        int subNumL = message[shift + 7] & 0xFF;
        int subNum = (subNumM << 8) + subNumL;
        return String.valueOf(net1) + "." + net2 + "." + type + "." + num + "." + subNum;
    }

    private byte[] siidToBytes(String siidString, int type) {
        String[] flds = siidString.split("\\.");
        byte[] siid = new byte[8];
        siid[0] = (byte)Integer.parseInt(flds[0]);
        siid[1] = (byte)Integer.parseInt(flds[1]);
        siid[2] = 16;
        siid[3] = (byte)type;
        int siNumber = Integer.parseInt(flds[3]);
        siid[4] = (byte)(siNumber >>> 8);
        siid[5] = (byte)siNumber;
        int siSubNumber = Integer.parseInt(flds[4]);
        siid[6] = (byte)(siSubNumber >>> 8);
        siid[7] = (byte)siSubNumber;
        return siid;
    }

    private Area getAddressedArea(byte[] message, int offset) {
        for (Area a2 : this.areas) {
            if (!a2.messageForMe(message, offset)) continue;
            return a2;
        }
        return null;
    }

    private Point getAddressedPoint(byte[] message, int offset) {
        for (Point p : this.points) {
            if (!p.messageForMe(message, offset)) continue;
            return p;
        }
        return null;
    }

    private Area getAreaBySIID(String siid) {
        for (Area a2 : this.areas) {
            if (!a2.siidString.equals(siid)) continue;
            return a2;
        }
        return null;
    }

    private Point getPointBySIID(String siid) {
        for (Point p : this.points) {
            if (!p.siidString.equals(siid)) continue;
            return p;
        }
        return null;
    }

    public boolean end() {
        this.quit = true;
        try {
            this.outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.inputStram.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.clientSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sshConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ioWrite("connection", "offline");
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        try {
            Point p;
            this.messageLog("Command: " + name + " = " + value);
            int sep = name.indexOf(46, name.indexOf(46, name.indexOf(46, name.indexOf(46, name.indexOf(46) + 1) + 1) + 1) + 1);
            String siid = name.substring(0, sep);
            String command = name.substring(sep + 1);
            if (siid.contains(".area.") || siid.contains(".controlpanelarea.")) {
                Area a2 = this.getAreaBySIID(siid);
                if (a2 != null) {
                    if (command.equals("armed")) {
                        byte[] data = new byte[9];
                        data[0] = (byte)Integer.parseInt(value);
                        System.arraycopy(a2.siid, 0, data, 1, a2.siid.length);
                        this.send(86, data, false);
                    } else if (command.equals("clearmem") && value.equals("1")) {
                        this.send(107, a2.siid, false);
                    }
                } else if (siid.endsWith(".area.0.0") && command.equals("clearmem") && value.equals("1")) {
                    this.send(107, this.siidToBytes(siid, 9), false);
                }
            } else if (siid.contains(".point.") && (p = this.getPointBySIID(siid)) != null) {
                if (command.equals("bypassed")) {
                    byte[] data = new byte[17];
                    data[0] = (byte)Integer.parseInt(value);
                    System.arraycopy(p.areaSiid, 0, data, 1, p.areaSiid.length);
                    System.arraycopy(p.siid, 0, data, 9, p.siid.length);
                    this.send(84, data, false);
                } else if (command.equals("reset") && value.equals("1")) {
                    byte[] data = new byte[16];
                    System.arraycopy(p.areaSiid, 0, data, 0, p.areaSiid.length);
                    System.arraycopy(p.siid, 0, data, 8, p.siid.length);
                    this.send(83, data, false);
                } else if (command.equals("open") && value.equals("read")) {
                    this.requestPointStatus(p);
                }
            }
        }
        catch (Exception e2) {
            this.errorLog("Exception executing command: " + e2);
        }
    }

    public void ioWrite(boolean event, String name, String value) {
        if (event) {
            this.ioWrite(name, value);
        } else {
            this.ioWriteNoEvents(name, value);
        }
    }

    @Override
    public void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    public void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }

    private class Area
    extends Device {
        private int armed;
        private int ready;
        private int bypassed;
        private int alarm;
        private int trouble;
        private int tamper;

        public Area(String siidString, String name) {
            super(siidString, siidString.contains(".area.") ? 9 : 11, name);
            this.armed = -1;
            this.ready = -1;
            this.bypassed = -1;
            this.alarm = -1;
            this.trouble = -1;
            this.tamper = -1;
        }

        public void setAlarm(int b2) {
            if (this.alarm != (b2 &= 0xFF)) {
                this.alarm = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".alarm", "" + b2);
            }
        }

        public void setTrouble(int b2) {
            if (this.trouble != (b2 &= 0xFF)) {
                this.trouble = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".trouble", "" + b2);
            }
        }

        public void setTamper(int b2) {
            if (this.tamper != (b2 &= 0xFF)) {
                this.tamper = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".tamper", "" + b2);
            }
        }

        public void setState(byte bm, byte bl) {
            this.setAlarm(bl & 1 | bm & 1);
            this.setTrouble(bl >>> 1 & 1);
            this.setTamper(bl >>> 2 & 1);
        }

        public void setBypassed(int b2) {
            int n2 = b2 = b2 == 0 ? 0 : 1;
            if (this.bypassed != b2) {
                this.bypassed = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".bypassed", "" + b2);
            }
        }

        public void setReadyToArm(int bf) {
            if (this.ready != bf) {
                this.ready = bf;
                int b2 = bf & 1;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".ready.arm.instant", "" + b2);
                b2 = bf >>> 1 & 1;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".ready.arm.delay", "" + b2);
                b2 = bf >>> 2 & 1;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".ready.disarm", "" + b2);
                b2 = bf >>> 3 & 1;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".ready.force.instant", "" + b2);
                b2 = bf >>> 4 & 1;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".ready.force.delay", "" + b2);
            }
        }

        public void setArmed(int b2) {
            if (this.armed != (b2 &= 0xFF)) {
                this.armed = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".armed", "" + b2);
                if (this.armed == 1) {
                    Driver.this.ioWrite(Driver.this.genEvent, "armed", "1");
                } else {
                    for (Area a2 : Driver.this.areas) {
                        if (a2.armed != 1) continue;
                        return;
                    }
                    Driver.this.ioWrite(Driver.this.genEvent, "armed", "0");
                }
            }
        }
    }

    private class Device {
        protected final String siidString;
        protected final byte[] siid;

        public Device(String siidString, int type, String name) {
            this.siid = Driver.this.siidToBytes(siidString, type);
            this.siidString = Driver.this.siidToString(this.siid, 0);
            Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".name", name);
        }

        public boolean messageForMe(byte[] message, int offset) {
            int i2 = 0;
            while (i2 < this.siid.length) {
                if (this.siid[i2] != message[i2 + offset]) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
    }

    private class Monitor
    extends Thread {
        ByteArrayOutputStream readDada;

        private Monitor() {
        }

        @Override
        public void run() {
            Driver.this.messageLog("Monitor started");
            int lastByte = 0;
            try {
                while (!Driver.this.quit) {
                    int b2 = Driver.this.inputStram.read();
                    if (b2 == 126) {
                        if (this.readDada != null && Configuration.verboseLog) {
                            Driver.this.messageLog("Warning: Non-terminated message received");
                        }
                        this.readDada = new ByteArrayOutputStream();
                    } else if (this.readDada != null) {
                        if (b2 != 125) {
                            if (lastByte == 125) {
                                if (b2 == 32) {
                                    this.readDada.flush();
                                    byte[] message = this.readDada.toByteArray();
                                    if (Configuration.verboseLog) {
                                        StringBuilder sb = new StringBuilder("<<");
                                        byte[] byArray = message;
                                        int n2 = message.length;
                                        int n3 = 0;
                                        while (n3 < n2) {
                                            byte m2 = byArray[n3];
                                            sb.append(" ");
                                            sb.append(Integer.toHexString(m2 & 0xFF | 0x100).substring(1));
                                            ++n3;
                                        }
                                        Driver.this.messageLog(sb.toString());
                                    }
                                    this.processMessage(message);
                                    this.readDada = null;
                                } else {
                                    this.readDada.write(b2 ^ 0x20);
                                }
                            } else {
                                this.readDada.write(b2);
                            }
                        }
                    } else if (Configuration.verboseLog) {
                        Driver.this.messageLog("Warning: Non-initiated message received");
                    }
                    lastByte = b2;
                }
            }
            catch (Exception e2) {
                Driver.this.errorLog("Exception in monitor: " + e2);
            }
            Driver.this.messageLog("Monitor quitted");
            Driver.this.quit = true;
        }

        private void processMessage(byte[] message) throws Exception {
            if (message != null) {
                if (message[0] == -128 && message[1] == 102) {
                    Driver.this.lastHeartbeat = System.currentTimeMillis();
                } else if (message[0] == 0) {
                    if (message[1] == 52 || message[1] == 59) {
                        int val = message[4] & 0xFF;
                        if (Driver.this.alarm != val) {
                            Driver.this.alarm = val;
                            Driver.this.ioWrite(Driver.this.genEvent, "alarm", "" + val);
                        }
                    } else if (message[1] == 53) {
                        int val = message[4] & 0xFF;
                        if (Driver.this.trouble != val) {
                            Driver.this.trouble = val;
                            Driver.this.ioWrite(Driver.this.genEvent, "trouble", "" + val);
                        }
                    } else if (message[1] == 54) {
                        int val = message[4] & 0xFF;
                        if (Driver.this.tamper != val) {
                            Driver.this.tamper = val;
                            Driver.this.ioWrite(Driver.this.genEvent, "tamper", "" + val);
                        }
                    } else if (message[1] == 64) {
                        int val = message[4] & 0xFF;
                        if (Driver.this.userTamper != val) {
                            Driver.this.userTamper = val;
                            Driver.this.ioWrite(Driver.this.genEvent, "user.tamper", "" + val);
                        }
                    } else if (message[1] == 23) {
                        Area a2 = Driver.this.getAddressedArea(message, 4);
                        if (a2 != null) {
                            a2.setArmed(message[12]);
                            a2.setReadyToArm(message[13]);
                        }
                    } else if (message[1] == 39 || message[1] == 47) {
                        Area a3 = Driver.this.getAddressedArea(message, 5);
                        if (a3 != null) {
                            a3.setAlarm(message[4]);
                        }
                    } else if (message[1] == 40) {
                        Area a4 = Driver.this.getAddressedArea(message, 5);
                        if (a4 != null) {
                            a4.setTrouble(message[4]);
                        }
                    } else if (message[1] == 41) {
                        Area a5 = Driver.this.getAddressedArea(message, 5);
                        if (a5 != null) {
                            a5.setTamper(message[4]);
                        }
                    } else if (message[1] == 4) {
                        Point p = Driver.this.getAddressedPoint(message, 13);
                        if (p != null) {
                            p.setAlarm(message[4]);
                        }
                    } else if (message[1] == 6) {
                        Point p = Driver.this.getAddressedPoint(message, 13);
                        if (p != null) {
                            p.setHoldup(message[4]);
                        }
                    } else if (message[1] == 7) {
                        Point p = Driver.this.getAddressedPoint(message, 13);
                        if (p != null) {
                            p.setDuress(message[4]);
                        }
                    } else if (message[1] == 12) {
                        Point p = Driver.this.getAddressedPoint(message, 13);
                        if (p != null) {
                            p.setTamper(message[4]);
                        }
                    } else if (message[1] == 21) {
                        Point p = Driver.this.getAddressedPoint(message, 13);
                        if (p != null) {
                            p.setBypassed(message[4]);
                        }
                    } else if (message[1] == 22) {
                        Point p = Driver.this.getAddressedPoint(message, 13);
                        if (p != null) {
                            p.setBlocked(message[4]);
                        }
                    } else if (message[1] == 13 || message[1] == 76) {
                        String siid = Driver.this.siidToString(message, 13);
                        String value = message[4] == 0 ? "0" : "1";
                        Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(siid) + ".tamper", value);
                    } else if (message[1] == 66 || message[1] == 77 || message[1] == 78) {
                        String siid = Driver.this.siidToString(message, 13);
                        String value = message[4] == 0 ? "0" : "1";
                        Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(siid) + ".trouble", value);
                    } else if (message[1] == 79) {
                        String siid = Driver.this.siidToString(message, 13);
                        String value = message[4] == 0 ? "0" : "1";
                        Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(siid) + ".alarm", value);
                    } else if (message[1] == 75) {
                        String siid = Driver.this.siidToString(message, 13);
                        String value = message[4] == 0 ? "0" : "1";
                        Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(siid) + ".open", value);
                    } else if (message[1] == 67) {
                        String siid = Driver.this.siidToString(message, 5);
                        String value = message[4] == 0 ? "0" : "1";
                        Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(siid) + ".active", value);
                    } else if (Configuration.verboseLog) {
                        Driver.this.messageLog("unknown message: 0x" + Integer.toHexString(message[0] & 0xFF | 0x100).substring(1) + Integer.toHexString(message[1] & 0xFF | 0x100).substring(1));
                    }
                } else if (message[0] == -128) {
                    Driver.this.respQ.offer(message[1]);
                    if (message[1] == 118) {
                        if (message[4] != 1) {
                            Driver.this.errorLog("authentication error: code " + (message[5] & 0xFF));
                            Driver.this.authenticated = false;
                        } else {
                            Driver.this.authenticated = true;
                        }
                    } else if (message[1] == 114) {
                        Area a6 = Driver.this.getAddressedArea(message, 4);
                        a6.setArmed(message[12]);
                        a6.setReadyToArm(message[13]);
                        a6.setBypassed(message[17]);
                        a6.setState(message[21], message[22]);
                    } else if (message[1] == 126) {
                        int i2 = 13;
                        while (i2 < message.length) {
                            Point p = Driver.this.getAddressedPoint(message, i2);
                            if (p != null) {
                                p.setBlocked(1);
                            }
                            i2 += 8;
                        }
                    } else if (message[1] == 127) {
                        int i3 = 13;
                        while (i3 < message.length) {
                            Point p = Driver.this.getAddressedPoint(message, i3);
                            if (p != null) {
                                p.setBypassed(message[i3 + 8]);
                            }
                            i3 += 9;
                        }
                    } else if (message[1] == 112) {
                        Point p = Driver.this.getAddressedPoint(message, 4);
                        p.setLogicalState(message[13]);
                    }
                } else if (Configuration.verboseLog) {
                    Driver.this.messageLog("unknown message: 0x" + Integer.toHexString(message[0] & 0xFF | 0x100).substring(1) + Integer.toHexString(message[1] & 0xFF | 0x100).substring(1));
                }
            }
        }
    }

    private class Point
    extends Device {
        private final byte[] areaSiid;
        private final boolean readable;
        private int alarm;
        private int holdup;
        private int duress;
        private int tamper;
        private int bypassed;
        private int blocked;
        private int open;

        public Point(String siidString, String name, byte[] areaSiid) {
            super(siidString, 7, name);
            this.alarm = -1;
            this.holdup = -1;
            this.duress = -1;
            this.tamper = -1;
            this.bypassed = -1;
            this.blocked = -1;
            this.open = -1;
            this.readable = !siidString.endsWith(".noread");
            this.areaSiid = areaSiid;
        }

        public void setLogicalState(int b2) {
            int n2 = b2 = b2 == 5 ? 1 : 0;
            if (this.open != b2) {
                this.open = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".open", "" + b2);
            }
        }

        public void setAlarm(int b2) {
            int n2 = b2 = b2 == 0 ? 0 : 1;
            if (this.alarm != b2) {
                this.alarm = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".alarm", "" + b2);
            }
        }

        public void setHoldup(int b2) {
            int n2 = b2 = b2 == 0 ? 0 : 1;
            if (this.holdup != b2) {
                this.holdup = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".holdup", "" + b2);
            }
        }

        public void setDuress(int b2) {
            int n2 = b2 = b2 == 0 ? 0 : 1;
            if (this.duress != b2) {
                this.duress = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".duress", "" + b2);
            }
        }

        public void setTamper(int b2) {
            int n2 = b2 = b2 == 0 ? 0 : 1;
            if (this.tamper != b2) {
                this.tamper = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".tamper", "" + b2);
            }
        }

        public void setBypassed(int b2) {
            if (this.bypassed != (b2 &= 0xFF)) {
                this.bypassed = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".bypassed", "" + b2);
            }
        }

        public void setBlocked(int b2) {
            if (this.blocked != (b2 &= 0xFF)) {
                this.blocked = b2;
                Driver.this.ioWrite(Driver.this.genEvent, String.valueOf(this.siidString) + ".blocked", "" + b2);
            }
        }
    }
}

