/*
 * Decompiled with CFR 0.152.
 */
package drivers.alert5;

import com.hsyco.driverBase;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import drivers.alert5.Area;
import drivers.alert5.Device;
import drivers.alert5.Log;
import drivers.alert5.System;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 502;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final int DEFAULTPOLLINTERVAL = 1000;
    public static final int DEFAULTLOGSIZE = 100;
    public static String UIPREFIX;
    private String host = null;
    private boolean gui = true;
    private boolean startupevent = true;
    private int sessionIndex = 0;
    private String name = null;
    private String username = "cliente";
    private String password = "cliente";
    private int logSize = 100;
    public int pollinterval = 1000;
    private Vector<String> logs;
    long lastLogTs = 0L;
    private String logsVar;
    private String lastLogVar;
    private Log mostRecentLog;
    private ArrayList<Log> templogs = new ArrayList();
    private HashMap<Integer, System> systems = new HashMap();
    private ArrayList<String> sessions = new ArrayList();
    private String userToken = "";
    private String sessionToken = "";
    private boolean firstLoop = true;
    public static final String[] WEBOBJECTS;

    static {
        WEBOBJECTS = new String[]{"alert5"};
    }

    public boolean init(String name, HashMap<String, String> config) {
        block18: {
            block19: {
                super.init(name);
                this.name = name;
                UIPREFIX = String.valueOf(name) + ".";
                try {
                    this.host = String.valueOf(config.get("host")) + ":" + config.get("port");
                }
                catch (Exception e2) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
                    return false;
                }
                try {
                    this.gui = Boolean.parseBoolean(config.get("gui"));
                }
                catch (Exception e3) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - gui ignored");
                }
                this.startupevent = Boolean.parseBoolean(config.get("startupevents"));
                if (config.containsKey("gui")) {
                    this.gui = Boolean.parseBoolean(config.get("gui"));
                }
                try {
                    int timer = Integer.parseInt(config.get("pollinterval"));
                    if (timer >= 100 && timer <= 30000) {
                        this.pollinterval = timer;
                    }
                }
                catch (Exception e4) {
                    this.messageLog(String.valueOf(name) + ": pollinterval ignored");
                }
                try {
                    this.username = config.get("user");
                }
                catch (Exception e5) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - user ignored");
                    return false;
                }
                try {
                    this.password = config.get("password");
                }
                catch (Exception e6) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - password gui ignored");
                    return false;
                }
                try {
                    int n2 = Integer.parseInt(config.get("logsize"));
                    if (n2 >= 0) {
                        this.logSize = n2;
                    }
                }
                catch (Exception e7) {
                    this.messageLog(String.valueOf(name) + ": logsize ignored");
                }
                this.loadLogs();
                if (!this.requestInfo()) break block18;
                if (!this.requestAuth()) break block19;
                this.messageLog(String.valueOf(name) + " - driver started | username: " + this.username + " | password: " + this.password + " | startupevents: " + this.startupevent + " | pollinterval: " + this.pollinterval);
                return true;
            }
            try {
                this.errorLog(String.valueOf(name) + " : authorization error");
            }
            catch (Exception e8) {
                this.errorLog(String.valueOf(name) + " : info request error | " + e8.toString());
            }
        }
        return false;
    }

    public boolean loop() {
        try {
            this.systemsStatus();
            this.areasStatus();
            this.devicesStatus();
            this.logs();
        }
        catch (Exception e2) {
            if (this.isVerboseLog()) {
                this.errorLog(String.valueOf(this.name) + " : polling error on status request | " + e2.toString());
            }
            try {
                if (!this.refreshSession()) {
                    return false;
                }
            }
            catch (JSONException e1) {
                if (this.isVerboseLog()) {
                    this.errorLog(String.valueOf(this.name) + " : polling error refresh session request | " + e1.toString());
                }
                return false;
            }
        }
        if (this.firstLoop) {
            this.firstLoop = false;
            this.initializeUILists();
            this.ioWrite("connection", "online");
            this.securityLog("HSYCO ONLINE");
            userBase.uiSet(String.valueOf(UIPREFIX) + "connection.online", "visible", "false");
            userBase.uiSet(String.valueOf(UIPREFIX) + "connection.panel", "visible", "false");
        }
        this.updateGUISystemsInterfaceAndAreaAlarms();
        for (String session : this.sessions) {
            this.updateGUIAreasAndDevicesInterface(session);
        }
        if (this.lastLogTs != 0L && java.lang.System.currentTimeMillis() > this.lastLogTs + 5000L) {
            this.uiSet("log0", "value", "");
            this.lastLogTs = 0L;
        }
        this.sleep(1000L);
        return true;
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.securityLog("HSYCO OFFLINE");
            userBase.uiSet(String.valueOf(UIPREFIX) + "connection.online", "visible", "true");
            userBase.uiSet(String.valueOf(UIPREFIX) + "connection.panel", "visible", "true");
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        this.addSession(session);
        if (id.startsWith("systems.list")) {
            String num = id.split("\\.")[2];
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "system.internal", num);
            String desc = userBase.ioGet(String.valueOf(this.name) + ".sys." + num + ".desc");
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "system.sel.name", "value", "Apparato " + num + " - " + desc);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "system.sel.cont", "visible", "true");
            return "!";
        }
        if (id.equals("system.sel.close")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "system.sel.cont", "visible", "false");
            return "!";
        }
        if (id.equals("subsystem.reset.alarms")) {
            String system = userBase.uiGet(session, String.valueOf(UIPREFIX) + "system.internal");
            int resetAlarms = 9;
            this.command("sys." + system + ".command." + resetAlarms, "1");
            return "!";
        }
        if (id.startsWith("systems.select")) {
            String num = id.split("\\.")[2];
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "systems.select", "value", num);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "area.sel.cont", "visible", "false");
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "device.sel.cont", "visible", "false");
            StringBuilder values = new StringBuilder();
            StringBuilder labels = new StringBuilder();
            int sysId = Integer.parseInt(num);
            for (int areaId : this.systems.get((Object)Integer.valueOf((int)sysId)).areas.keySet()) {
                values.append("," + areaId);
                String desc = this.systems.get((Object)Integer.valueOf((int)sysId)).areas.get((Object)Integer.valueOf((int)areaId)).desc;
                labels.append(",Area - " + desc);
            }
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "areas.select", "values", values.length() == 0 ? "" : values.substring(1));
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "areas.select", "labels", labels.length() == 0 ? "" : labels.substring(1));
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "areas.select", "value", "");
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "devices.list", "values", "");
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "devices.list", "labels", "");
            this.updateGUIAreasAndDevicesInterface(session);
            return "!";
        }
        if (id.startsWith("areas.select")) {
            String num = id.split("\\.")[2];
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "areas.select", "value", num);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "device.sel.cont", "visible", "false");
            this.updateGUIAreasAndDevicesInterface(session);
            return "!";
        }
        if (id.startsWith("areas.list")) {
            String num = id.split("\\.")[2];
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "area.internal", num);
            String sysId = userBase.uiGet(session, String.valueOf(UIPREFIX) + "systems.select", "value");
            String desc = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".area." + num + ".desc");
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "area.sel.name", "value", "Area - " + desc);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "area.sel.cont", "visible", "true");
            return "!";
        }
        if (id.equals("area.sel.close")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "area.sel.cont", "visible", "false");
            return "!";
        }
        if (id.startsWith("subarea.armed")) {
            String area = userBase.uiGet(session, String.valueOf(UIPREFIX) + "area.internal");
            int cmd = id.endsWith("0") ? 10 : 11;
            this.command("area." + area + ".command." + cmd, "1");
            return "!";
        }
        if (id.startsWith("areas.armed")) {
            String sysId = userBase.uiGet(session, String.valueOf(UIPREFIX) + "systems.select", "value");
            int cmd = id.endsWith("0") ? 5 : 6;
            this.command("sys." + sysId + ".command." + cmd, "1");
            return "!";
        }
        if (id.startsWith("devices.list")) {
            String num = id.split("\\.")[2];
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "device.internal", num);
            String sysId = userBase.uiGet(session, String.valueOf(UIPREFIX) + "systems.select", "value");
            String areaId = userBase.uiGet(session, String.valueOf(UIPREFIX) + "areas.select", "value");
            String desc = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".area." + areaId + ".dev." + num + ".desc");
            this.updateGUIDevicePopup(session);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "device.sel.name", "value", "Dispositivo - " + desc);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "device.sel.cont", "visible", "true");
            return "!";
        }
        if (id.equals("device.sel.close")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "device.sel.cont", "visible", "false");
            return "!";
        }
        if (id.startsWith("device.sel")) {
            String device = userBase.uiGet(session, String.valueOf(UIPREFIX) + "device.internal");
            int cmd = id.endsWith("unbypass") ? 25 : (id.endsWith("bypass") ? 26 : 10);
            this.command("dev." + device + ".command." + cmd, "1");
            return "!";
        }
        return null;
    }

    public void command(String name, String value) {
        block36: {
            OutputStream os = null;
            BufferedReader in = null;
            try {
                System system;
                int idDispositivo;
                int idArea;
                int idApparato;
                String[] fields = name.split("\\.");
                if (name.startsWith("sys") && fields[2].equals("command") && value.equals("1")) {
                    idApparato = Integer.parseInt(fields[1]);
                    idArea = 0;
                    idDispositivo = 0;
                } else if (name.startsWith("area") && fields[2].equals("command") && value.equals("1")) {
                    idApparato = 0;
                    block22: for (int i2 : this.systems.keySet()) {
                        system = this.systems.get(i2);
                        for (int area : system.areas.keySet()) {
                            if (area != Integer.parseInt(fields[1])) continue;
                            idApparato = i2;
                            continue block22;
                        }
                    }
                    idArea = Integer.parseInt(fields[1]);
                    idDispositivo = 0;
                } else if (name.startsWith("dev") && fields[2].equals("command") && value.equals("1")) {
                    idApparato = 0;
                    idArea = 0;
                    for (int i3 : this.systems.keySet()) {
                        system = this.systems.get(i3);
                        block25: for (int a2 : system.areas.keySet()) {
                            Area area = system.areas.get(a2);
                            for (int d2 : area.devices.keySet()) {
                                if (d2 != Integer.parseInt(fields[1])) continue;
                                idApparato = i3;
                                idArea = a2;
                                continue block25;
                            }
                        }
                    }
                    idDispositivo = Integer.parseInt(fields[1]);
                } else {
                    return;
                }
                try {
                    String output;
                    int idCommand = Integer.parseInt(fields[3]);
                    JSONObject json = new JSONObject();
                    json = this.getOrderedJSONObject(json);
                    json.put("IdApparato", idApparato);
                    json.put("IdArea", idArea);
                    json.put("IdDispositivo", idDispositivo);
                    json.put("IdComando", idCommand);
                    URL url = new URL("http://" + this.host + "/protected/command");
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestProperty("Authorization", "Bearer " + this.userToken);
                    conn.setRequestProperty("Content-Type", "application/json");
                    conn.setDoOutput(true);
                    conn.setRequestMethod("POST");
                    os = conn.getOutputStream();
                    os.write(json.toString().getBytes());
                    os.flush();
                    in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuffer response = new StringBuffer();
                    while ((output = in.readLine()) != null) {
                        response.append(output);
                    }
                    json = new JSONObject(response.toString());
                    String desc = json.getString("descrizione");
                    if (!this.isVerboseLog()) break block36;
                    if (desc.equals("OK")) {
                        this.messageLog(String.valueOf(name) + ": command: " + name + ", value: " + value + " | OK");
                        break block36;
                    }
                    this.messageLog(String.valueOf(name) + ": error executing command: " + name + ", value: " + value + " | command rejected");
                }
                catch (Exception e2) {
                    if (this.isVerboseLog()) {
                        this.errorLog(String.valueOf(name) + ": error executing command: " + name + ", value: " + value + " | " + e2.toString());
                    }
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean requestInfo() throws JSONException {
        String resp = Driver.urlGet("http://" + this.host + "/info", null, null);
        if (resp != null) {
            this.messageLog(String.valueOf(this.name) + " : info request | host: " + this.host + " | response: " + resp);
            if (resp.startsWith("200:")) {
                String jsonString = resp.substring(4);
                JSONObject obj = new JSONObject(jsonString);
                int errore = obj.getInt("errore");
                this.ioWrite("global.error", String.valueOf(errore));
                this.ioWrite("global.desc", obj.getString("descrizione"));
                this.ioWrite("global.api.name", obj.getJSONObject("info").getJSONObject("info").getString("nome"));
                this.ioWrite("global.api.version", obj.getJSONObject("info").getJSONObject("info").getString("versione"));
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean requestAuth() throws JSONException {
        String jsonString = new JSONObject().put("username", this.username).put("password", this.password).toString();
        String resp = Driver.urlPost("http://" + this.host + "/sessions/create", "application/json", jsonString, null, null);
        if (resp.startsWith("200:")) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + " : info request | host: " + this.host + " | response: " + resp);
            }
            String jsonString2 = resp.substring(4);
            JSONObject obj = new JSONObject(jsonString2);
            this.userToken = obj.getJSONObject("info").getString("user_token");
            this.sessionToken = obj.getJSONObject("info").getString("session_token");
            return true;
        }
        return false;
    }

    private void systemsStatus() throws IOException {
        String output;
        URL url = new URL("http://" + this.host + "/protected/app");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + this.userToken);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((output = in.readLine()) != null) {
            response.append(output);
        }
        String jsonString5 = response.toString();
        try {
            try {
                JSONObject obj = new JSONObject(jsonString5);
                JSONObject obj2 = obj.getJSONObject("info");
                JSONArray jsonarray = obj2.getJSONArray("apparati");
                int i2 = 0;
                while (i2 < jsonarray.length()) {
                    JSONObject jsonobject = jsonarray.getJSONObject(i2);
                    int idApparato = jsonobject.getInt("IdApparato");
                    String desc = jsonobject.getString("Apparato");
                    String type = jsonobject.getString("TipoApparato");
                    if (this.firstLoop) {
                        this.systems.put(idApparato, new System(desc, type));
                        this.systemCommands(idApparato);
                    }
                    this.ioWrite("sys." + idApparato + ".desc", jsonobject.getString("Apparato"));
                    this.ioWrite("sys." + idApparato + ".type", type);
                    this.ioWrite("sys." + idApparato + ".status.connection", String.valueOf(jsonobject.getInt("StatoOperativo")));
                    this.ioWrite("sys." + idApparato + ".status.system", String.valueOf(jsonobject.getInt("StatoApparato")));
                    this.ioWrite("sys." + idApparato + ".status.alarm", String.valueOf(jsonobject.getInt("StatoAllarme")));
                    this.ioWrite("sys." + idApparato + ".status.fault", String.valueOf(jsonobject.getInt("StatoGuasto")));
                    ++i2;
                }
            }
            catch (JSONException e2) {
                if (this.isVerboseLog()) {
                    this.errorLog(String.valueOf(this.name) + " :  systems status request json parsing error | " + e2.toString());
                }
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void areasStatus() throws IOException {
        String output;
        URL url = new URL("http://" + this.host + "/protected/aree");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + this.userToken);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((output = in.readLine()) != null) {
            response.append(output);
        }
        String jsonString5 = response.toString();
        try {
            try {
                JSONObject obj = new JSONObject(jsonString5);
                JSONObject obj2 = obj.getJSONObject("info");
                JSONArray jsonarray = obj2.getJSONArray("aree");
                int i2 = 0;
                while (i2 < jsonarray.length()) {
                    JSONObject jsonobject = jsonarray.getJSONObject(i2);
                    int idApparato = jsonobject.getInt("IdApparato");
                    int idArea = jsonobject.getInt("IdArea");
                    String desc = jsonobject.getString("Area");
                    if (this.firstLoop) {
                        System system = this.systems.get(idApparato);
                        system.areas.put(idArea, new Area(desc));
                        this.systems.put(idApparato, system);
                        this.areaCommands(idArea);
                    }
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".desc", jsonobject.getString("Area"));
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".code", String.valueOf(jsonobject.getInt("Codice")));
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".status.connection", String.valueOf(jsonobject.getInt("StatoOperativo")));
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".status.area", String.valueOf(jsonobject.getInt("StatoArea")));
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".status.alarm", String.valueOf(jsonobject.getInt("StatoAllarme")));
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".status.fault", String.valueOf(jsonobject.getInt("StatoGuasto")));
                    ++i2;
                }
            }
            catch (JSONException e2) {
                if (this.isVerboseLog()) {
                    this.errorLog(String.valueOf(this.name) + " :  areas status request json parsing error | " + e2.toString());
                }
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void devicesStatus() throws IOException {
        String output;
        URL url = new URL("http://" + this.host + "/protected/dev");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + this.userToken);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((output = in.readLine()) != null) {
            response.append(output);
        }
        String jsonString5 = response.toString();
        try {
            try {
                JSONObject obj = new JSONObject(jsonString5);
                JSONObject obj2 = obj.getJSONObject("info");
                JSONArray jsonarray = obj2.getJSONArray("dispositivi");
                int i2 = 0;
                while (i2 < jsonarray.length()) {
                    JSONObject jsonobject = jsonarray.getJSONObject(i2);
                    int idApparato = jsonobject.getInt("IdApparato");
                    int idArea = jsonobject.getInt("IdArea");
                    int idDispositivo = jsonobject.getInt("IdDispositivo");
                    String desc = jsonobject.getString("Dispositivo");
                    if (this.firstLoop) {
                        System system = this.systems.get(idApparato);
                        Area area = system.areas.get(idArea);
                        area.devices.put(idDispositivo, new Device(desc));
                        system.areas.put(idArea, area);
                        this.systems.put(idApparato, system);
                        this.deviceCommands(idDispositivo);
                    }
                    int statoOperativo = jsonobject.getInt("StatoOperativo");
                    int statoDispositivo = jsonobject.getInt("StatoDispositivo");
                    int statoAllarme = jsonobject.getInt("StatoAllarme");
                    int statoGuasto = jsonobject.getInt("StatoGuasto");
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".dev." + idDispositivo + ".desc", jsonobject.getString("Dispositivo"));
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".dev." + idDispositivo + ".code", String.valueOf(jsonobject.getInt("Codice")));
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".dev." + idDispositivo + ".status.bypass", String.valueOf(statoOperativo));
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".dev." + idDispositivo + ".status.open", String.valueOf(statoDispositivo));
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".dev." + idDispositivo + ".status.alarm", String.valueOf(statoAllarme));
                    this.ioWrite("sys." + idApparato + ".area." + idArea + ".dev." + idDispositivo + ".status.fault", String.valueOf(statoGuasto));
                    if (this.gui) {
                        String visible = statoOperativo == 0 ? "true" : "false";
                        userBase.uiSet(String.valueOf(UIPREFIX) + "dev." + idDispositivo + ".status.bypass", "visible", visible);
                        visible = statoDispositivo == 1 ? "true" : "false";
                        userBase.uiSet(String.valueOf(UIPREFIX) + "dev." + idDispositivo + ".status.open", "visible", visible);
                        visible = statoAllarme == 1 ? "true" : "false";
                        userBase.uiSet(String.valueOf(UIPREFIX) + "dev." + idDispositivo + ".status.alarm", "visible", visible);
                    }
                    ++i2;
                }
            }
            catch (JSONException e2) {
                if (this.isVerboseLog()) {
                    this.errorLog(String.valueOf(this.name) + " :  devices status request json parsing error | " + e2.toString());
                }
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void logs() throws Exception {
        String output;
        this.templogs.clear();
        URL url = new URL("http://" + this.host + "/protected/events");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + this.userToken);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        JSONObject body = new JSONObject();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date());
        c2.add(5, -28);
        body.put("inizio", format.format(c2.getTime()));
        body.put("fine", format.format(new Date()));
        body.put("order", "DESC");
        body.put("limit", this.logSize);
        OutputStream os = conn.getOutputStream();
        os.write(body.toString().getBytes());
        os.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((output = in.readLine()) != null) {
            response.append(output);
        }
        String jsonString5 = response.toString();
        try {
            try {
                JSONObject obj = new JSONObject(jsonString5);
                JSONObject obj2 = obj.getJSONObject("info");
                JSONArray jsonarray = obj2.getJSONArray("eventi");
                Log firstLog = null;
                format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                int i2 = 0;
                while (i2 < jsonarray.length()) {
                    JSONObject jsonobject = jsonarray.getJSONObject(i2);
                    String d2 = jsonobject.getString("DataEvento");
                    Date date = format.parse(d2);
                    if (this.mostRecentLog != null && !date.after(this.mostRecentLog.getTime())) break;
                    String desc = jsonobject.getString("Evento");
                    String msg = "Evento: " + desc;
                    try {
                        String sys = jsonobject.getString("Apparato");
                        if (!sys.isEmpty()) {
                            msg = String.valueOf(msg) + ", Apparato: " + sys;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        String area = jsonobject.getString("Area");
                        if (!area.isEmpty()) {
                            msg = String.valueOf(msg) + ", Area: " + area;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        String dev = jsonobject.getString("Dispositivo");
                        if (!dev.isEmpty()) {
                            msg = String.valueOf(msg) + ", Dispositivo: " + dev;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        String cdc = jsonobject.getString("CodiceTessera");
                        if (cdc.isEmpty()) {
                            msg = String.valueOf(msg) + ", Codice Tessera: " + cdc;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        String ana = jsonobject.getString("Anagrafica");
                        if (!ana.isEmpty()) {
                            msg = String.valueOf(msg) + ", Anagrafica: " + ana;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Log log = new Log(date, msg);
                    this.templogs.add(log);
                    if (i2 == 0) {
                        firstLog = log;
                    }
                    ++i2;
                }
                if (firstLog != null) {
                    this.mostRecentLog = firstLog;
                }
                this.writeLogs();
            }
            catch (JSONException e2) {
                if (this.isVerboseLog()) {
                    this.errorLog(String.valueOf(this.name) + " :  logs request json parsing error | " + e2.toString());
                }
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean refreshSession() throws JSONException {
        String jsonString3 = new JSONObject().put("session_token", this.sessionToken).toString();
        String resp = Driver.urlPost("http://" + this.host + "/sessions/refresh", "application/json", jsonString3, null, null);
        if (resp.startsWith("200:")) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + " : refresh session request | host: " + this.host + " | response: " + resp);
            }
            String jsonString4 = resp.substring(4);
            JSONObject obj = new JSONObject(jsonString4);
            this.userToken = obj.getJSONObject("info").getString("user_token");
            return true;
        }
        return false;
    }

    private void loadLogs() {
        block12: {
            this.logsVar = "$__HSYCO__ALERT5_" + this.name + ".log!";
            this.lastLogVar = "$__HSYCO__ALERT5_" + this.name + ".last_log!";
            ObjectInputStream ois = null;
            try {
                try {
                    String s = userBase.varGet(this.logsVar);
                    if (s == null) {
                        this.logs = new Vector(this.logSize);
                    }
                    byte[] data = Base64.decodeBase64(s);
                    ois = new ObjectInputStream(new ByteArrayInputStream(data));
                    this.logs = (Vector)ois.readObject();
                }
                catch (Exception e2) {
                    this.logs = new Vector(this.logSize);
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    ois.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mostRecentLog = Log.readMostRecentLog(userBase.varGet(this.lastLogVar));
    }

    void securityLog(String event) {
        String message = event;
        hsyco.securityLog(String.valueOf(this.name) + " - " + message);
        String guiEntry = "<div style=\"font-size:12px\">" + message + "</div>";
        this.logs.add(0, guiEntry);
        while (this.logs.size() > this.logSize) {
            this.logs.remove(this.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            guiEntry = this.logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(guiEntry).append("</div>");
            ++i2;
        }
        this.uiSet("log", "value", text.toString());
        this.uiSet("log0", "value", message);
        this.lastLogTs = java.lang.System.currentTimeMillis();
        this.saveLogs();
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                userBase.varSet(this.logsVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    private void writeLogs() {
        Collections.reverse(this.templogs);
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        for (Log log : this.templogs) {
            this.securityLog(String.valueOf(format.format(log.getTime())) + " | " + log.msg);
        }
        if (this.mostRecentLog != null) {
            userBase.varSet(this.lastLogVar, String.valueOf(format.format(this.mostRecentLog.getTime())) + " | " + this.mostRecentLog.msg);
        }
    }

    private void systemCommands(int id) throws IOException {
        String output;
        URL url = new URL("http://" + this.host + "/protected/app/" + id);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + this.userToken);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((output = in.readLine()) != null) {
            response.append(output);
        }
        String jsonString5 = response.toString();
        try {
            try {
                JSONObject obj = new JSONObject(jsonString5);
                JSONObject obj2 = obj.getJSONObject("info");
                JSONArray jsonarray = obj2.getJSONArray("apparati");
                JSONObject jsonobject = jsonarray.getJSONObject(0);
                JSONArray commands = jsonobject.getJSONArray("Comandi");
                int i2 = 0;
                while (i2 < commands.length()) {
                    JSONObject command = commands.getJSONObject(i2);
                    int IdComando = command.getInt("IdComando");
                    String descrizione = command.getString("Descrizione");
                    this.ioWrite("sys." + id + ".command." + IdComando + ".desc", descrizione);
                    ++i2;
                }
            }
            catch (JSONException e2) {
                if (this.isVerboseLog()) {
                    this.errorLog(String.valueOf(this.name) + " :  system commands request json parsing error | " + e2.toString());
                }
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void areaCommands(int id) throws IOException {
        String output;
        URL url = new URL("http://" + this.host + "/protected/aree/" + id);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + this.userToken);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((output = in.readLine()) != null) {
            response.append(output);
        }
        String jsonString5 = response.toString();
        try {
            try {
                JSONObject obj = new JSONObject(jsonString5);
                JSONObject obj2 = obj.getJSONObject("info");
                JSONArray jsonarray = obj2.getJSONArray("aree");
                JSONObject jsonobject = jsonarray.getJSONObject(0);
                JSONArray commands = jsonobject.getJSONArray("Comandi");
                int i2 = 0;
                while (i2 < commands.length()) {
                    JSONObject command = commands.getJSONObject(i2);
                    int IdComando = command.getInt("IdComando");
                    String descrizione = command.getString("Descrizione");
                    this.ioWrite("area." + id + ".command." + IdComando + ".desc", descrizione);
                    ++i2;
                }
            }
            catch (JSONException e2) {
                if (this.isVerboseLog()) {
                    this.errorLog(String.valueOf(this.name) + " :  area commands request json parsing error | " + e2.toString());
                }
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void deviceCommands(int id) throws IOException {
        String output;
        URL url = new URL("http://" + this.host + "/protected/dev/" + id);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + this.userToken);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((output = in.readLine()) != null) {
            response.append(output);
        }
        String jsonString5 = response.toString();
        try {
            try {
                JSONObject obj = new JSONObject(jsonString5);
                JSONObject obj2 = obj.getJSONObject("info");
                JSONArray jsonarray = obj2.getJSONArray("dispositivi");
                JSONObject jsonobject = jsonarray.getJSONObject(0);
                JSONArray commands = jsonobject.getJSONArray("Comandi");
                int i2 = 0;
                while (i2 < commands.length()) {
                    JSONObject command = commands.getJSONObject(i2);
                    int IdComando = command.getInt("IdComando");
                    String descrizione = command.getString("Descrizione");
                    this.ioWrite("dev." + id + ".command." + IdComando + ".desc", descrizione);
                    ++i2;
                }
            }
            catch (JSONException e2) {
                if (this.isVerboseLog()) {
                    this.errorLog(String.valueOf(this.name) + " :  device commands request json parsing error | " + e2.toString());
                }
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void updateGUISystemsInterfaceAndAreaAlarms() {
        StringBuilder values = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        for (int sysId : this.systems.keySet()) {
            values.append(",").append(sysId);
            labels.append(",");
            String allarme = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".status.alarm");
            if (allarme.equals("1")) {
                labels.append("<img src=\"/blue/pic/inim/inim-alert.png\" width=\"25\" height=\"25\">");
            } else {
                labels.append("<img src=\"/blue/pic/inim/inim-alert-tr.png\" width=\"25\" height=\"25\">");
            }
            String operativo = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".status.system");
            if (!operativo.equals("1")) {
                labels.append("<e style=\"color:red\"> Apparato - " + this.systems.get((Object)Integer.valueOf((int)sysId)).desc + "</e>");
                continue;
            }
            labels.append(" Apparato - " + this.systems.get((Object)Integer.valueOf((int)sysId)).desc);
        }
        userBase.uiSet(String.valueOf(UIPREFIX) + "systems.list", "values", values.substring(1));
        userBase.uiSet(String.valueOf(UIPREFIX) + "systems.list", "labels", labels.substring(1));
        String genAlarm = "false";
        block1: for (int sysId : this.systems.keySet()) {
            System system = this.systems.get(sysId);
            for (int areaId : system.areas.keySet()) {
                String alarm = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".area." + areaId + ".status.alarm");
                if (alarm == null || !alarm.equals("1")) continue;
                genAlarm = "true";
                continue block1;
            }
        }
        userBase.uiSet(String.valueOf(UIPREFIX) + "area.alarm.mem.label.1", "visible", genAlarm);
    }

    private void updateGUIAreasAndDevicesInterface(String session) {
        block10: {
            try {
                StringBuilder values = new StringBuilder();
                StringBuilder labels = new StringBuilder();
                String sysId = userBase.uiGet(session, String.valueOf(UIPREFIX) + "systems.select", "value");
                if (sysId != null && !sysId.isEmpty()) {
                    String desc;
                    values = new StringBuilder();
                    labels = new StringBuilder();
                    for (int areaId : this.systems.get((Object)Integer.valueOf((int)Integer.parseInt((String)sysId))).areas.keySet()) {
                        values.append(",").append(areaId);
                        labels.append(",");
                        desc = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".area." + areaId + ".desc");
                        String inserita = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".area." + areaId + ".status.connection");
                        if (inserita.equals("1")) {
                            labels.append("<img src=\"/blue/pic/inim/inim-lock.png\" width=\"25\" height=\"25\">");
                        } else {
                            labels.append("<img src=\"/blue/pic/inim/inim-unlock-tr.png\" width=\"25\" height=\"25\">");
                        }
                        labels.append(" Area - " + desc);
                    }
                    userBase.uiSet(session, String.valueOf(UIPREFIX) + "areas.list", "values", values.substring(1));
                    userBase.uiSet(session, String.valueOf(UIPREFIX) + "areas.list", "labels", labels.substring(1));
                    String areaId = userBase.uiGet(session, String.valueOf(UIPREFIX) + "areas.select", "value");
                    if (areaId != null && !areaId.isEmpty()) {
                        values = new StringBuilder();
                        labels = new StringBuilder();
                        for (int devId : this.systems.get((Object)Integer.valueOf((int)Integer.parseInt((String)sysId))).areas.get((Object)Integer.valueOf((int)Integer.parseInt((String)areaId))).devices.keySet()) {
                            values.append(",").append(devId);
                            labels.append(",");
                            desc = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".area." + areaId + ".dev." + devId + ".desc");
                            labels.append("Dispositivo - " + desc);
                        }
                        userBase.uiSet(session, String.valueOf(UIPREFIX) + "devices.list", "values", values.substring(1));
                        userBase.uiSet(session, String.valueOf(UIPREFIX) + "devices.list", "labels", labels.substring(1));
                    } else {
                        userBase.uiSet(session, String.valueOf(UIPREFIX) + "devices.list", "values", "");
                        userBase.uiSet(session, String.valueOf(UIPREFIX) + "devices.list", "labels", "");
                    }
                    this.updateGUIDevicePopup(session);
                } else {
                    userBase.uiSet(session, String.valueOf(UIPREFIX) + "areas.list", "values", "");
                    userBase.uiSet(session, String.valueOf(UIPREFIX) + "areas.list", "labels", "");
                    userBase.uiSet(session, String.valueOf(UIPREFIX) + "devices.list", "values", "");
                    userBase.uiSet(session, String.valueOf(UIPREFIX) + "devices.list", "labels", "");
                }
            }
            catch (Exception e2) {
                if (!this.isVerboseLog()) break block10;
                this.errorLog(String.valueOf(this.name) + " : error while updating GUI object alert5 | " + e2.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(String session) {
        ArrayList<String> arrayList = this.sessions;
        synchronized (arrayList) {
            if (this.sessions.contains(session)) {
                return;
            }
            if (this.sessionIndex >= 10) {
                this.sessionIndex = 0;
            }
            this.sessions.add(this.sessionIndex++, session);
        }
    }

    private void initializeUILists() {
        block7: {
            try {
                StringBuilder values = new StringBuilder();
                StringBuilder labels = new StringBuilder();
                StringBuilder values2 = new StringBuilder();
                StringBuilder labels2 = new StringBuilder();
                for (int sysId : this.systems.keySet()) {
                    values.append(",").append(sysId);
                    values2.append(",").append(sysId);
                    labels.append(",");
                    String operativo = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".status.connection");
                    String allarme = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".status.alarm");
                    if (allarme.equals("1")) {
                        labels.append("<img src=\"/blue/pic/inim/inim-alert.png\" width=\"25\" height=\"25\">");
                    } else {
                        labels.append("<img src=\"/blue/pic/inim/inim-alert-tr.png\" width=\"25\" height=\"25\">");
                    }
                    if (operativo.equals("0")) {
                        labels.append("<e style=\"color:red\"> Apparato - " + this.systems.get((Object)Integer.valueOf((int)sysId)).desc + "</e>");
                    } else {
                        labels.append(" Apparato - " + this.systems.get((Object)Integer.valueOf((int)sysId)).desc);
                    }
                    labels2.append(",Apparato - " + this.systems.get((Object)Integer.valueOf((int)sysId)).desc);
                }
                userBase.uiSet(String.valueOf(UIPREFIX) + "systems.list", "values", values.substring(1));
                userBase.uiSet(String.valueOf(UIPREFIX) + "systems.list", "labels", labels.substring(1));
                userBase.uiSet(String.valueOf(UIPREFIX) + "systems.select", "values", values2.substring(1));
                userBase.uiSet(String.valueOf(UIPREFIX) + "systems.select", "labels", labels2.substring(1));
                userBase.uiSet(String.valueOf(UIPREFIX) + "areas.list", "values", "");
                userBase.uiSet(String.valueOf(UIPREFIX) + "areas.list", "labels", "");
                userBase.uiSet(String.valueOf(UIPREFIX) + "devices.list", "values", "");
                userBase.uiSet(String.valueOf(UIPREFIX) + "devices.list", "labels", "");
            }
            catch (Exception e2) {
                if (!this.isVerboseLog()) break block7;
                this.errorLog(String.valueOf(this.name) + " : error while creating GUI lists | " + e2.toString());
            }
        }
    }

    private void updateGUIDevicePopup(String session) {
        String sysId = userBase.uiGet(session, String.valueOf(UIPREFIX) + "systems.select", "value");
        String areaId = userBase.uiGet(session, String.valueOf(UIPREFIX) + "areas.select", "value");
        String devId = userBase.uiGet(session, String.valueOf(UIPREFIX) + "device.internal");
        String open = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".area." + areaId + ".dev." + devId + ".status.open");
        open = open.equals("1") ? "true" : "false";
        userBase.uiSet(session, String.valueOf(UIPREFIX) + "device.sel.open.label", "visible", open);
        String alarm = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".area." + areaId + ".dev." + devId + ".status.alarm");
        alarm = alarm.equals("1") ? "true" : "false";
        userBase.uiSet(session, String.valueOf(UIPREFIX) + "device.sel.alarm.label", "visible", alarm);
        String fault = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".area." + areaId + ".dev." + devId + ".status.fault");
        fault = fault.equals("1") ? "true" : "false";
        userBase.uiSet(session, String.valueOf(UIPREFIX) + "device.sel.fault.label", "visible", fault);
        String bypass = userBase.ioGet(String.valueOf(this.name) + ".sys." + sysId + ".area." + areaId + ".dev." + devId + ".status.bypass");
        bypass = bypass.equals("0") ? "true" : "false";
        userBase.uiSet(session, String.valueOf(UIPREFIX) + "device.sel.bypass.label", "visible", bypass);
    }

    private JSONObject getOrderedJSONObject(JSONObject jsonObject) {
        try {
            Field changeMap = jsonObject.getClass().getDeclaredField("map");
            changeMap.setAccessible(true);
            changeMap.set(jsonObject, new LinkedHashMap());
            changeMap.setAccessible(false);
        }
        catch (Exception e2) {
            this.errorLog(e2.getMessage());
        }
        return jsonObject;
    }
}

