/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Argument;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID {
    private Map<String, String> serverParams = null;

    public ID(Response r) throws ProtocolException {
        r.skipSpaces();
        byte c2 = r.peekByte();
        if (c2 == 78 || c2 == 110) {
            return;
        }
        if (c2 != 40) {
            throw new ProtocolException("Missing '(' at start of ID");
        }
        this.serverParams = new HashMap<String, String>();
        String[] v = r.readStringList();
        if (v != null) {
            for (int i2 = 0; i2 < v.length; i2 += 2) {
                String name = v[i2];
                if (name == null) {
                    throw new ProtocolException("ID field name null");
                }
                if (i2 + 1 >= v.length) {
                    throw new ProtocolException("ID field without value: " + name);
                }
                String value = v[i2 + 1];
                this.serverParams.put(name, value);
            }
        }
        this.serverParams = Collections.unmodifiableMap(this.serverParams);
    }

    Map<String, String> getServerParams() {
        return this.serverParams;
    }

    static Argument getArgumentList(Map<String, String> clientParams) {
        Argument arg = new Argument();
        if (clientParams == null) {
            arg.writeAtom("NIL");
            return arg;
        }
        Argument list = new Argument();
        for (Map.Entry<String, String> e2 : clientParams.entrySet()) {
            list.writeNString(e2.getKey());
            list.writeNString(e2.getValue());
        }
        arg.writeArgument(list);
        return arg;
    }
}

