/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.utilities;

import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHSwitchSerializer1;
import com.philips.lighting.hue.sdk.utilities.impl.Color;
import com.philips.lighting.hue.sdk.utilities.impl.PHHueHelper;
import com.philips.lighting.hue.sdk.utilities.impl.PointF;
import com.philips.lighting.model.sensor.metadata.PHSwitchDeviceInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHUtilities {
    private static final int CPT_RED = 0;
    private static final int CPT_GREEN = 1;
    private static final int CPT_BLUE = 2;
    private static List<PointF> colorPointsGamut_A = new ArrayList<PointF>();
    private static List<PointF> colorPointsGamut_B = new ArrayList<PointF>();
    private static List<PointF> colorPointsGamut_C = new ArrayList<PointF>();
    private static List<PointF> colorPointsDefault = new ArrayList<PointF>();
    private static final List<String> GAMUT_A_BULBS_LIST = new ArrayList<String>();
    private static final List<String> GAMUT_B_BULBS_LIST = new ArrayList<String>();
    private static final List<String> GAMUT_C_BULBS_LIST = new ArrayList<String>();
    private static final List<String> MULTI_SOURCE_LUMINAIRES = new ArrayList<String>();

    public static int colorFromXY(float[] points, String model) {
        if (points == null || model == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PointF xy = new PointF(points[0], points[1]);
        List<PointF> colorPoints = PHUtilities.colorPointsForModel(model);
        boolean inReachOfLamps = PHUtilities.checkPointInLampsReach(xy, colorPoints);
        if (!inReachOfLamps) {
            PointF pAB = PHUtilities.getClosestPointToPoints(colorPoints.get(0), colorPoints.get(1), xy);
            PointF pAC = PHUtilities.getClosestPointToPoints(colorPoints.get(2), colorPoints.get(0), xy);
            PointF pBC = PHUtilities.getClosestPointToPoints(colorPoints.get(1), colorPoints.get(2), xy);
            float dAB = PHUtilities.getDistanceBetweenTwoPoints(xy, pAB);
            float dAC = PHUtilities.getDistanceBetweenTwoPoints(xy, pAC);
            float dBC = PHUtilities.getDistanceBetweenTwoPoints(xy, pBC);
            float lowest = dAB;
            PointF closestPoint = pAB;
            if (dAC < lowest) {
                lowest = dAC;
                closestPoint = pAC;
            }
            if (dBC < lowest) {
                lowest = dBC;
                closestPoint = pBC;
            }
            xy.x = closestPoint.x;
            xy.y = closestPoint.y;
        }
        float x = xy.x;
        float y = xy.y;
        float z = 1.0f - x - y;
        float y2 = 1.0f;
        float x2 = y2 / y * x;
        float z2 = y2 / y * z;
        float r = x2 * 1.656492f - y2 * 0.354851f - z2 * 0.255038f;
        float g2 = -x2 * 0.707196f + y2 * 1.655397f + z2 * 0.036152f;
        float b2 = x2 * 0.051713f - y2 * 0.121364f + z2 * 1.01153f;
        if (r > b2 && r > g2 && r > 1.0f) {
            g2 /= r;
            b2 /= r;
            r = 1.0f;
        } else if (g2 > b2 && g2 > r && g2 > 1.0f) {
            r /= g2;
            b2 /= g2;
            g2 = 1.0f;
        } else if (b2 > r && b2 > g2 && b2 > 1.0f) {
            r /= b2;
            g2 /= b2;
            b2 = 1.0f;
        }
        r = r <= 0.0031308f ? 12.92f * r : 1.055f * (float)Math.pow(r, 0.4166666567325592) - 0.055f;
        g2 = g2 <= 0.0031308f ? 12.92f * g2 : 1.055f * (float)Math.pow(g2, 0.4166666567325592) - 0.055f;
        float f2 = b2 = b2 <= 0.0031308f ? 12.92f * b2 : 1.055f * (float)Math.pow(b2, 0.4166666567325592) - 0.055f;
        if (r > b2 && r > g2) {
            if (r > 1.0f) {
                g2 /= r;
                b2 /= r;
                r = 1.0f;
            }
        } else if (g2 > b2 && g2 > r) {
            if (g2 > 1.0f) {
                r /= g2;
                b2 /= g2;
                g2 = 1.0f;
            }
        } else if (b2 > r && b2 > g2 && b2 > 1.0f) {
            r /= b2;
            g2 /= b2;
            b2 = 1.0f;
        }
        if (r < 0.0f) {
            r = 0.0f;
        }
        if (g2 < 0.0f) {
            g2 = 0.0f;
        }
        if (b2 < 0.0f) {
            b2 = 0.0f;
        }
        int r1 = (int)(r * 255.0f);
        int g1 = (int)(g2 * 255.0f);
        int b1 = (int)(b2 * 255.0f);
        return Color.rgb(r1, g1, b1);
    }

    public static float[] calculateXY(int color, String model) {
        List<PointF> colorPoints;
        PointF xyPoint;
        boolean inReachOfLamps;
        float z;
        float y;
        float b2;
        float g2;
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        red = (float)Color.red(color) / 255.0f;
        float r = red > 0.04045f ? (float)Math.pow((red + 0.055f) / 1.055f, 2.4f) : red / 12.92f;
        float x = r * 0.664511f + (g2 = (green = (float)Color.green(color) / 255.0f) > 0.04045f ? (float)Math.pow((green + 0.055f) / 1.055f, 2.4f) : green / 12.92f) * 0.154324f + (b2 = (blue = (float)Color.blue(color) / 255.0f) > 0.04045f ? (float)Math.pow((blue + 0.055f) / 1.055f, 2.4f) : blue / 12.92f) * 0.162028f;
        float[] xy = new float[]{x / (x + (y = r * 0.283881f + g2 * 0.668433f + b2 * 0.047685f) + (z = r * 8.8E-5f + g2 * 0.07231f + b2 * 0.986039f)), y / (x + y + z)};
        if (Float.isNaN(xy[0])) {
            xy[0] = 0.0f;
        }
        if (Float.isNaN(xy[1])) {
            xy[1] = 0.0f;
        }
        if (!(inReachOfLamps = PHUtilities.checkPointInLampsReach(xyPoint = new PointF(xy[0], xy[1]), colorPoints = PHUtilities.colorPointsForModel(model)))) {
            PointF pAB = PHUtilities.getClosestPointToPoints(colorPoints.get(0), colorPoints.get(1), xyPoint);
            PointF pAC = PHUtilities.getClosestPointToPoints(colorPoints.get(2), colorPoints.get(0), xyPoint);
            PointF pBC = PHUtilities.getClosestPointToPoints(colorPoints.get(1), colorPoints.get(2), xyPoint);
            float dAB = PHUtilities.getDistanceBetweenTwoPoints(xyPoint, pAB);
            float dAC = PHUtilities.getDistanceBetweenTwoPoints(xyPoint, pAC);
            float dBC = PHUtilities.getDistanceBetweenTwoPoints(xyPoint, pBC);
            float lowest = dAB;
            PointF closestPoint = pAB;
            if (dAC < lowest) {
                lowest = dAC;
                closestPoint = pAC;
            }
            if (dBC < lowest) {
                lowest = dBC;
                closestPoint = pBC;
            }
            xy[0] = closestPoint.x;
            xy[1] = closestPoint.y;
        }
        xy[0] = PHHueHelper.precision(xy[0]);
        xy[1] = PHHueHelper.precision(xy[1]);
        return xy;
    }

    public static float[] calculateXYFromRGB(int red, int green, int blue, String model) {
        int rgb = Color.rgb(red, green, blue);
        return PHUtilities.calculateXY(rgb, model);
    }

    private static boolean checkPointInLampsReach(PointF point, List<PointF> colorPoints) {
        if (point == null || colorPoints == null) {
            return false;
        }
        PointF red = colorPoints.get(0);
        PointF green = colorPoints.get(1);
        PointF blue = colorPoints.get(2);
        PointF v1 = new PointF(green.x - red.x, green.y - red.y);
        PointF v2 = new PointF(blue.x - red.x, blue.y - red.y);
        PointF q = new PointF(point.x - red.x, point.y - red.y);
        float s = PHUtilities.crossProduct(q, v2) / PHUtilities.crossProduct(v1, v2);
        float t = PHUtilities.crossProduct(v1, q) / PHUtilities.crossProduct(v1, v2);
        return s >= 0.0f && t >= 0.0f && s + t <= 1.0f;
    }

    private static float getDistanceBetweenTwoPoints(PointF one, PointF two) {
        float dx = one.x - two.x;
        float dy = one.y - two.y;
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        return dist;
    }

    private static float crossProduct(PointF point1, PointF point2) {
        return point1.x * point2.y - point1.y * point2.x;
    }

    private static List<PointF> colorPointsForModel(String model) {
        if (model == null) {
            model = " ";
        }
        List<PointF> colorPoints = GAMUT_B_BULBS_LIST.contains(model) || MULTI_SOURCE_LUMINAIRES.contains(model) ? colorPointsGamut_B : (GAMUT_A_BULBS_LIST.contains(model) ? colorPointsGamut_A : (GAMUT_C_BULBS_LIST.contains(model) ? colorPointsGamut_C : colorPointsDefault));
        return colorPoints;
    }

    private static PointF getClosestPointToPoints(PointF pointA, PointF pointB, PointF pointP) {
        if (pointA == null || pointB == null || pointP == null) {
            return null;
        }
        PointF pointAP = new PointF(pointP.x - pointA.x, pointP.y - pointA.y);
        PointF pointAB = new PointF(pointB.x - pointA.x, pointB.y - pointA.y);
        float apAb = pointAP.x * pointAB.x + pointAP.y * pointAB.y;
        float ab2 = pointAB.x * pointAB.x + pointAB.y * pointAB.y;
        float t = apAb / ab2;
        if (t < 0.0f) {
            t = 0.0f;
        } else if (t > 1.0f) {
            t = 1.0f;
        }
        PointF newPoint = new PointF(pointA.x + pointAB.x * t, pointA.y + pointAB.y * t);
        return newPoint;
    }

    public static Date stringToDate(String dateString, String timeZone) {
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", new Locale("nl_NL"));
        dateFormate.setTimeZone(TimeZone.getTimeZone(timeZone));
        Date date = null;
        try {
            date = dateFormate.parse(dateString);
        }
        catch (ParseException e2) {
            return null;
        }
        return date;
    }

    public static Date stringToDate(String dateString) {
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date date = null;
        try {
            date = dateFormate.parse(dateString);
        }
        catch (ParseException e2) {
            return null;
        }
        return date;
    }

    public static Date stringToDateForTime(String dateString) {
        SimpleDateFormat dateFormate = new SimpleDateFormat("HH:mm:ss", new Locale("nl_NL"));
        dateFormate.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = null;
        try {
            date = dateFormate.parse(dateString);
        }
        catch (ParseException e2) {
            return null;
        }
        return date;
    }

    public static List<PHSwitchDeviceInfo> getSwitchKnowledgeBase() {
        return PHSwitchSerializer1.getKnowledgeBase();
    }

    public static int dpToPx(int dpi, double dp) {
        return (int)Math.round(dp * (double)(dpi / 160));
    }

    public static double pxToDp(int dpi, int px) {
        return px / (dpi / 160);
    }

    public static boolean isJSONValid(String jsonString) {
        try {
            new JSONObject(jsonString);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(jsonString);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    static {
        GAMUT_A_BULBS_LIST.add("LLC001");
        GAMUT_A_BULBS_LIST.add("LLC005");
        GAMUT_A_BULBS_LIST.add("LLC006");
        GAMUT_A_BULBS_LIST.add("LLC007");
        GAMUT_A_BULBS_LIST.add("LLC010");
        GAMUT_A_BULBS_LIST.add("LLC011");
        GAMUT_A_BULBS_LIST.add("LLC012");
        GAMUT_A_BULBS_LIST.add("LLC014");
        GAMUT_A_BULBS_LIST.add("LLC013");
        GAMUT_A_BULBS_LIST.add("LST001");
        GAMUT_B_BULBS_LIST.add("LCT001");
        GAMUT_B_BULBS_LIST.add("LCT002");
        GAMUT_B_BULBS_LIST.add("LCT003");
        GAMUT_B_BULBS_LIST.add("LCT004");
        GAMUT_B_BULBS_LIST.add("LLM001");
        GAMUT_B_BULBS_LIST.add("LCT005");
        GAMUT_B_BULBS_LIST.add("LCT006");
        GAMUT_B_BULBS_LIST.add("LCT007");
        GAMUT_C_BULBS_LIST.add("LLC020");
        GAMUT_C_BULBS_LIST.add("LST002");
        MULTI_SOURCE_LUMINAIRES.add("HBL001");
        MULTI_SOURCE_LUMINAIRES.add("HBL002");
        MULTI_SOURCE_LUMINAIRES.add("HBL003");
        MULTI_SOURCE_LUMINAIRES.add("HIL001");
        MULTI_SOURCE_LUMINAIRES.add("HIL002");
        MULTI_SOURCE_LUMINAIRES.add("HEL001");
        MULTI_SOURCE_LUMINAIRES.add("HEL002");
        colorPointsGamut_A.add(new PointF(0.703f, 0.296f));
        colorPointsGamut_A.add(new PointF(0.214f, 0.709f));
        colorPointsGamut_A.add(new PointF(0.139f, 0.081f));
        colorPointsGamut_B.add(new PointF(0.674f, 0.322f));
        colorPointsGamut_B.add(new PointF(0.408f, 0.517f));
        colorPointsGamut_B.add(new PointF(0.168f, 0.041f));
        colorPointsGamut_C.add(new PointF(0.692f, 0.308f));
        colorPointsGamut_C.add(new PointF(0.17f, 0.7f));
        colorPointsGamut_C.add(new PointF(0.153f, 0.048f));
        colorPointsDefault.add(new PointF(1.0f, 0.0f));
        colorPointsDefault.add(new PointF(0.0f, 1.0f));
        colorPointsDefault.add(new PointF(0.0f, 0.0f));
    }
}

