/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.util;

import com.philips.lighting.hue.sdk.util.PHHueCountTimerListener;
import java.util.Timer;
import java.util.TimerTask;

public class PHHueCountTimer {
    private long timeoutInMs;
    private long currentTick = 0L;
    private long lastTick = 0L;
    private PHHueCountTimerListener phHueCountListener;
    private Timer timer;
    private boolean isRunning = false;

    public PHHueCountTimer(long timeoutInMs, PHHueCountTimerListener phHueCountListener) {
        this.timeoutInMs = timeoutInMs;
        this.phHueCountListener = phHueCountListener;
        this.currentTick = 0L;
        this.isRunning = true;
    }

    public void start(long delayTimeInMs) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new HueCountTimerTask(), delayTimeInMs);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.isRunning = false;
    }

    public void restart(long restartDelayInMs) {
        long processingTime = System.currentTimeMillis() - this.lastTick;
        this.currentTick = this.currentTick + processingTime + restartDelayInMs;
        this.start(restartDelayInMs);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    class HueCountTimerTask
    extends TimerTask {
        HueCountTimerTask() {
        }

        @Override
        public void run() {
            if (PHHueCountTimer.this.currentTick < PHHueCountTimer.this.timeoutInMs) {
                PHHueCountTimer.this.lastTick = System.currentTimeMillis();
                PHHueCountTimer.this.phHueCountListener.onTick();
            } else {
                PHHueCountTimer.this.phHueCountListener.onFinish();
            }
            this.cancel();
        }
    }
}

