/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.upnp;

import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.connection.impl.PHHueHttpConnection;
import com.philips.lighting.hue.sdk.utilities.PHUtilities;
import java.util.concurrent.Callable;
import org.json.hue.JSONObject;

public class IPAddressScanner
implements Callable<PHAccessPoint> {
    private String ipAddress;
    private PHHueHttpConnection connection;

    public IPAddressScanner(String ipAddress) {
        this.ipAddress = ipAddress;
        this.connection = new PHHueHttpConnection();
        this.connection.setTimeoutConnection(2000);
    }

    public IPAddressScanner(String ipAddress, PHHueHttpConnection connection) {
        this.ipAddress = ipAddress;
        this.connection = connection;
    }

    @Override
    public PHAccessPoint call() {
        String uri;
        String jsonData;
        PHAccessPoint accessPoint = new PHAccessPoint();
        if (this.ipAddress != null && !this.ipAddress.isEmpty() && (jsonData = this.connection.getData(uri = "http://" + this.ipAddress + "/" + "api/config")) != null && !jsonData.equals("") && PHUtilities.isJSONValid(jsonData)) {
            JSONObject jsonObject = new JSONObject(jsonData);
            if (!(jsonObject.has("name") && jsonObject.has("mac") && jsonObject.has("swversion"))) {
                return null;
            }
            String mac = jsonObject.optString("mac");
            String bridgeid = jsonObject.optString("bridgeid");
            if (bridgeid.isEmpty() && mac != null) {
                String stringWithoutColons = mac.replace(":", "");
                if (stringWithoutColons.length() != 12) {
                    accessPoint.setBridgeId(stringWithoutColons);
                } else {
                    accessPoint.setBridgeId(stringWithoutColons.substring(0, 6) + "fffe" + stringWithoutColons.substring(6));
                }
            } else {
                accessPoint.setBridgeId(bridgeid);
            }
            accessPoint.setIpAddress(this.ipAddress);
            accessPoint.setMacAddress(mac);
            return accessPoint;
        }
        return null;
    }
}

