/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.connection.impl;

import com.philips.lighting.hue.listener.PHBridgeConfigurationListener;
import com.philips.lighting.hue.listener.PHGroupListener;
import com.philips.lighting.hue.listener.PHHTTPListener;
import com.philips.lighting.hue.listener.PHLightListener;
import com.philips.lighting.hue.listener.PHRuleListener;
import com.philips.lighting.hue.listener.PHSceneListener;
import com.philips.lighting.hue.listener.PHScheduleListener;
import com.philips.lighting.hue.listener.PHSensorListener;
import com.philips.lighting.hue.listener.PHTimeZoneListener;
import com.philips.lighting.hue.sdk.PHMessageType;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeDelegator;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeImpl;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeResourcesCacheImpl;
import com.philips.lighting.hue.sdk.clip.PHLightSerializer;
import com.philips.lighting.hue.sdk.clip.PHSceneSerializer;
import com.philips.lighting.hue.sdk.clip.PHScheduleSerializer;
import com.philips.lighting.hue.sdk.clip.PHSensorSerializer;
import com.philips.lighting.hue.sdk.clip.PHTimeZoneSerializer;
import com.philips.lighting.hue.sdk.clip.serialisation.PHCLIPParserBase;
import com.philips.lighting.hue.sdk.connection.impl.PHHueHttpConnection;
import com.philips.lighting.hue.sdk.exception.PHHueInvalidAPIException;
import com.philips.lighting.hue.sdk.exception.PHInvalidInputException;
import com.philips.lighting.hue.sdk.fbp.PHBridgeVersionManager;
import com.philips.lighting.hue.sdk.notification.impl.PHNotificationManagerImpl;
import com.philips.lighting.hue.sdk.util.PHHueCountTimer;
import com.philips.lighting.hue.sdk.util.PHHueCountTimerListener;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHHueError;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import com.philips.lighting.model.PHSoftwareUpdateStatus;
import com.philips.lighting.model.rule.PHRule;
import com.philips.lighting.model.sensor.PHDaylightSensorConfiguration;
import com.philips.lighting.model.sensor.PHDaylightSensorState;
import com.philips.lighting.model.sensor.PHGenericFlagSensorState;
import com.philips.lighting.model.sensor.PHGenericStatusSensorState;
import com.philips.lighting.model.sensor.PHGeofenceSensorConfiguration;
import com.philips.lighting.model.sensor.PHGeofenceSensorState;
import com.philips.lighting.model.sensor.PHHumiditySensorState;
import com.philips.lighting.model.sensor.PHOpenCloseSensorState;
import com.philips.lighting.model.sensor.PHPresenceSensorConfiguration;
import com.philips.lighting.model.sensor.PHPresenceSensorState;
import com.philips.lighting.model.sensor.PHSensor;
import com.philips.lighting.model.sensor.PHSwitchState;
import com.philips.lighting.model.sensor.PHTemperatureSensorState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.hue.JSONArray;
import org.json.hue.JSONObject;

public class PHLocalBridgeDelegator
implements PHBridgeDelegator {
    static final String LIGHT = "lights/";
    static final String GROUP = "groups/";
    static final String STATE = "/state";
    static final String LIGHTSTATES = "/lightstates";
    static final String ACTION = "/action";
    static final String SCENE = "scenes/";
    static final String SENSOR = "sensors/";
    static final String RULE = "rules/";
    static final String SENSOR_STATE = "/state";
    static final String CONFIGURATION = "/config";
    static final String STARTUPSTATE = "/startupstate";
    static final String INFO = "info/";
    static final String TIMEZONES = "timezones";
    static final String NEW = "new";
    private static final String CONFIG = "config";
    private static final String WHITELIST = "/whitelist/";
    static final String SCHEDULES = "schedules/";
    private static final String TAG = "PHLocalBridgeDelegator1_0";
    private static final long UPGRADE_DURATION = 90000L;
    static final int LOCAL_KEY = 4626;
    static final long SEARCH_DURATION = 60000L;
    static final long SEARCH_ITERATION = 2000L;
    static final long TIMER_DELAY = 30000L;
    public static final boolean CACHE_UPDATE_DISABLED = false;
    private String ipAddress;
    private String key;
    private PHHueCountTimer timer = null;
    private PHHueCountTimer softwareUpdateTimer = null;
    public static final boolean cacheUpdateDisabled = false;

    public PHLocalBridgeDelegator(String ipAddress, String key) {
        this.ipAddress = ipAddress;
        this.key = key;
    }

    public StringBuffer buildHttpAddress() {
        StringBuffer sb = new StringBuffer();
        sb.append("http://").append(this.ipAddress).append("/api/").append(this.key).append("/");
        return sb;
    }

    public StringBuffer buildScheduleCommand(String owner) {
        StringBuffer sb = new StringBuffer();
        sb.append("/api/").append(owner).append("/");
        return sb;
    }

    public PHHueHttpConnection getConnectionObject() {
        return new PHHueHttpConnection();
    }

    @Override
    public void findNewLights(final PHLightListener listener) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                if (!PHLocalBridgeDelegator.this.searchLights(notificationManager, listener)) {
                    return;
                }
                if (notificationManager != null) {
                    notificationManager.startSearchNotification();
                }
                if (PHLocalBridgeDelegator.this.timer != null && PHLocalBridgeDelegator.this.timer.isRunning()) {
                    PHLocalBridgeDelegator.this.timer.stop();
                }
                PHLocalBridgeDelegator.this.timer = new PHHueCountTimer(60000L, new PHHueCountTimerListener(){

                    @Override
                    public void onFinish() {
                        if (notificationManager != null) {
                            notificationManager.notifyLightHeaders(listener, new ArrayList<PHBridgeResource>(), true);
                        }
                    }

                    @Override
                    public void onTick() {
                        try {
                            String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.LIGHT).append(PHLocalBridgeDelegator.NEW).toString();
                            PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                            String response = httpConnection.getData(url);
                            if (response != null) {
                                PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                                List<PHHueError> errorTable = parser.parseError(response);
                                if (errorTable.size() != 0) {
                                    PHHueError error = errorTable.get(0);
                                    if (notificationManager != null) {
                                        notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                                    }
                                } else {
                                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                                    List<PHBridgeResource> lightHeaders = bridgeVersionManager.getLightSerializer().parseGetAllLightHeaders(response);
                                    if (lightHeaders == null || lightHeaders.size() == 0) {
                                        notificationManager.notifyLightHeaders(listener, new ArrayList<PHBridgeResource>(), false);
                                    } else if (notificationManager != null) {
                                        notificationManager.notifyLightHeaders(listener, lightHeaders, false);
                                    }
                                    JSONObject jObject = new JSONObject(response);
                                    String scanStatus = jObject.optString("lastscan");
                                    if (!scanStatus.equals("active")) {
                                        this.onFinish();
                                        return;
                                    }
                                }
                            }
                            if (notificationManager != null) {
                                if (notificationManager.isSearchRunning()) {
                                    PHLocalBridgeDelegator.this.timer.restart(2000L);
                                } else {
                                    notificationManager.notifyLightHeaders(listener, new ArrayList<PHBridgeResource>(), true);
                                }
                            }
                        }
                        catch (Exception e2) {
                            if (PHLog.isLoggable()) {
                                PHLog.e(PHLocalBridgeDelegator.TAG, "Exception: " + e2);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                            }
                            return;
                        }
                    }
                });
                PHLocalBridgeDelegator.this.timer.start(0L);
            }
        }.start();
    }

    private boolean searchLights(PHNotificationManagerImpl notificationManager, PHLightListener listener) {
        try {
            if (notificationManager == null) {
                return false;
            }
            String url = this.buildHttpAddress().append(LIGHT).toString();
            PHHueHttpConnection httpConnection = this.getConnectionObject();
            String response = httpConnection.postData("", url);
            if (response == null) {
                String searchFailForLights = "Unable to search Lights";
                if (notificationManager != null) {
                    notificationManager.notifyBridgeAPIError(listener, 46, searchFailForLights);
                }
                return false;
            }
            PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
            List<PHHueError> errorTable = parser.parseError(response);
            if (errorTable.size() != 0) {
                PHHueError error = errorTable.get(0);
                if (notificationManager != null) {
                    notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                }
                return false;
            }
            return true;
        }
        catch (Exception e2) {
            if (PHLog.isLoggable()) {
                PHLog.e(TAG, "Exception: " + e2);
            }
            return false;
        }
    }

    @Override
    public void updateLight(final PHLight light, final PHLightListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canUpdate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        if (!lightSerializer.validateAPI(light)) {
            String lightNotUpdated = "Unable to update name of Light";
            if (notificationManager != null) {
                notificationManager.notifyBridgeAPIError(listener, 42, lightNotUpdated);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getLightSerializer().updateLightPacket(light).toString();
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.LIGHT).append(light.getIdentifier()).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.putData(data, url);
                    if (response == null) {
                        String lightNotUpdated = "Unable to update name of Light";
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, lightNotUpdated);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            PHLocalBridgeDelegator.this.doLocalLightUpdate(light.getIdentifier(), light.getName(), bridge);
                            if (notificationManager != null) {
                                notificationManager.notifyCacheUpdated(PHMessageType.LIGHTS_CACHE_UPDATED, (PHBridge)bridge);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPISuccess(listener);
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (PHLog.isLoggable()) {
                        PHLog.e(PHLocalBridgeDelegator.TAG, "Exception: " + e2);
                    }
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void createGroup(final PHGroup group, final PHGroupListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getGroupSerializer().createGroupPacket(group.getName(), group.getLightIdentifiers()).toString();
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.GROUP).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.postData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            Map<String, String> successTable = parser.parseSuccess(response);
                            String val = successTable.get("id");
                            if (val == null) {
                                String msg = "Unable to parse response";
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, 52, msg);
                                }
                            } else {
                                String[] arr = val.split("/");
                                PHGroup grp = new PHGroup(group.getName(), arr[arr.length - 1]);
                                grp.setLightIdentifiers(group.getLightIdentifiers());
                                if (grp.getIdentifier() != null) {
                                    PHLocalBridgeDelegator.this.doLocalGroupCreate(grp, bridge);
                                    if (notificationManager != null) {
                                        notificationManager.notifyCacheUpdated(PHMessageType.GROUPS_CACHE_UPDATED, (PHBridge)bridge);
                                    }
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyGroupCreated(listener, grp);
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    @Deprecated
    public void createGroup(String name, List<String> lightIdentifiers, PHGroupListener listener, PHBridgeImpl bridge) {
        PHGroup group = new PHGroup(name, "");
        group.setLightIdentifiers(lightIdentifiers);
        this.createGroup(group, listener, bridge);
    }

    @Override
    public void updateGroup(final PHGroup group, final PHGroupListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getGroupSerializer().updateGroupPacket(group).toString();
                    if (data == null) {
                        throw new PHInvalidInputException();
                    }
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.GROUP).append(group.getIdentifier()).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.putData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            PHLocalBridgeDelegator.this.doLocalGroupUpdate(group, bridge, parser.parseSuccess(response));
                            if (notificationManager != null) {
                                notificationManager.notifyCacheUpdated(PHMessageType.GROUPS_CACHE_UPDATED, (PHBridge)bridge);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPISuccess(listener);
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void deleteGroup(final String groupIdentifier, final PHGroupListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.GROUP).append(groupIdentifier).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.deleteData(url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            boolean flag = parser.parseIsSuccess(response);
                            if (!flag) {
                                String msg = "Unable to parse response";
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, 52, msg);
                                }
                            } else {
                                PHLocalBridgeDelegator.this.doLocalGroupDelete(groupIdentifier, bridge);
                                if (notificationManager != null) {
                                    notificationManager.notifyCacheUpdated(PHMessageType.GROUPS_CACHE_UPDATED, (PHBridge)bridge);
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPISuccess(listener);
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void setLightStateForGroup(final String groupIdentifier, final PHLightState state, final PHGroupListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        String errorMsg = state.validateState();
        if (errorMsg != null) {
            if (notificationManager != null) {
                notificationManager.notifyBridgeAPIError(listener, 51, errorMsg);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getLightSerializer().updateLightStatePacket(state).toString();
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.GROUP).append(groupIdentifier).append(PHLocalBridgeDelegator.ACTION).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.putData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        Map<String, String> successTable = parser.parseSuccess(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            if (PHLocalBridgeDelegator.this.doLocalUpdateGroupLights(bridge, successTable, state, groupIdentifier) && notificationManager != null) {
                                notificationManager.notifyCacheUpdated(PHMessageType.LIGHTS_CACHE_UPDATED, (PHBridge)bridge);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIStateUpdate(listener, successTable, errorTable);
                                notificationManager.notifyBridgeAPISuccess(listener);
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    private void getBridgeConfigurations(final PHBridgeConfigurationListener listener, PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                block9: {
                    try {
                        String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.CONFIG).toString();
                        PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                        String response = httpConnection.getData(url);
                        if (response == null) {
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 46, null);
                            }
                        } else {
                            PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                            List<PHHueError> errorTable = parser.parseError(response);
                            if (errorTable.size() != 0) {
                                PHHueError error = errorTable.get(0);
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                                }
                            } else {
                                PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                                PHBridgeConfiguration config = bridgeVersionManager.getBridgeConfigurationSerializer().parseBridgeConfiguration(new JSONObject(response));
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeConfigReceived(listener, config);
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        if (notificationManager == null) break block9;
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                }
            }
        }.start();
    }

    @Override
    public void updateBridgeConfigurations(final PHBridgeConfiguration configuration, final PHBridgeConfigurationListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getBridgeConfigurationSerializer().updateBridgeConfigurationPacket(configuration).toString();
                    if (data == null) {
                        throw new PHInvalidInputException();
                    }
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.CONFIG).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.putData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        Map<String, String> successTable = parser.parseSuccess(response);
                        PHLocalBridgeDelegator.this.doLocalBridgeUpdate(configuration, successTable, bridge);
                        if (notificationManager != null) {
                            notificationManager.notifyCacheUpdated(PHMessageType.BRIDGE_CONFIGURATION_CACHE_UPDATED, (PHBridge)bridge);
                        }
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIStateUpdate(listener, successTable, errorTable);
                            notificationManager.notifyBridgeAPISuccess(listener);
                        }
                    }
                }
                catch (Exception e2) {
                    if (PHLog.isLoggable()) {
                        PHLog.e(PHLocalBridgeDelegator.TAG, "Exception: " + e2);
                    }
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void removeUsername(final String username, final PHBridgeConfigurationListener listener) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.CONFIG).append(PHLocalBridgeDelegator.WHITELIST).append(username).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.deleteData(url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else if (notificationManager != null) {
                            notificationManager.notifyBridgeAPISuccess(listener);
                        }
                    }
                }
                catch (Exception e2) {
                    if (PHLog.isLoggable()) {
                        PHLog.e(PHLocalBridgeDelegator.TAG, "Exception: " + e2);
                    }
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void createSchedule(final PHSchedule schedule, final PHScheduleListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHScheduleSerializer schedulesSerializer = PHBridgeVersionManager.getInstance().getSchedulesSerializer();
        if (schedulesSerializer == null || !schedulesSerializer.canCreate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        if (!schedulesSerializer.validateAPI(schedule)) {
            String msg = "Random times and recurring schedules are not supported in this bridge version";
            if (notificationManager != null) {
                notificationManager.notifyBridgeAPIError(listener, 54, msg);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                String cmdAddress = null;
                String owner = PHLocalBridgeDelegator.this.getOwner(bridge, schedule);
                if (schedule.getLightIdentifier() != null) {
                    cmdAddress = PHLocalBridgeDelegator.this.buildScheduleCommand(owner).append(PHLocalBridgeDelegator.LIGHT).append(schedule.getLightIdentifier()).append("/state").toString();
                } else if (schedule.getGroupIdentifier() != null) {
                    cmdAddress = PHLocalBridgeDelegator.this.buildScheduleCommand(owner).append(PHLocalBridgeDelegator.GROUP).append(schedule.getGroupIdentifier()).append(PHLocalBridgeDelegator.ACTION).toString();
                } else if (schedule.getSceneIdentifier() != null) {
                    cmdAddress = schedule.getGroupIdentifier() != null ? PHLocalBridgeDelegator.this.buildScheduleCommand(owner).append(PHLocalBridgeDelegator.GROUP).append(schedule.getGroupIdentifier()).append(PHLocalBridgeDelegator.ACTION).toString() : PHLocalBridgeDelegator.this.buildScheduleCommand(owner).append(PHLocalBridgeDelegator.GROUP).append("0").append(PHLocalBridgeDelegator.ACTION).toString();
                }
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getSchedulesSerializer().createSchedulePacket(schedule, cmdAddress, "PUT", bridge.getResourceCache().getBridgeConfiguration().getTimeZone()).toString();
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SCHEDULES).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.postData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            Map<String, String> successTable = parser.parseSuccess(response);
                            String val = successTable.get("id");
                            if (val == null) {
                                String msg = "Unable to parse response";
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, 52, msg);
                                }
                            } else {
                                String[] arr = val.split("/");
                                String scheduleIdentifier = arr[arr.length - 1];
                                schedule.setIdentifier(scheduleIdentifier);
                                PHLocalBridgeDelegator.this.doLocalScheduleCreated(schedule, bridge);
                                if (notificationManager != null) {
                                    notificationManager.notifyCacheUpdated(PHMessageType.SCHEDULES_CACHE_UPDATED, (PHBridge)bridge);
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyScheduleCreated(listener, schedule);
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    public String getOwner(PHBridge bridge, PHSchedule schedule) {
        if (schedule.getOwner() != null && schedule.getOwner().equals("")) {
            return schedule.getOwner();
        }
        String owner = this.key;
        if (schedule.getIdentifier() == null) {
            return this.key;
        }
        if (bridge.getResourceCache().getSchedules().containsKey(schedule.getIdentifier())) {
            owner = bridge.getResourceCache().getSchedules().get(schedule.getIdentifier()).getOwner();
        }
        return owner;
    }

    @Override
    public void updateSchedule(final PHSchedule schedule, final PHScheduleListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHScheduleSerializer schedulesSerializer = PHBridgeVersionManager.getInstance().getSchedulesSerializer();
        if (schedulesSerializer == null || !schedulesSerializer.canUpdate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        if (!schedulesSerializer.validateAPI(schedule)) {
            String msg = "Random times and recurring schedules are not supported in this bridge version";
            if (notificationManager != null) {
                notificationManager.notifyBridgeAPIError(listener, 54, msg);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String cmdAddress = null;
                    String owner = PHLocalBridgeDelegator.this.getOwner(bridge, schedule);
                    if (schedule.getLightIdentifier() != null) {
                        cmdAddress = PHLocalBridgeDelegator.this.buildScheduleCommand(owner).append(PHLocalBridgeDelegator.LIGHT).append(schedule.getLightIdentifier()).append("/state").toString();
                    } else if (schedule.getGroupIdentifier() != null) {
                        cmdAddress = PHLocalBridgeDelegator.this.buildScheduleCommand(owner).append(PHLocalBridgeDelegator.GROUP).append(schedule.getGroupIdentifier()).append(PHLocalBridgeDelegator.ACTION).toString();
                    } else if (schedule.getSceneIdentifier() != null) {
                        cmdAddress = schedule.getGroupIdentifier() != null ? PHLocalBridgeDelegator.this.buildScheduleCommand(owner).append(PHLocalBridgeDelegator.GROUP).append(schedule.getGroupIdentifier()).append(PHLocalBridgeDelegator.ACTION).toString() : PHLocalBridgeDelegator.this.buildScheduleCommand(owner).append(PHLocalBridgeDelegator.GROUP).append("0").append(PHLocalBridgeDelegator.ACTION).toString();
                    }
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getSchedulesSerializer().updateSchedulePacket(schedule, cmdAddress, "PUT", bridge.getResourceCache().getBridgeConfiguration().getTimeZone()).toString();
                    if (data == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 44, "Input parameter can't be null");
                        }
                        return;
                    }
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SCHEDULES).append(schedule.getIdentifier()).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.putData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            PHLocalBridgeDelegator.this.doLocalScheduleUpdate(schedule, bridge, parser.parseSuccess(response));
                            if (notificationManager != null) {
                                notificationManager.notifyCacheUpdated(PHMessageType.SCHEDULES_CACHE_UPDATED, (PHBridge)bridge);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPISuccess(listener);
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void removeSchedule(final String scheduleIdentifier, final PHScheduleListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SCHEDULES).append(scheduleIdentifier).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.deleteData(url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            boolean flag = parser.parseIsSuccess(response);
                            if (!flag) {
                                String msg = "Unable to parse response";
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, 52, msg);
                                }
                            } else {
                                PHLocalBridgeDelegator.this.doLocalScheduleRemove(scheduleIdentifier, bridge);
                                if (notificationManager != null) {
                                    notificationManager.notifyCacheUpdated(PHMessageType.SCHEDULES_CACHE_UPDATED, (PHBridge)bridge);
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPISuccess(listener);
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void updateSoftware(PHBridgeConfigurationListener listener, PHBridgeImpl bridge) {
        PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        try {
            PHBridgeConfiguration config = bridge.getResourceCache().getBridgeConfiguration();
            if (!config.getPortalServicesEnabled().booleanValue()) {
                if (notificationManager != null) {
                    notificationManager.notifyBridgeAPIError(listener, 48, "Portal service for is not activated.You can't upgrade software");
                }
                return;
            }
            PHSoftwareUpdateStatus status = config.getSoftwareStatus();
            if (status != null) {
                if (!status.isSoftwareUpdateAvailable()) {
                    if (config.getSoftwareStatus().getState() == PHSoftwareUpdateStatus.PHStateType.NO_UPDATE) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 49, "No new software updates are available.");
                        }
                    } else if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 57, "Software Update is being Downloading..");
                    }
                    return;
                }
                this.startSoftwareUpdate(listener, bridge);
            }
        }
        catch (Exception e2) {
            if (notificationManager != null) {
                notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
            }
            return;
        }
    }

    private void startSoftwareUpdate(final PHBridgeConfigurationListener listener, final PHBridgeImpl bridge) {
        PHBridgeConfiguration tempConfig = new PHBridgeConfiguration();
        PHSoftwareUpdateStatus status = new PHSoftwareUpdateStatus();
        status.setState(PHSoftwareUpdateStatus.PHStateType.INSTALLING_UPDATES);
        tempConfig.setSoftwareStatus(status);
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        this.updateBridgeConfigurations(tempConfig, new PHBridgeConfigurationListener(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onStateUpdate(Map<String, String> successAttribute, List<PHHueError> errorAttribute) {
                if (errorAttribute.size() > 0) {
                    PHHueError error = errorAttribute.get(0);
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getAddress());
                    }
                } else {
                    PHLocalBridgeDelegator.this.getSoftwareUpdateStatus(listener, bridge);
                }
            }

            @Override
            public void onError(int code, String msg) {
                if (notificationManager != null) {
                    notificationManager.notifyBridgeAPIError(listener, code, msg);
                }
            }

            @Override
            public void onReceivingConfiguration(PHBridgeConfiguration configuration) {
            }
        }, bridge);
    }

    private void getSoftwareUpdateStatus(final PHBridgeConfigurationListener listener, final PHBridgeImpl bridge) {
        this.softwareUpdateTimer = new PHHueCountTimer(90000L, new PHHueCountTimerListener(){

            @Override
            public void onFinish() {
            }

            @Override
            public void onTick() {
                PHLocalBridgeDelegator.this.getBridgeConfigurations(new PHBridgeConfigurationListener(){

                    @Override
                    public void onSuccess() {
                    }

                    @Override
                    public void onStateUpdate(Map<String, String> successAttribute, List<PHHueError> errorAttribute) {
                    }

                    @Override
                    public void onReceivingConfiguration(PHBridgeConfiguration config) {
                        PHLocalBridgeDelegator.this.softwareUpdateRemoveNotify(listener, bridge);
                    }

                    @Override
                    public void onError(int code, String msg) {
                        PHLocalBridgeDelegator.this.softwareUpdateTimer.restart(30000L);
                    }
                }, bridge);
            }
        });
        this.softwareUpdateTimer.start(30000L);
    }

    private void softwareUpdateRemoveNotify(final PHBridgeConfigurationListener listener, PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        try {
            PHBridgeConfiguration tempConfig = new PHBridgeConfiguration();
            PHSoftwareUpdateStatus status = new PHSoftwareUpdateStatus();
            status.setState(PHSoftwareUpdateStatus.PHStateType.NO_UPDATE);
            tempConfig.setSoftwareStatus(status);
            this.updateBridgeConfigurations(tempConfig, new PHBridgeConfigurationListener(){

                @Override
                public void onSuccess() {
                }

                @Override
                public void onStateUpdate(Map<String, String> successAttribute, List<PHHueError> errorAttribute) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPISuccess(listener);
                    }
                }

                @Override
                public void onError(int code, String msg) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, code, msg);
                    }
                }

                @Override
                public void onReceivingConfiguration(PHBridgeConfiguration configuration) {
                }
            }, bridge);
        }
        catch (Exception e2) {
            if (notificationManager != null) {
                notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
            }
            return;
        }
    }

    @Override
    public void onIPAddressChanged(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    private void doLocalScheduleCreated(PHSchedule schedule, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHSchedule> schedules = cache.getSchedules();
        if (schedules == null) {
            schedules = new HashMap<String, PHSchedule>();
        }
        if (schedule.getOwner() == null || schedule.getOwner().equals("")) {
            schedule.setOwner(cache.getBridgeConfiguration().getUsername());
        }
        schedules.put(schedule.getIdentifier(), schedule);
        cache.setSchedules(schedules);
    }

    private void doLocalScheduleRemove(String scheduleIdentifier, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHSchedule> scheduleCache = cache.getSchedules();
        scheduleCache.remove(scheduleIdentifier);
    }

    private void doLocalScheduleUpdate(PHSchedule schedule, PHBridgeImpl bridge, Map<String, String> successTable) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHSchedule> scheduleCache = cache.getSchedules();
        PHSchedule cachedSchedule = scheduleCache.get(schedule.getIdentifier());
        if (cachedSchedule == null) {
            this.doLocalScheduleCreated(schedule, bridge);
            return;
        }
        if (cachedSchedule.getOwner() == null || cachedSchedule.getOwner().equals("")) {
            cachedSchedule.setOwner(bridge.getResourceCache().getBridgeConfiguration().getUsername());
        }
        Set<String> keys = successTable.keySet();
        for (String key : keys) {
            if (key.endsWith("name")) {
                cachedSchedule.setName(schedule.getName());
                continue;
            }
            if (key.endsWith("description")) {
                cachedSchedule.setDescription(schedule.getDescription());
                continue;
            }
            if (key.endsWith("time")) {
                cachedSchedule.setDate(schedule.getDate());
                cachedSchedule.setTimer(schedule.getTimer());
                cachedSchedule.setRandomTime(schedule.getRandomTime());
                cachedSchedule.setRecurringDays(schedule.getRecurringDays());
                cachedSchedule.setRecurringTimerInterval(schedule.getRecurringTimerInterval());
                continue;
            }
            if (key.endsWith("command")) {
                cachedSchedule.setLightIdentifier(schedule.getLightIdentifier());
                cachedSchedule.setGroupIdentifier(schedule.getGroupIdentifier());
                PHLightState newstate = schedule.getLightState();
                PHLightState oldState = cachedSchedule.getLightState();
                boolean hueSatReceived = false;
                boolean ctReceived = false;
                boolean xyReceived = false;
                if (newstate != null) {
                    if (oldState == null) {
                        oldState = new PHLightState();
                    }
                    if (newstate.isOn() != null) {
                        oldState.setOn(newstate.isOn());
                    }
                    if (newstate.getAlertMode() != null) {
                        oldState.setAlertMode(newstate.getAlertMode());
                    }
                    if (newstate.getBrightness() != null) {
                        oldState.setBrightness(newstate.getBrightness());
                    }
                    if (newstate.getColorMode() != null) {
                        oldState.setColorMode(newstate.getColorMode());
                    }
                    if (newstate.getCt() != null) {
                        ctReceived = true;
                        oldState.setCt(newstate.getCt());
                    }
                    if (newstate.getEffectMode() != null) {
                        oldState.setEffectMode(newstate.getEffectMode());
                    }
                    if (newstate.getHue() != null) {
                        hueSatReceived = true;
                        oldState.setHue(newstate.getHue());
                    }
                    if (newstate.getSaturation() != null) {
                        hueSatReceived = true;
                        oldState.setSaturation(newstate.getSaturation());
                    }
                    if (newstate.getTransitionTime() != null) {
                        oldState.setTransitionTime(newstate.getTransitionTime());
                    }
                    if (newstate.getX() != null) {
                        xyReceived = true;
                        oldState.setX(newstate.getX());
                    }
                    if (newstate.getY() != null) {
                        xyReceived = true;
                        oldState.setY(newstate.getY());
                    }
                    if (hueSatReceived) {
                        oldState.setColorMode(PHLight.PHLightColorMode.COLORMODE_HUE_SATURATION);
                    }
                    if (ctReceived) {
                        oldState.setColorMode(PHLight.PHLightColorMode.COLORMODE_CT);
                    }
                    if (xyReceived) {
                        oldState.setColorMode(PHLight.PHLightColorMode.COLORMODE_XY);
                    }
                    if (newstate.getIncrementBri() != null) {
                        oldState.setIncrementBri(newstate.getIncrementBri());
                    }
                    if (newstate.getIncrementCt() != null) {
                        oldState.setIncrementCt(newstate.getIncrementCt());
                    }
                    if (newstate.getIncrementHue() != null) {
                        oldState.setIncrementHue(newstate.getIncrementHue());
                    }
                    if (newstate.getIncrementSat() != null) {
                        oldState.setIncrementSat(newstate.getIncrementSat());
                    }
                    if (newstate.getIncrementX() != null) {
                        oldState.setIncrementX(newstate.getIncrementX());
                    }
                    if (newstate.getIncrementY() != null) {
                        oldState.setIncrementY(newstate.getIncrementY());
                    }
                }
                cachedSchedule.setLightState(oldState);
                continue;
            }
            if (!key.endsWith("status")) continue;
            cachedSchedule.setStatus(schedule.getStatus());
        }
    }

    private void doLocalBridgeUpdate(PHBridgeConfiguration bridgeConfig, Map<String, String> successTable, PHBridgeImpl bridge) {
        boolean isIpChanged = false;
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        PHBridgeConfiguration cacheBridgeConfig = cache.getBridgeConfiguration();
        if (cacheBridgeConfig == null) {
            cacheBridgeConfig = new PHBridgeConfiguration();
            cache.setBridgeConfiguration(cacheBridgeConfig);
        }
        String oldIpAddress = cacheBridgeConfig.getIpAddress();
        Set<String> keys = successTable.keySet();
        for (String keySuccess : keys) {
            if (keySuccess.endsWith("ipaddress")) {
                String newIpAddress = bridgeConfig.getIpAddress();
                if (oldIpAddress != null && !newIpAddress.equals(oldIpAddress)) {
                    isIpChanged = true;
                }
                this.ipAddress = newIpAddress;
                cacheBridgeConfig.setIpAddress(this.ipAddress);
                PHBridgeDelegator delegator = bridge.getBridgeDelegator();
                delegator.onIPAddressChanged(this.ipAddress);
            } else if (keySuccess.endsWith("name")) {
                cacheBridgeConfig.setName(bridgeConfig.getName());
            } else if (keySuccess.endsWith("proxyaddress")) {
                cacheBridgeConfig.setProxy(bridgeConfig.getProxy());
            } else if (keySuccess.endsWith("proxyport")) {
                cacheBridgeConfig.setProxyPort(bridgeConfig.getProxyPort());
            } else if (keySuccess.endsWith("netmask")) {
                cacheBridgeConfig.setNetmask(bridgeConfig.getNetmask());
            } else if (keySuccess.endsWith("gateway")) {
                cacheBridgeConfig.setGateway(bridgeConfig.getGateway());
            } else if (keySuccess.endsWith("dhcp")) {
                cacheBridgeConfig.setDhcpEnabled(bridgeConfig.getDhcpEnabled());
            } else if (keySuccess.endsWith("portalservices")) {
                cacheBridgeConfig.setPortalServicesEnabled(bridgeConfig.getPortalServicesEnabled());
            } else if (keySuccess.endsWith("zigbeechannel")) {
                cacheBridgeConfig.setZigbeeChannel(bridgeConfig.getZigbeeChannel());
            } else if (keySuccess.endsWith("timezone")) {
                cacheBridgeConfig.setTimeZone(bridgeConfig.getTimeZone());
            }
            if (!isIpChanged) continue;
            PHLog.e("doLocalBridgeUpdate", oldIpAddress);
        }
    }

    private boolean doLocalUpdateGroupLights(PHBridgeImpl bridge, Map<String, String> successTable, PHLightState state, String groupIdentifier) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        if (groupIdentifier.equals("0")) {
            Map<String, PHLight> lightsCache = cache.getLights();
            HashMap<String, PHLight> updatedLightCache = new HashMap<String, PHLight>();
            ArrayList<PHLight> lightsArrayList = new ArrayList<PHLight>(lightsCache.values());
            for (PHLight light : lightsArrayList) {
                light.setLastKnownLightState(this.getNewLightState(light.getLastKnownLightState(), successTable, state));
                updatedLightCache.put(light.getIdentifier(), light);
            }
            cache.setLights(updatedLightCache);
        } else {
            Map<String, PHGroup> groupCache = cache.getGroups();
            PHGroup group = groupCache.get(groupIdentifier);
            if (group == null) {
                return false;
            }
            Map<String, PHLight> lightsCache = cache.getLights();
            HashMap<String, PHLight> updatedLightCache = new HashMap<String, PHLight>();
            ArrayList<PHLight> lightsArrayList = new ArrayList<PHLight>(lightsCache.values());
            for (PHLight light : lightsArrayList) {
                updatedLightCache.put(light.getIdentifier(), light);
            }
            for (String lightIdentifier : group.getLightIdentifiers()) {
                PHLight updatingLight = (PHLight)updatedLightCache.get(lightIdentifier);
                updatingLight.setLastKnownLightState(this.getNewLightState(updatingLight.getLastKnownLightState(), successTable, state));
                updatedLightCache.remove(lightIdentifier);
                updatedLightCache.put(lightIdentifier, updatingLight);
            }
            cache.setLights(updatedLightCache);
        }
        return true;
    }

    private PHLightState getNewLightState(PHLightState cachedState, Map<String, String> successTable, PHLightState newState) {
        if (cachedState == null) {
            return newState;
        }
        boolean hueSatReceived = false;
        boolean ctReceived = false;
        boolean xyReceived = false;
        Set<String> keys = successTable.keySet();
        for (String key : keys) {
            if (key.endsWith("on")) {
                cachedState.setOn(newState.isOn());
                continue;
            }
            if (key.endsWith("bri")) {
                cachedState.setBrightness(Integer.parseInt(successTable.get(key)));
                continue;
            }
            if (key.endsWith("hue")) {
                cachedState.setHue(Integer.parseInt(successTable.get(key)));
                hueSatReceived = true;
                continue;
            }
            if (key.endsWith("sat")) {
                cachedState.setSaturation(Integer.parseInt(successTable.get(key)));
                hueSatReceived = true;
                continue;
            }
            if (key.endsWith("xy")) {
                JSONArray xyArray = new JSONArray(successTable.get(key));
                cachedState.setX(Float.valueOf((float)xyArray.optDouble(0)), true);
                cachedState.setY(Float.valueOf((float)xyArray.optDouble(1)), true);
                xyReceived = true;
                continue;
            }
            if (key.endsWith("alert")) {
                cachedState.setAlertMode(newState.getAlertMode());
                continue;
            }
            if (key.endsWith("effect")) {
                cachedState.setEffectMode(newState.getEffectMode());
                continue;
            }
            if (!key.endsWith("ct")) continue;
            cachedState.setCt(Integer.parseInt(successTable.get(key)));
            ctReceived = true;
        }
        if (hueSatReceived) {
            cachedState.setColorMode(PHLight.PHLightColorMode.COLORMODE_HUE_SATURATION);
        }
        if (ctReceived) {
            cachedState.setColorMode(PHLight.PHLightColorMode.COLORMODE_CT);
        }
        if (xyReceived) {
            cachedState.setColorMode(PHLight.PHLightColorMode.COLORMODE_XY);
        }
        if (newState.getIncrementBri() != null && newState.getBrightness() == null && cachedState.getBrightness() != null) {
            cachedState.setBrightness(cachedState.getBrightness() + newState.getIncrementBri(), true);
        }
        if (newState.getIncrementHue() != null && newState.getHue() == null && cachedState.getHue() != null) {
            cachedState.setHue(cachedState.getHue() + newState.getIncrementHue(), true);
        }
        if (newState.getIncrementSat() != null && newState.getSaturation() == null && cachedState.getSaturation() != null) {
            cachedState.setSaturation(cachedState.getSaturation() + newState.getIncrementSat(), true);
        }
        if (newState.getIncrementCt() != null && newState.getCt() == null && cachedState.getCt() != null) {
            cachedState.setCt(cachedState.getCt() + newState.getIncrementCt(), true);
        }
        if (newState.getIncrementX() != null && newState.getX() == null && cachedState.getX() != null) {
            cachedState.setX(Float.valueOf(cachedState.getX().floatValue() + newState.getIncrementX().floatValue()), true);
        }
        if (newState.getIncrementY() != null && newState.getY() == null && cachedState.getY() != null) {
            cachedState.setY(Float.valueOf(cachedState.getY().floatValue() + newState.getIncrementY().floatValue()), true);
        }
        return cachedState;
    }

    private void doLocalGroupDelete(String groupIdentifier, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHGroup> groupCache = cache.getGroups();
        groupCache.remove(groupIdentifier);
    }

    private void doLocalLightUpdate(String lightIdentifier, String newName, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHLight> lightCache = cache.getLights();
        if (lightCache.containsKey(lightIdentifier)) {
            lightCache.get(lightIdentifier).setName(newName);
        }
    }

    private void doLocalGroupUpdate(PHGroup group, PHBridgeImpl bridge, Map<String, String> successTable) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHGroup> groupCache = cache.getGroups();
        PHGroup cachedGrp = groupCache.get(group.getIdentifier());
        Set<String> keys = successTable.keySet();
        for (String keySuccess : keys) {
            if (keySuccess.endsWith("name")) {
                cachedGrp.setName(group.getName());
                continue;
            }
            if (!keySuccess.endsWith("lights")) continue;
            cachedGrp.setLightIdentifiers(group.getLightIdentifiers());
        }
    }

    private void doLocalGroupCreate(PHGroup group, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHGroup> groupCache = cache.getGroups();
        groupCache.put(group.getIdentifier(), group);
    }

    @Override
    public void saveSceneWithCurrentLightStates(final PHScene scene, final PHSceneListener listener, final PHBridgeImpl bridge, final boolean isModify) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        if (scene == null) {
            notificationManager.notifyBridgeAPIError(listener, 23, "Scene is null");
            return;
        }
        if (scene.getSceneIdentifier() == null) {
            notificationManager.notifyBridgeAPIError(listener, 23, "Scene identifier not set.");
            return;
        }
        PHSceneSerializer scenesSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (scenesSerializer == null || !scenesSerializer.canCreate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                block10: {
                    try {
                        PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                        PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                        boolean isVersion2Scene = bridgeVersionManager.getScenesSerializer().isVersion2Scene();
                        String url = isVersion2Scene && !isModify ? PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SCENE).toString() : PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SCENE).append(scene.getSceneIdentifier()).toString();
                        String data = bridgeVersionManager.getScenesSerializer().createScenePacket(scene, isModify).toString();
                        String response = isVersion2Scene && !isModify ? httpConnection.postData(data, url) : httpConnection.putData(data, url);
                        if (response == null) {
                            String apiError = "Unsupported Response from Bridge";
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 46, apiError);
                            }
                        } else {
                            PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                            List<PHHueError> errorTable = parser.parseError(response);
                            if (errorTable.size() != 0) {
                                PHHueError error = errorTable.get(0);
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                                }
                            } else {
                                PHLocalBridgeDelegator.this.doLocalSceneUpdate(scene, bridge);
                                if (notificationManager != null) {
                                    notificationManager.notifyCacheUpdated(PHMessageType.SCENE_CACHE_UPDATED, (PHBridge)bridge);
                                }
                                Map<String, String> successTable = parser.parseSuccess(response);
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIStateUpdate(listener, successTable, errorTable);
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        if (notificationManager == null) break block10;
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                }
            }
        }.start();
    }

    @Override
    public void saveLightStateInScene(final PHLightState lightState, final String lightIdentifier, final String sceneIdentifier, final PHSceneListener listener) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHSceneSerializer scenesSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (scenesSerializer == null || !scenesSerializer.canCreate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                block11: {
                    boolean identifierIsNotValid;
                    boolean bl = identifierIsNotValid = sceneIdentifier == null || sceneIdentifier.length() < 1 || sceneIdentifier.length() > 16;
                    if (lightState == null || identifierIsNotValid || lightIdentifier == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 23, "Input parameter can't be null");
                        }
                        return;
                    }
                    try {
                        PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                        PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                        boolean isVersion2Scene = bridgeVersionManager.getScenesSerializer().isVersion2Scene();
                        String url = isVersion2Scene ? PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SCENE).append(sceneIdentifier).append(PHLocalBridgeDelegator.LIGHTSTATES).append("/").append(lightIdentifier).toString() : PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SCENE).append(sceneIdentifier).append("/").append(PHLocalBridgeDelegator.LIGHT).append(lightIdentifier).append("/state").toString();
                        String body = bridgeVersionManager.getLightSerializer().updateLightStatePacket(lightState).toString();
                        String response = httpConnection.putData(body, url);
                        if (response == null) {
                            String apiError = "Unsupported Response from Bridge";
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 46, apiError);
                            }
                        } else {
                            PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                            List<PHHueError> errorTable = parser.parseError(response);
                            if (errorTable.size() != 0) {
                                PHHueError error = errorTable.get(0);
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                                }
                            } else {
                                Map<String, String> successTable = parser.parseSuccess(response);
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIStateUpdate(listener, successTable, errorTable);
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        if (notificationManager == null) break block11;
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                }
            }
        }.start();
    }

    @Override
    public void activateScene(final String sceneIdentifier, final String groupIdentifier, final PHSceneListener listener) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHSceneSerializer scenesSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (scenesSerializer == null || !scenesSerializer.canCreate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                block9: {
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.GROUP).append(groupIdentifier).append(PHLocalBridgeDelegator.ACTION).toString();
                    try {
                        PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                        PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                        String data = bridgeVersionManager.getScenesSerializer().createActivateScenePacket(sceneIdentifier).toString();
                        String response = httpConnection.putData(data, url);
                        if (response == null) {
                            String apiError = "Unsupported Response from Bridge";
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 46, apiError);
                            }
                        } else {
                            PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                            List<PHHueError> errorTable = parser.parseError(response);
                            if (errorTable.size() != 0) {
                                PHHueError error = errorTable.get(0);
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                                }
                            } else if (notificationManager != null) {
                                notificationManager.notifyBridgeAPISuccess(listener);
                            }
                        }
                    }
                    catch (Exception e2) {
                        if (notificationManager == null) break block9;
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                }
            }
        }.start();
    }

    @Override
    public void findNewLightsWithSerials(final List<String> serials, final PHLightListener listener) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canCreate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                if (!PHLocalBridgeDelegator.this.searchLightsWithSerials(notificationManager, serials, listener)) {
                    return;
                }
                if (notificationManager != null) {
                    notificationManager.startSearchNotification();
                }
                if (PHLocalBridgeDelegator.this.timer != null && PHLocalBridgeDelegator.this.timer.isRunning()) {
                    PHLocalBridgeDelegator.this.timer.stop();
                }
                PHLocalBridgeDelegator.this.timer = new PHHueCountTimer(60000L, new PHHueCountTimerListener(){

                    @Override
                    public void onFinish() {
                        notificationManager.notifyLightHeaders(listener, new ArrayList<PHBridgeResource>(), true);
                    }

                    @Override
                    public void onTick() {
                        String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.LIGHT).append(PHLocalBridgeDelegator.NEW).toString();
                        try {
                            PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                            String response = httpConnection.getData(url);
                            if (response != null) {
                                PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                                List<PHHueError> errorTable = parser.parseError(response);
                                if (errorTable.size() != 0) {
                                    if (notificationManager != null) {
                                        notificationManager.notifyLightHeaders(listener, new ArrayList<PHBridgeResource>(), false);
                                    }
                                } else {
                                    JSONObject jObject;
                                    String scanStatus;
                                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                                    List<PHBridgeResource> lightHeaders = bridgeVersionManager.getLightSerializer().parseGetAllLightHeaders(response);
                                    if (lightHeaders == null || lightHeaders.size() == 0) {
                                        if (notificationManager != null) {
                                            notificationManager.notifyLightHeaders(listener, new ArrayList<PHBridgeResource>(), false);
                                        }
                                    } else if (notificationManager != null) {
                                        notificationManager.notifyLightHeaders(listener, lightHeaders, false);
                                    }
                                    if (!(scanStatus = (jObject = new JSONObject(response)).optString("lastscan")).equals("active")) {
                                        this.onFinish();
                                        return;
                                    }
                                }
                            }
                            if (notificationManager != null) {
                                if (notificationManager.isSearchRunning()) {
                                    PHLocalBridgeDelegator.this.timer.restart(2000L);
                                } else {
                                    notificationManager.notifyLightHeaders(listener, new ArrayList<PHBridgeResource>(), true);
                                }
                            }
                        }
                        catch (Exception e2) {
                            if (PHLog.isLoggable()) {
                                PHLog.e(PHLocalBridgeDelegator.TAG, "Exception: " + e2);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                            }
                            return;
                        }
                    }
                });
                PHLocalBridgeDelegator.this.timer.start(0L);
            }
        }.start();
    }

    public boolean searchLightsWithSerials(PHNotificationManagerImpl notificationManager, List<String> serials, PHLightListener listener) {
        if (notificationManager == null) {
            return false;
        }
        String url = this.buildHttpAddress().append(LIGHT).toString();
        PHHueHttpConnection httpConnection = this.getConnectionObject();
        boolean isSuccess = false;
        try {
            PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
            String data = bridgeVersionManager.getLightSerializer().createFindLightWithSerialsPacket(serials).toString();
            String response = httpConnection.postData(data, url);
            if (response == null) {
                String apiError = "Unsupported Response from Bridge";
                if (notificationManager != null) {
                    notificationManager.notifyBridgeAPIError(listener, 46, apiError);
                }
            } else {
                PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                List<PHHueError> errorTable = parser.parseError(response);
                if (errorTable.size() != 0) {
                    PHHueError error = errorTable.get(0);
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                    }
                    isSuccess = false;
                } else {
                    isSuccess = true;
                }
            }
        }
        catch (Exception e2) {
            if (notificationManager != null) {
                notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
            }
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public void deleteLight(final String lightIdentifier, final PHLightListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canDelete()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.LIGHT).append(lightIdentifier).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.deleteData(url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            boolean flag = parser.parseIsSuccess(response);
                            if (!flag) {
                                String msg = "Unable to parse response";
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, 52, msg);
                                }
                            } else {
                                PHLocalBridgeDelegator.this.doLocalLightDelete(lightIdentifier, bridge);
                                if (notificationManager != null) {
                                    notificationManager.notifyCacheUpdated(PHMessageType.LIGHTS_CACHE_UPDATED, (PHBridge)bridge);
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPISuccess(listener);
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void updateLightState(final String lightIdentifier, final PHLightState lightState, final PHLightListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canLightStateUpdate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        String errorMsg = lightState.validateState();
        if (errorMsg != null) {
            if (notificationManager != null) {
                notificationManager.notifyBridgeAPIError(listener, 51, errorMsg);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getLightSerializer().updateLightStatePacket(lightState).toString();
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.LIGHT).append(lightIdentifier).append("/state").toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.putData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = new PHCLIPParserBase();
                        List<PHHueError> errorTable = parser.parseError(response);
                        Map<String, String> successTable = parser.parseSuccess(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            PHLocalBridgeDelegator.this.doLocalLightStateUpdate(lightIdentifier, successTable, lightState, bridge);
                            if (notificationManager != null) {
                                notificationManager.notifyCacheUpdated(PHMessageType.LIGHTS_CACHE_UPDATED, (PHBridge)bridge);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIStateUpdate(listener, successTable, errorTable);
                                notificationManager.notifyBridgeAPISuccess(listener);
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void findNewSensors(final PHSensorListener listener) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canCreate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                if (!PHLocalBridgeDelegator.this.searchSensors(notificationManager, listener)) {
                    return;
                }
                if (notificationManager != null) {
                    notificationManager.startSearchNotification();
                }
                if (PHLocalBridgeDelegator.this.timer != null && PHLocalBridgeDelegator.this.timer.isRunning()) {
                    PHLocalBridgeDelegator.this.timer.stop();
                }
                PHLocalBridgeDelegator.this.timer = new PHHueCountTimer(60000L, new PHHueCountTimerListener(){

                    @Override
                    public void onFinish() {
                        if (notificationManager != null) {
                            notificationManager.notifySensorSearchFinished(listener);
                        }
                    }

                    @Override
                    public void onTick() {
                        try {
                            String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SENSOR).append(PHLocalBridgeDelegator.NEW).toString();
                            PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                            String response = httpConnection.getData(url);
                            if (response != null) {
                                PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                                List<PHHueError> errorTable = parser.parseError(response);
                                if (errorTable.size() != 0) {
                                    PHHueError error = errorTable.get(0);
                                    if (notificationManager != null) {
                                        notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                                    }
                                } else {
                                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                                    List<PHBridgeResource> sensorHeaders = bridgeVersionManager.getLightSerializer().parseGetAllLightHeaders(response);
                                    if (sensorHeaders == null || sensorHeaders.size() == 0) {
                                        notificationManager.notifySensorsReceived(listener, new ArrayList<PHBridgeResource>());
                                    } else if (notificationManager != null) {
                                        notificationManager.notifySensorsReceived(listener, sensorHeaders);
                                    }
                                    JSONObject jObject = new JSONObject(response);
                                    String scanStatus = jObject.optString("lastscan");
                                    if (!scanStatus.equals("active")) {
                                        this.onFinish();
                                        return;
                                    }
                                }
                            }
                            if (notificationManager.isSearchRunning()) {
                                PHLocalBridgeDelegator.this.timer.restart(2000L);
                            } else {
                                notificationManager.notifySensorSearchFinished(listener);
                            }
                        }
                        catch (Exception e2) {
                            if (PHLog.isLoggable()) {
                                PHLog.e(PHLocalBridgeDelegator.TAG, "Exception: " + e2);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                            }
                            return;
                        }
                    }
                });
                PHLocalBridgeDelegator.this.timer.start(0L);
            }
        }.start();
    }

    @Override
    public void findNewSensorsWithSerials(final List<String> serials, final PHSensorListener listener) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canCreate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                if (!PHLocalBridgeDelegator.this.searchSensorsWithSerials(notificationManager, serials, listener)) {
                    return;
                }
                if (notificationManager != null) {
                    notificationManager.startSearchNotification();
                }
                if (PHLocalBridgeDelegator.this.timer != null && PHLocalBridgeDelegator.this.timer.isRunning()) {
                    PHLocalBridgeDelegator.this.timer.stop();
                }
                PHLocalBridgeDelegator.this.timer = new PHHueCountTimer(60000L, new PHHueCountTimerListener(){

                    @Override
                    public void onFinish() {
                        notificationManager.notifySensorSearchFinished(listener);
                    }

                    @Override
                    public void onTick() {
                        String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SENSOR).append(PHLocalBridgeDelegator.NEW).toString();
                        try {
                            PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                            String response = httpConnection.getData(url);
                            if (response != null) {
                                PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                                List<PHHueError> errorTable = parser.parseError(response);
                                if (errorTable.size() != 0) {
                                    if (notificationManager != null) {
                                        notificationManager.notifySensorsReceived(listener, new ArrayList<PHBridgeResource>());
                                    }
                                } else {
                                    JSONObject jObject;
                                    String scanStatus;
                                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                                    List<PHBridgeResource> sensorHeaders = bridgeVersionManager.getLightSerializer().parseGetAllLightHeaders(response);
                                    if (sensorHeaders == null || sensorHeaders.size() == 0) {
                                        if (notificationManager != null) {
                                            notificationManager.notifySensorsReceived(listener, new ArrayList<PHBridgeResource>());
                                        }
                                    } else if (notificationManager != null) {
                                        notificationManager.notifySensorsReceived(listener, sensorHeaders);
                                    }
                                    if (!(scanStatus = (jObject = new JSONObject(response)).optString("lastscan")).equals("active")) {
                                        this.onFinish();
                                        return;
                                    }
                                }
                            }
                            if (notificationManager != null) {
                                if (notificationManager.isSearchRunning()) {
                                    PHLocalBridgeDelegator.this.timer.restart(2000L);
                                } else {
                                    notificationManager.notifySensorSearchFinished(listener);
                                }
                            }
                        }
                        catch (Exception e2) {
                            if (PHLog.isLoggable()) {
                                PHLog.e(PHLocalBridgeDelegator.TAG, "Exception: " + e2);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                            }
                            return;
                        }
                    }
                });
                PHLocalBridgeDelegator.this.timer.start(0L);
            }
        }.start();
    }

    @Override
    public void createSensor(final PHSensor sensor, final PHSensorListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canCreate()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getSensorSerializer().createSensorPacket(sensor).toString();
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SENSOR).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.postData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            Map<String, String> successTable = parser.parseSuccess(response);
                            String val = successTable.get("id");
                            if (val == null) {
                                String msg = "Unable to parse response";
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, 52, msg);
                                }
                            } else {
                                String[] arr = val.split("/");
                                sensor.setIdentifier(arr[arr.length - 1]);
                                if (sensor.getIdentifier() != null) {
                                    PHLocalBridgeDelegator.this.doLocalSensorCreate(sensor, bridge);
                                    if (notificationManager != null) {
                                        notificationManager.notifyCacheUpdated(PHMessageType.SENSOR_CACHE_UPDATED, (PHBridge)bridge);
                                    }
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifySensorDetails(listener, sensor);
                                    notificationManager.notifyBridgeAPISuccess(listener);
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void updateSensor(final PHSensor sensor, final PHSensorListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getSensorSerializer().updateSensorPacket(sensor).toString();
                    if (data == null) {
                        throw new PHInvalidInputException();
                    }
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SENSOR).append(sensor.getIdentifier()).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.putData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            PHLocalBridgeDelegator.this.doLocalSensorUpdate(sensor, bridge, parser.parseSuccess(response));
                            if (notificationManager != null) {
                                notificationManager.notifyCacheUpdated(PHMessageType.SENSOR_CACHE_UPDATED, (PHBridge)bridge);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPISuccess(listener);
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void deleteSensor(final String sensorIdentifier, final PHSensorListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SENSOR).append(sensorIdentifier).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.deleteData(url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            boolean flag = parser.parseIsSuccess(response);
                            if (!flag) {
                                String msg = "Unable to parse response";
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, 52, msg);
                                }
                            } else {
                                PHLocalBridgeDelegator.this.doLocalSensorDelete(sensorIdentifier, bridge);
                                if (notificationManager != null) {
                                    notificationManager.notifyCacheUpdated(PHMessageType.SENSOR_CACHE_UPDATED, (PHBridge)bridge);
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPISuccess(listener);
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void saveSensorState(final PHSensor sensor, final PHSensorListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                block12: {
                    if (sensor == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 23, "Input parameter can't be null");
                        }
                        return;
                    }
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SENSOR).append(sensor.getIdentifier()).append("/state").toString();
                    try {
                        PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                        PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                        String body = bridgeVersionManager.getSensorSerializer().updateSensorStatePacket(sensor).toString();
                        String response = httpConnection.putData(body, url);
                        if (response == null) {
                            String apiError = "Unsupported Response from Bridge";
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 46, apiError);
                            }
                        } else {
                            PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                            List<PHHueError> errorTable = parser.parseError(response);
                            if (errorTable.size() != 0) {
                                PHHueError error = errorTable.get(0);
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                                }
                            } else {
                                Map<String, String> successTable = parser.parseSuccess(response);
                                PHLocalBridgeDelegator.this.doLocalSensorStateUpdate(sensor, bridge, successTable);
                                if (notificationManager != null) {
                                    notificationManager.notifyCacheUpdated(PHMessageType.SENSOR_CACHE_UPDATED, (PHBridge)bridge);
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIStateUpdate(listener, successTable, errorTable);
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        if (notificationManager == null) break block12;
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                }
            }
        }.start();
    }

    @Override
    public void saveSensorConfiguration(final PHSensor sensor, final PHSensorListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                block12: {
                    if (sensor == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 23, "Input parameter can't be null");
                        }
                        return;
                    }
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SENSOR).append(sensor.getIdentifier()).append(PHLocalBridgeDelegator.CONFIGURATION).toString();
                    try {
                        PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                        PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                        String body = bridgeVersionManager.getSensorSerializer().updateSensorConfigurationPacket(sensor).toString();
                        String response = httpConnection.putData(body, url);
                        if (response == null) {
                            String apiError = "Unsupported Response from Bridge";
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 46, apiError);
                            }
                        } else {
                            PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                            List<PHHueError> errorTable = parser.parseError(response);
                            if (errorTable.size() != 0) {
                                PHHueError error = errorTable.get(0);
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                                }
                            } else {
                                Map<String, String> successTable = parser.parseSuccess(response);
                                PHLocalBridgeDelegator.this.doLocalSensorConfigUpdate(sensor, bridge, successTable);
                                if (notificationManager != null) {
                                    notificationManager.notifyCacheUpdated(PHMessageType.SENSOR_CACHE_UPDATED, (PHBridge)bridge);
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIStateUpdate(listener, successTable, errorTable);
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        if (notificationManager == null) break block12;
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                }
            }
        }.start();
    }

    private boolean searchSensors(PHNotificationManagerImpl notificationManager, PHSensorListener listener) {
        try {
            if (notificationManager == null) {
                return false;
            }
            String url = this.buildHttpAddress().append(SENSOR).toString();
            PHHueHttpConnection httpConnection = this.getConnectionObject();
            String response = httpConnection.postData("", url);
            if (response == null) {
                String searchFailForLights = "Unable to search Sensors";
                if (notificationManager != null) {
                    notificationManager.notifyBridgeAPIError(listener, 46, searchFailForLights);
                }
                return false;
            }
            PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
            List<PHHueError> errorTable = parser.parseError(response);
            if (errorTable.size() != 0) {
                PHHueError error = errorTable.get(0);
                if (notificationManager != null) {
                    notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                }
                return false;
            }
            if (notificationManager != null) {
                notificationManager.notifyBridgeAPISuccess(listener);
            }
            return true;
        }
        catch (Exception e2) {
            if (PHLog.isLoggable()) {
                PHLog.e(TAG, "Exception: " + e2);
            }
            return false;
        }
    }

    private boolean searchSensorsWithSerials(PHNotificationManagerImpl notificationManager, List<String> serials, PHSensorListener listener) {
        if (notificationManager == null) {
            return false;
        }
        String url = this.buildHttpAddress().append(SENSOR).toString();
        PHHueHttpConnection httpConnection = this.getConnectionObject();
        boolean isSuccess = false;
        try {
            PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
            String data = bridgeVersionManager.getSensorSerializer().createFindSensorWithSerialsPacket(serials).toString();
            String response = httpConnection.postData(data, url);
            if (response == null) {
                String apiError = "Unsupported Response from Bridge";
                if (notificationManager != null) {
                    notificationManager.notifyBridgeAPIError(listener, 46, apiError);
                }
            } else {
                PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                List<PHHueError> errorTable = parser.parseError(response);
                if (errorTable.size() != 0) {
                    PHHueError error = errorTable.get(0);
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                    }
                    isSuccess = false;
                } else {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPISuccess(listener);
                    }
                    isSuccess = true;
                }
            }
        }
        catch (Exception e2) {
            if (notificationManager != null) {
                notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
            }
            isSuccess = false;
        }
        return isSuccess;
    }

    private void doLocalSceneUpdate(PHScene scene, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHScene> scenesCache = cache.getScenes();
        scenesCache.put(scene.getSceneIdentifier(), scene);
    }

    private void doLocalLightDelete(String lightIdentifier, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHLight> lightCache = cache.getLights();
        lightCache.remove(lightIdentifier);
    }

    private void doLocalSceneDelete(String sceneIdentifier, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHScene> scenesCache = cache.getScenes();
        scenesCache.remove(sceneIdentifier);
    }

    private void doLocalLightStateUpdate(String identifier, Map<String, String> successTable, PHLightState lightState, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHLight> lightCache = cache.getLights();
        PHLight light = lightCache.get(identifier);
        PHLightState newLightState = light.getLastKnownLightState();
        if (newLightState == null) {
            newLightState = new PHLightState();
            light.setLastKnownLightState(newLightState);
        }
        boolean hueSatReceived = false;
        boolean ctReceived = false;
        boolean xyReceived = false;
        Set<String> keys = successTable.keySet();
        for (String key : keys) {
            if (key.endsWith("on")) {
                newLightState.setOn(lightState.isOn());
                continue;
            }
            if (key.endsWith("bri")) {
                newLightState.setBrightness(Integer.parseInt(successTable.get(key)));
                continue;
            }
            if (key.endsWith("hue")) {
                newLightState.setHue(Integer.parseInt(successTable.get(key)));
                hueSatReceived = true;
                continue;
            }
            if (key.endsWith("sat")) {
                newLightState.setSaturation(Integer.parseInt(successTable.get(key)));
                hueSatReceived = true;
                continue;
            }
            if (key.endsWith("xy")) {
                JSONArray xyArray = new JSONArray(successTable.get(key));
                newLightState.setX(Float.valueOf((float)xyArray.optDouble(0)), true);
                newLightState.setY(Float.valueOf((float)xyArray.optDouble(1)), true);
                xyReceived = true;
                continue;
            }
            if (key.endsWith("alert")) {
                newLightState.setAlertMode(lightState.getAlertMode());
                continue;
            }
            if (key.endsWith("effect")) {
                newLightState.setEffectMode(lightState.getEffectMode());
                continue;
            }
            if (!key.endsWith("ct")) continue;
            newLightState.setCt(Integer.parseInt(successTable.get(key)));
            ctReceived = true;
        }
        if (hueSatReceived) {
            newLightState.setColorMode(PHLight.PHLightColorMode.COLORMODE_HUE_SATURATION);
        }
        if (ctReceived) {
            newLightState.setColorMode(PHLight.PHLightColorMode.COLORMODE_CT);
        }
        if (xyReceived) {
            newLightState.setColorMode(PHLight.PHLightColorMode.COLORMODE_XY);
        }
    }

    private void doLocalSensorCreate(PHSensor sensor, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHSensor> sensorCache = cache.getSensors();
        sensorCache.put(sensor.getIdentifier(), sensor);
    }

    private void doLocalSensorUpdate(PHSensor sensor, PHBridgeImpl bridge, Map<String, String> successTable) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHSensor> sensorCache = cache.getSensors();
        PHSensor cachedSensor = sensorCache.get(sensor.getIdentifier());
        Set<String> keys = successTable.keySet();
        for (String key : keys) {
            if (!key.endsWith("name")) continue;
            cachedSensor.setName(sensor.getName());
        }
    }

    private void doLocalSensorConfigUpdate(PHSensor sensor, PHBridgeImpl bridge, Map<String, String> successTable) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHSensor> sensorCache = cache.getSensors();
        PHSensor cachedSensor = sensorCache.get(sensor.getIdentifier());
        Set<String> keys = successTable.keySet();
        for (String key : keys) {
            if (key.endsWith("on")) {
                cachedSensor.getBaseConfiguration().setOn(sensor.getBaseConfiguration().getOn());
                continue;
            }
            if (key.endsWith("url")) {
                cachedSensor.getBaseConfiguration().setUrl(sensor.getBaseConfiguration().getUrl());
                continue;
            }
            if (key.endsWith("battery")) {
                cachedSensor.getBaseConfiguration().setBattery(sensor.getBaseConfiguration().getBattery());
                continue;
            }
            if (sensor.getBaseConfiguration() instanceof PHPresenceSensorConfiguration) {
                if (!key.endsWith("motionsensitivity")) continue;
                ((PHPresenceSensorConfiguration)cachedSensor.getBaseConfiguration()).setMotionSensitivity(((PHPresenceSensorConfiguration)sensor.getBaseConfiguration()).getMotionSensitivity());
                continue;
            }
            if (sensor.getBaseConfiguration() instanceof PHGeofenceSensorConfiguration) {
                if (key.endsWith("radius")) {
                    ((PHGeofenceSensorConfiguration)cachedSensor.getBaseConfiguration()).setRadius(((PHGeofenceSensorConfiguration)sensor.getBaseConfiguration()).getRadius());
                    continue;
                }
                if (!key.endsWith("device")) continue;
                ((PHGeofenceSensorConfiguration)cachedSensor.getBaseConfiguration()).setDevice(((PHGeofenceSensorConfiguration)sensor.getBaseConfiguration()).getDevice());
                continue;
            }
            if (!(sensor.getBaseConfiguration() instanceof PHDaylightSensorConfiguration)) continue;
            if (key.endsWith("long")) {
                ((PHDaylightSensorConfiguration)cachedSensor.getBaseConfiguration()).setLongitude(((PHDaylightSensorConfiguration)sensor.getBaseConfiguration()).getLongitude());
                continue;
            }
            if (key.endsWith("lat")) {
                ((PHDaylightSensorConfiguration)cachedSensor.getBaseConfiguration()).setLatitude(((PHDaylightSensorConfiguration)sensor.getBaseConfiguration()).getLatitude());
                continue;
            }
            if (key.endsWith("sunriseoffset")) {
                ((PHDaylightSensorConfiguration)cachedSensor.getBaseConfiguration()).setSunriseOffset(((PHDaylightSensorConfiguration)sensor.getBaseConfiguration()).getSunriseOffset());
                continue;
            }
            if (!key.endsWith("sunsetoffset")) continue;
            ((PHDaylightSensorConfiguration)cachedSensor.getBaseConfiguration()).setSunsetOffset(((PHDaylightSensorConfiguration)sensor.getBaseConfiguration()).getSunsetOffset());
        }
    }

    private void doLocalSensorStateUpdate(PHSensor sensor, PHBridgeImpl bridge, Map<String, String> successTable) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHSensor> sensorCache = cache.getSensors();
        PHSensor cachedSensor = sensorCache.get(sensor.getIdentifier());
        Set<String> keys = successTable.keySet();
        for (String key : keys) {
            if (sensor.getBaseState() instanceof PHGenericFlagSensorState) {
                if (!key.endsWith("flag")) continue;
                ((PHGenericFlagSensorState)cachedSensor.getBaseState()).setFlag(((PHGenericFlagSensorState)sensor.getBaseState()).getFlag());
                continue;
            }
            if (sensor.getBaseState() instanceof PHGenericStatusSensorState) {
                if (!key.endsWith("status")) continue;
                ((PHGenericStatusSensorState)cachedSensor.getBaseState()).setStatus(((PHGenericStatusSensorState)sensor.getBaseState()).getStatus());
                continue;
            }
            if (sensor.getBaseState() instanceof PHSwitchState) {
                if (!key.endsWith("buttonevent")) continue;
                ((PHSwitchState)cachedSensor.getBaseState()).setButtonEvent(((PHSwitchState)sensor.getBaseState()).getButtonEvent());
                continue;
            }
            if (sensor.getBaseState() instanceof PHOpenCloseSensorState) {
                if (!key.endsWith("open")) continue;
                ((PHOpenCloseSensorState)cachedSensor.getBaseState()).setOpen(((PHOpenCloseSensorState)sensor.getBaseState()).getOpen());
                continue;
            }
            if (sensor.getBaseState() instanceof PHPresenceSensorState) {
                if (!key.endsWith("presence")) continue;
                ((PHPresenceSensorState)cachedSensor.getBaseState()).setPresence(((PHPresenceSensorState)sensor.getBaseState()).getPresence());
                continue;
            }
            if (sensor.getBaseState() instanceof PHGeofenceSensorState) {
                if (!key.endsWith("presence")) continue;
                ((PHGeofenceSensorState)cachedSensor.getBaseState()).setPresence(((PHGeofenceSensorState)sensor.getBaseState()).getPresence());
                continue;
            }
            if (sensor.getBaseState() instanceof PHTemperatureSensorState) {
                if (!key.endsWith("temperature")) continue;
                ((PHTemperatureSensorState)cachedSensor.getBaseState()).setTemperature(((PHTemperatureSensorState)sensor.getBaseState()).getTemperature());
                continue;
            }
            if (sensor.getBaseState() instanceof PHHumiditySensorState) {
                if (!key.endsWith("humidity")) continue;
                ((PHHumiditySensorState)cachedSensor.getBaseState()).setHumidity(((PHHumiditySensorState)sensor.getBaseState()).getHumidity());
                continue;
            }
            if (!(sensor.getBaseState() instanceof PHDaylightSensorState) || !key.endsWith("daylight")) continue;
            ((PHDaylightSensorState)cachedSensor.getBaseState()).setDaylight(((PHDaylightSensorState)sensor.getBaseState()).getDaylight());
        }
    }

    private void doLocalSensorDelete(String sensorIdentifier, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHSensor> sensorCache = cache.getSensors();
        sensorCache.remove(sensorIdentifier);
    }

    private void doLocalRuleCreate(PHRule rule, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHRule> ruleCache = cache.getRules();
        ruleCache.put(rule.getIdentifier(), rule);
    }

    private void doLocalRuleUpdate(PHRule rule, PHBridgeImpl bridge, Map<String, String> successTable) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHRule> ruleCache = cache.getRules();
        PHRule cachedRule = ruleCache.get(rule.getIdentifier());
        Set<String> keys = successTable.keySet();
        for (String key : keys) {
            if (!key.endsWith("name")) continue;
            cachedRule.setName(rule.getName());
        }
    }

    private void doLocalRuleDelete(String ruleIdentifier, PHBridgeImpl bridge) {
        PHBridgeResourcesCacheImpl cache = (PHBridgeResourcesCacheImpl)bridge.getResourceCache();
        Map<String, PHRule> ruleCache = cache.getRules();
        ruleCache.remove(ruleIdentifier);
    }

    @Override
    public void createRule(final PHRule rule, final PHRuleListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getRulesSerializer().createRule(rule).toString();
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.RULE).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.postData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            Map<String, String> successTable = parser.parseSuccess(response);
                            String val = successTable.get("id");
                            if (val == null) {
                                String msg = "Unable to parse response";
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, 52, msg);
                                }
                            } else {
                                String[] arr = val.split("/");
                                rule.setIdentifier(arr[arr.length - 1]);
                                if (rule.getIdentifier() != null) {
                                    PHLocalBridgeDelegator.this.doLocalRuleCreate(rule, bridge);
                                    if (notificationManager != null) {
                                        notificationManager.notifyCacheUpdated(PHMessageType.RULE_CACHE_UPDATED, (PHBridge)bridge);
                                    }
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyRuleDetails(listener, rule);
                                    notificationManager.notifyBridgeAPISuccess(listener);
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void updateRule(final PHRule rule, final PHRuleListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    String data = bridgeVersionManager.getRulesSerializer().updateRule(rule).toString();
                    if (data == null) {
                        throw new PHInvalidInputException();
                    }
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.RULE).append(rule.getIdentifier()).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.putData(data, url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            PHLocalBridgeDelegator.this.doLocalRuleUpdate(rule, bridge, parser.parseSuccess(response));
                            if (notificationManager != null) {
                                notificationManager.notifyCacheUpdated(PHMessageType.RULE_CACHE_UPDATED, (PHBridge)bridge);
                            }
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPISuccess(listener);
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void deleteRule(final String ruleIdentifier, final PHRuleListener listener, final PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.RULE).append(ruleIdentifier).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.deleteData(url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            boolean flag = parser.parseIsSuccess(response);
                            if (!flag) {
                                String msg = "Unable to parse response";
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, 52, msg);
                                }
                            } else {
                                PHLocalBridgeDelegator.this.doLocalRuleDelete(ruleIdentifier, bridge);
                                if (notificationManager != null) {
                                    notificationManager.notifyCacheUpdated(PHMessageType.RULE_CACHE_UPDATED, (PHBridge)bridge);
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPISuccess(listener);
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public String getWhitelistIdentifier() {
        return this.key;
    }

    @Override
    public void getSupportedTimeZones(final PHTimeZoneListener listener) {
        final PHTimeZoneSerializer timeZoneSerializer = PHBridgeVersionManager.getInstance().getTimeZoneSerializer();
        if (timeZoneSerializer == null) {
            listener.onError("Unsupported in this Bridge Version");
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.INFO).append(PHLocalBridgeDelegator.TIMEZONES).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.getData(url);
                    if (response == null) {
                        if (listener != null) {
                            listener.onError("Data not found");
                        }
                    } else if (listener != null) {
                        List<String> timeZoneArray = timeZoneSerializer.parseTimeZones(response);
                        listener.onSuccess(timeZoneArray);
                    }
                }
                catch (Exception e2) {
                    if (PHLog.isLoggable()) {
                        PHLog.e(PHLocalBridgeDelegator.TAG, "Exception: " + e2);
                    }
                    if (listener != null) {
                        listener.onError("Exception: " + e2);
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void doGet(final String url, final PHHTTPListener listener) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.getData(url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyHTTPResponse(listener, "Unable to Process Request");
                        }
                    } else if (notificationManager != null) {
                        notificationManager.notifyHTTPResponse(listener, response);
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyHTTPResponse(listener, "Unable to Process Request");
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void doPut(String url, String json, PHHTTPListener listener) {
        this.doPostOrPutOrDelete("PUT", url, json, listener);
    }

    @Override
    public void doPost(String url, String json, PHHTTPListener listener) {
        this.doPostOrPutOrDelete("POST", url, json, listener);
    }

    @Override
    public void doDelete(String url, PHHTTPListener listener) {
        this.doPostOrPutOrDelete("DELETE", url, "", listener);
    }

    public void doPostOrPutOrDelete(final String method, final String url, final String json, final PHHTTPListener listener) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = method.equalsIgnoreCase("PUT") ? httpConnection.putData(json, url) : (method.equalsIgnoreCase("POST") ? httpConnection.postData(json, url) : httpConnection.deleteData(url));
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyHTTPResponse(listener, "Unable to Process Request");
                        }
                    } else if (notificationManager != null) {
                        notificationManager.notifyHTTPResponse(listener, response);
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyHTTPResponse(listener, "Unable to Process Request");
                    }
                    return;
                }
            }
        }.start();
    }

    @Override
    public void getScene(final String sceneId, final PHSceneListener listener, PHBridgeImpl bridge) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        if (sceneId == null) {
            notificationManager.notifyBridgeAPIError(listener, 23, "Scene identifier not set.");
            return;
        }
        PHSceneSerializer scenesSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (scenesSerializer == null) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                block9: {
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SCENE).append(sceneId).toString();
                    try {
                        PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                        PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                        String response = httpConnection.getData(url);
                        if (response == null) {
                            String apiError = "Unsupported Response from Bridge";
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, 46, apiError);
                            }
                        } else {
                            PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                            List<PHHueError> errorTable = parser.parseError(response);
                            if (errorTable.size() != 0) {
                                PHHueError error = errorTable.get(0);
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                                }
                            } else {
                                PHScene scene = bridgeVersionManager.getScenesSerializer().parseSceneDetails(response, sceneId);
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeGetScene(listener, scene);
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        if (notificationManager == null) break block9;
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                }
            }
        }.start();
    }

    @Override
    public void deleteScene(final String sceneIdentifier, final PHSceneListener listener, final PHBridgeImpl bridge) throws PHHueInvalidAPIException {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        PHSceneSerializer sceneSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (sceneSerializer == null || !sceneSerializer.canDelete()) {
            if (notificationManager != null) {
                String apiError = "Unsupported in this Bridge Version";
                notificationManager.notifyBridgeAPIError(listener, 50, apiError);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String url = PHLocalBridgeDelegator.this.buildHttpAddress().append(PHLocalBridgeDelegator.SCENE).append(sceneIdentifier).toString();
                    PHHueHttpConnection httpConnection = PHLocalBridgeDelegator.this.getConnectionObject();
                    String response = httpConnection.deleteData(url);
                    if (response == null) {
                        if (notificationManager != null) {
                            notificationManager.notifyBridgeAPIError(listener, 46, null);
                        }
                    } else {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            PHHueError error = errorTable.get(0);
                            if (notificationManager != null) {
                                notificationManager.notifyBridgeAPIError(listener, error.getCode(), error.getMessage());
                            }
                        } else {
                            boolean flag = parser.parseIsSuccess(response);
                            if (!flag) {
                                String msg = "Unable to parse response";
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPIError(listener, 52, msg);
                                }
                            } else {
                                PHLocalBridgeDelegator.this.doLocalSceneDelete(sceneIdentifier, bridge);
                                if (notificationManager != null) {
                                    notificationManager.notifyCacheUpdated(PHMessageType.LIGHTS_CACHE_UPDATED, (PHBridge)bridge);
                                }
                                if (notificationManager != null) {
                                    notificationManager.notifyBridgeAPISuccess(listener);
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    if (notificationManager != null) {
                        notificationManager.notifyBridgeAPIError(listener, 42, e2 != null ? e2.getMessage() : null);
                    }
                    return;
                }
            }
        }.start();
    }
}

