/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.connection.impl;

import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.PHHueSDK;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeImpl;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeResourcesCacheImpl;
import com.philips.lighting.hue.sdk.clip.PHBridgeConfigurationSerializer;
import com.philips.lighting.hue.sdk.clip.PHGroupSerializer;
import com.philips.lighting.hue.sdk.clip.PHLightSerializer;
import com.philips.lighting.hue.sdk.clip.PHRuleSerializer;
import com.philips.lighting.hue.sdk.clip.PHSceneSerializer;
import com.philips.lighting.hue.sdk.clip.PHScheduleSerializer;
import com.philips.lighting.hue.sdk.clip.PHSensorSerializer;
import com.philips.lighting.hue.sdk.clip.serialisation.PHCLIPParserBase;
import com.philips.lighting.hue.sdk.connection.impl.PHHueHttpConnection;
import com.philips.lighting.hue.sdk.connection.impl.PHLocalBridgeDelegator;
import com.philips.lighting.hue.sdk.fbp.PHBridgeVersionManager;
import com.philips.lighting.hue.sdk.notification.impl.PHNotificationManagerImpl;
import com.philips.lighting.hue.sdk.util.PHHueCountTimer;
import com.philips.lighting.hue.sdk.util.PHHueCountTimerListener;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHHueError;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import com.philips.lighting.model.rule.PHRule;
import com.philips.lighting.model.sensor.PHSensor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHBridgeInternal {
    private static final String TAG = "PHBridgeInternal";
    private static final long TIMEOUT_PUSHLINKINMS = 30000L;
    private static final long TIMER_DELAY = 1000L;
    private static final long START_DELAY_TIMEINMS = 0L;
    private PHHueCountTimer pushLinkTimer = null;

    public PHHueHttpConnection getConnectionObject() {
        return new PHHueHttpConnection();
    }

    public void connectToAccessPoint(final PHAccessPoint accessPoint) {
        final PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (notificationManager == null) {
            return;
        }
        if (accessPoint == null) {
            notificationManager.notifySDKError(44, "Data not found");
            return;
        }
        if (this.checkAlreadyConnected(accessPoint.getIpAddress())) {
            notificationManager.notifySDKError(27, "You can not connect to a bridge which is already connected");
            return;
        }
        new Thread(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    String key = accessPoint.getUsername();
                    String response = PHBridgeInternal.this.getBridgeDetails(key, accessPoint.getIpAddress());
                    if (response != null) {
                        PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                        List<PHHueError> errorTable = parser.parseError(response);
                        if (errorTable.size() != 0) {
                            for (PHHueError error : errorTable) {
                                if (error.getCode() != 1) continue;
                                notificationManager.notifyBridgeAuthentication(accessPoint);
                            }
                            return;
                        } else {
                            PHBridgeImpl phBridgeImpl = PHBridgeInternal.this.processResponse(response, key);
                            if (phBridgeImpl == null) return;
                            notificationManager.notifyBridgeConnected(phBridgeImpl, key);
                        }
                        return;
                    } else {
                        String noResponse = "bridge not responding";
                        notificationManager.notifySDKError(46, noResponse);
                    }
                    return;
                }
                catch (Exception ex) {
                    notificationManager.notifySDKError(42, ex != null ? ex.getMessage() : null);
                }
            }
        }.start();
    }

    public String getBridgeDetails(String username, String ipAddress) {
        if (ipAddress != null) {
            String url = "http://" + ipAddress + "/api/" + username;
            return this.getDataFromURL(url);
        }
        return null;
    }

    public String getConfigDetails(String username, String ipAddress) {
        if (username != null && ipAddress != null) {
            String url = "http://" + ipAddress + "/api/" + username + "/config";
            return this.getDataFromURL(url);
        }
        return null;
    }

    public String getLightsDetail(String username, String ipAddress) {
        if (username != null && ipAddress != null) {
            String url = "http://" + ipAddress + "/api/" + username + "/lights";
            return this.getDataFromURL(url);
        }
        return null;
    }

    public String getGroupsDetail(String username, String ipAddress) {
        if (username != null && ipAddress != null) {
            String url = "http://" + ipAddress + "/api/" + username + "/groups";
            return this.getDataFromURL(url);
        }
        return null;
    }

    public String getScenesDetail(String username, String ipAddress) {
        if (username != null && ipAddress != null) {
            String url = "http://" + ipAddress + "/api/" + username + "/scenes";
            return this.getDataFromURL(url);
        }
        return null;
    }

    public String getSchedulesDetail(String username, String ipAddress) {
        if (username != null && ipAddress != null) {
            String url = "http://" + ipAddress + "/api/" + username + "/schedules";
            return this.getDataFromURL(url);
        }
        return null;
    }

    public String getSensorsDetail(String username, String ipAddress) {
        if (username != null && ipAddress != null) {
            String url = "http://" + ipAddress + "/api/" + username + "/sensors";
            return this.getDataFromURL(url);
        }
        return null;
    }

    public String getRulesDetail(String username, String ipAddress) {
        if (username != null && ipAddress != null) {
            String url = "http://" + ipAddress + "/api/" + username + "/rules";
            return this.getDataFromURL(url);
        }
        return null;
    }

    private String getDataFromURL(String url) {
        block3: {
            if (url != null && !url.isEmpty()) {
                try {
                    PHHueHttpConnection httpConnection = this.getConnectionObject();
                    return httpConnection.getData(url);
                }
                catch (Exception e2) {
                    PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
                    if (notificationManager == null) break block3;
                    notificationManager.notifySDKError(42, e2 != null ? e2.getMessage() : null);
                }
            }
        }
        return null;
    }

    public void startPushlinkTimer(final PHAccessPoint accessPoint) {
        if (this.pushLinkTimer == null) {
            this.pushLinkTimer = new PHHueCountTimer(30000L, new PHHueCountTimerListener(){

                @Override
                public void onTick() {
                    PHBridgeInternal.this.postDeviceKey(PHBridgeInternal.this.pushLinkTimer, accessPoint);
                }

                @Override
                public void onFinish() {
                    PHBridgeInternal.this.pushLinkTimer = null;
                    String pushlinkAuthenticationFailed = "Authentication failed";
                    PHNotificationManagerImpl notification = PHNotificationManagerImpl.getNotificationManager();
                    if (notification != null) {
                        notification.notifySDKError(1158, pushlinkAuthenticationFailed);
                    }
                }
            });
            this.pushLinkTimer.start(0L);
        }
    }

    public boolean stopPushLinkTimer() {
        if (this.pushLinkTimer != null) {
            this.pushLinkTimer.stop();
            return true;
        }
        return false;
    }

    private void postDeviceKey(PHHueCountTimer timer, PHAccessPoint accessPoint) {
        block15: {
            if (accessPoint == null) {
                throw new IllegalArgumentException("Input parameter can't be null");
            }
            try {
                PHHueSDK phHueSDK = PHHueSDK.getInstance();
                String deviceName = phHueSDK.getDeviceName();
                String appName = phHueSDK.getAppName();
                String username = accessPoint.getUsername();
                PHLog.d(TAG, "postDeviceKey deviceID..." + username);
                JSONObject json = new JSONObject();
                json.put("devicetype", appName + "#" + deviceName);
                String postData = json.toString();
                String url = "http://" + accessPoint.getIpAddress() + "/api/";
                PHHueHttpConnection httpConnection = this.getConnectionObject();
                String response = httpConnection.postData(postData, url);
                if (response == null) {
                    if (timer.isRunning()) {
                        timer.restart(1000L);
                    }
                    break block15;
                }
                PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
                List<PHHueError> errorTable = parser.parseError(response);
                if (errorTable.size() != 0) {
                    for (PHHueError error : errorTable) {
                        if (error.getCode() != 101) continue;
                        PHNotificationManagerImpl notification = PHNotificationManagerImpl.getNotificationManager();
                        if (notification != null) {
                            notification.notifySDKError(101, error.getMessage());
                        }
                        if (!timer.isRunning()) continue;
                        timer.restart(1000L);
                    }
                    break block15;
                }
                String receivedKey = null;
                try {
                    JSONObject jObject;
                    JSONObject successObject;
                    JSONArray jsonArray = new JSONArray(response);
                    if (jsonArray.length() == 1 && (successObject = (jObject = jsonArray.getJSONObject(0)).optJSONObject("success")) != null) {
                        receivedKey = successObject.getString("username");
                    }
                }
                catch (JSONException e2) {
                    String msg = "Unable to parse response";
                    PHNotificationManagerImpl notification = PHNotificationManagerImpl.getNotificationManager();
                    if (notification != null) {
                        notification.notifySDKError(52, msg);
                    }
                    return;
                }
                if (receivedKey != null) {
                    if (timer != null) {
                        timer.stop();
                    }
                    PHLog.d(TAG, "postDeviceKey() GOT A KEY!: ");
                    accessPoint.setUsername(receivedKey);
                }
                this.connectToAccessPoint(accessPoint);
            }
            catch (Exception e3) {
                if (timer.isRunning()) {
                    timer.restart(1000L);
                }
                if (!PHLog.isLoggable()) break block15;
                PHLog.e(TAG, "Exception: " + e3);
            }
        }
    }

    public PHBridgeImpl processResponse(String response, String username) {
        PHBridgeImpl phBridge = null;
        JSONObject rootObject = null;
        try {
            rootObject = new JSONObject(response);
            if (rootObject != null) {
                PHBridgeResourcesCacheImpl cacheImpl;
                PHBridgeConfiguration bridgeConfigCache;
                PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                PHBridgeConfigurationSerializer bridgeConfigSerializer = bridgeVersionManager.getBridgeConfigurationSerializer();
                String bridgeSwVersion = bridgeConfigSerializer.parseBridgeSoftwareVersion(rootObject);
                String bridgeAPIVersion = bridgeConfigSerializer.parseBridgeAPIVersion(rootObject);
                bridgeVersionManager.setBridgeVersion(bridgeSwVersion, bridgeAPIVersion);
                PHBridgeConfiguration newBridgeConfig = bridgeVersionManager.getBridgeConfigurationSerializer().parseBridgeConfiguration(rootObject);
                if (phBridge == null) {
                    PHLocalBridgeDelegator bridgeDelegator = new PHLocalBridgeDelegator(newBridgeConfig.getIpAddress(), username);
                    phBridge = new PHBridgeImpl(bridgeDelegator);
                }
                if ((bridgeConfigCache = (cacheImpl = (PHBridgeResourcesCacheImpl)phBridge.getResourceCache()).getBridgeConfiguration()) == null) {
                    newBridgeConfig.setUserName(username);
                    cacheImpl.setBridgeConfiguration(newBridgeConfig);
                }
                this.addLightsToBridge(cacheImpl, rootObject, bridgeVersionManager);
                this.addGroupsToBridge(cacheImpl, rootObject, bridgeVersionManager);
                this.addSchedulesToBridge(cacheImpl, rootObject, bridgeVersionManager);
                this.addScenesToBridge(cacheImpl, rootObject, bridgeVersionManager);
                this.addSensorsToBridge(cacheImpl, rootObject, bridgeVersionManager);
                this.addRulesToBridge(cacheImpl, rootObject, bridgeVersionManager);
                if (this.checkAlreadyConnected(newBridgeConfig.getIpAddress())) {
                    PHNotificationManagerImpl notification = PHNotificationManagerImpl.getNotificationManager();
                    if (notification != null) {
                        notification.notifySDKError(27, "You can not connect to a bridge which is already connected");
                    }
                    return null;
                }
                PHHueSDK sdkObj = PHHueSDK.getStoredSDKObject();
                if (sdkObj != null) {
                    sdkObj.addBridge(phBridge);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            phBridge = null;
        }
        if (phBridge == null) {
            PHNotificationManagerImpl notification = PHNotificationManagerImpl.getNotificationManager();
            if (notification != null) {
                notification.notifySDKError(45, "Unsupported Response from Bridge");
            }
            return null;
        }
        return phBridge;
    }

    private void addLightsToBridge(PHBridgeResourcesCacheImpl cacheImpl, JSONObject rootObject, PHBridgeVersionManager bridgeVersionManager) {
        PHLightSerializer lightSerializer = bridgeVersionManager.getLightSerializer();
        if (lightSerializer != null) {
            List<PHLight> lightsList = lightSerializer.parseLights(rootObject);
            Map<String, PHLight> lightsCache = cacheImpl.getLights();
            if (lightsCache.isEmpty() && lightsList != null) {
                lightsCache = new HashMap<String, PHLight>();
                for (PHLight light : lightsList) {
                    lightsCache.put(light.getIdentifier(), light);
                }
                cacheImpl.setLights(lightsCache);
            }
        }
    }

    private void addGroupsToBridge(PHBridgeResourcesCacheImpl cacheImpl, JSONObject rootObject, PHBridgeVersionManager bridgeVersionManager) {
        PHGroupSerializer groupSerializer = bridgeVersionManager.getGroupSerializer();
        if (groupSerializer != null) {
            List<PHGroup> groupsList = groupSerializer.parseGroups(rootObject);
            Map<String, PHGroup> groupsCache = cacheImpl.getGroups();
            if (groupsCache.isEmpty() && groupsList != null) {
                groupsCache = new HashMap<String, PHGroup>();
                for (PHGroup group : groupsList) {
                    groupsCache.put(group.getIdentifier(), group);
                }
                cacheImpl.setGroups(groupsCache);
            }
        }
    }

    private void addSchedulesToBridge(PHBridgeResourcesCacheImpl cacheImpl, JSONObject rootObject, PHBridgeVersionManager bridgeVersionManager) {
        PHScheduleSerializer schedulesSerializer = bridgeVersionManager.getSchedulesSerializer();
        if (schedulesSerializer != null) {
            String timeZone = null;
            if (cacheImpl != null && cacheImpl.getBridgeConfiguration() != null) {
                timeZone = cacheImpl.getBridgeConfiguration().getTimeZone();
            }
            List<PHSchedule> schedulesList = schedulesSerializer.parseSchedules(rootObject, timeZone);
            Map<String, PHSchedule> schedulesCache = cacheImpl.getSchedules();
            if (schedulesCache.isEmpty() && schedulesList != null) {
                schedulesCache = new HashMap<String, PHSchedule>();
                for (PHSchedule schedule : schedulesList) {
                    schedulesCache.put(schedule.getIdentifier(), schedule);
                }
                cacheImpl.setSchedules(schedulesCache);
            }
        }
    }

    private void addScenesToBridge(PHBridgeResourcesCacheImpl cacheImpl, JSONObject rootObject, PHBridgeVersionManager bridgeVersionManager) {
        PHSceneSerializer scenesSerializer = bridgeVersionManager.getScenesSerializer();
        if (scenesSerializer != null) {
            List<PHScene> sceneList = scenesSerializer.parseScenes(rootObject);
            Map<String, PHScene> sceneCache = cacheImpl.getScenes();
            if (sceneCache.isEmpty() && sceneList != null) {
                sceneCache = new HashMap<String, PHScene>();
                for (PHScene scene : sceneList) {
                    sceneCache.put(scene.getSceneIdentifier(), scene);
                }
                cacheImpl.setScenes(sceneCache);
            }
        }
    }

    private void addSensorsToBridge(PHBridgeResourcesCacheImpl cacheImpl, JSONObject rootObject, PHBridgeVersionManager bridgeVersionManager) {
        PHSensorSerializer sensorSerializer = bridgeVersionManager.getSensorSerializer();
        if (sensorSerializer != null) {
            List<PHSensor> sensorList = sensorSerializer.parseSensors(rootObject);
            Map<String, PHSensor> sensorCache = cacheImpl.getSensors();
            if (sensorCache.isEmpty() && sensorList != null) {
                sensorCache = new HashMap<String, PHSensor>();
                for (PHSensor sensor : sensorList) {
                    sensorCache.put(sensor.getIdentifier(), sensor);
                }
                cacheImpl.setSensors(sensorCache);
            }
        }
    }

    private void addRulesToBridge(PHBridgeResourcesCacheImpl cacheImpl, JSONObject rootObject, PHBridgeVersionManager bridgeVersionManager) {
        PHRuleSerializer rulesSerializer = bridgeVersionManager.getRulesSerializer();
        if (rulesSerializer != null) {
            List<PHRule> rulesList = rulesSerializer.parseRules(rootObject);
            Map<String, PHRule> rulesCache = cacheImpl.getRules();
            if (rulesCache.isEmpty() && rulesList != null) {
                rulesCache = new HashMap<String, PHRule>();
                for (PHRule rule : rulesList) {
                    rulesCache.put(rule.getIdentifier(), rule);
                }
                cacheImpl.setRules(rulesCache);
            }
        }
    }

    private boolean checkAlreadyConnected(String ipAddress) {
        PHHueSDK bridgeImpl = PHHueSDK.getStoredSDKObject();
        if (bridgeImpl == null) {
            return false;
        }
        List<PHBridge> bridgeList = bridgeImpl.getAllBridges();
        for (PHBridge bridge : bridgeList) {
            String ip = bridge.getResourceCache().getBridgeConfiguration().getIpAddress();
            if (!ip.equals(ipAddress)) continue;
            return true;
        }
        return false;
    }
}

