/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation.sensors;

import com.philips.lighting.hue.sdk.utilities.PHUtilities;
import com.philips.lighting.model.sensor.PHSensor;
import com.philips.lighting.model.sensor.PHSensorConfiguration;
import com.philips.lighting.model.sensor.PHSensorState;
import java.util.Date;
import org.json.hue.JSONObject;

public class PHSensorSerializerBase1 {
    protected static PHSensor fillBasicSensor(PHSensor sensorInstance, JSONObject json) {
        String name = json.optString("name");
        sensorInstance.setName(name);
        String parsedModelId = json.optString("modelid");
        sensorInstance.setModelId(parsedModelId);
        String parsedManufacturerName = json.optString("manufacturername");
        sensorInstance.setManufacturerName(parsedManufacturerName);
        String parsedSwVersion = json.optString("swversion");
        sensorInstance.setSwVersion(parsedSwVersion);
        String parsedUniqueId = json.optString("uniqueid");
        sensorInstance.setUniqueId(parsedUniqueId);
        return sensorInstance;
    }

    protected static PHSensorState fillBasicSensorState(PHSensorState stateInstance, JSONObject json) {
        String lastUpdatedString = json.optString("lastupdated");
        if (lastUpdatedString != null && lastUpdatedString.length() != 0) {
            Date parsedLastUpdated = PHUtilities.stringToDate(lastUpdatedString, "UTC");
            stateInstance.setLastUpdated(parsedLastUpdated);
        } else {
            stateInstance.setLastUpdated(null);
        }
        return stateInstance;
    }

    protected static PHSensorConfiguration fillBasicSensorConfiguration(PHSensorConfiguration configInstance, JSONObject json) {
        if (json.has("url")) {
            String parsedUrl = json.optString("url");
            configInstance.setUrl(parsedUrl);
        } else {
            configInstance.setUrl(null);
        }
        if (json.has("battery")) {
            int parsedBattery = json.optInt("battery");
            configInstance.setBattery(parsedBattery);
        } else {
            configInstance.setBattery(null);
        }
        if (json.has("reachable")) {
            Boolean parsedReachable = json.optBoolean("reachable");
            configInstance.setReachable(parsedReachable);
        } else {
            configInstance.setReachable(null);
        }
        if (json.has("on")) {
            Boolean parsedOn = json.optBoolean("on");
            configInstance.setOn(parsedOn);
        } else {
            configInstance.setOn(null);
        }
        if (json.has("usertest")) {
            Boolean userTest = json.optBoolean("usertest");
            configInstance.setUserTest(userTest);
        } else {
            configInstance.setUserTest(null);
        }
        if (json.has("alert")) {
            String alertMode = json.optString("alert");
            configInstance.setAlertMode(PHSensorConfiguration.PHSensorAlertMode.fromValue(alertMode));
        } else {
            configInstance.setAlertMode(null);
        }
        return configInstance;
    }

    protected static JSONObject getJSONSensorBase(PHSensor sensor) {
        JSONObject json = new JSONObject();
        json.putOpt("name", sensor.getName());
        json.putOpt("manufacturername", sensor.getManufacturerName());
        json.putOpt("modelid", sensor.getModelId());
        json.putOpt("swversion", sensor.getSwVersion());
        json.putOpt("uniqueid", sensor.getUniqueId());
        return json;
    }

    protected static JSONObject getJSONSensorStateBase(PHSensorState state) {
        if (state != null) {
            JSONObject json = new JSONObject();
            return json;
        }
        return null;
    }

    protected static JSONObject getJSONSensorConfigurationBase(PHSensorConfiguration config) {
        if (config != null) {
            JSONObject json = new JSONObject();
            json.putOpt("url", config.getUrl());
            json.putOpt("battery", config.getBattery());
            json.putOpt("on", config.getOn());
            json.putOpt("usertest", config.getUserTest());
            if (config.getAlertMode() != null) {
                json.putOpt("alert", config.getAlertMode().getValue());
            }
            return json;
        }
        return null;
    }
}

