/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation.sensors;

import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHSensorSerializerBase1;
import com.philips.lighting.model.sensor.PHPresenceSensor;
import com.philips.lighting.model.sensor.PHPresenceSensorConfiguration;
import com.philips.lighting.model.sensor.PHPresenceSensorState;
import org.json.hue.JSONObject;

public class PHPresenceSensorSerializer1
extends PHSensorSerializerBase1 {
    public static PHPresenceSensor createFromJSON(JSONObject json, String identifier) {
        PHPresenceSensor.Type type = PHPresenceSensor.Type.CLIP;
        String sType = json.optString("type");
        if (sType != null && sType.equals(PHPresenceSensor.Type.ZLL.getValue())) {
            type = PHPresenceSensor.Type.ZLL;
        }
        PHPresenceSensor sensor = new PHPresenceSensor("", identifier, type);
        sensor = (PHPresenceSensor)PHPresenceSensorSerializer1.fillBasicSensor(sensor, json);
        sensor = PHPresenceSensorSerializer1.createConfigurationFromJSON(json, sensor);
        sensor = PHPresenceSensorSerializer1.createStateFromJSON(json, sensor);
        return sensor;
    }

    private static PHPresenceSensor createStateFromJSON(JSONObject json, PHPresenceSensor sensor) {
        JSONObject sensorStateObject = json.optJSONObject("state");
        if (sensorStateObject != null) {
            PHPresenceSensorState state = new PHPresenceSensorState();
            state = (PHPresenceSensorState)PHPresenceSensorSerializer1.fillBasicSensorState(state, sensorStateObject);
            if (sensorStateObject.has("presence")) {
                Boolean parsedPresence = sensorStateObject.optBoolean("presence");
                state.setPresence(parsedPresence);
            } else {
                state.setPresence(null);
            }
            sensor.setState(state);
        }
        return sensor;
    }

    private static PHPresenceSensor createConfigurationFromJSON(JSONObject json, PHPresenceSensor sensor) {
        JSONObject sensorConfigObject = json.optJSONObject("config");
        if (sensorConfigObject != null) {
            PHPresenceSensorConfiguration config = new PHPresenceSensorConfiguration();
            config = (PHPresenceSensorConfiguration)PHPresenceSensorSerializer1.fillBasicSensorConfiguration(config, sensorConfigObject);
            if (sensorConfigObject.has("motionsensitivity")) {
                int parsedMotionSensitivity = sensorConfigObject.optInt("motionsensitivity");
                config.setMotionSensitivity(parsedMotionSensitivity);
            } else {
                config.setMotionSensitivity(null);
            }
            sensor.setConfiguration(config);
        }
        return sensor;
    }

    public static JSONObject getJSON(PHPresenceSensor sensor) {
        JSONObject json = PHPresenceSensorSerializer1.getJSONSensorBase(sensor);
        json.putOpt("type", sensor.getTypeAsString());
        json = PHPresenceSensorSerializer1.addSensorStateJSON(json, sensor.getState());
        json = PHPresenceSensorSerializer1.addSensorConfigurationJSON(json, sensor.getConfiguration());
        return json;
    }

    private static JSONObject addSensorStateJSON(JSONObject sensorObj, PHPresenceSensorState state) {
        if (state != null) {
            JSONObject json = PHPresenceSensorSerializer1.getJSONSensorStateBase(state);
            String type = sensorObj.getString("type");
            if (!type.equals(PHPresenceSensor.Type.ZLL.getValue())) {
                json.putOpt("presence", state.getPresence());
            }
            sensorObj.put("state", json);
        }
        return sensorObj;
    }

    private static JSONObject addSensorConfigurationJSON(JSONObject sensorObj, PHPresenceSensorConfiguration config) {
        if (config != null) {
            JSONObject json = PHPresenceSensorSerializer1.getJSONSensorConfigurationBase(config);
            json.putOpt("motionsensitivity", config.getMotionSensitivity());
            String type = sensorObj.getString("type");
            if (type.equals(PHPresenceSensor.Type.ZLL.getValue())) {
                json.remove("battery");
            }
            sensorObj.putOpt("config", json);
        }
        return sensorObj;
    }

    public static JSONObject getStateJSON(PHPresenceSensor sensor) {
        JSONObject sensorObj = PHPresenceSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("state");
    }

    public static JSONObject getConfigurationJSON(PHPresenceSensor sensor) {
        JSONObject sensorObj = PHPresenceSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("config");
    }
}

