/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.PHSensorSerializer;
import com.philips.lighting.hue.sdk.clip.serialisation.PHCLIPParserBase;
import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHDaylightSensorSerializer1;
import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHGenericFlagSensorSerializer1;
import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHGenericStatusSensorSerializer1;
import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHGeofenceSensorSerializer1;
import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHHumiditySensorSerializer1;
import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHOpenCloseSensorSerializer1;
import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHPresenceSensorSerializer1;
import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHSwitchSerializer1;
import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHTemperatureSensorSerializer1;
import com.philips.lighting.hue.sdk.exception.PHHueException;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.sensor.PHDaylightSensor;
import com.philips.lighting.model.sensor.PHGenericFlagSensor;
import com.philips.lighting.model.sensor.PHGenericStatusSensor;
import com.philips.lighting.model.sensor.PHGeofenceSensor;
import com.philips.lighting.model.sensor.PHHumiditySensor;
import com.philips.lighting.model.sensor.PHOpenCloseSensor;
import com.philips.lighting.model.sensor.PHPresenceSensor;
import com.philips.lighting.model.sensor.PHSensor;
import com.philips.lighting.model.sensor.PHSensorConfiguration;
import com.philips.lighting.model.sensor.PHSensorState;
import com.philips.lighting.model.sensor.PHSwitch;
import com.philips.lighting.model.sensor.PHTemperatureSensor;
import java.util.ArrayList;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHSensorSerializer1
extends PHCLIPParserBase
implements PHSensorSerializer {
    private static final String TAG = PHSensorSerializer1.class.getSimpleName();
    private static PHSensorSerializer1 sensorSerialisation1;

    public static synchronized PHSensorSerializer1 getInstance() {
        if (sensorSerialisation1 == null) {
            sensorSerialisation1 = new PHSensorSerializer1();
        }
        return sensorSerialisation1;
    }

    @Override
    public List<PHSensor> parseSensors(JSONObject rootObject) {
        JSONArray sensorArray;
        ArrayList<PHSensor> sensorsList = new ArrayList<PHSensor>();
        JSONObject sensors = rootObject.optJSONObject("sensors");
        if (sensors == null) {
            sensors = rootObject;
        }
        if (sensors != null && (sensorArray = sensors.names()) != null) {
            for (int i2 = 0; i2 < sensorArray.length(); ++i2) {
                String sensorIdentifier = sensorArray.optString(i2);
                try {
                    JSONObject sensorObject = sensors.optJSONObject(sensorIdentifier);
                    if (sensorObject == null) continue;
                    String sensorType = sensorObject.optString("type");
                    if (sensorType == null || sensorType.length() == 0) {
                        throw new PHHueException("Internal error: JSON contains invalid type data");
                    }
                    if (sensorType.equals(PHGenericFlagSensor.Type.CLIP.getValue())) {
                        sensorsList.add(PHGenericFlagSensorSerializer1.createFromJSON(sensorObject, sensorIdentifier));
                        continue;
                    }
                    if (sensorType.equals(PHGenericStatusSensor.Type.CLIP.getValue())) {
                        sensorsList.add(PHGenericStatusSensorSerializer1.createFromJSON(sensorObject, sensorIdentifier));
                        continue;
                    }
                    if (sensorType.equals(PHSwitch.Type.CLIP.getValue()) || sensorType.equals(PHSwitch.Type.ZLL.getValue()) || sensorType.equals(PHSwitch.Type.ZGP.getValue())) {
                        sensorsList.add(PHSwitchSerializer1.createFromJSON(sensorObject, sensorIdentifier));
                        continue;
                    }
                    if (sensorType.equals(PHOpenCloseSensor.Type.CLIP.getValue()) || sensorType.equals(PHOpenCloseSensor.Type.ZLL.getValue())) {
                        sensorsList.add(PHOpenCloseSensorSerializer1.createFromJSON(sensorObject, sensorIdentifier));
                        continue;
                    }
                    if (sensorType.equals(PHPresenceSensor.Type.CLIP.getValue()) || sensorType.equals(PHPresenceSensor.Type.ZLL.getValue())) {
                        sensorsList.add(PHPresenceSensorSerializer1.createFromJSON(sensorObject, sensorIdentifier));
                        continue;
                    }
                    if (sensorType.equals(PHGeofenceSensor.Type.CLIP.getValue())) {
                        sensorsList.add(PHGeofenceSensorSerializer1.createFromJSON(sensorObject, sensorIdentifier));
                        continue;
                    }
                    if (sensorType.equals(PHTemperatureSensor.Type.CLIP.getValue()) || sensorType.equals(PHTemperatureSensor.Type.ZLL.getValue())) {
                        sensorsList.add(PHTemperatureSensorSerializer1.createFromJSON(sensorObject, sensorIdentifier));
                        continue;
                    }
                    if (sensorType.equals(PHHumiditySensor.Type.CLIP.getValue()) || sensorType.equals(PHHumiditySensor.Type.ZLL.getValue())) {
                        sensorsList.add(PHHumiditySensorSerializer1.createFromJSON(sensorObject, sensorIdentifier));
                        continue;
                    }
                    if (sensorType.equals(PHDaylightSensor.Type.CLIP.getValue())) {
                        sensorsList.add(PHDaylightSensorSerializer1.createFromJSON(sensorObject, sensorIdentifier));
                        continue;
                    }
                    throw new PHHueException("Internal error: JSON contains invalid type data");
                }
                catch (Exception e2) {
                    this.reportParsingError(65, sensorIdentifier, "Sensor unparsable due to error: " + e2.getMessage(), sensors.optJSONObject(sensorIdentifier));
                }
            }
        }
        return sensorsList;
    }

    public PHSensor parseGetSensorDetails(String response, String sensorIdentifier) {
        block4: {
            JSONObject jObject = null;
            try {
                List<PHSensor> sensors;
                jObject = new JSONObject(response);
                if (jObject != null && (sensors = this.parseSensors(jObject)) != null && sensors.size() != 0) {
                    for (PHSensor sensor : sensors) {
                        if (!sensor.getIdentifier().equals(sensorIdentifier)) continue;
                        return sensor;
                    }
                }
            }
            catch (JSONException e2) {
                if (!PHLog.isLoggable()) break block4;
                PHLog.e(TAG, "JSONException: " + e2);
            }
        }
        return null;
    }

    @Override
    public JSONObject createSensorPacket(PHSensor sensor) {
        if (sensor instanceof PHDaylightSensor) {
            return PHDaylightSensorSerializer1.getJSON((PHDaylightSensor)sensor);
        }
        if (sensor instanceof PHGenericFlagSensor) {
            return PHGenericFlagSensorSerializer1.getJSON((PHGenericFlagSensor)sensor);
        }
        if (sensor instanceof PHGenericStatusSensor) {
            return PHGenericStatusSensorSerializer1.getJSON((PHGenericStatusSensor)sensor);
        }
        if (sensor instanceof PHGeofenceSensor) {
            return PHGeofenceSensorSerializer1.getJSON((PHGeofenceSensor)sensor);
        }
        if (sensor instanceof PHHumiditySensor) {
            return PHHumiditySensorSerializer1.getJSON((PHHumiditySensor)sensor);
        }
        if (sensor instanceof PHOpenCloseSensor) {
            return PHOpenCloseSensorSerializer1.getJSON((PHOpenCloseSensor)sensor);
        }
        if (sensor instanceof PHPresenceSensor) {
            return PHPresenceSensorSerializer1.getJSON((PHPresenceSensor)sensor);
        }
        if (sensor instanceof PHSwitch) {
            return PHSwitchSerializer1.getJSON((PHSwitch)sensor);
        }
        if (sensor instanceof PHTemperatureSensor) {
            return PHTemperatureSensorSerializer1.getJSON((PHTemperatureSensor)sensor);
        }
        return null;
    }

    @Override
    public JSONObject updateSensorPacket(PHSensor sensor) throws JSONException {
        JSONObject json = new JSONObject();
        json.putOpt("name", sensor.getName());
        return json;
    }

    @Override
    public JSONObject updateSensorStatePacket(PHSensor sensor) {
        if (sensor instanceof PHDaylightSensor) {
            return PHDaylightSensorSerializer1.getStateJSON((PHDaylightSensor)sensor);
        }
        if (sensor instanceof PHGenericFlagSensor) {
            return PHGenericFlagSensorSerializer1.getStateJSON((PHGenericFlagSensor)sensor);
        }
        if (sensor instanceof PHGenericStatusSensor) {
            return PHGenericStatusSensorSerializer1.getStateJSON((PHGenericStatusSensor)sensor);
        }
        if (sensor instanceof PHGeofenceSensor) {
            return PHGeofenceSensorSerializer1.getStateJSON((PHGeofenceSensor)sensor);
        }
        if (sensor instanceof PHHumiditySensor) {
            return PHHumiditySensorSerializer1.getStateJSON((PHHumiditySensor)sensor);
        }
        if (sensor instanceof PHOpenCloseSensor) {
            return PHOpenCloseSensorSerializer1.getStateJSON((PHOpenCloseSensor)sensor);
        }
        if (sensor instanceof PHPresenceSensor) {
            return PHPresenceSensorSerializer1.getStateJSON((PHPresenceSensor)sensor);
        }
        if (sensor instanceof PHSwitch) {
            return PHSwitchSerializer1.getStateJSON((PHSwitch)sensor);
        }
        if (sensor instanceof PHTemperatureSensor) {
            return PHTemperatureSensorSerializer1.getStateJSON((PHTemperatureSensor)sensor);
        }
        return null;
    }

    @Override
    public JSONObject updateSensorConfigurationPacket(PHSensor sensor) {
        if (sensor instanceof PHDaylightSensor) {
            return PHDaylightSensorSerializer1.getConfigurationJSON((PHDaylightSensor)sensor);
        }
        if (sensor instanceof PHGenericFlagSensor) {
            return PHGenericFlagSensorSerializer1.getConfigurationJSON((PHGenericFlagSensor)sensor);
        }
        if (sensor instanceof PHGenericStatusSensor) {
            return PHGenericStatusSensorSerializer1.getConfigurationJSON((PHGenericStatusSensor)sensor);
        }
        if (sensor instanceof PHGeofenceSensor) {
            return PHGeofenceSensorSerializer1.getConfigurationJSON((PHGeofenceSensor)sensor);
        }
        if (sensor instanceof PHHumiditySensor) {
            return PHHumiditySensorSerializer1.getConfigurationJSON((PHHumiditySensor)sensor);
        }
        if (sensor instanceof PHOpenCloseSensor) {
            return PHOpenCloseSensorSerializer1.getConfigurationJSON((PHOpenCloseSensor)sensor);
        }
        if (sensor instanceof PHPresenceSensor) {
            return PHPresenceSensorSerializer1.getConfigurationJSON((PHPresenceSensor)sensor);
        }
        if (sensor instanceof PHSwitch) {
            return PHSwitchSerializer1.getConfigurationJSON((PHSwitch)sensor);
        }
        if (sensor instanceof PHTemperatureSensor) {
            return PHTemperatureSensorSerializer1.getConfigurationJSON((PHTemperatureSensor)sensor);
        }
        return null;
    }

    @Override
    public JSONObject createFindSensorWithSerialsPacket(List<String> serials) throws JSONException {
        JSONArray serialArray = new JSONArray();
        for (String serial : serials) {
            serialArray.put(serial);
        }
        JSONObject json = new JSONObject();
        json.putOpt("deviceid", serialArray);
        return json;
    }

    @Override
    public boolean validateAPI(PHSensor sensor) {
        return true;
    }

    @Override
    public boolean validateAPI(PHSensorState sensorState) {
        return true;
    }

    @Override
    public boolean validateAPI(PHSensorConfiguration sensorConfig) {
        return true;
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public boolean canSensorStateCreate() {
        return false;
    }

    @Override
    public boolean canSensorStateRead() {
        return true;
    }

    @Override
    public boolean canSensorStateUpdate() {
        return true;
    }

    @Override
    public boolean canSensorStateDelete() {
        return false;
    }

    @Override
    public boolean canSensorConfigurationCreate() {
        return false;
    }

    @Override
    public boolean canSensorConfigurationRead() {
        return true;
    }

    @Override
    public boolean canSensorConfigurationUpdate() {
        return true;
    }

    @Override
    public boolean canSensorConfigurationDelete() {
        return false;
    }

    @Override
    public boolean canFetchAll() {
        return true;
    }
}

