/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHBridgeConfigurationSerializer2;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHPortalState;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHBridgeConfigurationSerializer3
extends PHBridgeConfigurationSerializer2 {
    private static PHBridgeConfigurationSerializer3 bridgeConfigSerialisation3;

    public static synchronized PHBridgeConfigurationSerializer2 getInstance() {
        if (bridgeConfigSerialisation3 == null) {
            bridgeConfigSerialisation3 = new PHBridgeConfigurationSerializer3();
        }
        return bridgeConfigSerialisation3;
    }

    @Override
    public PHBridgeConfiguration parseBridgeConfiguration(JSONObject rootObject) {
        PHBridgeConfiguration config = super.parseBridgeConfiguration(rootObject);
        if (config != null) {
            JSONObject configObject = null;
            configObject = rootObject.has("config") ? rootObject.getJSONObject("config") : rootObject;
            if (configObject.has("portalstate")) {
                JSONObject portalStateJSON = configObject.getJSONObject("portalstate");
                Boolean signedOn = null;
                if (portalStateJSON.has("signedon")) {
                    signedOn = portalStateJSON.getBoolean("signedon");
                }
                Boolean incoming = null;
                if (portalStateJSON.has("incoming")) {
                    incoming = portalStateJSON.getBoolean("incoming");
                }
                Boolean outgoing = null;
                if (portalStateJSON.has("outgoing")) {
                    outgoing = portalStateJSON.getBoolean("outgoing");
                }
                PHPortalState.PHPortalCommunicationState communication = null;
                if (portalStateJSON.has("communication")) {
                    String comState = portalStateJSON.getString("communication");
                    communication = PHPortalState.PHPortalCommunicationState.getCommunicationState(comState);
                }
                config.setPortalState(new PHPortalState(signedOn, incoming, outgoing, communication));
            }
        }
        return config;
    }

    @Override
    public JSONObject updateBridgeConfigurationPacket(PHBridgeConfiguration bridgeConfig) throws JSONException {
        JSONObject packet = super.updateBridgeConfigurationPacket(bridgeConfig);
        if (bridgeConfig.isReboot()) {
            packet.put("reboot", true);
        }
        return packet;
    }

    @Override
    public boolean validateAPI(PHBridgeConfiguration bridgeConfiguration) {
        return bridgeConfiguration.getZigbeeChannel() == null;
    }
}

