/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.PHBridgeConfigurationSerializer;
import com.philips.lighting.hue.sdk.clip.serialisation.PHBridgeConfigurationSerializer2;
import com.philips.lighting.hue.sdk.clip.serialisation.PHCLIPParserBase;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHSoftwareUpdateStatus;
import com.philips.lighting.model.PHWhiteListEntry;
import java.util.ArrayList;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHBridgeConfigurationSerializer1
extends PHCLIPParserBase
implements PHBridgeConfigurationSerializer {
    private static PHBridgeConfigurationSerializer1 bridgeConfigSerialisation1;

    public static synchronized PHBridgeConfigurationSerializer1 getInstance() {
        if (bridgeConfigSerialisation1 == null) {
            bridgeConfigSerialisation1 = new PHBridgeConfigurationSerializer1();
        }
        return bridgeConfigSerialisation1;
    }

    @Override
    public PHBridgeConfiguration parseBridgeConfiguration(JSONObject rootObject) {
        PHBridgeConfiguration bridgeConfig = new PHBridgeConfiguration();
        try {
            JSONObject config = rootObject.optJSONObject("config");
            if (config == null) {
                config = rootObject;
            }
            if (config != null) {
                Integer proxyPort = 0;
                String ipAddress = config.optString("ipaddress");
                String macAddress = config.optString("mac");
                String name = config.optString("name");
                String proxy = config.optString("proxyaddress");
                String netmask = config.optString("netmask");
                String gateway = config.optString("gateway");
                proxyPort = config.optInt("proxyport");
                Boolean dhcpEnabled = null;
                dhcpEnabled = config.isNull("dhcp") ? null : Boolean.valueOf(config.optBoolean("dhcp"));
                String swversion = config.optString("swversion");
                Boolean portalServiceEnabled = config.isNull("portalservices") ? null : Boolean.valueOf(config.optBoolean("portalservices"));
                String time = config.optString("UTC");
                PHSoftwareUpdateStatus status = new PHSoftwareUpdateStatus();
                JSONObject swconfig = config.optJSONObject("swupdate");
                if (swconfig != null) {
                    int swState = swconfig.optInt("updatestate");
                    boolean notified = swconfig.optBoolean("notify");
                    status.setState(swState);
                    status.setNotify(notified);
                    status.setReleaseNotesUrl(swconfig.optString("url"));
                    status.setUpdateText(swconfig.optString("text"));
                } else {
                    status.setNotify(false);
                }
                JSONObject jsonObject = config.getJSONObject("whitelist");
                String[] names = JSONObject.getNames(jsonObject);
                ArrayList<PHWhiteListEntry> whiteListEntries = new ArrayList<PHWhiteListEntry>();
                for (String userName : names) {
                    JSONObject whiteList = jsonObject.getJSONObject(userName);
                    String[] nameDevice = ((String)whiteList.opt("name")).split("#");
                    String appName = null;
                    String deviceName = nameDevice[0];
                    if (nameDevice.length >= 2) {
                        appName = nameDevice[0];
                        deviceName = nameDevice[1];
                    }
                    whiteListEntries.add(new PHWhiteListEntry(userName, deviceName, appName));
                }
                if (bridgeConfig != null) {
                    bridgeConfig.setIpAddress(ipAddress);
                    bridgeConfig.setName(name);
                    bridgeConfig.setProxy(proxy);
                    bridgeConfig.setProxyPort(proxyPort);
                    bridgeConfig.setNetmask(netmask);
                    bridgeConfig.setGateway(gateway);
                    bridgeConfig.setDhcpEnabled(dhcpEnabled);
                    bridgeConfig.setSoftwareVersion(swversion);
                    bridgeConfig.setPortalServicesEnabled(portalServiceEnabled);
                    bridgeConfig.setSoftwareStatus(status);
                    bridgeConfig.setTime(time);
                    bridgeConfig.setMacAddress(macAddress);
                    bridgeConfig.setWhiteListEntries(whiteListEntries);
                    bridgeConfig.setModelId("BSB001");
                }
            }
        }
        catch (Exception e2) {
            this.reportParsingError(60, "", "Config unparsable due to error: " + e2.getMessage(), rootObject.optJSONObject("config"));
        }
        return bridgeConfig;
    }

    @Override
    public JSONObject updateBridgeConfigurationPacket(PHBridgeConfiguration bridgeConfig) throws JSONException {
        PHSoftwareUpdateStatus status;
        JSONObject toSend = new JSONObject();
        if (bridgeConfig.getName() != null) {
            toSend.putOpt("name", bridgeConfig.getName());
        }
        if (bridgeConfig.getTime() != null) {
            toSend.putOpt("UTC", bridgeConfig.getTime());
        }
        if (bridgeConfig.getProxy() != null) {
            toSend.putOpt("proxyaddress", bridgeConfig.getProxy());
        }
        if (bridgeConfig.getProxyPort() != -55) {
            toSend.putOpt("proxyport", bridgeConfig.getProxyPort());
        }
        if (bridgeConfig.getDhcpEnabled() != null) {
            toSend.putOpt("dhcp", bridgeConfig.getDhcpEnabled());
        }
        if (bridgeConfig.getIpAddress() != null) {
            toSend.putOpt("ipaddress", bridgeConfig.getIpAddress());
        }
        if (bridgeConfig.getNetmask() != null) {
            toSend.putOpt("netmask", bridgeConfig.getNetmask());
        }
        if (bridgeConfig.getGateway() != null) {
            toSend.putOpt("gateway", bridgeConfig.getGateway());
        }
        if (bridgeConfig.getPortalServicesEnabled() != null) {
            toSend.putOpt("portalservices", bridgeConfig.getPortalServicesEnabled());
        }
        if ((status = bridgeConfig.getSoftwareStatus()) != null) {
            JSONObject swUpdateJson = new JSONObject();
            PHSoftwareUpdateStatus.PHStateType state = status.getState();
            if (state != null) {
                if (state == PHSoftwareUpdateStatus.PHStateType.NO_UPDATE) {
                    swUpdateJson.putOpt("notify", false);
                } else {
                    swUpdateJson.putOpt("updatestate", state.ordinal());
                }
            }
            toSend.putOpt("swupdate", swUpdateJson);
        }
        return toSend;
    }

    @Override
    public String parseBridgeSoftwareVersion(JSONObject rootObject) {
        String swversion;
        JSONObject config = rootObject.optJSONObject("config");
        if (config == null) {
            config = rootObject;
        }
        return (swversion = config.optString("swversion")).isEmpty() ? null : swversion;
    }

    @Override
    public String parseBridgeAPIVersion(JSONObject rootObject) {
        String apiversion;
        JSONObject config = rootObject.optJSONObject("config");
        if (config == null) {
            config = rootObject;
        }
        return (apiversion = config.optString("apiversion")).isEmpty() ? null : apiversion;
    }

    @Override
    public boolean validateAPI(PHBridgeConfiguration bridgeConfiguration) {
        if (PHBridgeConfigurationSerializer2.getInstance().validateAPI(bridgeConfiguration)) {
            if (bridgeConfiguration.getLocalTime() != null) {
                return false;
            }
            return bridgeConfiguration.getTimeZone() == null;
        }
        return false;
    }

    @Override
    public boolean canCreate() {
        return false;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean canDelete() {
        return false;
    }
}

