/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.bridge.impl;

import com.philips.lighting.hue.listener.PHBridgeConfigurationListener;
import com.philips.lighting.hue.listener.PHGroupListener;
import com.philips.lighting.hue.listener.PHHTTPListener;
import com.philips.lighting.hue.listener.PHLightListener;
import com.philips.lighting.hue.listener.PHRuleListener;
import com.philips.lighting.hue.listener.PHSceneListener;
import com.philips.lighting.hue.listener.PHScheduleListener;
import com.philips.lighting.hue.listener.PHSensorListener;
import com.philips.lighting.hue.listener.PHTimeZoneListener;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeDelegator;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeResourcesCacheImpl;
import com.philips.lighting.hue.sdk.clip.PHBridgeConfigurationSerializer;
import com.philips.lighting.hue.sdk.clip.PHGroupSerializer;
import com.philips.lighting.hue.sdk.clip.PHLightSerializer;
import com.philips.lighting.hue.sdk.clip.PHRuleSerializer;
import com.philips.lighting.hue.sdk.clip.PHSceneSerializer;
import com.philips.lighting.hue.sdk.clip.PHScheduleSerializer;
import com.philips.lighting.hue.sdk.clip.PHSensorSerializer;
import com.philips.lighting.hue.sdk.exception.PHHueInvalidAPIException;
import com.philips.lighting.hue.sdk.fbp.PHBridgeVersionManager;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHBridgeResourcesCache;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHHueError;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import com.philips.lighting.model.rule.PHRule;
import com.philips.lighting.model.sensor.PHSensor;
import java.util.List;
import java.util.Map;

public class PHBridgeImpl
implements PHBridge {
    private PHBridgeDelegator delegator;
    private PHBridgeResourcesCacheImpl cacheImpl;
    private boolean isPortal;

    public PHBridgeImpl(PHBridgeDelegator delegator) {
        this.delegator = delegator;
        this.cacheImpl = new PHBridgeResourcesCacheImpl();
    }

    public PHBridgeImpl(PHBridgeDelegator delegator, boolean isPortal) {
        this(delegator);
        this.isPortal = isPortal;
    }

    public PHBridgeDelegator getBridgeDelegator() {
        return this.delegator;
    }

    @Override
    public PHBridgeResourcesCache getResourceCache() {
        return this.cacheImpl;
    }

    @Override
    public void findNewLights(PHLightListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.findNewLights(listener);
    }

    @Override
    public void updateLight(PHLight light, PHLightListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (light == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.updateLight(light, listener, this);
    }

    @Override
    public void deleteLight(String lightIdentifier, PHLightListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (lightIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canDelete()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.deleteLight(lightIdentifier, listener, this);
    }

    @Override
    public void updateLightState(String lightIdentifier, PHLightState lightState, PHLightListener listener) {
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (lightIdentifier == null || lightState == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canLightStateUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.updateLightState(lightIdentifier, lightState, listener, this);
    }

    @Override
    public void createGroup(PHGroup group, PHGroupListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (group.getLightIdentifiers() == null || group.getName() == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHGroupSerializer groupSerializer = PHBridgeVersionManager.getInstance().getGroupSerializer();
        if (groupSerializer == null || !groupSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.createGroup(group, listener, this);
    }

    @Override
    public void createGroup(String name, List<String> lightIdentifiers, PHGroupListener listener) throws PHHueInvalidAPIException {
        PHGroup group = new PHGroup(name, "");
        group.setLightIdentifiers(lightIdentifiers);
        this.createGroup(group, listener);
    }

    @Override
    public void updateGroup(PHGroup group, PHGroupListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHGroupSerializer groupSerializer = PHBridgeVersionManager.getInstance().getGroupSerializer();
        if (groupSerializer == null || !groupSerializer.canUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.updateGroup(group, listener, this);
    }

    @Override
    public void deleteGroup(String groupIdentifier, PHGroupListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (groupIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHGroupSerializer groupSerializer = PHBridgeVersionManager.getInstance().getGroupSerializer();
        if (groupSerializer == null || !groupSerializer.canDelete()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.deleteGroup(groupIdentifier, listener, this);
    }

    @Override
    public void setLightStateForGroup(String groupIdentifier, PHLightState state, PHGroupListener listener) {
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (groupIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHGroupSerializer groupSerializer = PHBridgeVersionManager.getInstance().getGroupSerializer();
        if (groupSerializer == null || !groupSerializer.canUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.setLightStateForGroup(groupIdentifier, state, listener, this);
    }

    @Override
    public void updateBridgeConfigurations(PHBridgeConfiguration configuration, PHBridgeConfigurationListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        PHBridgeConfigurationSerializer bridgeConfigurationSerializer = PHBridgeVersionManager.getInstance().getBridgeConfigurationSerializer();
        if (bridgeConfigurationSerializer == null || !bridgeConfigurationSerializer.canUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.updateBridgeConfigurations(configuration, listener, this);
    }

    @Override
    public void removeUsername(String username, PHBridgeConfigurationListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHBridgeConfigurationSerializer bridgeConfigurationSerializer = PHBridgeVersionManager.getInstance().getBridgeConfigurationSerializer();
        if (bridgeConfigurationSerializer == null || !bridgeConfigurationSerializer.canUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.removeUsername(username, listener);
    }

    @Override
    public void createSchedule(PHSchedule schedule, PHScheduleListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (schedule == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHScheduleSerializer schedulesSerializer = PHBridgeVersionManager.getInstance().getSchedulesSerializer();
        if (schedulesSerializer == null || !schedulesSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.createSchedule(schedule, listener, this);
    }

    @Override
    public void updateSchedule(PHSchedule schedule, PHScheduleListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (schedule == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHScheduleSerializer schedulesSerializer = PHBridgeVersionManager.getInstance().getSchedulesSerializer();
        if (schedulesSerializer == null || !schedulesSerializer.canUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.updateSchedule(schedule, listener, this);
    }

    @Override
    public void removeSchedule(String scheduleIdentifier, PHScheduleListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (scheduleIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHScheduleSerializer schedulesSerializer = PHBridgeVersionManager.getInstance().getSchedulesSerializer();
        if (schedulesSerializer == null || !schedulesSerializer.canDelete()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.removeSchedule(scheduleIdentifier, listener, this);
    }

    @Override
    public void updateSoftware(PHBridgeConfigurationListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.updateSoftware(listener, this);
    }

    @Override
    public void saveScene(PHScene scene, PHSceneListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (scene == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSceneSerializer scenesSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (scenesSerializer == null || !scenesSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.saveSceneWithCurrentLightStates(scene, listener, this, true);
    }

    @Override
    public void activateScene(String sceneIdentifier, String groupIdentifier, PHSceneListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (sceneIdentifier == null || groupIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSceneSerializer scenesSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (scenesSerializer == null || !scenesSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.activateScene(sceneIdentifier, groupIdentifier, listener);
    }

    @Override
    public void saveSceneWithCurrentLightStates(PHScene scene, PHSceneListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (scene == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSceneSerializer scenesSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (scenesSerializer == null || !scenesSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.saveSceneWithCurrentLightStates(scene, listener, this, false);
    }

    @Override
    public void findNewLightsWithSerials(List<String> serials, PHLightListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (serials == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.findNewLightsWithSerials(serials, listener);
    }

    @Override
    public void saveLightState(PHLightState lightState, String lightIdentifier, String sceneIdentifier, PHSceneListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (lightState == null || lightIdentifier == null || sceneIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSceneSerializer scenesSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (scenesSerializer == null || !scenesSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.saveLightStateInScene(lightState, lightIdentifier, sceneIdentifier, listener);
    }

    @Override
    public void updateLightState(PHLight light, PHLightState lightState, PHLightListener listener) {
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canLightStateUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.updateLightState(light.getIdentifier(), lightState, listener, this);
    }

    @Override
    public void updateLightState(PHLight light, PHLightState lightState) {
        PHLightListener listener = new PHLightListener(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onStateUpdate(Map<String, String> successAttribute, List<PHHueError> errorAttribute) {
            }

            @Override
            public void onError(int code, String message) {
            }

            @Override
            public void onReceivingLightDetails(PHLight light) {
            }

            @Override
            public void onReceivingLights(List<PHBridgeResource> lights) {
            }

            @Override
            public void onSearchComplete() {
            }
        };
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canLightStateUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.updateLightState(light.getIdentifier(), lightState, listener, this);
    }

    @Override
    public void setLightStateForDefaultGroup(PHLightState state) {
        PHGroupSerializer groupSerializer = PHBridgeVersionManager.getInstance().getGroupSerializer();
        if (groupSerializer == null || !groupSerializer.canUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.setLightStateForGroup("0", state);
    }

    @Override
    public void setLightStateForGroup(String groupIdentifier, PHLightState state) {
        PHGroupListener groupListener = new PHGroupListener(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onStateUpdate(Map<String, String> successAttribute, List<PHHueError> errorAttribute) {
            }

            @Override
            public void onError(int code, String message) {
            }

            @Override
            public void onCreated(PHGroup group) {
            }

            @Override
            public void onReceivingGroupDetails(PHGroup group) {
            }

            @Override
            public void onReceivingAllGroups(List<PHBridgeResource> groupHeaders) {
            }
        };
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (groupIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHGroupSerializer groupSerializer = PHBridgeVersionManager.getInstance().getGroupSerializer();
        if (groupSerializer == null || !groupSerializer.canUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.setLightStateForGroup(groupIdentifier, state, groupListener, this);
    }

    @Override
    public void findNewSensors(PHSensorListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.findNewSensors(listener);
    }

    @Override
    public void findNewSensorsWithSerials(List<String> serials, PHSensorListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (serials == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.findNewSensorsWithSerials(serials, listener);
    }

    @Override
    public void createSensor(PHSensor sensor, PHSensorListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (sensor == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.createSensor(sensor, listener, this);
    }

    @Override
    public void updateSensor(PHSensor sensor, PHSensorListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (sensor == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.updateSensor(sensor, listener, this);
    }

    @Override
    public void deleteSensor(String sensorIdentifier, PHSensorListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (sensorIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canDelete()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.deleteSensor(sensorIdentifier, listener, this);
    }

    @Override
    public void saveSensorState(PHSensor sensor, PHSensorListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (sensor == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canSensorStateUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.saveSensorState(sensor, listener, this);
    }

    @Override
    public void saveSensorConfiguration(PHSensor sensor, PHSensorListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (sensor == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canSensorConfigurationUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.saveSensorConfiguration(sensor, listener, this);
    }

    @Override
    public void createRule(PHRule rule, PHRuleListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (rule == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHRuleSerializer rulesSerializer = PHBridgeVersionManager.getInstance().getRulesSerializer();
        if (rulesSerializer == null || !rulesSerializer.canCreate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.createRule(rule, listener, this);
    }

    @Override
    public void updateRule(PHRule rule, PHRuleListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (rule == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHRuleSerializer rulesSerializer = PHBridgeVersionManager.getInstance().getRulesSerializer();
        if (rulesSerializer == null || !rulesSerializer.canUpdate()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.updateRule(rule, listener, this);
    }

    @Override
    public void deleteRule(String ruleIdentifier, PHRuleListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (ruleIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHRuleSerializer rulesSerializer = PHBridgeVersionManager.getInstance().getRulesSerializer();
        if (rulesSerializer == null || !rulesSerializer.canDelete()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.deleteRule(ruleIdentifier, listener, this);
    }

    @Override
    public void getSupportedTimeZones(PHTimeZoneListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.getSupportedTimeZones(listener);
    }

    @Override
    public void doHTTPGet(String url, PHHTTPListener listener) {
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.doGet(url, listener);
    }

    @Override
    public void doHTTPPut(String url, String json, PHHTTPListener listener) {
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.doPut(url, json, listener);
    }

    @Override
    public void doHTTPPost(String url, String json, PHHTTPListener listener) {
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.doPost(url, json, listener);
    }

    @Override
    public void doHTTPDelete(String url, PHHTTPListener listener) {
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.doDelete(url, listener);
    }

    @Override
    public void getScene(String sceneIdentifier, PHSceneListener listener) {
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.getScene(sceneIdentifier, listener, this);
    }

    @Override
    public void deleteScene(String sceneIdentifier, PHSceneListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (sceneIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHSceneSerializer scenesSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (scenesSerializer == null || !scenesSerializer.canDelete()) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.delegator.deleteScene(sceneIdentifier, listener, this);
    }
}

