/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk;

public class PHAccessPoint {
    private String ipAddress;
    private String macAddress;
    private String bridgeId;
    private String username;

    public PHAccessPoint() {
    }

    public PHAccessPoint(String ipAddress, String userName, String macAddress) {
        this.ipAddress = ipAddress;
        this.username = userName;
        this.macAddress = macAddress;
    }

    public PHAccessPoint(PHAccessPoint accessPoint) {
        if (accessPoint == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.ipAddress = accessPoint.ipAddress;
        this.macAddress = accessPoint.macAddress;
        this.username = accessPoint.username;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getMacAddress() {
        if (this.macAddress != null) {
            return this.macAddress.toUpperCase();
        }
        return null;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getBridgeId() {
        if (this.bridgeId != null) {
            return this.bridgeId;
        }
        if (this.macAddress == null) {
            return null;
        }
        String stringWithoutColons = this.macAddress.replace(":", "");
        if (stringWithoutColons.length() != 12) {
            return this.macAddress;
        }
        String bridgeId = stringWithoutColons.substring(0, 6) + "FFFE" + stringWithoutColons.substring(6);
        return bridgeId.toUpperCase();
    }

    public void setBridgeId(String bridgeId) {
        this.bridgeId = bridgeId != null ? bridgeId.toUpperCase() : bridgeId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.macAddress == null ? 0 : this.macAddress.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PHAccessPoint)) {
            return false;
        }
        PHAccessPoint other = (PHAccessPoint)obj;
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        if (this.macAddress == null ? other.macAddress != null : !this.macAddress.equals(other.macAddress)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

