/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortIOException;
import com.hsyco.CameraFrame;
import com.hsyco.Configuration;
import com.hsyco.DigestParams;
import com.hsyco.HsycoFile;
import com.hsyco.HttpResponse;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import com.hsyco.suntimes.SunTimes;
import com.hsyco.suntimes.Time;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;

public class util {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    static final int COMM_TIMEOUT = 2000;
    public static final boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    private static final Object fileLogMonitor = new Object();
    private static final File root = new File(".");
    private static BitSet commServerErrorStatus = new BitSet();
    private static BitSet commServerConnectionRetry = new BitSet();
    private static BitSet CommPortsFailoverActive = new BitSet();
    private static Vector<Socket> CommPortsSocket = null;
    private static Vector<BufferedInputStream> CommPortsInStream = null;
    private static Vector<BufferedOutputStream> CommPortsOutStream = null;
    private static boolean readCommDump = false;
    private static boolean writeCommDump = false;

    public static void initComm() {
        if (CommPortsSocket == null) {
            CommPortsSocket = new Vector();
            CommPortsInStream = new Vector();
            CommPortsOutStream = new Vector();
        }
        int i2 = 0;
        while (i2 < Configuration.CommPorts.size()) {
            CommPortsSocket.add(null);
            CommPortsInStream.add(null);
            CommPortsOutStream.add(null);
            ++i2;
        }
        if (new File("logs", "readcomm.log").canWrite()) {
            readCommDump = true;
        }
        if (new File("logs", "writecomm.log").canWrite()) {
            writeCommDump = true;
        }
    }

    public static Vector<String> listComm() {
        Vector<String> ports = new Vector<String>();
        try {
            SerialPort[] pa = SerialPort.getCommPorts();
            int i2 = 0;
            while (i2 < pa.length) {
                ports.add(String.valueOf(pa[i2].getSystemPortName()) + " [" + pa[i2].getDescriptivePortName() + "]");
                ++i2;
            }
            return ports;
        }
        catch (Exception e2) {
            return new Vector<String>();
        }
    }

    public static SerialPort openComm(String id, int baudrate, int dataBits, int stopBits, int parity, int flowControl, int timeout) {
        SerialPort serialPort = SerialPort.getCommPort(id);
        if (!serialPort.openPort(2000)) {
            hsyco.errorLog("Comm port [" + id + "] error opening port");
            return null;
        }
        try {
            int serialParity;
            int serialStopBits;
            int serialDataBits;
            switch (dataBits) {
                case 5: 
                case 6: 
                case 7: {
                    serialDataBits = dataBits;
                    break;
                }
                default: {
                    serialDataBits = 8;
                }
            }
            switch (stopBits) {
                case 2: {
                    serialStopBits = 3;
                    break;
                }
                case 3: {
                    serialStopBits = 2;
                    break;
                }
                default: {
                    serialStopBits = 1;
                }
            }
            switch (parity) {
                case 1: {
                    serialParity = 1;
                    break;
                }
                case 2: {
                    serialParity = 2;
                    break;
                }
                case 3: {
                    serialParity = 3;
                    break;
                }
                case 4: {
                    serialParity = 4;
                    break;
                }
                default: {
                    serialParity = 0;
                }
            }
            if (baudrate > 0) {
                serialPort.setComPortParameters(baudrate, serialDataBits, serialStopBits, serialParity);
            }
            switch (flowControl) {
                case 0: {
                    serialPort.setFlowControl(0);
                    break;
                }
                case 1: {
                    serialPort.setFlowControl(0x110000);
                    break;
                }
                case 2: {
                    serialPort.setFlowControl(17);
                }
            }
            serialPort.setComPortTimeouts(16, timeout, 0);
            hsyco.messageLog("Comm port [" + serialPort.getSystemPortName() + "] connected");
            return serialPort;
        }
        catch (Exception e2) {
            hsyco.errorLog("Comm port [" + id + "] error - unable to set communication parameters");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerialPort reopenComm(String portName) {
        Vector<SerialPort> vector = Configuration.CommPortsSerial;
        synchronized (vector) {
            int x = Configuration.CommPorts.indexOf(portName);
            if (x >= 0) {
                String id = Configuration.CommPortsId.elementAt(x);
                Integer[] p = Configuration.CommPortsParams.elementAt(x);
                SerialPort port = Configuration.CommPortsSerial.elementAt(x);
                try {
                    port.getInputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    port.getOutputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    port.closePort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                port = util.openComm(id, p[0], p[1], p[2], p[3], p[4], p[5]);
                if (port != null) {
                    Configuration.CommPortsSerial.set(x, port);
                }
                return port;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeComm(String portName, String data) {
        int x = Configuration.CommPorts.indexOf(portName);
        if (x >= 0) {
            if (data == null || data.length() % 2 != 0) {
                util.errorLogCommServer(x, "Comm port [" + portName + "] error - hex data format error");
                return 0;
            }
            switch (Configuration.CommPortsType.get(x)) {
                case 0: {
                    SerialPort port = Configuration.CommPortsSerial.get(x);
                    try {
                        byte[] bytea = new byte[data.length() / 2];
                        int i2 = 0;
                        while (i2 < bytea.length) {
                            bytea[i2] = (byte)Integer.parseInt(data.substring(i2 * 2, (i2 + 1) * 2), 16);
                            ++i2;
                        }
                        OutputStream out = port.getOutputStream();
                        out.write(bytea);
                        out.flush();
                        util.errorClearCommServer(x);
                        if (writeCommDump) {
                            File f2 = new File("logs", "writecomm.log");
                            if (f2.canWrite()) {
                                FileOutputStream fos = new FileOutputStream(f2, true);
                                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                osw.write(String.valueOf(System.currentTimeMillis()) + " ");
                                osw.write(portName);
                                osw.write(": ");
                                osw.write(data);
                                osw.write("\r\n");
                                osw.close();
                                fos.close();
                            } else {
                                writeCommDump = false;
                            }
                        }
                        return bytea.length;
                    }
                    catch (SerialPortIOException e2) {
                        if (!port.isOpen()) {
                            port = util.reopenComm(portName);
                        }
                        util.errorLogCommServer(x, "Comm port [" + portName + "] error - write exception");
                        return 0;
                    }
                    catch (Exception e3) {
                        util.errorLogCommServer(x, "Comm port [" + portName + "] error - write exception");
                        return 0;
                    }
                }
                case 1: {
                    int bytes = data.length() / 2;
                    ArrayBlockingQueue<byte[]> commQueueTx = Configuration.CommPortsQueueTx.get(x);
                    ArrayBlockingQueue<byte[]> f2 = commQueueTx;
                    synchronized (f2) {
                        try {
                            if (commQueueTx.remainingCapacity() >= 1) {
                                byte[] ba = new byte[bytes];
                                int i3 = 0;
                                while (i3 < bytes) {
                                    ba[i3] = (byte)Integer.parseInt(data.substring(i3 * 2, (i3 + 1) * 2), 16);
                                    ++i3;
                                }
                                commQueueTx.add(ba);
                                return bytes;
                            }
                            return 0;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (Exception e4) {
                                return 0;
                            }
                        }
                    }
                }
                case 2: {
                    DatagramSocket IRclient;
                    String irtransname = Configuration.CommPortsId.get(x).substring(8);
                    try {
                        InetSocketAddress irtransaddr = new InetSocketAddress(Configuration.getIRTransIP(irtransname), Configuration.IRTransPort);
                        byte[] bytea = Arrays.copyOf("serial ".getBytes(), 7 + data.length() / 2);
                        int i4 = 0;
                        while (i4 < data.length() / 2) {
                            bytea[i4 + 7] = (byte)Integer.parseInt(data.substring(i4 * 2, (i4 + 1) * 2), 16);
                            ++i4;
                        }
                        IRclient = new DatagramSocket();
                        DatagramPacket IRout = new DatagramPacket(bytea, bytea.length, irtransaddr);
                        IRclient.send(IRout);
                    }
                    catch (Exception e5) {
                        return 0;
                    }
                    try {
                        IRclient.close();
                    }
                    catch (Exception e5) {
                        // empty catch block
                    }
                    return data.length() / 2;
                }
                case 3: {
                    InetSocketAddress addr;
                    InetSocketAddress inetSocketAddress = addr = Configuration.CommPortsTCPAddress.get(x);
                    synchronized (inetSocketAddress) {
                        try {
                            BufferedOutputStream bout;
                            Socket sock = CommPortsSocket.get(x);
                            if (sock == null) {
                                sock = new Socket();
                                if (CommPortsFailoverActive.get(x)) {
                                    sock.connect(Configuration.CommPortsTCPAddressFailover.get(x), 3000);
                                    sock.setSoTimeout(Configuration.CommPortsParams.get(x)[0]);
                                    if (!commServerConnectionRetry.get(x)) {
                                        hsyco.messageLog("Comm port [" + portName + "/failover] connected");
                                    }
                                } else {
                                    sock.connect(addr, 3000);
                                    sock.setSoTimeout(Configuration.CommPortsParams.get(x)[0]);
                                    if (!commServerConnectionRetry.get(x)) {
                                        hsyco.messageLog("Comm port [" + portName + "] connected");
                                    }
                                }
                                util.errorClearCommServer(x);
                                BufferedInputStream bin = new BufferedInputStream(sock.getInputStream());
                                bout = new BufferedOutputStream(sock.getOutputStream());
                                CommPortsSocket.set(x, sock);
                                CommPortsInStream.set(x, bin);
                                CommPortsOutStream.set(x, bout);
                            } else {
                                bout = CommPortsOutStream.get(x);
                            }
                            byte[] bytea = new byte[data.length() / 2];
                            int i5 = 0;
                            while (i5 < bytea.length) {
                                bytea[i5] = (byte)Integer.parseInt(data.substring(i5 * 2, (i5 + 1) * 2), 16);
                                ++i5;
                            }
                            bout.write(bytea);
                            bout.flush();
                            if (writeCommDump) {
                                File f3 = new File("logs", "writecomm.log");
                                if (f3.canWrite()) {
                                    FileOutputStream fos = new FileOutputStream(f3, true);
                                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                    osw.write(String.valueOf(System.currentTimeMillis()) + " ");
                                    osw.write(portName);
                                    osw.write(": ");
                                    osw.write(data);
                                    osw.write("\r\n");
                                    osw.close();
                                    fos.close();
                                } else {
                                    writeCommDump = false;
                                }
                            }
                            return bytea.length;
                        }
                        catch (Exception e6) {
                            util.closeCommServer(x, addr, false);
                            if (CommPortsFailoverActive.get(x)) {
                                CommPortsFailoverActive.clear(x);
                                util.errorLogCommServer(x, "Comm port [" + portName + "] warning - switching to main address");
                            } else if (Configuration.CommPortsTCPAddressFailover.get(x) != null) {
                                CommPortsFailoverActive.set(x);
                                util.errorLogCommServer(x, "Comm port [" + portName + "] warning - switching to failover address");
                            } else {
                                util.errorLogCommServer(x, "Comm port [" + portName + "] disconnected: " + e6.getLocalizedMessage());
                            }
                            return 0;
                        }
                    }
                }
            }
            return 0;
        }
        util.errorLogCommServer(x, "Comm port [" + portName + "] error - not found");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeCommBytes(String portName, byte[] data) {
        int x = Configuration.CommPorts.indexOf(portName);
        if (x >= 0) {
            switch (Configuration.CommPortsType.get(x)) {
                case 0: {
                    SerialPort port = Configuration.CommPortsSerial.get(x);
                    try {
                        OutputStream out = port.getOutputStream();
                        out.write(data);
                        out.flush();
                        util.errorClearCommServer(x);
                        if (writeCommDump) {
                            File f2 = new File("logs", "writecomm.log");
                            if (f2.canWrite()) {
                                FileOutputStream fos = new FileOutputStream(f2, true);
                                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                osw.write(String.valueOf(System.currentTimeMillis()) + " ");
                                StringBuffer sb = new StringBuffer(data.length);
                                int i2 = 0;
                                while (i2 < data.length) {
                                    String b2 = Integer.toHexString(data[i2] & 0xFF).toUpperCase();
                                    if (b2.length() == 1) {
                                        sb.append('0');
                                    }
                                    sb.append(b2);
                                    ++i2;
                                }
                                osw.write(portName);
                                osw.write(": ");
                                osw.write(sb.toString());
                                osw.write("\r\n");
                                osw.close();
                                fos.close();
                            } else {
                                writeCommDump = false;
                            }
                        }
                        return data.length;
                    }
                    catch (SerialPortIOException e2) {
                        if (!port.isOpen()) {
                            port = util.reopenComm(portName);
                        }
                        util.errorLogCommServer(x, "Comm port [" + portName + "] error - write exception");
                        return 0;
                    }
                    catch (Exception e3) {
                        util.errorLogCommServer(x, "Comm port [" + portName + "] error - write exception");
                        return 0;
                    }
                }
                case 1: {
                    ArrayBlockingQueue<byte[]> commQueueTx = Configuration.CommPortsQueueTx.get(x);
                    ArrayBlockingQueue<byte[]> f2 = commQueueTx;
                    synchronized (f2) {
                        try {
                            if (commQueueTx.remainingCapacity() >= 1) {
                                commQueueTx.add(data);
                                return data.length;
                            }
                            return 0;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (Exception e4) {
                                return 0;
                            }
                        }
                    }
                }
                case 2: {
                    DatagramSocket IRclient;
                    String irtransname = Configuration.CommPortsId.get(x).substring(8);
                    try {
                        InetSocketAddress irtransaddr = new InetSocketAddress(Configuration.getIRTransIP(irtransname), Configuration.IRTransPort);
                        byte[] bytea = Arrays.copyOf("serial ".getBytes(), 7 + data.length);
                        int i3 = 0;
                        while (i3 < data.length) {
                            bytea[i3 + 7] = data[i3];
                            ++i3;
                        }
                        IRclient = new DatagramSocket();
                        DatagramPacket IRout = new DatagramPacket(bytea, bytea.length, irtransaddr);
                        IRclient.send(IRout);
                    }
                    catch (Exception e5) {
                        return 0;
                    }
                    try {
                        IRclient.close();
                    }
                    catch (Exception e5) {
                        // empty catch block
                    }
                    return data.length;
                }
                case 3: {
                    InetSocketAddress addr;
                    InetSocketAddress inetSocketAddress = addr = Configuration.CommPortsTCPAddress.get(x);
                    synchronized (inetSocketAddress) {
                        try {
                            BufferedOutputStream bout;
                            Socket sock = CommPortsSocket.get(x);
                            if (sock == null) {
                                sock = new Socket();
                                if (CommPortsFailoverActive.get(x)) {
                                    sock.connect(Configuration.CommPortsTCPAddressFailover.get(x), 3000);
                                    sock.setSoTimeout(Configuration.CommPortsParams.get(x)[0]);
                                    if (!commServerConnectionRetry.get(x)) {
                                        hsyco.messageLog("Comm port [" + portName + "/failover] connected");
                                    }
                                } else {
                                    sock.connect(addr, 3000);
                                    sock.setSoTimeout(Configuration.CommPortsParams.get(x)[0]);
                                    if (!commServerConnectionRetry.get(x)) {
                                        hsyco.messageLog("Comm port [" + portName + "] connected");
                                    }
                                }
                                util.errorClearCommServer(x);
                                BufferedInputStream bin = new BufferedInputStream(sock.getInputStream());
                                bout = new BufferedOutputStream(sock.getOutputStream());
                                CommPortsSocket.set(x, sock);
                                CommPortsInStream.set(x, bin);
                                CommPortsOutStream.set(x, bout);
                            } else {
                                bout = CommPortsOutStream.get(x);
                            }
                            bout.write(data);
                            bout.flush();
                            if (writeCommDump) {
                                File f3 = new File("logs", "writecomm.log");
                                if (f3.canWrite()) {
                                    FileOutputStream fos = new FileOutputStream(f3, true);
                                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                    osw.write(String.valueOf(System.currentTimeMillis()) + " ");
                                    StringBuffer sb = new StringBuffer(data.length);
                                    int i4 = 0;
                                    while (i4 < data.length) {
                                        String b3 = Integer.toHexString(data[i4] & 0xFF).toUpperCase();
                                        if (b3.length() == 1) {
                                            sb.append('0');
                                        }
                                        sb.append(b3);
                                        ++i4;
                                    }
                                    osw.write(portName);
                                    osw.write(": ");
                                    osw.write(sb.toString());
                                    osw.write("\r\n");
                                    osw.close();
                                    fos.close();
                                } else {
                                    writeCommDump = false;
                                }
                            }
                            return data.length;
                        }
                        catch (Exception e6) {
                            util.closeCommServer(x, addr, false);
                            if (CommPortsFailoverActive.get(x)) {
                                CommPortsFailoverActive.clear(x);
                                util.errorLogCommServer(x, "Comm port [" + portName + "] warning - switching to main address");
                            } else if (Configuration.CommPortsTCPAddressFailover.get(x) != null) {
                                CommPortsFailoverActive.set(x);
                                util.errorLogCommServer(x, "Comm port [" + portName + "] warning - switching to failover address");
                            } else {
                                util.errorLogCommServer(x, "Comm port [" + portName + "] disconnected: " + e6.getLocalizedMessage());
                            }
                            return 0;
                        }
                    }
                }
            }
            return 0;
        }
        util.errorLogCommServer(x, "Comm port [" + portName + "] error - not found");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static String readComm(String portName, int len) {
        StringBuffer sb = null;
        int x = Configuration.CommPorts.indexOf(portName);
        if (x >= 0) {
            switch (Configuration.CommPortsType.get(x)) {
                case 0: {
                    SerialPort port = Configuration.CommPortsSerial.get(x);
                    try {
                        if (len == 0) {
                            int r = port.bytesAvailable();
                            if (r > 0) {
                                byte[] bytes = new byte[r];
                                port.readBytes(bytes, r);
                            }
                            return "";
                        }
                        byte[] bytes = new byte[len];
                        sb = new StringBuffer(len * 2);
                        int r = port.readBytes(bytes, len);
                        int i2 = 0;
                        while (i2 < r) {
                            String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                            if (b2.length() == 1) {
                                sb.append('0');
                            }
                            sb.append(b2);
                            ++i2;
                        }
                        util.errorClearCommServer(x);
                        if (readCommDump) {
                            File f2 = new File("logs", "readcomm.log");
                            if (f2.canWrite()) {
                                FileOutputStream fos = new FileOutputStream(f2, true);
                                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                osw.write(String.valueOf(System.currentTimeMillis()) + " ");
                                osw.write(portName);
                                osw.write(": ");
                                osw.write(sb.toString());
                                osw.write("\r\n");
                                osw.close();
                                fos.close();
                            } else {
                                readCommDump = false;
                            }
                        }
                        return sb.toString();
                    }
                    catch (SerialPortIOException e2) {
                        if (!port.isOpen()) {
                            port = util.reopenComm(portName);
                        }
                        util.errorLogCommServer(x, "Comm port [" + portName + "] error - read exception");
                        return null;
                    }
                    catch (Exception e3) {
                        util.errorLogCommServer(x, "Comm port [" + portName + "] error - read exception");
                        return null;
                    }
                }
                case 1: 
                case 2: {
                    ArrayBlockingQueue<Byte> commQueueRx = Configuration.CommPortsQueueRx.get(x);
                    if (len == 0) {
                        commQueueRx.clear();
                        return "";
                    }
                    sb = new StringBuffer(len * 2);
                    try {
                        int i3 = 0;
                        while (i3 < len) {
                            Byte r = commQueueRx.poll(2000L, TimeUnit.MILLISECONDS);
                            if (r == null) break;
                            String b3 = Integer.toHexString(r & 0xFF).toUpperCase();
                            if (b3.length() == 1) {
                                sb.append('0');
                            }
                            sb.append(b3);
                            ++i3;
                        }
                        return sb.toString();
                    }
                    catch (Exception e4) {
                        return null;
                    }
                }
                case 3: {
                    BufferedInputStream bin;
                    InetSocketAddress addr;
                    InetSocketAddress osw = addr = Configuration.CommPortsTCPAddress.get(x);
                    synchronized (osw) {
                        try {
                            Socket sock = CommPortsSocket.get(x);
                            if (sock == null) {
                                sock = new Socket();
                                if (CommPortsFailoverActive.get(x)) {
                                    sock.connect(Configuration.CommPortsTCPAddressFailover.get(x), 3000);
                                    if (!commServerConnectionRetry.get(x)) {
                                        hsyco.messageLog("Comm port [" + portName + "/failover] connected");
                                    }
                                } else {
                                    sock.connect(addr, 3000);
                                    if (!commServerConnectionRetry.get(x)) {
                                        hsyco.messageLog("Comm port [" + portName + "] connected");
                                    }
                                }
                                sock.setSoTimeout(Configuration.CommPortsParams.get(x)[0]);
                                sock.setKeepAlive(true);
                                util.errorClearCommServer(x);
                                bin = new BufferedInputStream(sock.getInputStream());
                                BufferedOutputStream bout = new BufferedOutputStream(sock.getOutputStream());
                                CommPortsSocket.set(x, sock);
                                CommPortsInStream.set(x, bin);
                                CommPortsOutStream.set(x, bout);
                            } else {
                                bin = CommPortsInStream.get(x);
                            }
                        }
                        catch (Exception e5) {
                            util.closeCommServer(x, addr, false);
                            if (CommPortsFailoverActive.get(x)) {
                                CommPortsFailoverActive.clear(x);
                                util.errorLogCommServer(x, "Comm port [" + portName + "] warning - switching to main address");
                            } else if (Configuration.CommPortsTCPAddressFailover.get(x) != null) {
                                CommPortsFailoverActive.set(x);
                                util.errorLogCommServer(x, "Comm port [" + portName + "] warning - switching to failover address");
                            } else {
                                util.errorLogCommServer(x, "Comm port [" + portName + "] disconnected: " + e5.getLocalizedMessage());
                            }
                            return null;
                        }
                    }
                    try {
                        if (len == 0) {
                            int n2 = bin.available();
                            if (n2 > 0) {
                                bin.skip(n2);
                            }
                            return "";
                        }
                        byte[] bytes = new byte[len];
                        sb = new StringBuffer(len * 2);
                        int totr = 0;
                        while (totr < len) {
                            int r = bin.read(bytes, 0, len - totr);
                            if (r <= 0) break;
                            totr += r;
                            int i4 = 0;
                            while (i4 < r) {
                                String b4 = Integer.toHexString(bytes[i4] & 0xFF).toUpperCase();
                                if (b4.length() == 1) {
                                    sb.append('0');
                                }
                                sb.append(b4);
                                ++i4;
                            }
                        }
                        if (readCommDump) {
                            File f3 = new File("logs", "readcomm.log");
                            if (f3.canWrite()) {
                                FileOutputStream fos = new FileOutputStream(f3, true);
                                OutputStreamWriter osw2 = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                osw2.write(String.valueOf(System.currentTimeMillis()) + " ");
                                osw2.write(portName);
                                osw2.write(": ");
                                osw2.write(sb.toString());
                                osw2.write("\r\n");
                                osw2.close();
                                fos.close();
                            } else {
                                readCommDump = false;
                            }
                        }
                        return sb.toString();
                    }
                    catch (SocketTimeoutException e6) {
                        return sb == null ? "" : sb.toString();
                    }
                    catch (Exception e7) {
                        util.closeCommServer(x, addr, false);
                        util.errorLogCommServer(x, "Comm port [" + portName + "] disconnected: " + e7.getLocalizedMessage());
                        return null;
                    }
                }
            }
            return null;
        }
        util.errorLogCommServer(x, "Comm port [" + portName + "] error - not found");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static byte[] readCommBytes(String portName, int len) {
        ByteArrayOutputStream buffer = null;
        int x = Configuration.CommPorts.indexOf(portName);
        if (x >= 0) {
            switch (Configuration.CommPortsType.get(x)) {
                case 0: {
                    SerialPort port = Configuration.CommPortsSerial.get(x);
                    try {
                        byte[] ba;
                        if (len == 0) {
                            int r = port.bytesAvailable();
                            if (r > 0) {
                                byte[] bytes = new byte[r];
                                port.readBytes(bytes, r);
                            }
                            return new byte[0];
                        }
                        byte[] bytes = new byte[len];
                        int r = port.readBytes(bytes, len);
                        if (r == 0) {
                            ba = new byte[]{};
                        } else if (r == len) {
                            ba = bytes;
                        } else {
                            buffer = new ByteArrayOutputStream(r);
                            buffer.write(bytes, 0, r);
                            ba = buffer.toByteArray();
                        }
                        util.errorClearCommServer(x);
                        if (readCommDump) {
                            File f2 = new File("logs", "readcomm.log");
                            if (f2.canWrite()) {
                                FileOutputStream fos = new FileOutputStream(f2, true);
                                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                osw.write(String.valueOf(System.currentTimeMillis()) + " ");
                                StringBuffer sb = new StringBuffer(ba.length);
                                int i2 = 0;
                                while (i2 < ba.length) {
                                    String b2 = Integer.toHexString(ba[i2] & 0xFF).toUpperCase();
                                    if (b2.length() == 1) {
                                        sb.append('0');
                                    }
                                    sb.append(b2);
                                    ++i2;
                                }
                                osw.write(portName);
                                osw.write(": ");
                                osw.write(sb.toString());
                                osw.write("\r\n");
                                osw.close();
                                fos.close();
                            } else {
                                readCommDump = false;
                            }
                        }
                        return ba;
                    }
                    catch (SerialPortIOException e2) {
                        if (!port.isOpen()) {
                            port = util.reopenComm(portName);
                        }
                        util.errorLogCommServer(x, "Comm port [" + portName + "] error - read exception");
                        return null;
                    }
                    catch (Exception e3) {
                        util.errorLogCommServer(x, "Comm port [" + portName + "] error - read exception");
                        return null;
                    }
                }
                case 1: 
                case 2: {
                    ArrayBlockingQueue<Byte> commQueueRx = Configuration.CommPortsQueueRx.get(x);
                    if (len == 0) {
                        commQueueRx.clear();
                        return new byte[0];
                    }
                    try {
                        buffer = new ByteArrayOutputStream(len);
                        int i3 = 0;
                        while (i3 < len) {
                            Byte r = commQueueRx.poll(2000L, TimeUnit.MILLISECONDS);
                            if (r == null) break;
                            buffer.write((int)(r & 0xFF));
                            ++i3;
                        }
                        return buffer.toByteArray();
                    }
                    catch (Exception e4) {
                        return null;
                    }
                }
                case 3: {
                    BufferedInputStream bin;
                    InetSocketAddress addr;
                    InetSocketAddress fos = addr = Configuration.CommPortsTCPAddress.get(x);
                    synchronized (fos) {
                        try {
                            Socket sock = CommPortsSocket.get(x);
                            if (sock == null) {
                                sock = new Socket();
                                if (CommPortsFailoverActive.get(x)) {
                                    sock.connect(Configuration.CommPortsTCPAddressFailover.get(x), 3000);
                                    if (!commServerConnectionRetry.get(x)) {
                                        hsyco.messageLog("Comm port [" + portName + "/failover] connected");
                                    }
                                } else {
                                    sock.connect(addr, 3000);
                                    if (!commServerConnectionRetry.get(x)) {
                                        hsyco.messageLog("Comm port [" + portName + "] connected");
                                    }
                                }
                                sock.setSoTimeout(Configuration.CommPortsParams.get(x)[0]);
                                sock.setKeepAlive(true);
                                util.errorClearCommServer(x);
                                bin = new BufferedInputStream(sock.getInputStream());
                                BufferedOutputStream bout = new BufferedOutputStream(sock.getOutputStream());
                                CommPortsSocket.set(x, sock);
                                CommPortsInStream.set(x, bin);
                                CommPortsOutStream.set(x, bout);
                            } else {
                                bin = CommPortsInStream.get(x);
                            }
                        }
                        catch (Exception e5) {
                            util.closeCommServer(x, addr, false);
                            if (CommPortsFailoverActive.get(x)) {
                                CommPortsFailoverActive.clear(x);
                                util.errorLogCommServer(x, "Comm port [" + portName + "] warning - switching to main address");
                            } else if (Configuration.CommPortsTCPAddressFailover.get(x) != null) {
                                CommPortsFailoverActive.set(x);
                                util.errorLogCommServer(x, "Comm port [" + portName + "] warning - switching to failover address");
                            } else {
                                util.errorLogCommServer(x, "Comm port [" + portName + "] disconnected: " + e5.getLocalizedMessage());
                            }
                            return null;
                        }
                    }
                    try {
                        if (len == 0) {
                            int a2 = bin.available();
                            if (a2 > 0) {
                                bin.skip(a2);
                            }
                            return new byte[0];
                        }
                        buffer = new ByteArrayOutputStream(len);
                        byte[] bytes = new byte[len];
                        int totr = 0;
                        while (totr < len) {
                            int r = bin.read(bytes, 0, len - totr);
                            if (r <= 0) break;
                            totr += r;
                            buffer.write(bytes, 0, r);
                        }
                        byte[] ba = buffer.toByteArray();
                        if (readCommDump) {
                            File f3 = new File("logs", "readcomm.log");
                            if (f3.canWrite()) {
                                FileOutputStream fos2 = new FileOutputStream(f3, true);
                                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos2, "UTF-8");
                                osw.write(String.valueOf(System.currentTimeMillis()) + " ");
                                StringBuffer sb = new StringBuffer(ba.length);
                                int i4 = 0;
                                while (i4 < ba.length) {
                                    String b3 = Integer.toHexString(ba[i4] & 0xFF).toUpperCase();
                                    if (b3.length() == 1) {
                                        sb.append('0');
                                    }
                                    sb.append(b3);
                                    ++i4;
                                }
                                osw.write(portName);
                                osw.write(": ");
                                osw.write(sb.toString());
                                osw.write("\r\n");
                                osw.close();
                                fos2.close();
                            } else {
                                readCommDump = false;
                            }
                        }
                        return ba;
                    }
                    catch (SocketTimeoutException e6) {
                        return buffer == null ? new byte[]{} : buffer.toByteArray();
                    }
                    catch (Exception e7) {
                        util.closeCommServer(x, addr, false);
                        util.errorLogCommServer(x, "Comm port [" + portName + "] disconnected: " + e7.getLocalizedMessage());
                        return null;
                    }
                }
            }
            return null;
        }
        util.errorLogCommServer(x, "Comm port [" + portName + "] error - not found");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean checkCommAvailable(String portName) {
        int x = Configuration.CommPorts.indexOf(portName);
        if (x >= 0) {
            switch (Configuration.CommPortsType.get(x)) {
                case 0: {
                    SerialPort port = Configuration.CommPortsSerial.get(x);
                    try {
                        return port.bytesAvailable() > 0;
                    }
                    catch (Exception e2) {
                        util.errorLogCommServer(x, "Comm port [" + portName + "] error - check available exception");
                        return false;
                    }
                }
                case 1: 
                case 2: {
                    ArrayBlockingQueue<Byte> commQueueRx = Configuration.CommPortsQueueRx.get(x);
                    return commQueueRx.size() > 0;
                }
                case 3: {
                    BufferedInputStream bin;
                    InetSocketAddress addr;
                    InetSocketAddress inetSocketAddress = addr = Configuration.CommPortsTCPAddress.get(x);
                    synchronized (inetSocketAddress) {
                        try {
                            Socket sock = CommPortsSocket.get(x);
                            if (sock == null) {
                                sock = new Socket();
                                if (CommPortsFailoverActive.get(x)) {
                                    sock.connect(Configuration.CommPortsTCPAddressFailover.get(x), 3000);
                                    sock.setSoTimeout(Configuration.CommPortsParams.get(x)[0]);
                                    if (!commServerConnectionRetry.get(x)) {
                                        hsyco.messageLog("Comm port [" + portName + "/failover] connected");
                                    }
                                } else {
                                    sock.connect(addr, 3000);
                                    sock.setSoTimeout(Configuration.CommPortsParams.get(x)[0]);
                                    if (!commServerConnectionRetry.get(x)) {
                                        hsyco.messageLog("Comm port [" + portName + "] connected");
                                    }
                                }
                                util.errorClearCommServer(x);
                                bin = new BufferedInputStream(sock.getInputStream());
                                BufferedOutputStream bout = new BufferedOutputStream(sock.getOutputStream());
                                CommPortsSocket.set(x, sock);
                                CommPortsInStream.set(x, bin);
                                CommPortsOutStream.set(x, bout);
                            } else {
                                bin = CommPortsInStream.get(x);
                            }
                        }
                        catch (Exception e3) {
                            util.closeCommServer(x, addr, false);
                            if (CommPortsFailoverActive.get(x)) {
                                CommPortsFailoverActive.clear(x);
                                util.errorLogCommServer(x, "Comm port [" + portName + "] warning - switching to main address");
                            } else if (Configuration.CommPortsTCPAddressFailover.get(x) != null) {
                                CommPortsFailoverActive.set(x);
                                util.errorLogCommServer(x, "Comm port [" + portName + "] warning - switching to failover address");
                            } else {
                                util.errorLogCommServer(x, "Comm port [" + portName + "] disconnected: " + e3.getLocalizedMessage());
                            }
                            return false;
                        }
                    }
                    try {
                        return bin.available() > 0;
                    }
                    catch (SocketTimeoutException e4) {
                        return false;
                    }
                    catch (Exception e5) {
                        util.closeCommServer(x, addr, false);
                        util.errorLogCommServer(x, "Comm port [" + portName + "] disconnected: " + e5.getLocalizedMessage());
                        return false;
                    }
                }
            }
            return false;
        }
        util.errorLogCommServer(x, "Comm port [" + portName + "] error - not found");
        return false;
    }

    public static void closeComm(String portName) {
        int x = Configuration.CommPorts.indexOf(portName);
        if (x >= 0 && Configuration.CommPortsType.get(x) == 3) {
            util.closeCommServer(x, Configuration.CommPortsTCPAddress.get(x), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeCommServer(int id, InetSocketAddress addr, boolean retry) {
        InetSocketAddress inetSocketAddress = addr;
        synchronized (inetSocketAddress) {
            commServerConnectionRetry.set(id, retry);
            try {
                CommPortsInStream.get(id).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                CommPortsOutStream.get(id).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                CommPortsSocket.get(id).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            CommPortsSocket.set(id, null);
        }
    }

    private static void errorLogCommServer(int id, String message) {
        try {
            if (!commServerErrorStatus.get(id)) {
                commServerErrorStatus.set(id);
                commServerConnectionRetry.clear(id);
                hsyco.errorLog(message);
            }
        }
        catch (Exception e2) {
            hsyco.errorLog(message);
        }
    }

    private static void errorClearCommServer(int id) {
        try {
            if (commServerErrorStatus.get(id)) {
                commServerErrorStatus.clear(id);
                commServerConnectionRetry.clear(id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int sendMail(String to, String from, String subject, Vector<String> body) {
        String[] ta;
        boolean sendError;
        Service t;
        block46: {
            t = null;
            sendError = true;
            ta = to.split("@");
            if (ta.length == 2 && ta[1].length() >= 4) break block46;
            hsyco.errorLog("sendMail - ERROR: to address is invalid");
            return -1;
        }
        try {
            Object[] servers;
            if (Configuration.SmtpHostName == null) {
                String[] da = ta[1].split(":");
                if (da.length == 2) {
                    to = String.valueOf(ta[0]) + "@" + da[0];
                    servers = new Object[]{da[1]};
                } else {
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                    InitialDirContext ictx = new InitialDirContext(env);
                    Attributes attrs = ictx.getAttributes(ta[1], new String[]{"MX"});
                    Attribute attr = attrs.get("MX");
                    NamingEnumeration<?> en = attr.getAll();
                    TreeMap<Integer, String> ns = new TreeMap<Integer, String>();
                    while (en.hasMore()) {
                        String[] sa = ((String)en.next()).split(" ");
                        ns.put(Integer.parseInt(sa[0]), sa[1].endsWith(".") ? sa[1].substring(0, sa[1].length() - 1) : sa[1]);
                    }
                    servers = ns.values().toArray();
                }
            } else {
                servers = new Object[]{null};
            }
            int i2 = 0;
            while (i2 < servers.length) {
                try {
                    Session session;
                    Properties props = new Properties();
                    if (servers[i2] != null) {
                        props.setProperty("mail.smtp.host", (String)servers[i2]);
                        session = Session.getInstance(props, null);
                    } else {
                        props.setProperty("mail.smtp.host", Configuration.SmtpHostName);
                        props.setProperty("mail.smtp.port", Integer.toString(Configuration.SmtpHostPort));
                        switch (Configuration.SmtpHostSSL) {
                            case 1: {
                                props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                                props.setProperty("mail.smtp.socketFactory.fallback", "false");
                                break;
                            }
                            case 2: {
                                props.setProperty("mail.smtp.starttls.enable", "true");
                            }
                        }
                        if (Configuration.SmtpHostUser.length() > 0 || Configuration.SmtpHostPassword.length() > 0) {
                            props.setProperty("mail.smtp.auth", "true");
                            session = Session.getInstance(props, new Authenticator(){

                                @Override
                                protected PasswordAuthentication getPasswordAuthentication() {
                                    return new PasswordAuthentication(Configuration.SmtpHostUser, Configuration.SmtpHostPassword);
                                }
                            });
                        } else {
                            session = Session.getInstance(props, null);
                        }
                    }
                    if (Configuration.SmtpDebug) {
                        session.setDebug(true);
                    }
                    MimeMessage message = new MimeMessage(session);
                    message.setFrom(new InternetAddress(from));
                    message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
                    message.setSubject(subject, "UTF-8");
                    if (body.size() == 1 && !body.get(0).toLowerCase().startsWith("cam:") && !body.get(0).toLowerCase().startsWith("file:")) {
                        message.setText(body.get(0), "UTF-8");
                    } else {
                        boolean textpartseparator = false;
                        MimeMultipart multipart = new MimeMultipart();
                        Hashtable<String, Long> frameIndexCache = new Hashtable<String, Long>();
                        int b2 = 0;
                        while (b2 < body.size()) {
                            block47: {
                                try {
                                    MimeBodyPart part;
                                    String item = body.get(b2);
                                    if (item.toLowerCase().startsWith("cam:")) {
                                        try {
                                            CameraFrame frame;
                                            textpartseparator = false;
                                            item = item.substring(4);
                                            int s = item.indexOf(58);
                                            int f2 = item.indexOf(35);
                                            if (s == -1 && f2 == -1) {
                                                frame = SystemState.cameraGet(Configuration.getCameraIndex(item), 0, 0);
                                            } else if (s == -1) {
                                                frame = SystemState.cameraRecGet(Configuration.getCameraIndex(item.substring(0, f2)), Integer.parseInt(item.substring(f2 + 1)), 0, 0);
                                            } else {
                                                int sec;
                                                int cam = Configuration.getCameraIndex(item.substring(0, s));
                                                int o2 = item.substring(s + 1).indexOf(58);
                                                if (o2 == -1) {
                                                    sec = Integer.parseInt(item.substring(s + 1));
                                                    frame = SystemState.cameraRecGet(cam, SystemState.cameraRecGetIndex(cam, sec), 0, 0);
                                                } else {
                                                    long baseindex;
                                                    sec = Integer.parseInt(item.substring(s + 1, s + 1 + o2));
                                                    int offset = Integer.parseInt(item.substring(s + 2 + o2));
                                                    String cacheKey = String.valueOf(cam) + ":" + sec;
                                                    if (frameIndexCache.containsKey(cacheKey)) {
                                                        baseindex = (Long)frameIndexCache.get(cacheKey);
                                                    } else {
                                                        baseindex = SystemState.cameraRecGetIndex(cam, sec);
                                                        frameIndexCache.put(cacheKey, baseindex);
                                                    }
                                                    frame = SystemState.cameraRecGet(cam, baseindex - (long)offset, 0, 0);
                                                }
                                            }
                                            if (frame != null) {
                                                InternetHeaders headers = new InternetHeaders();
                                                headers.addHeader("Content-Type", frame.mimetype);
                                                headers.addHeader("Content-Transfer-Encoding", "base64");
                                                part = new MimeBodyPart(headers, util.encodeBase64String(frame.data).getBytes("UTF-8"));
                                                ((Multipart)multipart).addBodyPart(part);
                                                break block47;
                                            }
                                            part = new MimeBodyPart();
                                            part.setText(" ");
                                            textpartseparator = true;
                                            ((Multipart)multipart).addBodyPart(part);
                                        }
                                        catch (Exception e2) {
                                            part = new MimeBodyPart();
                                            part.setText(" ");
                                            textpartseparator = true;
                                            ((Multipart)multipart).addBodyPart(part);
                                        }
                                        break block47;
                                    }
                                    if (item.toLowerCase().startsWith("file:")) {
                                        try {
                                            File theFile = new File(item.substring(5));
                                            DataInputStream fis = new DataInputStream(new BufferedInputStream(new FileInputStream(theFile)));
                                            byte[] theData = new byte[(int)theFile.length()];
                                            fis.readFully(theData);
                                            fis.close();
                                            InternetHeaders headers = new InternetHeaders();
                                            headers.addHeader("Content-Type", "application/octet-stream");
                                            headers.addHeader("Content-Disposition", "attachment; filename=" + theFile.getName());
                                            headers.addHeader("Content-Transfer-Encoding", "base64");
                                            part = new MimeBodyPart(headers, util.encodeBase64String(theData).getBytes("UTF-8"));
                                            ((Multipart)multipart).addBodyPart(part);
                                        }
                                        catch (Exception e3) {
                                            part = new MimeBodyPart();
                                            part.setText(" ");
                                            textpartseparator = true;
                                            ((Multipart)multipart).addBodyPart(part);
                                        }
                                    } else {
                                        part = new MimeBodyPart();
                                        part.setText(textpartseparator ? " " + item : item, "UTF-8");
                                        textpartseparator = true;
                                        ((Multipart)multipart).addBodyPart(part);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ++b2;
                        }
                        message.setContent(multipart);
                    }
                    t = session.getTransport("smtp");
                    t.connect();
                    ((Transport)t).sendMessage(message, message.getAllRecipients());
                    sendError = false;
                    break;
                }
                catch (Exception e4) {
                    if (Configuration.verboseLog) {
                        hsyco.errorLog("sendMail - ERROR: " + e4.getMessage());
                    }
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
                ++i2;
            }
            return sendError ? 0 : 1;
        }
        catch (Exception e5) {
            hsyco.errorLog("sendMail - GENERIC ERROR: " + e5);
            return -1;
        }
    }

    public static long parseMacAddress(String mac) {
        String[] sa;
        StringBuffer sb;
        block7: {
            if (!Character.isLetterOrDigit(mac.charAt(0))) {
                mac = mac.substring(1);
            }
            if (!Character.isLetterOrDigit(mac.charAt(mac.length() - 1))) {
                mac = mac.substring(0, mac.length() - 1);
            }
            sb = new StringBuffer();
            sa = mac.split("[:-]+");
            if (sa.length == 6) break block7;
            return 0L;
        }
        try {
            int i2 = 0;
            while (i2 < 6) {
                if (sa[i2].length() == 1) {
                    sb.append('0');
                }
                sb.append(sa[i2]);
                ++i2;
            }
            return Long.parseLong(sb.toString(), 16);
        }
        catch (Exception e2) {
            return 0L;
        }
    }

    public static byte[] parseMacAddressBytes(String mac) {
        String[] sa;
        byte[] macBytes;
        block6: {
            if (!Character.isLetterOrDigit(mac.charAt(0))) {
                mac = mac.substring(1);
            }
            if (!Character.isLetterOrDigit(mac.charAt(mac.length() - 1))) {
                mac = mac.substring(0, mac.length() - 1);
            }
            macBytes = new byte[6];
            sa = mac.split("[:-]+");
            if (sa.length == 6) break block6;
            return null;
        }
        try {
            int i2 = 0;
            while (i2 < 6) {
                macBytes[i2] = (byte)Integer.parseInt(sa[i2], 16);
                ++i2;
            }
            return macBytes;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String printMacAddress(long mac) {
        String[] b2 = new String[6];
        StringBuffer sb = new StringBuffer();
        try {
            int i2 = 0;
            while (i2 < b2.length) {
                b2[i2] = Long.toHexString(mac & 0xFFL);
                mac >>>= 8;
                ++i2;
            }
            i2 = b2.length - 1;
            while (i2 >= 0) {
                if (b2[i2].length() == 1) {
                    sb.append('0');
                }
                sb.append(b2[i2]);
                if (i2 > 0) {
                    sb.append(':');
                }
                --i2;
            }
            return sb.toString().toUpperCase();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static long getClientMacAddress(InetAddress IP) {
        long mac = 0L;
        try {
            String[] cmda = new String[]{"arp", "-n", IP.getHostAddress()};
            Runtime rt = System.getProperty("os.name").toLowerCase().indexOf("windows") == -1 ? Runtime.getRuntime() : null;
            Process proc = rt.exec(cmda);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String s = null;
            while ((s = brout.readLine()) != null) {
                String[] sa = s.split(" ");
                int i2 = 0;
                while (i2 < sa.length && mac == 0L) {
                    mac = util.parseMacAddress(sa[i2]);
                    ++i2;
                }
            }
            proc.destroy();
            brerr.close();
            brout.close();
            return mac;
        }
        catch (Exception e2) {
            return -1L;
        }
    }

    public static byte[] getClientMacAddressBytes(InetAddress IP) {
        byte[] macBytes = null;
        try {
            String[] cmda = new String[]{"arp", "-n", IP.getHostAddress()};
            Runtime rt = System.getProperty("os.name").toLowerCase().indexOf("windows") == -1 ? Runtime.getRuntime() : null;
            Process proc = rt.exec(cmda);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String s = null;
            while ((s = brout.readLine()) != null) {
                String[] sa = s.split(" ");
                int i2 = 0;
                while (i2 < sa.length && macBytes == null) {
                    macBytes = util.parseMacAddressBytes(sa[i2]);
                    ++i2;
                }
            }
            proc.destroy();
            brerr.close();
            brout.close();
            return macBytes;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static int wakeOnLan(InetAddress broadcast, InetAddress ip) {
        byte[] macBytes = util.getClientMacAddressBytes(ip);
        if (macBytes == null) {
            block7: {
                try {
                    InetSocketAddress echoAddress = new InetSocketAddress(ip, 7);
                    Socket echoSocket = new Socket();
                    echoSocket.connect(echoAddress, 1000);
                    echoSocket.close();
                }
                catch (Exception echoAddress) {
                    // empty catch block
                }
                try {
                    macBytes = util.getClientMacAddressBytes(ip);
                    if (macBytes != null) break block7;
                    Properties p = new Properties();
                    p.load(new FileInputStream(new File("wol.data")));
                    String mac = p.getProperty(ip.getHostAddress(), null).trim();
                    if (mac != null) {
                        return util.wakeOnLan(broadcast, mac);
                    }
                    return -1;
                }
                catch (Exception e2) {
                    return -1;
                }
            }
            util.updateWolCache(ip.getHostAddress(), macBytes);
            return util.wakeOnLan(broadcast, macBytes);
        }
        util.updateWolCache(ip.getHostAddress(), macBytes);
        return util.wakeOnLan(broadcast, macBytes);
    }

    public static int wakeOnLan(InetAddress broadcast, String mac) {
        byte[] macBytes = new byte[6];
        macBytes = util.parseMacAddressBytes(mac);
        if (macBytes == null) {
            return -1;
        }
        return util.wakeOnLan(broadcast, macBytes);
    }

    public static int wakeOnLan(InetAddress broadcast, byte[] mac) {
        byte[] packetBytes = new byte[102];
        int i2 = 0;
        while (i2 < 6) {
            packetBytes[i2] = -1;
            ++i2;
        }
        i2 = 6;
        while (i2 < 102) {
            System.arraycopy(mac, 0, packetBytes, i2, 6);
            i2 += 6;
        }
        try {
            DatagramPacket packet = new DatagramPacket(packetBytes, packetBytes.length, broadcast, 9);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            socket.close();
            return 1;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    private static void updateWolCache(String ip, byte[] mac) {
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(new File("wol.data")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < mac.length) {
            if (i2 > 0) {
                sb.append("-");
            }
            sb.append(Integer.toHexString(mac[i2] & 0xFF));
            ++i2;
        }
        p.setProperty(ip, sb.toString());
        try {
            util.safePropertiesStore(p, "wol.data");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long getNextSunrise(long now, boolean withoffset) {
        try {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
            cal.setTimeInMillis(now);
            int y = cal.get(1);
            int m2 = cal.get(2) + 1;
            int d2 = cal.get(5);
            Time sun = SunTimes.getSunriseTimeUTC(y, m2, d2, Configuration.Longitude, Configuration.Latitude, 96.0);
            cal.set(11, sun.getHour());
            cal.set(12, sun.getMinute());
            cal.set(13, sun.getSecond());
            cal.clear(14);
            long sunrise = cal.getTimeInMillis();
            if (sunrise > now) {
                if (withoffset) {
                    return sunrise + (long)(Configuration.SunriseOffsetMinutes * 60000);
                }
                return sunrise;
            }
            cal.add(5, 1);
            y = cal.get(1);
            m2 = cal.get(2) + 1;
            d2 = cal.get(5);
            sun = SunTimes.getSunriseTimeUTC(y, m2, d2, Configuration.Longitude, Configuration.Latitude, 96.0);
            cal.set(11, sun.getHour());
            cal.set(12, sun.getMinute());
            cal.set(13, sun.getSecond());
            if (withoffset) {
                return cal.getTimeInMillis() + (long)(Configuration.SunriseOffsetMinutes * 60000);
            }
            return cal.getTimeInMillis();
        }
        catch (Exception e2) {
            return 0L;
        }
    }

    public static long getNextSunset(long now, boolean withoffset) {
        try {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
            cal.setTimeInMillis(now);
            int y = cal.get(1);
            int m2 = cal.get(2) + 1;
            int d2 = cal.get(5);
            Time sun = SunTimes.getSunsetTimeUTC(y, m2, d2, Configuration.Longitude, Configuration.Latitude, 96.0);
            cal.set(11, sun.getHour());
            cal.set(12, sun.getMinute());
            cal.set(13, sun.getSecond());
            cal.clear(14);
            long sunset = cal.getTimeInMillis();
            if (sunset > now) {
                if (withoffset) {
                    return sunset + (long)(Configuration.SunsetOffsetMinutes * 60000);
                }
                return sunset;
            }
            cal.add(5, 1);
            y = cal.get(1);
            m2 = cal.get(2) + 1;
            d2 = cal.get(5);
            sun = SunTimes.getSunsetTimeUTC(y, m2, d2, Configuration.Longitude, Configuration.Latitude, 96.0);
            cal.set(11, sun.getHour());
            cal.set(12, sun.getMinute());
            cal.set(13, sun.getSecond());
            if (withoffset) {
                return cal.getTimeInMillis() + (long)(Configuration.SunsetOffsetMinutes * 60000);
            }
            return cal.getTimeInMillis();
        }
        catch (Exception e2) {
            return 0L;
        }
    }

    public static String guessContentTypeFromName(String name) {
        if (name == null) {
            return null;
        }
        String namelowercase = name.toLowerCase();
        if (namelowercase.endsWith(".html") || namelowercase.endsWith(".htm")) {
            return "text/html";
        }
        if (namelowercase.endsWith(".xml")) {
            return "text/xml";
        }
        if (namelowercase.endsWith(".txt")) {
            return "text/plain";
        }
        if (namelowercase.endsWith(".js")) {
            return "text/javascript";
        }
        if (namelowercase.endsWith(".svg")) {
            return "text/xml";
        }
        if (namelowercase.endsWith(".png")) {
            return "image/png";
        }
        if (namelowercase.endsWith(".gif")) {
            return "image/gif";
        }
        if (namelowercase.endsWith(".class")) {
            return "application/octet-stream";
        }
        if (namelowercase.endsWith(".jar")) {
            return "application/java-archive";
        }
        if (namelowercase.endsWith(".jpg") || namelowercase.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (namelowercase.endsWith(".ico")) {
            return "image/vnd.microsoft.icon";
        }
        if (namelowercase.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        if (namelowercase.endsWith(".mp4")) {
            return "video/mp4";
        }
        if (namelowercase.endsWith(".webm")) {
            return "video/webm";
        }
        if (namelowercase.endsWith(".ogv")) {
            return "video/ogg";
        }
        if (namelowercase.endsWith(".mov")) {
            return "video/quicktime";
        }
        if (namelowercase.endsWith(".mpeg")) {
            return "video/mpeg";
        }
        if (namelowercase.endsWith(".swf")) {
            return "application/x-shockwave-flash";
        }
        if (namelowercase.endsWith(".wav") || namelowercase.endsWith(".wave")) {
            return "audio/wav";
        }
        if (namelowercase.endsWith(".pem")) {
            return "application/x-pem-file";
        }
        if (namelowercase.endsWith(".csv")) {
            return "text/csv";
        }
        if (namelowercase.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (namelowercase.endsWith(".zip")) {
            return "application/zip";
        }
        return "text/plain";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer topoParser() throws Exception {
        File theFile = new File("systemtopo.txt");
        StringBuffer[] out = new StringBuffer[4];
        StringBuffer topo = new StringBuffer();
        int line = 1;
        int state = 0;
        boolean[] sections = new boolean[4];
        int i2 = 0;
        while (i2 < out.length) {
            out[i2] = new StringBuffer();
            ++i2;
        }
        if (theFile.canRead()) {
            String fl;
            BufferedReader fis = new BufferedReader(new FileReader(theFile));
            while ((fl = fis.readLine()) != null) {
                block34: {
                    String l2 = fl.trim();
                    if (l2.length() > 2) {
                        if (l2.startsWith("(") && l2.endsWith(")")) {
                            if (l2.indexOf("location") > 0) {
                                state = 1;
                            } else if (l2.indexOf("devices") > 0) {
                                state = 2;
                            } else {
                                if (l2.indexOf("temp") <= 0) {
                                    hsyco.errorLog("systemtopo.txt Parser: Syntax Error - wrong section header format, line: " + line);
                                    fis.close();
                                    return null;
                                }
                                state = 3;
                            }
                            if (sections[state]) {
                                hsyco.errorLog("systemtopo.txt Parser: Syntax Error - duplicate section name, line: " + line);
                                fis.close();
                                return null;
                            }
                            sections[state] = true;
                        } else if (!l2.startsWith("#")) {
                            try {
                                int snew = l2.indexOf(58);
                                String left = l2.substring(0, snew).trim().toLowerCase();
                                String right = l2.substring(snew + 1);
                                if (left.length() < 1 || right.length() < 1) {
                                    hsyco.errorLog("systemtopo.txt Parser: Syntax Error, line: " + line);
                                    return null;
                                }
                                String[] sa = right.split(";");
                                if (out[state].length() > 0) {
                                    out[state].append(',');
                                }
                                out[state].append('\"');
                                switch (state) {
                                    case 1: {
                                        out[state].append(left);
                                        out[state].append("\":[");
                                        int i3 = 0;
                                        while (true) {
                                            if (i3 >= sa.length) {
                                                out[state].append(']');
                                                break block34;
                                            }
                                            if (i3 > 0) {
                                                out[state].append(',');
                                            }
                                            out[state].append('\"');
                                            out[state].append(sa[i3].trim().replace("\\", "\\\\\\\\").replace("'", "\\'").replace("\"", "\\\\\""));
                                            out[state].append('\"');
                                            ++i3;
                                        }
                                    }
                                    case 2: {
                                        String s;
                                        if (left.length() == 0 || sa.length < 2 || sa.length > 5) {
                                            hsyco.errorLog("systemtopo.txt Parser: Syntax Error, line: " + line);
                                            return null;
                                        }
                                        String functionField = sa[0].trim().toUpperCase();
                                        String typeField = sa[1].trim().toUpperCase();
                                        String OptionsField = sa[sa.length - 1].trim().equalsIgnoreCase("NOCLICK") || sa[sa.length - 2].trim().equalsIgnoreCase("NOCLICK") ? "NOCLICK" : null;
                                        String imageField = sa.length >= 3 ? ((s = sa[2].trim().toLowerCase()).startsWith("cam:") || s.endsWith(".jpg") || s.endsWith(".png") ? sa[2].trim() : null) : null;
                                        String descriptionField = sa.length == 3 && OptionsField == null && imageField == null ? sa[2].trim() : (sa.length == 4 && (OptionsField == null || imageField == null) ? sa[3].trim() : (sa.length == 5 ? sa[4].trim() : ""));
                                        out[state].append(left);
                                        out[state].append("\":[\"");
                                        out[state].append(functionField);
                                        out[state].append("\",\"");
                                        out[state].append(descriptionField.replace("\\", "\\\\\\\\").replace("'", "\\'").replace("\"", "\\\\\""));
                                        out[state].append("\",\"\",\"");
                                        out[state].append(typeField);
                                        out[state].append('\"');
                                        if (imageField != null) {
                                            out[state].append(",\"");
                                            out[state].append(imageField);
                                            out[state].append('\"');
                                        }
                                        if (OptionsField != null) {
                                            if (imageField == null) {
                                                out[state].append(",\"\"");
                                            }
                                            out[state].append(",\"");
                                            out[state].append(OptionsField);
                                            out[state].append('\"');
                                        }
                                        out[state].append(']');
                                        break;
                                    }
                                    default: {
                                        hsyco.errorLog("systemtopo.txt Parser: Syntax Error, line: " + line);
                                        return null;
                                    }
                                }
                            }
                            catch (Exception e2) {
                                hsyco.errorLog("systemtopo.txt Parser: Syntax Error, line: " + line);
                                fis.close();
                                return null;
                            }
                        }
                    }
                }
                ++line;
            }
            fis.close();
        }
        topo.append("{\"hsycotopology\":{");
        if (out[1].length() > 0) {
            topo.append("\"location\":{");
            topo.append(out[1]);
            topo.append("},");
        } else {
            topo.append("\"location\":null,");
        }
        if (out[3].length() > 0) {
            topo.append("\"temp\":{");
            topo.append(out[3]);
            topo.append("},");
        } else {
            topo.append("\"temp\":null,");
        }
        if (out[2].length() > 0) {
            topo.append("\"devices\":{");
            topo.append(out[2]);
            topo.append("}");
        } else {
            topo.append("\"devices\":null");
        }
        topo.append("}}");
        return topo;
    }

    public static void topoFunctionParser() {
        File theFile = new File("systemtopo.txt");
        int state = 0;
        boolean[] sections = new boolean[4];
        if (theFile.canRead()) {
            try {
                String fl;
                BufferedReader fis = new BufferedReader(new FileReader(theFile));
                while ((fl = fis.readLine()) != null) {
                    String l2 = fl.trim();
                    if (l2.length() <= 2) continue;
                    if (l2.startsWith("(") && l2.endsWith(")")) {
                        if (l2.indexOf("location") > 0) {
                            state = 1;
                        } else if (l2.indexOf("devices") > 0) {
                            state = 2;
                        } else if (l2.indexOf("temp") > 0) {
                            state = 3;
                        } else {
                            fis.close();
                            return;
                        }
                        if (!sections[state]) {
                            sections[state] = true;
                            continue;
                        }
                        fis.close();
                        return;
                    }
                    if (l2.startsWith("#")) continue;
                    int snew = l2.indexOf(58);
                    String left = l2.substring(0, snew).trim().toLowerCase();
                    String right = l2.substring(snew + 1);
                    if (left.length() < 1 || right.length() < 1) {
                        fis.close();
                        return;
                    }
                    String[] sa = right.split(";");
                    switch (state) {
                        case 2: {
                            String s;
                            if (left.length() == 0 || sa.length < 2 || sa.length > 5) {
                                return;
                            }
                            String functionField = sa[0].trim().toUpperCase();
                            String typeField = sa[1].trim().toUpperCase();
                            String OptionsField = sa[sa.length - 1].trim().equalsIgnoreCase("NOCLICK") || sa[sa.length - 2].trim().equalsIgnoreCase("NOCLICK") ? "NOCLICK" : null;
                            String imageField = sa.length >= 3 ? ((s = sa[2].trim().toLowerCase()).startsWith("cam:") || s.endsWith(".jpg") || s.endsWith(".png") ? sa[2].trim() : null) : null;
                            String descriptionField = sa.length == 3 && OptionsField == null && imageField == null ? sa[2].trim() : (sa.length == 4 && (OptionsField == null || imageField == null) ? sa[3].trim() : (sa.length == 5 ? sa[4].trim() : ""));
                            if (functionField.equals("LIGHT")) {
                                if (typeField.equals("DIMMER")) {
                                    SystemState.deviceSet(false, 11, left, null, descriptionField);
                                    break;
                                }
                                SystemState.deviceSet(false, 1, left, null, descriptionField);
                                break;
                            }
                            if (!functionField.equals("AUTOM")) break;
                            SystemState.deviceSet(false, 2, left, null, descriptionField);
                        }
                    }
                }
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean topoUpdate() {
        File topoFile = new File("systemtopo.txt");
        Vector<String> topoLines = new Vector<String>();
        HashSet<String> devicesFiled = new HashSet<String>();
        ArrayList<String> devicesAdd = new ArrayList<String>();
        boolean devicesSection = false;
        int line = 1;
        int state = 0;
        try {
            String l2;
            if (topoFile.canRead()) {
                String fl;
                BufferedReader fis = new BufferedReader(new FileReader(topoFile));
                while ((fl = fis.readLine()) != null) {
                    l2 = fl.trim();
                    topoLines.add(l2);
                    if (l2.length() > 2) {
                        if (l2.startsWith("(") && l2.endsWith(")")) {
                            if (l2.indexOf("devices") > 0) {
                                state = 6;
                                devicesSection = true;
                            } else {
                                state = 0;
                            }
                        } else if (!l2.startsWith("#") && state == 6) {
                            int snew = l2.indexOf(58);
                            String id = l2.substring(0, snew).trim().toLowerCase();
                            String right = l2.substring(snew + 1);
                            if (id.length() < 1 || right.length() < 1) {
                                hsyco.errorLog("systemtopo.txt Parser: Syntax Error, line: " + line);
                                fis.close();
                                return false;
                            }
                            devicesFiled.add(id);
                        }
                    }
                    ++line;
                }
                fis.close();
            }
            Vector<String> dv = SystemState.deviceListDetected();
            int i2 = 0;
            while (i2 < dv.size()) {
                String d2 = dv.get(i2);
                int function = SystemState.deviceFunctionGet(d2);
                if (function != -1 && !devicesFiled.contains(d2)) {
                    switch (function) {
                        case 1: {
                            devicesAdd.add(String.valueOf(d2) + " : LIGHT ; LIGHT ; " + SystemState.deviceCommentGet(d2));
                            break;
                        }
                        case 11: {
                            devicesAdd.add(String.valueOf(d2) + " : LIGHT ; DIMMER ; " + SystemState.deviceCommentGet(d2));
                            break;
                        }
                        case 2: {
                            devicesAdd.add(String.valueOf(d2) + " : AUTOM ; VSHUT ; " + SystemState.deviceCommentGet(d2));
                            break;
                        }
                        case 100: {
                            devicesAdd.add(String.valueOf(d2) + " : LIGHT ; STD ; " + SystemState.deviceCommentGet(d2));
                            break;
                        }
                    }
                }
                ++i2;
            }
            if (devicesAdd.size() > 0) {
                if (!devicesSection) {
                    topoLines.add("");
                    topoLines.add("(devices)");
                }
                Collections.sort(devicesAdd);
                BufferedWriter fo = new BufferedWriter(new FileWriter(topoFile));
                hsyco.messageLog("ALERT: systemtopo.txt file changed");
                int i3 = 0;
                while (i3 < topoLines.size()) {
                    l2 = (String)topoLines.get(i3);
                    fo.write(l2);
                    fo.newLine();
                    if (l2.equals("(devices)")) {
                        int j2 = 0;
                        while (j2 < devicesAdd.size()) {
                            fo.write((String)devicesAdd.get(j2));
                            fo.newLine();
                            ++j2;
                        }
                    }
                    ++i3;
                }
                fo.close();
                topoFile.setWritable(true, false);
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static byte[] fileParser(HsycoFile hf, String skin, Properties properties) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        char[] o2 = util.macroParser(hf, null, properties, skin, null, false);
        if (o2 != null) {
            out.write(o2);
            out.flush();
            return bout.toByteArray();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] pageParser(HsycoFile hf, String urlkey, String path, String query, boolean metadataonly, boolean cachemanifest) throws Exception {
        bout = new ByteArrayOutputStream();
        out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        filePathName = String.valueOf(path) + "/" + hf.getName();
        popupBuffer = null;
        popupLine = 0;
        pageBuffer = null;
        pageLine = 0;
        pageNameLocations = null;
        pageLocations = new Hashtable<String, Vector<String>>();
        ptxt = null;
        macro = null;
        skinMeta = false;
        languageMeta = false;
        sizeMeta = false;
        styleMeta = false;
        queryLanguage = null;
        line = 1;
        state = 0;
        nestingLevel = 0;
        linebreak = -1;
        try {
            i = query.toLowerCase().indexOf("language=");
            if (i >= 0) {
                queryLanguage = query.substring(i).split("&")[0].substring(9).toLowerCase();
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        if (!hf.getFile().getName().toLowerCase().endsWith("hsm")) {
            o = util.macroParser(hf, null, ptxt, path, query, cachemanifest);
            if (o != null) {
                out.write(o);
                out.flush();
                return bout.toByteArray();
            }
            hsyco.errorLog("Page Parser [" + filePathName + "]: Error");
            return null;
        }
        ptxt = new Properties();
        ptxt.put("__path", path);
        ptxt.put("__scale", "1.0");
        if (urlkey != null) {
            ptxt.put("__urlkey", urlkey);
        }
        ptxt.put("__query", query != null ? "?" + query : "");
        SystemState.setStyle(path, null);
        theData = hf.getBytes();
        i = 0;
        while (i < theData.length) {
            c = theData[i];
            switch (c) {
                case 40: {
                    linebreak = 0;
                    if (state == 0) {
                        macro = new ByteArrayOutputStream();
                        nestingLevel = 0;
                        state = 2;
                        break;
                    }
                    if (state == 1) {
                        out.write(c);
                        break;
                    }
                    if (state != 2) break;
                    ++nestingLevel;
                    macro.write(c);
                    break;
                }
                case 41: {
                    linebreak = 0;
                    if (state == 0) {
                        hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                        return null;
                    }
                    if (state == 1) {
                        out.write(c);
                        break;
                    }
                    if (state != 2) break;
                    if (nestingLevel > 0) {
                        --nestingLevel;
                        macro.write(c);
                        break;
                    }
                    s = macro.toString("UTF-8");
                    if (!s.startsWith("#")) ** GOTO lbl337
                    if (!s.startsWith("#skin ")) ** GOTO lbl108
                    if (s.length() <= 6) ** GOTO lbl106
                    skin = s.substring(6).trim();
                    SystemState.setSkin(path, skin);
                    if (languageMeta && sizeMeta && styleMeta) {
                        return null;
                    }
                    if (metadataonly) {
                        skinMeta = true;
                    }
                    language = queryLanguage != null ? queryLanguage : SystemState.getLanguage(path);
                    text = new Properties();
                    text.load(new ByteArrayInputStream(new HsycoFile("www", String.valueOf(skin) + "/" + "text_" + language + ".txt").getBytes()));
                    try {
                        text.load(new ByteArrayInputStream(new HsycoFile("www", String.valueOf(path) + "/" + "text_" + language + ".txt").getBytes()));
                    }
                    catch (Exception var33_67) {
                        // empty catch block
                    }
                    ptxt.putAll((Map<?, ?>)text);
                    ptxt.put("__textdictionary", util.propertiesToJson(text));
                    ptxt.put("__scale", "1.0");
                    if (cachemanifest) {
                        ptxt.put("__htmlmanifest", " manifest=\"/" + path + "/" + skin + ".hsyco.manifest\"");
                    }
                    ** GOTO lbl335
lbl106:
                    // 1 sources

                    hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                    return null;
lbl108:
                    // 1 sources

                    if (!s.startsWith("#language ")) ** GOTO lbl118
                    if (s.length() <= 10) ** GOTO lbl116
                    SystemState.setLanguage(path, s.substring(10).trim());
                    if (skinMeta && sizeMeta && styleMeta) {
                        return null;
                    }
                    if (metadataonly) {
                        languageMeta = true;
                    }
                    ** GOTO lbl335
lbl116:
                    // 1 sources

                    hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                    return null;
lbl118:
                    // 1 sources

                    if (!s.startsWith("#size ")) ** GOTO lbl162
                    try {
                        width = 0;
                        height = 0;
                        width2 = 0;
                        height2 = 0;
                        sa = s.substring(6).trim().split("[ ,;xX]+");
                        if (sa.length == 2) {
                            width = Integer.parseInt(sa[0]);
                            height = Integer.parseInt(sa[1]);
                        } else if (sa.length == 4) {
                            width = Integer.parseInt(sa[0]);
                            height = Integer.parseInt(sa[1]);
                            width2 = Integer.parseInt(sa[2]);
                            height2 = Integer.parseInt(sa[3]);
                        }
                        if (sa.length != 2 || width <= 0 || height <= 0) ** GOTO lbl140
                        ptxt.put("__size:width", Integer.toString(width));
                        ptxt.put("__size:height", Integer.toString(height));
                        ** GOTO lbl156
lbl140:
                        // 1 sources

                        if (sa.length != 4 || width <= 0 || height <= 0 || width2 <= 0 || height2 <= 0) ** GOTO lbl150
                        ptxt.put("__size:width", Integer.toString(width));
                        ptxt.put("__size:height", Integer.toString(height));
                        ptxt.put("__size:width2", Integer.toString(width2));
                        ptxt.put("__size:height2", Integer.toString(height2));
                        ** GOTO lbl156
lbl150:
                        // 1 sources

                        hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                        return null;
                    }
                    catch (Exception e) {
                        hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                        return null;
                    }
lbl156:
                    // 3 sources

                    if (!skinMeta || !languageMeta || !styleMeta) ** GOTO lbl159
                    return null;
lbl159:
                    // 2 sources

                    if (!metadataonly) ** GOTO lbl335
                    sizeMeta = true;
lbl162:
                    // 1 sources

                    if (!s.startsWith("#style ")) ** GOTO lbl185
                    try {
                        style = s.substring(7);
                        params = style.split(";");
                        j = 0;
                        while (j < params.length) {
                            pa = params[j].split("=");
                            if (pa.length != 2) {
                                throw new Exception();
                            }
                            ptxt.put("__style:" + pa[0].trim(), pa[1].trim());
                            ++j;
                        }
                        SystemState.setStyle(path, style);
                        if (!languageMeta || !skinMeta || !sizeMeta) ** GOTO lbl182
                        return null;
                    }
                    catch (Exception e) {
                        hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                        return null;
                    }
lbl182:
                    // 2 sources

                    if (!metadataonly) ** GOTO lbl335
                    styleMeta = true;
lbl185:
                    // 1 sources

                    if (!s.startsWith("#include ")) ** GOTO lbl213
                    if (s.length() <= 9) ** GOTO lbl211
                    if (popupBuffer != null) {
                        o = util.macroParser(popupBuffer, hf, null, ptxt, path, query, cachemanifest);
                        if (o == null) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + popupLine);
                            return null;
                        }
                        out.write(o);
                        state = 0;
                        popupBuffer = null;
                        popupLine = 0;
                    }
                    if (pageBuffer != null) {
                        o = util.macroParser(pageBuffer, hf, null, ptxt, path, query, cachemanifest);
                        if (o == null) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + pageLine);
                            return null;
                        }
                        out.write(o);
                        state = 0;
                        pageBuffer = null;
                        pageLine = 0;
                    }
                    if ((include = util.pageParser(f = new HsycoFile(hf.getFile().getParentFile(), String.valueOf(s.substring(9).trim()) + ".hsm"), urlkey, path, query, false, cachemanifest)) == null) {
                        hsyco.errorLog("Page Parser [" + filePathName + "]: File Error, line: " + line);
                        return null;
                    }
                    out.flush();
                    bout.write(include);
                    ** GOTO lbl335
lbl211:
                    // 1 sources

                    hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                    return null;
lbl213:
                    // 1 sources

                    if (s.startsWith("#gestures ")) {
                        try {
                            ptxt.put("__gestures", s.substring(10).trim());
                        }
                        catch (Exception e) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                            return null;
                        }
                    }
                    if (!s.startsWith("#deviceimage ")) ** GOTO lbl230
                    try {
                        if (s.length() > 13 && ((value = s.substring(13).trim()).equalsIgnoreCase("disable") || value.equalsIgnoreCase("off"))) {
                            ptxt.put("__deviceimage:disable", "1");
                        }
                        ** GOTO lbl335
                    }
                    catch (Exception value) {}
                    ** GOTO lbl335
lbl230:
                    // 1 sources

                    if (!s.startsWith("#locked ")) ** GOTO lbl239
                    try {
                        if (s.length() > 8 && (value = s.substring(8).trim()).equalsIgnoreCase("true")) {
                            ptxt.put("__locked", "1");
                        }
                        ** GOTO lbl335
                    }
                    catch (Exception value) {}
                    ** GOTO lbl335
lbl239:
                    // 1 sources

                    if (s.startsWith("#pageswipelist ")) {
                        try {
                            param = s.substring(s.indexOf(32) + 1).trim();
                            ptxt.put("__pageswipe:list", param);
                        }
                        catch (Exception e) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                            return null;
                        }
                    }
                    if (s.startsWith("#cameralist ")) {
                        try {
                            param = s.substring(s.indexOf(32) + 1).trim();
                            ptxt.put("__camera:list", param);
                        }
                        catch (Exception e) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                            return null;
                        }
                    }
                    if (s.startsWith("#cameraoverlay ")) {
                        try {
                            param = s.substring(s.indexOf(32) + 1).trim();
                            ptxt.put("__camera:overlay", param);
                        }
                        catch (Exception e) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                            return null;
                        }
                    }
                    if (s.startsWith("#cameragridlist ")) {
                        try {
                            param = s.substring(s.indexOf(32) + 1).trim();
                            ptxt.put("__camera:gridlist", param);
                        }
                        catch (Exception e) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                            return null;
                        }
                    }
                    if (s.startsWith("#kiosk ")) {
                        try {
                            param = s.trim().length() > 6 ? s.substring(6).trim().toLowerCase() : "nolock";
                            ptxt.put("__kiosk:mode", param);
                        }
                        catch (Exception e) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                            return null;
                        }
                    }
                    if (!s.startsWith("#scale ")) ** GOTO lbl301
                    try {
                        if (s.length() > 7) {
                            value = s.substring(7).trim();
                            if (value.equalsIgnoreCase("auto") || value.equalsIgnoreCase("fit")) {
                                ptxt.put("__scale", "\"" + value + "\"");
                            } else {
                                factor = Double.parseDouble(value);
                                if (factor > 0.0) {
                                    ptxt.put("__scale", value);
                                }
                            }
                        }
                        ** GOTO lbl335
                    }
                    catch (Exception value) {}
                    ** GOTO lbl335
lbl301:
                    // 1 sources

                    if (s.startsWith("#uiset ")) {
                        try {
                            param = s.substring(7).trim();
                            ptxt.put("__uiset", param);
                        }
                        catch (Exception e) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                            return null;
                        }
                    }
                    if (!s.startsWith("#location ")) ** GOTO lbl327
                    try {
                        if (s.length() <= 10 || pageNameLocations == null) ** GOTO lbl335
                        v = util.splitMacroParams(s.substring(10), ptxt);
                        if (v.size() <= 0) ** GOTO lbl318
                        pageLocations.put(pageNameLocations, v);
                        ** GOTO lbl324
lbl318:
                        // 1 sources

                        hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                        return null;
                    }
                    catch (Exception e) {
                        hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                        return null;
                    }
lbl324:
                    // 2 sources

                    pageNameLocations = null;
lbl327:
                    // 1 sources

                    if (s.startsWith("#scope ")) {
                        try {
                            ptxt.put("__scope", s.substring(7).trim());
                        }
                        catch (Exception e) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                            return null;
                        }
                    }
lbl335:
                    // 29 sources

                    state = 0;
                    break;
lbl337:
                    // 1 sources

                    if (s.startsWith("main ")) {
                        state = 0;
                        break;
                    }
                    if (s.startsWith("popup ")) {
                        state = 0;
                        popupBuffer = new String(s);
                        popupLine = line;
                        ptxt.remove("size:width");
                        ptxt.remove("size:height");
                        ptxt.remove("size:width2");
                        ptxt.remove("size:height2");
                        break;
                    }
                    if (s.startsWith("page ") || s.startsWith("page#portrait ") || s.startsWith("page#landscape ")) {
                        state = 0;
                        pageBuffer = new String(s);
                        pageLine = line;
                        try {
                            pageNameLocations = util.splitMacroParams(s.substring(s.indexOf(32) + 1), ptxt).get(0);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ptxt.remove("__gestures");
                        ptxt.remove("__scope");
                        break;
                    }
                    if (s.startsWith("menu") || s.startsWith("menu#portrait") || s.startsWith("menu#landscape")) {
                        if (metadataonly) {
                            return null;
                        }
                        state = 0;
                        pageBuffer = new String(s);
                        pageLine = line;
                        try {
                            pageNameLocations = "menu";
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ptxt.remove("__gestures");
                        ptxt.remove("__scope");
                        break;
                    }
                    if (popupBuffer != null) {
                        o = util.macroParser(popupBuffer, hf, null, ptxt, path, query, cachemanifest);
                        if (o == null) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + popupLine);
                            return null;
                        }
                        out.write(o);
                        state = 0;
                        popupBuffer = null;
                        popupLine = 0;
                    }
                    if (pageBuffer != null) {
                        o = util.macroParser(pageBuffer, hf, null, ptxt, path, query, cachemanifest);
                        if (o == null) {
                            hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + pageLine);
                            return null;
                        }
                        out.write(o);
                        state = 0;
                        pageBuffer = null;
                        pageLine = 0;
                    }
                    if ((o = util.macroParser(s, hf, null, ptxt, path, query, cachemanifest)) != null) {
                        out.write(o);
                        state = 0;
                        break;
                    }
                    hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                    return null;
                }
                case 60: {
                    linebreak = 0;
                    if (state == 0) {
                        out.write(c);
                        state = 1;
                        break;
                    }
                    if (state == 2) {
                        macro.write(c);
                        break;
                    }
                    if (state != 1) break;
                    hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                    return null;
                }
                case 62: {
                    linebreak = 0;
                    if (state == 1) {
                        out.write(c);
                        state = 0;
                        break;
                    }
                    if (state == 2) {
                        macro.write(c);
                        break;
                    }
                    if (state != 0) break;
                    hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                    return null;
                }
                case 35: {
                    if (linebreak != 0) {
                        state = 3;
                        break;
                    }
                    linebreak = 0;
                    if (state == 2) {
                        macro.write(c);
                        break;
                    }
                    if (state != 0 && state != 1) break;
                    out.write(c);
                    break;
                }
                case 10: 
                case 13: {
                    if (linebreak == 0) {
                        linebreak = c;
                        ++line;
                    } else if (linebreak == c) {
                        ++line;
                    } else {
                        linebreak = c;
                    }
                    if (state == 2) {
                        macro.write(c);
                        break;
                    }
                    if (state == 0 || state == 1) {
                        out.write(c);
                        break;
                    }
                    if (state != 3) break;
                    state = 0;
                    break;
                }
                default: {
                    linebreak = 0;
                    if (state == 2) {
                        macro.write(c);
                        break;
                    }
                    if (state != 0 && state != 1) break;
                    out.write(c);
                }
            }
            ++i;
        }
        if (state == 0 || state == 3) {
            if (hf.getName().equalsIgnoreCase("index.hsm")) {
                if (pageLocations.size() > 0) {
                    try {
                        locationPages = new Hashtable<String, Vector>();
                        e = pageLocations.keys();
                        while (e.hasMoreElements()) {
                            p = (String)e.nextElement();
                            lv = (Vector)pageLocations.get(p);
                            x = 0;
                            while (x < lv.size()) {
                                l = (String)lv.get(x);
                                pv = locationPages.containsKey(l) != false ? (Vector)locationPages.get(l) : new Vector();
                                if (!pv.contains(p)) {
                                    pv.add(p);
                                }
                                locationPages.put(l, pv);
                                ++x;
                            }
                        }
                        sb = new StringBuffer("{");
                        e = locationPages.keys();
                        while (e.hasMoreElements()) {
                            l = (String)e.nextElement();
                            pv = (Vector)locationPages.get(l);
                            if (sb.length() > 1) {
                                sb.append(',');
                            }
                            sb.append('\"');
                            sb.append(l);
                            sb.append("\":[");
                            x = 0;
                            while (x < pv.size()) {
                                if (sb.charAt(sb.length() - 1) == '\"') {
                                    sb.append(',');
                                }
                                sb.append('\"');
                                sb.append((String)pv.get(x));
                                sb.append('\"');
                                ++x;
                            }
                            sb.append(']');
                        }
                        sb.append('}');
                        ptxt.put("__location:pages", sb.toString());
                    }
                    catch (Exception locationPages) {
                        // empty catch block
                    }
                }
                if ((o = util.macroParser("main", hf, null, ptxt, path, query, cachemanifest)) != null) {
                    out.write(o);
                    state = 0;
                } else {
                    hsyco.errorLog("Page Parser [" + filePathName + "]: Syntax Error, line: " + line);
                    return null;
                }
            }
            out.flush();
            return bout.toByteArray();
        }
        return null;
    }

    private static char[] macroParser(HsycoFile hf, String id, Properties ptxt, String path, String query, boolean cachemanifest) {
        return util.macroParser(null, null, null, hf, id, ptxt, path, query, cachemanifest);
    }

    private static char[] macroParser(String macro, HsycoFile hf, String id, Properties ptxt, String path, String query, boolean cachemanifest) {
        return util.macroParser(macro, null, null, hf, id, ptxt, path, query, cachemanifest);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static char[] macroParser(String macro, char[] data, Vector<String> dataParams, HsycoFile hf, String id, Properties ptxt, String path, String query, boolean cachemanifest) {
        filePathName = String.valueOf(path) + "/" + hf.getName();
        out = new ByteArrayOutputStream();
        txtVarName = null;
        state = 0;
        condExpression = null;
        condSkip = false;
        macroId = null;
        queryLanguage = null;
        nestingLevel = 0;
        try {
            i = query.toLowerCase().indexOf("language=");
            if (i >= 0) {
                queryLanguage = query.substring(i).split("&")[0].substring(9).toLowerCase();
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        if (data != null) {
            macroFile = hf;
            macroName = hf.getName();
            macroId = id;
            macroParams = dataParams;
            try {
                bytes = new String(data).getBytes("UTF-8");
            }
            catch (Exception e) {
                bytes = null;
            }
        } else if (macro != null) {
            block114: {
                ts = macro.trim();
                ni = ts.indexOf(32);
                if (ni > 0) {
                    macroName = ts.substring(0, ni);
                    macroParams = util.splitMacroParams(ts.substring(ni + 1), ptxt);
                    if (macroParams == null) {
                        return null;
                    }
                } else if (ni == -1 && ts.length() > 0) {
                    macroName = ts;
                    macroParams = null;
                } else {
                    return null;
                }
                try {
                    ii = macroName.indexOf(33);
                    if (ii == 0) {
                        return null;
                    }
                    if (ii > 0) {
                        macroId = macroName.substring(ii + 1);
                        macroName = macroName.substring(0, ii);
                        break block114;
                    }
                    if (id != null) {
                        macroId = id;
                    }
                }
                catch (Exception e) {
                    return null;
                }
            }
            macroFile = new HsycoFile("www", String.valueOf(SystemState.getSkin(path)) + "/" + macroName + ".hsc");
            bytes = macroFile.getBytes();
        } else {
            macroFile = hf;
            macroName = hf.getName();
            macroParams = null;
            bytes = hf.getBytes();
        }
        try {
            i = 0;
            while (i < bytes.length) {
                c = bytes[i];
                block10 : switch (c) {
                    case 36: {
                        if (condSkip || state == 0) {
                            state = 36;
                            break;
                        }
                        if (state == 77) {
                            condExpression.write(c);
                            break;
                        }
                        if (state != 36) {
                            return null;
                        }
                        out.write(c);
                        state = 0;
                        break;
                    }
                    case 59: {
                        if (condSkip) break;
                        if (state == 0) {
                            out.write(c);
                            break;
                        }
                        if (state == 77) {
                            condExpression.write(c);
                            break;
                        }
                        if (state != 84) {
                            return null;
                        }
                        if (ptxt == null) {
                            skin = SystemState.getSkin(path);
                            style = SystemState.getStyle(path);
                            ptxt = new Properties();
                            language = queryLanguage != null ? queryLanguage : SystemState.getLanguage(path);
                            text = new Properties();
                            text.load(new ByteArrayInputStream(new HsycoFile("www", String.valueOf(skin) + "/" + "text_" + language + ".txt").getBytes()));
                            try {
                                text.load(new ByteArrayInputStream(new HsycoFile("www", String.valueOf(path) + "/" + "text_" + language + ".txt").getBytes()));
                            }
                            catch (Exception var28_56) {
                                // empty catch block
                            }
                            ptxt.putAll((Map<?, ?>)text);
                            ptxt.put("__textdictionary", util.propertiesToJson(text));
                            ptxt.put("__scale", "1.0");
                            if (cachemanifest) {
                                ptxt.put("__htmlmanifest", " manifest=\"/" + path + "/" + skin + ".hsyco.manifest\"");
                            }
                            if (style != null) {
                                params = style.split(";");
                                j = 0;
                                while (j < params.length) {
                                    pa = params[j].split("=");
                                    if (pa.length != 2) {
                                        throw new Exception();
                                    }
                                    ptxt.put("__style:" + pa[0].trim(), pa[1].trim());
                                    ++j;
                                }
                            }
                        }
                        if ((name = txtVarName.toString()).startsWith("__file:")) {
                            theFile = name.charAt(7) == '/' ? new HsycoFile("www", name.substring(8)) : new HsycoFile("www/" + path, name.substring(7));
                            if (theFile.getFile() != null) {
                                if (name.endsWith(".css")) {
                                    out.write(new String(util.macroParser(theFile, id, ptxt, path, query, cachemanifest)).getBytes("UTF-8"));
                                } else {
                                    out.write(theFile.getBytes());
                                }
                            }
                            out.write("\r\n".getBytes("UTF-8"));
                        } else if (name.startsWith("__embed:jsonstate")) {
                            out.write(SystemState.embedState("jsonstate").getBytes("UTF-8"));
                        } else if (name.startsWith("__embed:jsontopo")) {
                            out.write(SystemState.embedState("jsontopo").getBytes("UTF-8"));
                        } else if (name.startsWith("__embed:jsonconfig")) {
                            out.write(SystemState.embedState("jsonconfig").getBytes("UTF-8"));
                        } else if (name.equals("__embed:indexjs")) {
                            theFile = new HsycoFile("www/" + path, "index.js");
                            if (theFile.getBytes() != null) {
                                out.write(theFile.getBytes());
                            }
                        } else if (name.equalsIgnoreCase("__path")) {
                            out.write(path.getBytes("UTF-8"));
                        } else {
                            defsep = name.indexOf(124);
                            if (defsep > 0) {
                                out.write(ptxt.getProperty(name.substring(0, defsep), name.substring(defsep + 1)).trim().getBytes("UTF-8"));
                            } else {
                                out.write(ptxt.getProperty(name, "").trim().getBytes("UTF-8"));
                            }
                        }
                        state = 0;
                        break;
                    }
                    case 64: {
                        if (condSkip) break;
                        if (state == 0) {
                            out.write(c);
                            break;
                        }
                        if (state == 77) {
                            condExpression.write(c);
                            break;
                        }
                        if (state == 84) {
                            out.write(c);
                            break;
                        }
                        if (state != 36) {
                            return null;
                        }
                        state = 64;
                        break;
                    }
                    case 33: {
                        if (condSkip) break;
                        if (state == 67) {
                            if (condExpression == null) {
                                condExpression = new CharArrayWriter();
                            }
                            condExpression.write(c);
                            break;
                        }
                        if (state == 77) {
                            condExpression.write(c);
                            break;
                        }
                        out.write(c);
                        break;
                    }
                    case 63: {
                        if (condSkip) break;
                        if (state == 36) {
                            if (macroId != null) {
                                out.write(macroId.getBytes("UTF-8"));
                            }
                            state = 0;
                            break;
                        }
                        if (state == 67) {
                            if (condExpression == null) {
                                condExpression = new CharArrayWriter();
                            }
                            condExpression.write(c);
                            break;
                        }
                        if (state == 77) {
                            condExpression.write(c);
                            break;
                        }
                        out.write(c);
                        break;
                    }
                    case 40: {
                        if (state == 36) {
                            condExpression = null;
                            state = 67;
                            break;
                        }
                        if (state == 67 && condExpression == null) {
                            condExpression = new CharArrayWriter();
                            condExpression.write(c);
                            state = 77;
                            nestingLevel = 0;
                            break;
                        }
                        if (state == 77) {
                            condExpression.write(c);
                            ++nestingLevel;
                            break;
                        }
                        if (condSkip) break;
                        if (state == 0) {
                            out.write(c);
                            break;
                        }
                        if (state != 84) {
                            return null;
                        }
                        txtVarName.write(c);
                        break;
                    }
                    case 41: {
                        if (state == 77) {
                            condExpression.write(c);
                            if (nestingLevel > 0) {
                                --nestingLevel;
                                break;
                            }
                            state = 67;
                            break;
                        }
                        if (state != 67) ** GOTO lbl284
                        if (condExpression != null) ** GOTO lbl233
                        condSkip = false;
                        ** GOTO lbl282
lbl233:
                        // 1 sources

                        condition = condExpression.toString();
                        if (!condition.startsWith("(") || !condition.endsWith(")")) ** GOTO lbl238
                        ca = util.macroParser(null, condition.substring(1, condition.length() - 1).toCharArray(), macroParams, hf, macroId, ptxt, path, query, cachemanifest);
                        out.write(new String(util.macroParser(new String(ca), hf, macroId, ptxt, path, query, cachemanifest)).getBytes("UTF-8"));
                        ** GOTO lbl282
lbl238:
                        // 1 sources

                        eqx = condition.indexOf(61);
                        if (condition.charAt(0) != '!') ** GOTO lbl263
                        if (eqx != -1) ** GOTO lbl252
                        try {
                            pn = Integer.parseInt(condition.substring(1));
                            condSkip = pn <= macroParams.size() && macroParams.elementAt(pn - 1).length() != 0;
                        }
                        catch (Exception e) {
                            if (condition.length() != 2 || condition.charAt(1) < 'A' || condition.charAt(1) > 'F') ** GOTO lbl250
                            pn = 10 + condition.charAt(1) - 65;
                            condSkip = pn <= macroParams.size() && macroParams.elementAt(pn - 1).length() != 0;
                            ** GOTO lbl282
lbl250:
                            // 1 sources

                            condSkip = ptxt.containsKey(condition.substring(1));
                        }
                        ** GOTO lbl282
lbl252:
                        // 1 sources

                        try {
                            sc = condition.substring(eqx + 1);
                            value = eqx == 2 ? ((cc = condition.charAt(1)) >= '0' && cc <= '9' ? macroParams.elementAt(cc - 48 - 1) : (cc >= 'A' && cc <= 'F' ? macroParams.elementAt(cc - 65 - 1) : null)) : ptxt.getProperty(condition.substring(1, eqx));
                            if (sc.charAt(0) != '~') ** GOTO lbl258
                            condSkip = value.matches(sc.substring(1));
                            ** GOTO lbl282
lbl258:
                            // 1 sources

                            condSkip = value.equals(sc);
                        }
                        catch (Exception e) {
                            condSkip = false;
                        }
                        ** GOTO lbl282
lbl263:
                        // 1 sources

                        if (eqx != -1) ** GOTO lbl275
                        try {
                            pn = Integer.parseInt(condition);
                            condSkip = pn > macroParams.size() || macroParams.elementAt(pn - 1).length() == 0;
                        }
                        catch (Exception e) {
                            if (condition.length() != 1 || condition.charAt(0) < 'A' || condition.charAt(0) > 'F') ** GOTO lbl273
                            pn = 10 + condition.charAt(0) - 65;
                            condSkip = pn > macroParams.size() || macroParams.elementAt(pn - 1).length() == 0;
                            ** GOTO lbl282
lbl273:
                            // 1 sources

                            condSkip = ptxt.containsKey(condition) == false;
                        }
                        ** GOTO lbl282
lbl275:
                        // 1 sources

                        try {
                            sc = condition.substring(eqx + 1);
                            value = eqx == 1 ? ((cc = condition.charAt(0)) >= '0' && cc <= '9' ? macroParams.elementAt(cc - 48 - 1) : (cc >= 'A' && cc <= 'F' ? macroParams.elementAt(cc - 65 - 1) : null)) : ptxt.getProperty(condition.substring(0, eqx));
                            condSkip = sc.charAt(0) == '~' ? value.matches(sc.substring(1)) == false : value.equals(sc) == false;
                        }
                        catch (Exception e) {
                            condSkip = true;
                        }
lbl282:
                        // 13 sources

                        state = 0;
                        break;
lbl284:
                        // 1 sources

                        if (condSkip) break;
                        if (state == 0) {
                            out.write(c);
                            break;
                        }
                        if (state != 84) {
                            return null;
                        }
                        txtVarName.write(c);
                        break;
                    }
                    default: {
                        if (state == 67 || state == 77) {
                            if (condExpression == null) {
                                condExpression = new CharArrayWriter();
                            }
                            condExpression.write(c);
                            break;
                        }
                        if (condSkip) break;
                        if (state == 0) {
                            out.write(c);
                            break;
                        }
                        if (state == 36) {
                            if (c >= 49 && c <= 57) {
                                out.write(macroParams.get(c - 49).getBytes("UTF-8"));
                                state = 0;
                                break;
                            }
                            if (c >= 65 && c <= 70) {
                                out.write(macroParams.get(9 + c - 65).getBytes("UTF-8"));
                                state = 0;
                                break;
                            }
                            txtVarName = new CharArrayWriter();
                            txtVarName.write(c);
                            state = 84;
                            break;
                        }
                        if (state == 64) {
                            if (c >= 49 && c <= 57) {
                                pos = macroParams.get(c - 49).toUpperCase();
                                switch (bytes[i + 2]) {
                                    case 67: 
                                    case 99: {
                                        if (pos.matches("\\d\\d")) {
                                            out.write(" r".getBytes("UTF-8"));
                                            out.write(pos.charAt(0));
                                            out.write(" c".getBytes("UTF-8"));
                                            out.write(pos.charAt(1));
                                        } else if (pos.matches("R\\d+C\\d+")) {
                                            ci = pos.indexOf(67);
                                            out.write(" r".getBytes("UTF-8"));
                                            out.write(pos.substring(1, ci).getBytes("UTF-8"));
                                            out.write(" c".getBytes("UTF-8"));
                                            out.write(pos.substring(ci + 1).getBytes("UTF-8"));
                                        } else if (!pos.matches("X[\\-\\d]\\d*Y[\\-\\d]\\d*")) {
                                            return null;
                                        }
                                        i += 2;
                                        state = 0;
                                        break block10;
                                    }
                                    case 83: 
                                    case 115: {
                                        if (!pos.matches("\\d\\d") && !pos.matches("R\\d+C\\d+")) {
                                            if (!pos.matches("X[\\-\\d]\\d*Y[\\-\\d]\\d*")) {
                                                return null;
                                            }
                                            ci = pos.indexOf(89);
                                            out.write("left:".getBytes("UTF-8"));
                                            out.write(pos.substring(1, ci).getBytes("UTF-8"));
                                            out.write("px; top:".getBytes("UTF-8"));
                                            out.write(pos.substring(ci + 1).getBytes("UTF-8"));
                                            out.write("px;".getBytes("UTF-8"));
                                        }
                                        i += 2;
                                        state = 0;
                                        break block10;
                                    }
                                }
                                return null;
                            }
                            return null;
                        }
                        if (state != 84) {
                            return null;
                        }
                        txtVarName.write(c);
                        break;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            hsyco.errorLog("Page Parser [" + filePathName + "]: File Error: " + macroName);
            return null;
        }
        if (state != 0) {
            return null;
        }
        try {
            return out.toString("UTF-8").toCharArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Vector<String> splitMacroParams(String paramString, Properties p) {
        int state = 0;
        char c2 = '\u0000';
        StringBuffer param = new StringBuffer();
        Vector<String> params = new Vector<String>();
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= paramString.length()) {
                    if (param.length() <= 0) break;
                    params.add(util.parseMacroParam(p, param.toString().trim()));
                    return params;
                }
                c2 = paramString.charAt(i2);
                block1 : switch (c2) {
                    case ';': {
                        switch (state) {
                            case 0: {
                                params.add("");
                                break;
                            }
                            case 1: {
                                params.add(util.parseMacroParam(p, param.toString().trim()));
                                param = new StringBuffer();
                                state = 0;
                                break;
                            }
                            case 2: {
                                param.append(c2);
                                break;
                            }
                        }
                        break;
                    }
                    case '(': {
                        switch (state) {
                            case 0: {
                                state = 2;
                                break block1;
                            }
                            case 1: {
                                param.append(c2);
                                break block1;
                            }
                            case 2: {
                                return null;
                            }
                        }
                        break;
                    }
                    case ')': {
                        switch (state) {
                            case 0: {
                                state = 2;
                                break;
                            }
                            case 1: {
                                return null;
                            }
                            case 2: {
                                state = 1;
                                break;
                            }
                        }
                        break;
                    }
                    case '\\': {
                        switch (state) {
                            case 0: 
                            case 1: {
                                param.append(c2);
                                break;
                            }
                            case 2: {
                                c2 = paramString.charAt(++i2);
                                param.append(c2);
                                break;
                            }
                        }
                        break;
                    }
                    case ' ': {
                        switch (state) {
                            case 0: {
                                break;
                            }
                            case 1: 
                            case 2: {
                                param.append(c2);
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        switch (state) {
                            case 0: {
                                state = 1;
                                param.append(c2);
                                break block1;
                            }
                            case 1: 
                            case 2: {
                                param.append(c2);
                                break block1;
                            }
                        }
                    }
                }
                ++i2;
            }
            if (c2 != ';') return params;
            params.add("");
            return params;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static String parseMacroParam(Properties p, String param) {
        StringBuffer sb = new StringBuffer();
        StringBuffer id = new StringBuffer();
        int state = 0;
        int i2 = 0;
        while (i2 < param.length()) {
            char c2 = param.charAt(i2);
            if (state == 36) {
                if (c2 == ';') {
                    String s = id.toString();
                    String v = p.getProperty(s);
                    sb.append(v != null ? v : "$" + s + ";");
                    state = 0;
                    id = new StringBuffer();
                } else {
                    id.append(c2);
                }
            } else if (c2 == '$') {
                state = 36;
            } else {
                sb.append(c2);
            }
            ++i2;
        }
        if (id.length() > 0) {
            sb.append('$');
            sb.append(id);
        }
        return sb.toString();
    }

    public static String md5(String message) {
        StringBuffer sb = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(message.getBytes());
            int i2 = 0;
            while (i2 < digest.length) {
                String s = Integer.toHexString(digest[i2] & 0xFF);
                if (s.length() < 2) {
                    sb.append('0');
                }
                sb.append(s);
                ++i2;
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static int utf8Length(CharSequence sequence) {
        int count = 0;
        int i2 = 0;
        int len = sequence.length();
        while (i2 < len) {
            char ch = sequence.charAt(i2);
            if (ch <= '\u007f') {
                ++count;
            } else if (ch <= '\u07ff') {
                count += 2;
            } else if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i2;
            } else {
                count += 3;
            }
            ++i2;
        }
        return count;
    }

    public static HttpResponse httpGet(URL url, String user2, String password) {
        try {
            String basicAuth = user2 != null && password != null ? "Basic " + util.encodeBase64String(String.valueOf(user2) + ":" + password) : null;
            URLConnection uc = url.openConnection();
            if (basicAuth != null) {
                uc.setRequestProperty("Authorization", basicAuth);
            }
            uc.setConnectTimeout(10000);
            uc.setReadTimeout(30000);
            int code = util.httpResponseCode(uc);
            if (code >= 200 && code < 300) {
                int c2;
                InputStream instream = uc.getInputStream();
                StringBuffer sb = new StringBuffer();
                int i2 = 0;
                while (i2 < 1000000 && (c2 = instream.read()) != -1) {
                    sb.append((char)c2);
                    ++i2;
                }
                instream.close();
                return new HttpResponse(code, sb.toString());
            }
            if (code == 401) {
                DigestParams authparams = util.httpDigestAuth(util.httpGetHeaderField(uc, "www-authenticate"), "GET", url.getFile(), user2, password);
                if ((authparams = util.httpDigestAuth(authparams)) != null) {
                    uc = url.openConnection();
                    uc.setRequestProperty("Authorization", authparams.authorization);
                    uc.setConnectTimeout(10000);
                    uc.setReadTimeout(30000);
                    code = util.httpResponseCode(uc);
                    if (code >= 200 && code < 300) {
                        int c3;
                        InputStream instream = uc.getInputStream();
                        StringBuffer sb = new StringBuffer();
                        int i3 = 0;
                        while (i3 < 1000000 && (c3 = instream.read()) != -1) {
                            sb.append((char)c3);
                            ++i3;
                        }
                        instream.close();
                        return new HttpResponse(code, sb.toString());
                    }
                    return new HttpResponse(code, null);
                }
                return new HttpResponse(code, null);
            }
            InputStream instream = uc.getInputStream();
            int i4 = 0;
            while (i4 < 1000000 && instream.read() != -1) {
                ++i4;
            }
            instream.close();
            return new HttpResponse(code, null);
        }
        catch (Exception e2) {
            return new HttpResponse(-1, null);
        }
    }

    public static int httpPost(URL url, String data, String user2, String password) {
        return util.httpPost(url, null, data.getBytes(UTF8_CHARSET), user2, password);
    }

    public static int httpPost(URL url, String contenttype, String data, String user2, String password) {
        return util.httpPost(url, contenttype, data.getBytes(UTF8_CHARSET), user2, password);
    }

    public static int httpPost(URL url, String contenttype, byte[] data, String user2, String password) {
        return util.httpPostRead((URL)url, (String)contenttype, (byte[])data, (String)user2, (String)password).code;
    }

    public static HttpResponse httpPostRead(URL url, String contenttype, String data, String user2, String password) {
        return util.httpPostRead(url, contenttype, data.getBytes(UTF8_CHARSET), user2, password);
    }

    public static HttpResponse httpPostRead(URL url, String contenttype, byte[] data, String user2, String password) {
        int code = -1;
        try {
            String basicAuth = user2 != null && password != null ? "Basic " + util.encodeBase64String(String.valueOf(user2) + ":" + password) : null;
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setConnectTimeout(10000);
            uc.setReadTimeout(30000);
            uc.setRequestMethod("POST");
            uc.setDoOutput(true);
            if (basicAuth != null) {
                uc.setRequestProperty("Authorization", basicAuth);
            }
            if (contenttype != null) {
                uc.setRequestProperty("Content-Type", contenttype);
            }
            uc.setRequestProperty("Content-Length", Integer.toString(data.length));
            OutputStream outstream = uc.getOutputStream();
            outstream.write(data);
            outstream.flush();
            code = util.httpResponseCode(uc);
            if (code >= 200 && code < 300) {
                int b2;
                InputStream instream = uc.getInputStream();
                StringBuffer sb = new StringBuffer();
                while ((b2 = instream.read()) != -1) {
                    sb.append((char)b2);
                }
                outstream.close();
                instream.close();
                if (sb.length() > 0) {
                    return new HttpResponse(code, sb.toString());
                }
                return new HttpResponse(code, null);
            }
            if (code == 401) {
                outstream.close();
                DigestParams authparams = util.httpDigestAuth(util.httpGetHeaderField(uc, "www-authenticate"), "POST", url.getFile(), user2, password);
                authparams = util.httpDigestAuth(authparams);
                if (authparams != null) {
                    uc = (HttpURLConnection)url.openConnection();
                    uc.setConnectTimeout(10000);
                    uc.setReadTimeout(30000);
                    uc.setRequestMethod("POST");
                    uc.setDoOutput(true);
                    uc.setRequestProperty("Authorization", authparams.authorization);
                    if (contenttype != null) {
                        uc.setRequestProperty("Content-Type", contenttype);
                    }
                    uc.setRequestProperty("Content-Length", Integer.toString(data.length));
                    outstream = uc.getOutputStream();
                    outstream.write(data);
                    outstream.flush();
                    code = util.httpResponseCode(uc);
                    if (code >= 200 && code < 300) {
                        int b3;
                        InputStream instream = uc.getInputStream();
                        StringBuffer sb = new StringBuffer();
                        while ((b3 = instream.read()) != -1) {
                            sb.append((char)b3);
                        }
                        outstream.close();
                        instream.close();
                        if (sb.length() > 0) {
                            return new HttpResponse(code, sb.toString());
                        }
                        return new HttpResponse(code, null);
                    }
                    return new HttpResponse(code, null);
                }
                return new HttpResponse(code, null);
            }
            InputStream instream = uc.getInputStream();
            int i2 = 0;
            while (i2 < 1000000 && instream.read() != -1) {
                ++i2;
            }
            outstream.close();
            instream.close();
            return new HttpResponse(code, null);
        }
        catch (Exception e2) {
            return new HttpResponse(code, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileLog(String pathname, String message) {
        try {
            Object object = fileLogMonitor;
            synchronized (object) {
                File filename = new File(root, pathname);
                if (!filename.getCanonicalPath().startsWith(root.getCanonicalPath())) {
                    hsyco.errorLog("fileLog - File pathname error: " + filename.getCanonicalPath());
                } else {
                    File path = filename.getParentFile();
                    if (!path.isDirectory()) {
                        path.mkdirs();
                        path.setWritable(true, false);
                    }
                    FileOutputStream fos = new FileOutputStream(filename, true);
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                    osw.write(message);
                    osw.write("\r\n");
                    osw.close();
                    fos.close();
                    filename.setWritable(true, false);
                }
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("fileLog - Exception: " + e2.getMessage());
        }
    }

    static int httpResponseCode(URLConnection uc) {
        try {
            String header = uc.getHeaderField(0);
            int bx = header.indexOf(32) + 1;
            int ex = header.indexOf(32, bx);
            return Integer.parseInt(header.substring(bx, ex));
        }
        catch (Exception e2) {
            return -1;
        }
    }

    static DigestParams httpDigestAuth(List<String> headers, String method, String uri, String user2, String password) {
        DigestParams params = new DigestParams();
        try {
            int h2 = 0;
            while (h2 < headers.size()) {
                String header = headers.get(h2);
                if (header.startsWith("Digest")) {
                    ArrayList<String> tokens = new ArrayList<String>();
                    StringBuilder sb = new StringBuilder();
                    boolean quoted = false;
                    int i2 = 6;
                    while (i2 < header.length()) {
                        char c2 = header.charAt(i2);
                        switch (c2) {
                            case ',': {
                                if (quoted) {
                                    sb.append(c2);
                                    break;
                                }
                                tokens.add(sb.toString());
                                sb = new StringBuilder();
                                break;
                            }
                            case '\"': {
                                quoted = !quoted;
                            }
                            default: {
                                sb.append(c2);
                            }
                        }
                        ++i2;
                    }
                    if (sb.length() > 0) {
                        tokens.add(sb.toString());
                    }
                    for (String token : tokens) {
                        int eqidx = token.indexOf(61);
                        if (eqidx <= 0) continue;
                        String name = token.substring(0, eqidx).trim();
                        String value = token.substring(eqidx + 1).trim();
                        if (value.startsWith("\"") && value.endsWith("\"")) {
                            value = value.substring(1, value.length() - 1);
                        }
                        if (name.equalsIgnoreCase("realm")) {
                            params.realm = value;
                            continue;
                        }
                        if (name.equalsIgnoreCase("qop")) {
                            params.qop = value;
                            continue;
                        }
                        if (name.equalsIgnoreCase("nonce")) {
                            params.nonce = value;
                            continue;
                        }
                        if (!name.equalsIgnoreCase("opaque")) continue;
                        params.opaque = value;
                    }
                    params.method = method.toUpperCase();
                    params.uri = new String(uri);
                    params.user = new String(user2);
                    params.password = new String(password);
                    params.counter = 0;
                    params.authorization = null;
                    return params;
                }
                ++h2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static DigestParams httpDigestAuth(DigestParams params) {
        StringBuffer sb;
        block12: {
            sb = new StringBuffer();
            if (params.qop != null) break block12;
            ++params.counter;
            try {
                String ha1 = util.md5(String.valueOf(params.user) + ":" + params.realm + ":" + params.password);
                String ha2 = util.md5(String.valueOf(params.method) + ":" + params.uri);
                String n2 = Integer.toHexString(params.counter);
                int i2 = n2.length();
                while (i2 < 8) {
                    sb.append('0');
                    ++i2;
                }
                sb.append(n2);
                String nc = sb.toString();
                String cnonce = util.md5(Long.toString(System.currentTimeMillis())).substring(0, 8);
                sb = new StringBuffer(ha1);
                sb.append(':');
                sb.append(params.nonce);
                sb.append(':');
                sb.append(ha2);
                String response = util.md5(sb.toString());
                sb = new StringBuffer("Digest username=\"");
                sb.append(params.user);
                sb.append("\", realm=\"");
                sb.append(params.realm);
                sb.append("\", nonce=\"");
                sb.append(params.nonce);
                sb.append("\", uri=\"");
                sb.append(params.uri);
                sb.append("\", response=\"");
                sb.append(response);
                if (params.opaque != null) {
                    sb.append("\", opaque=\"");
                    sb.append(params.opaque);
                }
                sb.append('\"');
                params.authorization = sb.toString();
                return params;
            }
            catch (Exception e2) {
                return null;
            }
        }
        try {
            if (params.qop.equals("auth")) {
                ++params.counter;
                try {
                    String ha1 = util.md5(String.valueOf(params.user) + ":" + params.realm + ":" + params.password);
                    String ha2 = util.md5(String.valueOf(params.method) + ":" + params.uri);
                    String n3 = Integer.toHexString(params.counter);
                    int i3 = n3.length();
                    while (i3 < 8) {
                        sb.append('0');
                        ++i3;
                    }
                    sb.append(n3);
                    String nc = sb.toString();
                    String cnonce = util.md5(Long.toString(System.currentTimeMillis())).substring(0, 8);
                    sb = new StringBuffer(ha1);
                    sb.append(':');
                    sb.append(params.nonce);
                    sb.append(':');
                    sb.append(nc);
                    sb.append(':');
                    sb.append(cnonce);
                    sb.append(":auth:");
                    sb.append(ha2);
                    String response = util.md5(sb.toString());
                    sb = new StringBuffer("Digest username=\"");
                    sb.append(params.user);
                    sb.append("\", realm=\"");
                    sb.append(params.realm);
                    sb.append("\", nonce=\"");
                    sb.append(params.nonce);
                    sb.append("\", uri=\"");
                    sb.append(params.uri);
                    sb.append("\", response=\"");
                    sb.append(response);
                    sb.append("\", qop=auth, nc=");
                    sb.append(nc);
                    sb.append(", cnonce=\"");
                    sb.append(cnonce);
                    if (params.opaque != null) {
                        sb.append("\", opaque=\"");
                        sb.append(params.opaque);
                    }
                    sb.append('\"');
                    params.authorization = sb.toString();
                    return params;
                }
                catch (Exception e3) {
                    return null;
                }
            }
            return null;
        }
        catch (Exception e4) {
            return null;
        }
    }

    static List<String> httpGetHeaderField(URLConnection connection, String key) {
        boolean end = false;
        ArrayList<String> result = new ArrayList<String>();
        try {
            int i2 = 0;
            while (!end && i2 < 1024) {
                String k2 = connection.getHeaderFieldKey(i2);
                if (k2 == null) {
                    if (i2 > 0) {
                        end = true;
                    }
                } else if (k2.equalsIgnoreCase(key)) {
                    result.add(connection.getHeaderField(i2));
                }
                ++i2;
            }
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String readParamString(String data, String param) {
        int state = 0;
        StringBuffer namebuffer = new StringBuffer();
        StringBuffer valuebuffer = new StringBuffer();
        String name = null;
        String value = null;
        try {
            int i2 = 0;
            while (i2 < data.length()) {
                char ch = data.charAt(i2);
                switch (state) {
                    case 0: {
                        if (!Character.isLetterOrDigit(ch)) break;
                        state = 1;
                        namebuffer.append(ch);
                        break;
                    }
                    case 1: {
                        if (Character.isLetterOrDigit(ch)) {
                            namebuffer.append(ch);
                            break;
                        }
                        name = namebuffer.toString();
                        namebuffer = new StringBuffer();
                        state = ch == '=' ? 3 : 2;
                        break;
                    }
                    case 2: {
                        if (ch != '=') break;
                        state = 3;
                        break;
                    }
                    case 3: {
                        if (ch == '\"') {
                            state = 4;
                            break;
                        }
                        if (!Character.isLetterOrDigit(ch)) break;
                        valuebuffer.append(ch);
                        state = 5;
                        break;
                    }
                    case 4: {
                        if (ch != '\"') {
                            valuebuffer.append(ch);
                            break;
                        }
                        value = valuebuffer.toString();
                        if (name.equals(param)) {
                            return value;
                        }
                        valuebuffer = new StringBuffer();
                        state = 0;
                        break;
                    }
                    case 5: {
                        if (!Character.isWhitespace(ch)) {
                            valuebuffer.append(ch);
                            break;
                        }
                        value = valuebuffer.toString();
                        if (name.equals(param)) {
                            return value;
                        }
                        valuebuffer = new StringBuffer();
                        state = 0;
                    }
                }
                ++i2;
            }
            if (namebuffer.length() > 0 && valuebuffer.length() > 0 && state == 5) {
                value = valuebuffer.toString();
                if (name.equals(param)) {
                    return value;
                }
                return null;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static byte[] encodeInteger(BigInteger number, int size) {
        try {
            byte[] bv = number.toByteArray();
            byte[] b2 = new byte[size];
            int i2 = 0;
            while (i2 < b2.length) {
                if (bv.length - 1 >= i2) {
                    b2[b2.length - 1 - i2] = bv[bv.length - 1 - i2];
                } else if (number.signum() == -1) {
                    b2[b2.length - 1 - i2] = -1;
                }
                ++i2;
            }
            return b2;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static byte[] encodeInteger(long number, int size) {
        return util.encodeInteger(BigInteger.valueOf(number), size);
    }

    static byte[] encodeInteger(String number, int size) {
        return util.encodeInteger(new BigInteger(number), size);
    }

    static BigInteger decodeInteger(byte[] data, boolean signed) {
        try {
            if (signed) {
                return new BigInteger(data);
            }
            return new BigInteger(1, data);
        }
        catch (Exception e2) {
            return null;
        }
    }

    static byte[] encodeFloat(Float number) {
        byte[] b2 = new byte[4];
        try {
            int i2 = Float.floatToIntBits(number.floatValue());
            b2[0] = (byte)(i2 >> 24);
            b2[1] = (byte)(i2 >> 16);
            b2[2] = (byte)(i2 >> 8);
            b2[3] = (byte)i2;
            return b2;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static byte[] encodeFloat(String number) {
        return util.encodeFloat(Float.valueOf(Float.parseFloat(number)));
    }

    static Float decodeFloat(byte[] data) {
        try {
            return Float.valueOf(Float.intBitsToFloat((data[3] & 0xFF) + ((data[2] & 0xFF) << 8) + ((data[1] & 0xFF) << 16) + ((data[0] & 0xFF) << 24)));
        }
        catch (Exception e2) {
            return null;
        }
    }

    static Double decodeDouble(byte[] data) {
        try {
            return Double.longBitsToDouble((data[7] & 0xFF) + ((data[6] & 0xFF) << 8) + ((data[5] & 0xFF) << 16) + ((data[4] & 0xFF) << 24) + ((data[3] & 0xFF) << 32) + ((data[2] & 0xFF) << 40) + ((data[1] & 0xFF) << 48) + ((data[0] & 0xFF) << 56));
        }
        catch (Exception e2) {
            return null;
        }
    }

    static String decodeHex(byte[] data) {
        StringBuffer sb = new StringBuffer();
        try {
            int i2 = 0;
            while (i2 < data.length) {
                String b2 = Integer.toHexString(data[i2] & 0xFF).toUpperCase();
                if (b2.length() == 1) {
                    sb.append('0');
                }
                sb.append(b2);
                ++i2;
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    static byte encodeBCD(int data) {
        return (byte)(data / 10 << 4 | data % 10);
    }

    static int decodeBCD(byte data) {
        return ((data & 0xF0) >> 4) * 10 + (data & 0xF);
    }

    static String DecimalFormat(String locale, String pattern, String number) {
        try {
            DecimalFormat df = locale != null && locale.length() > 0 ? (DecimalFormat)NumberFormat.getInstance(new Locale(locale)) : new DecimalFormat();
            df.applyLocalizedPattern(pattern);
            return df.format(Double.parseDouble(number));
        }
        catch (Exception e2) {
            return number;
        }
    }

    static String encodeBase64String(String data) throws Exception {
        String s = Base64.encodeBase64String(data.getBytes());
        int i2 = s.lastIndexOf(13);
        return i2 != -1 ? s.substring(0, i2) : s;
    }

    static String encodeBase64String(byte[] data) throws Exception {
        String s = Base64.encodeBase64String(data);
        int i2 = s.lastIndexOf(13);
        return i2 != -1 ? s.substring(0, i2) : s;
    }

    static Properties splitQuery(String query) throws UnsupportedEncodingException {
        String[] pairs;
        Properties map = new Properties();
        String[] stringArray = pairs = query != null ? query.split("&") : new String[]{};
        int n2 = pairs.length;
        int n3 = 0;
        while (n3 < n2) {
            String value;
            String pair = stringArray[n3];
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            String string = value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : "";
            if (!key.equals("")) {
                map.put(key, value);
            }
            ++n3;
        }
        return map;
    }

    static String propertiesToJson(Properties p) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        try {
            sb.append("{");
            Enumeration<Object> e2 = p.keys();
            while (e2.hasMoreElements()) {
                String k2 = (String)e2.nextElement();
                String v = p.getProperty(k2);
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(JSONObject.quote(k2));
                sb.append(":");
                sb.append(JSONObject.quote(v));
            }
            sb.append("}");
            return sb.toString();
        }
        catch (Exception e3) {
            return null;
        }
    }

    protected static void safePropertiesStore(Properties p, String filename) throws Exception {
        File destFile = new File(filename);
        File tempFile = new File(String.valueOf(isWindows ? "_" : ".~") + filename);
        FileOutputStream fos = new FileOutputStream(tempFile);
        p.store(fos, "Generated by HSYCO 3.8.0 BETA Build 0134 DEV 92");
        fos.flush();
        fos.close();
        if (isWindows) {
            destFile.delete();
        }
        tempFile.renameTo(destFile);
        destFile.setWritable(true, false);
    }

    protected static String trimComments(String line) {
        String tline = line.trim();
        StringBuffer sb = new StringBuffer();
        int state = 0;
        boolean trim = false;
        int i2 = 0;
        while (i2 < tline.length() && !trim) {
            char c2 = tline.charAt(i2);
            switch (c2) {
                case '\"': {
                    sb.append(c2);
                    state = state == 0 ? 2 : 0;
                    break;
                }
                case '#': {
                    if (state == 2) {
                        sb.append(c2);
                        break;
                    }
                    trim = true;
                    break;
                }
                default: {
                    sb.append(c2);
                }
            }
            ++i2;
        }
        return sb.toString().trim();
    }

    public static Set<String> ioListAll() {
        return SystemState.ioListAll();
    }

    public static Set<String> ioListByServerName(String name) {
        return SystemState.ioListByServerName(name);
    }

    public static Set<String> ioListByServerType(String type) {
        return SystemState.ioListByServerType(type);
    }

    public static Set<String> varListByNamePrefix(String prefix, boolean persistent) {
        return SystemState.varListByNamePrefix(prefix, persistent);
    }

    public static void haFilesChangeNotify() {
        SystemState.haFilesChangeNotify();
    }

    public static File getCameraTempFile(String text) {
        try {
            CameraFrame frame;
            text = text.substring(4);
            int s = text.indexOf(58);
            int f2 = text.indexOf(35);
            if (s == -1 && f2 == -1) {
                frame = SystemState.cameraGet(Configuration.getCameraIndex(text), 0, 0);
            } else if (s == -1) {
                frame = SystemState.cameraRecGet(Configuration.getCameraIndex(text.substring(0, f2)), Integer.parseInt(text.substring(f2 + 1)), 0, 0);
            } else {
                int cam = Configuration.getCameraIndex(text.substring(0, s));
                int o2 = text.substring(s + 1).indexOf(58);
                if (o2 == -1) {
                    int sec = Integer.parseInt(text.substring(s + 1));
                    frame = SystemState.cameraRecGet(cam, SystemState.cameraRecGetIndex(cam, sec), 0, 0);
                } else {
                    int sec = Integer.parseInt(text.substring(s + 1, s + 1 + o2));
                    int offset = Integer.parseInt(text.substring(s + 2 + o2));
                    long baseindex = SystemState.cameraRecGetIndex(cam, sec);
                    frame = SystemState.cameraRecGet(cam, baseindex - (long)offset, 0, 0);
                }
            }
            if (frame != null) {
                File tf = File.createTempFile("hsyco_", frame.mimetype.endsWith("/png") ? ".png" : ".jpg");
                tf.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(tf);
                fos.write(frame.data);
                fos.close();
                return tf;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static double geoDistance(double lat1, double lon1, double lat2, double lon2) {
        double lat1r = Math.toRadians(lat1);
        double lat2r = Math.toRadians(lat2);
        double latdeltar = Math.toRadians(lat2 - lat1);
        double londeltar = Math.toRadians(lon2 - lon1);
        double a2 = Math.sin(latdeltar / 2.0) * Math.sin(latdeltar / 2.0) + Math.cos(lat1r) * Math.cos(lat2r) * Math.sin(londeltar / 2.0) * Math.sin(londeltar / 2.0);
        double c2 = 2.0 * Math.atan2(Math.sqrt(a2), Math.sqrt(1.0 - a2));
        return 6371000.0 * c2;
    }

    public static double geoBearing(double lat1, double lon1, double lat2, double lon2) {
        double x;
        double lat1r = Math.toRadians(lat1);
        double lat2r = Math.toRadians(lat2);
        double lon1r = Math.toRadians(lon1);
        double lon2r = Math.toRadians(lon2);
        double y = Math.sin(lon2r - lon1r) * Math.cos(lat2r);
        double deg = Math.toDegrees(Math.atan2(y, x = Math.cos(lat1r) * Math.sin(lat2r) - Math.sin(lat1r) * Math.cos(lat2r) * Math.cos(lon2r - lon1r)));
        return deg < 0.0 ? deg + 360.0 : deg;
    }
}

