/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco.suntimes;

import com.hsyco.suntimes.SunTimesException;
import com.hsyco.suntimes.Time;

public class SunTimes {
    public static final double ZENITH = 90.83333333333333;
    public static final double CIVIL_ZENITH = 96.0;
    public static final double NAUTICAL_ZENITH = 102.0;
    public static final double ASTRONOMICAL_ZENITH = 108.0;
    private static final int TYPE_SUNRISE = 0;
    private static final int TYPE_SUNSET = 1;
    private static final double DEG_PER_HOUR = 15.0;

    private static double sinDeg(double deg) {
        return Math.sin(deg * 2.0 * Math.PI / 360.0);
    }

    private static double acosDeg(double x) {
        return Math.acos(x) * 360.0 / (Math.PI * 2);
    }

    private static double asinDeg(double x) {
        return Math.asin(x) * 360.0 / (Math.PI * 2);
    }

    private static double tanDeg(double deg) {
        return Math.tan(deg * 2.0 * Math.PI / 360.0);
    }

    private static double cosDeg(double deg) {
        return Math.cos(deg * 2.0 * Math.PI / 360.0);
    }

    private static int getDayOfYear(int year, int month, int day) {
        int N1 = 275 * month / 9;
        int N2 = (month + 9) / 12;
        int N3 = 1 + (year - 4 * (year / 4) + 2) / 3;
        int N = N1 - N2 * N3 + day - 30;
        return N;
    }

    private static double getHoursFromMeridian(double longitude) {
        return longitude / 15.0;
    }

    private static double getApproxTimeDays(int dayOfYear, double hoursFromMeridian, int type) {
        if (type == 0) {
            return (double)dayOfYear + (6.0 - hoursFromMeridian) / 24.0;
        }
        return (double)dayOfYear + (18.0 - hoursFromMeridian) / 24.0;
    }

    private static double getMeanAnomaly(int dayOfYear, double longitude, int type) {
        return 0.9856 * SunTimes.getApproxTimeDays(dayOfYear, SunTimes.getHoursFromMeridian(longitude), type) - 3.289;
    }

    private static double getSunTrueLongitude(double sunMeanAnomaly) {
        double l2 = sunMeanAnomaly + 1.916 * SunTimes.sinDeg(sunMeanAnomaly) + 0.02 * SunTimes.sinDeg(2.0 * sunMeanAnomaly) + 282.634;
        if (l2 >= 360.0) {
            l2 -= 360.0;
        }
        if (l2 < 0.0) {
            l2 += 360.0;
        }
        return l2;
    }

    private static double getSunRightAscensionHours(double sunTrueLongitude) {
        double a2 = 0.91764 * SunTimes.tanDeg(sunTrueLongitude);
        double ra = 57.29577951308232 * Math.atan(a2);
        double lQuadrant = Math.floor(sunTrueLongitude / 90.0) * 90.0;
        double raQuadrant = Math.floor(ra / 90.0) * 90.0;
        return (ra += lQuadrant - raQuadrant) / 15.0;
    }

    private static double getCosLocalHourAngle(double sunTrueLongitude, double latitude, double zenith) {
        double sinDec = 0.39782 * SunTimes.sinDeg(sunTrueLongitude);
        double cosDec = SunTimes.cosDeg(SunTimes.asinDeg(sinDec));
        double cosH = (SunTimes.cosDeg(zenith) - sinDec * SunTimes.sinDeg(latitude)) / (cosDec * SunTimes.cosDeg(latitude));
        return cosH;
    }

    private static double getLocalMeanTime(double localHour, double sunRightAscensionHours, double approxTimeDays) {
        return localHour + sunRightAscensionHours - 0.06571 * approxTimeDays - 6.622;
    }

    private static Time getTimeUTC(int year, int month, int day, double longitude, double latitude, double zenith, int type) throws SunTimesException {
        double localHourAngle;
        int dayOfYear = SunTimes.getDayOfYear(year, month, day);
        double sunMeanAnomaly = SunTimes.getMeanAnomaly(dayOfYear, longitude, type);
        double sunTrueLong = SunTimes.getSunTrueLongitude(sunMeanAnomaly);
        double sunRightAscensionHours = SunTimes.getSunRightAscensionHours(sunTrueLong);
        double cosLocalHourAngle = SunTimes.getCosLocalHourAngle(sunTrueLong, latitude, zenith);
        if (type == 0) {
            if (cosLocalHourAngle > 1.0) {
                throw new SunTimesException("Sun never rises on the specified date at the specified location");
            }
            localHourAngle = 360.0 - SunTimes.acosDeg(cosLocalHourAngle);
        } else if (type == 1) {
            if (cosLocalHourAngle < -1.0) {
                throw new SunTimesException("Sun never sets on the specified date at the specified location");
            }
            localHourAngle = SunTimes.acosDeg(cosLocalHourAngle);
        } else {
            throw new SunTimesException("Internal error");
        }
        double localHour = localHourAngle / 15.0;
        double localMeanTime = SunTimes.getLocalMeanTime(localHour, sunRightAscensionHours, SunTimes.getApproxTimeDays(dayOfYear, SunTimes.getHoursFromMeridian(longitude), type));
        return new Time(localMeanTime - SunTimes.getHoursFromMeridian(longitude));
    }

    public static Time getSunriseTimeUTC(int year, int month, int day, double longitude, double latitude, double zenith) throws SunTimesException {
        return SunTimes.getTimeUTC(year, month, day, longitude, latitude, zenith, 0);
    }

    public static Time getSunsetTimeUTC(int year, int month, int day, double longitude, double latitude, double zenith) throws SunTimesException {
        return SunTimes.getTimeUTC(year, month, day, longitude, latitude, zenith, 1);
    }
}

