/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.DigestParams;
import com.hsyco.FP2000;
import com.hsyco.KnxBaos;
import com.hsyco.MyHome;
import com.hsyco.Nuvo;
import com.hsyco.RIO;
import com.hsyco.SystemState;
import com.hsyco.SystemStatus;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

class ioCommandDispatcher
extends Thread {
    public long heartbeat = 0L;
    public boolean quit;
    private boolean initialized;
    private int ioIndex;
    private Socket sock;
    private OutputStream out;
    private final byte[] readInCommand;
    private final byte[] readOutCommand;
    private byte[] writeOutCommand;
    private final String HIDEDGE_XML_COMMANDGRANTACCESS = "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22CM%22%20command%3D%22grantAccess%22%2F%3E%0A%3C%2FVertXMessage%3E";
    private final String HIDEDGE_XML_COMMANDUNLOCKDOOR = "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22CM%22%20command%3D%22unlockDoor%22%2F%3E%0A%3C%2FVertXMessage%3E";
    private final String HIDEDGE_XML_COMMANDLOCKDOOR = "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22CM%22%20command%3D%22lockDoor%22%2F%3E%0A%3C%2FVertXMessage%3E";
    private final String HIDEDGE_XML_COMMANDSTOPALARM = "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3AControlVariables%20action%3D%22CM%22%20index%3D%22101%22%20value%3D%22false%22%2F%3E%0A%3C%2FVertXMessage%3E";

    public ioCommandDispatcher(int ioIndex) {
        byte[] byArray = new byte[7];
        byArray[0] = -1;
        byArray[1] = -6;
        byArray[2] = 44;
        byArray[3] = 50;
        byArray[5] = -1;
        byArray[6] = -16;
        this.readInCommand = byArray;
        this.readOutCommand = new byte[]{-1, -6, 44, 50, 48, -1, -16};
        byte[] byArray2 = new byte[7];
        byArray2[0] = -1;
        byArray2[1] = -6;
        byArray2[2] = 44;
        byArray2[3] = 51;
        byArray2[5] = -1;
        byArray2[6] = -16;
        this.writeOutCommand = byArray2;
        this.HIDEDGE_XML_COMMANDGRANTACCESS = "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22CM%22%20command%3D%22grantAccess%22%2F%3E%0A%3C%2FVertXMessage%3E";
        this.HIDEDGE_XML_COMMANDUNLOCKDOOR = "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22CM%22%20command%3D%22unlockDoor%22%2F%3E%0A%3C%2FVertXMessage%3E";
        this.HIDEDGE_XML_COMMANDLOCKDOOR = "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22CM%22%20command%3D%22lockDoor%22%2F%3E%0A%3C%2FVertXMessage%3E";
        this.HIDEDGE_XML_COMMANDSTOPALARM = "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3AControlVariables%20action%3D%22CM%22%20index%3D%22101%22%20value%3D%22false%22%2F%3E%0A%3C%2FVertXMessage%3E";
        this.ioIndex = ioIndex;
        this.initialized = SystemState.ioServersInitializedGet(ioIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int type = Configuration.ioServersType.elementAt(this.ioIndex);
        if (type == 1) {
            String itemnameprefix = String.valueOf(Configuration.ioServersName.elementAt(this.ioIndex)) + ".o";
            try {
                this.sock = SystemState.ioServersSocket[this.ioIndex];
                this.out = this.sock.getOutputStream();
                this.quit = false;
            }
            catch (Exception e2) {
                hsyco.errorLog("ioCommandDispatcher - Generic exception [" + this.ioIndex + "] - " + e2.getLocalizedMessage());
                this.quit = true;
            }
            hsyco.messageLog("ioCommandDispatcher [" + this.ioIndex + "] started");
            while (!this.quit) {
                try {
                    Socket i22;
                    if (SystemState.ioDispatchWait(this.ioIndex, this.initialized ? 10000 : 100)) {
                        Socket e2 = this.sock;
                        synchronized (e2) {
                            this.out.write(this.readInCommand);
                            this.out.flush();
                        }
                    }
                    if (this.initialized) {
                        byte b2 = 0;
                        try {
                            int i22 = 7;
                            while (i22 >= 0) {
                                int value = Integer.parseInt(SystemState.ioDispatchGet(String.valueOf(itemnameprefix) + (i22 + 1)));
                                b2 = (byte)(b2 << 1);
                                b2 = (byte)(b2 | (byte)(value != 0 ? 1 : 0));
                                --i22;
                            }
                            this.writeOutCommand[4] = b2;
                            i22 = this.sock;
                            synchronized (i22) {
                                this.out.write(this.writeOutCommand);
                                this.out.flush();
                            }
                        }
                        catch (Exception i22) {}
                    } else {
                        i22 = this.sock;
                        synchronized (i22) {
                            this.out.write(this.readOutCommand);
                            this.out.flush();
                        }
                        this.initialized = SystemState.ioServersInitializedGet(this.ioIndex);
                    }
                    this.heartbeat = System.currentTimeMillis();
                }
                catch (Exception e3) {
                    hsyco.errorLog("ioCommandDispatcher - Generic exception [" + this.ioIndex + "] - " + e3.getLocalizedMessage());
                    this.quit = true;
                }
            }
        } else if (type == 2) {
            String servername = Configuration.ioServersName.elementAt(this.ioIndex);
            ArrayBlockingQueue<String> ioqtx = Configuration.ioQueueTx.elementAt(this.ioIndex);
            InetSocketAddress ioInetAddress = Configuration.ioServersTCPAddress.elementAt(this.ioIndex);
            URL commandUrl = null;
            try {
                commandUrl = new URL("HTTP", ioInetAddress.getHostName(), ioInetAddress.getPort(), "/setup.xml");
            }
            catch (Exception e4) {
                this.quit = true;
            }
            hsyco.messageLog("ioCommandDispatcher [" + this.ioIndex + "] started");
            while (!this.quit) {
                try {
                    String item = ioqtx.poll(10L, TimeUnit.SECONDS);
                    if (item != null) {
                        int equalidx = item.indexOf(61);
                        String name = item.substring(0, equalidx);
                        String value = item.substring(equalidx + 1);
                        if ("read".equalsIgnoreCase(name) && "all".equalsIgnoreCase(value)) {
                            Socket sock = new Socket();
                            sock.connect(ioInetAddress, 6000);
                            ioMonitor.hwgGetValuesXml(sock, servername);
                        } else {
                            String id = SystemState.HwgMonitorNameIdMap.get((String.valueOf(servername) + "." + name).toLowerCase());
                            if (id != null) {
                                name = id;
                            }
                            URLConnection uc = commandUrl.openConnection();
                            uc.setDoOutput(true);
                            uc.setConnectTimeout(6000);
                            uc.setReadTimeout(6000);
                            OutputStreamWriter w = new OutputStreamWriter(uc.getOutputStream());
                            StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                            sb.append('\n');
                            sb.append("<Root><BinaryOutSet><Entry><ID>");
                            sb.append(name);
                            sb.append("</ID><Value>");
                            sb.append(value);
                            sb.append("</Value></Entry></BinaryOutSet></Root>");
                            w.write(sb.toString());
                            w.flush();
                            BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                            while (in.readLine() != null) {
                            }
                            w.close();
                            in.close();
                        }
                    }
                    this.heartbeat = System.currentTimeMillis();
                }
                catch (Exception e5) {
                    hsyco.errorLog("ioCommandDispatcher - Generic exception [" + this.ioIndex + "] - " + e5.getLocalizedMessage());
                    this.quit = true;
                }
            }
        } else if (type == 4) {
            ArrayBlockingQueue<String> ioqtx = Configuration.ioQueueTx.elementAt(this.ioIndex);
            InetSocketAddress ioInetAddress = Configuration.ioServersTCPAddress.elementAt(this.ioIndex);
            String user2 = null;
            String password = null;
            DigestParams authparams = null;
            String uri = null;
            try {
                user2 = Configuration.ioServersUser.elementAt(this.ioIndex);
                password = Configuration.ioServersPassword.elementAt(this.ioIndex);
            }
            catch (Exception e6) {
                this.quit = true;
            }
            hsyco.messageLog("ioCommandDispatcher [" + this.ioIndex + "] started");
            while (!this.quit) {
                try {
                    block92: {
                        String item = ioqtx.poll(10L, TimeUnit.SECONDS);
                        if (item != null) {
                            try {
                                int pointidx = item.indexOf(46);
                                int equalidx = item.indexOf(61, pointidx);
                                String tagid = item.substring(0, pointidx);
                                String command = item.substring(pointidx + 1, equalidx);
                                String param = item.substring(equalidx + 1);
                                if (command.equalsIgnoreCase("buzzer")) {
                                    uri = "/epe/cfg/tagcommandadd?tagid=" + URLEncoder.encode(tagid, "UTF-8") + "&cmd=mmt%201";
                                    break block92;
                                }
                                if (command.equalsIgnoreCase("message")) {
                                    uri = "/epe/msg/tagsendmsg?tagid=" + URLEncoder.encode(tagid, "UTF-8") + "&message=" + URLEncoder.encode(param, "UTF-8");
                                    break block92;
                                }
                                if (command.equalsIgnoreCase("instantmessage")) {
                                    uri = "/epe/msg/tagsendmsg?tagid=" + URLEncoder.encode(tagid, "UTF-8") + "&messagetype=instant&message=" + URLEncoder.encode(param, "UTF-8");
                                    break block92;
                                }
                                uri = null;
                            }
                            catch (Exception pointidx) {}
                        }
                    }
                    while (uri != null) {
                        Socket ioSocket;
                        block93: {
                            String line;
                            ioSocket = new Socket();
                            ioSocket.connect(ioInetAddress, 6000);
                            ioSocket.setSoTimeout(6000);
                            SystemState.ioServersSocket[this.ioIndex] = ioSocket;
                            BufferedReader in = new BufferedReader(new InputStreamReader(ioSocket.getInputStream()));
                            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(ioSocket.getOutputStream()));
                            out.write("GET " + uri + " HTTP/1.1\r\n");
                            out.write("Host: ");
                            out.write(ioInetAddress.getHostName());
                            out.write(58);
                            out.write(Integer.toString(ioInetAddress.getPort()));
                            out.write("\r\n");
                            if (authparams != null && (authparams = util.httpDigestAuth(authparams)) != null) {
                                out.write("Authorization: ");
                                out.write(authparams.authorization);
                                out.write("\r\n");
                            }
                            out.write("Connection: close\r\n\r\n");
                            out.flush();
                            do {
                                if ((line = in.readLine()) != null) continue;
                                uri = null;
                                break block93;
                            } while (!line.toLowerCase().startsWith("www-authenticate: digest"));
                            authparams = util.httpDigestAuth(Arrays.asList(line.substring(18)), "GET", uri, user2, password);
                        }
                        ioSocket.close();
                    }
                    this.heartbeat = System.currentTimeMillis();
                }
                catch (Exception e7) {
                    hsyco.errorLog("ioCommandDispatcher - Generic exception [" + this.ioIndex + "] - " + e7.getLocalizedMessage());
                    this.quit = true;
                }
            }
        } else if (type > 5000 && type < 6000) {
            int outqty = type % 10;
            String servername = Configuration.ioServersName.elementAt(this.ioIndex);
            String itemnameprefix = String.valueOf(servername) + ".o";
            String urlfileprefix = null;
            URL commandUrl = null;
            String user3 = Configuration.ioServersUser.elementAt(this.ioIndex);
            String password = Configuration.ioServersPassword.elementAt(this.ioIndex);
            String host = Configuration.ioServersTCPAddress.elementAt(this.ioIndex).getHostName();
            int port = Configuration.ioServersTCPAddress.elementAt(this.ioIndex).getPort();
            switch (type % 100 / 10) {
                case 1: {
                    urlfileprefix = "/cgi-bin/io?submenu=output&action=";
                    break;
                }
                case 2: {
                    urlfileprefix = "/cgi-bin/control.cgi?msubmenu=output&action=";
                }
            }
            hsyco.messageLog("ioCommandDispatcher [" + this.ioIndex + "] started");
            while (!this.quit) {
                try {
                    SystemState.ioDispatchWait(this.ioIndex, 10000);
                    int i2 = 1;
                    while (i2 <= outqty) {
                        String itemname = String.valueOf(itemnameprefix) + i2;
                        String curstate = SystemState.ioGet(itemname);
                        String newstate = SystemState.ioDispatchGet(itemname);
                        if (newstate != null && !newstate.equals(curstate)) {
                            if (newstate.equals("0")) {
                                commandUrl = new URL("http", host, port, String.valueOf(urlfileprefix) + i2 + ":L");
                            } else {
                                commandUrl = new URL("http", host, port, String.valueOf(urlfileprefix) + i2 + ":H");
                                newstate = "1";
                            }
                            if (util.httpGet((URL)commandUrl, (String)user3, (String)password).code == 200) {
                                SystemState.ioWrite(itemname, newstate);
                            }
                        }
                        ++i2;
                    }
                    this.heartbeat = System.currentTimeMillis();
                }
                catch (Exception e8) {
                    hsyco.errorLog("ioCommandDispatcher - Generic exception [" + this.ioIndex + "] - " + e8.getLocalizedMessage());
                    this.quit = true;
                }
            }
        } else if (type == 7) {
            String protocol;
            int port;
            String host;
            String password;
            String user4;
            ArrayBlockingQueue<String> ioqtx = Configuration.ioQueueTx.elementAt(this.ioIndex);
            try {
                user4 = Configuration.ioServersUser.elementAt(this.ioIndex);
                password = Configuration.ioServersPassword.elementAt(this.ioIndex);
                host = Configuration.ioServersTCPAddress.elementAt(this.ioIndex).getHostName();
                port = Configuration.ioServersTCPAddress.elementAt(this.ioIndex).getPort();
                protocol = port == 443 ? "https" : "http";
            }
            catch (Exception e9) {
                hsyco.errorLog("ioMonitor - Initialization exception [" + this.ioIndex + "] - " + e9.getLocalizedMessage());
                return;
            }
            hsyco.messageLog("ioCommandDispatcher [" + this.ioIndex + "] started");
            while (!this.quit) {
                try {
                    String item = ioqtx.poll(10L, TimeUnit.SECONDS);
                    if (item == null) continue;
                    int equalidx = item.indexOf(61);
                    String name = item.substring(0, equalidx);
                    String value = item.substring(equalidx + 1);
                    URL commandUrl = null;
                    if ("command.access".equalsIgnoreCase(name)) {
                        if ("grant".equalsIgnoreCase(value)) {
                            commandUrl = new URL(protocol, host, port, "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22CM%22%20command%3D%22grantAccess%22%2F%3E%0A%3C%2FVertXMessage%3E");
                        }
                    } else if ("command.door".equalsIgnoreCase(name)) {
                        if ("lock".equalsIgnoreCase(value)) {
                            commandUrl = new URL(protocol, host, port, "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22CM%22%20command%3D%22lockDoor%22%2F%3E%0A%3C%2FVertXMessage%3E");
                        } else if ("unlock".equalsIgnoreCase(value)) {
                            commandUrl = new URL(protocol, host, port, "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22CM%22%20command%3D%22unlockDoor%22%2F%3E%0A%3C%2FVertXMessage%3E");
                        }
                    } else if ("command.alarm".equalsIgnoreCase(name) && "stop".equalsIgnoreCase(value)) {
                        commandUrl = new URL(protocol, host, port, "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3AControlVariables%20action%3D%22CM%22%20index%3D%22101%22%20value%3D%22false%22%2F%3E%0A%3C%2FVertXMessage%3E");
                    }
                    if (util.httpGet(commandUrl, (String)user4, (String)password).code != 200) continue;
                    SystemState.ioWrite(name, value);
                }
                catch (Exception e10) {
                    hsyco.errorLog("ioCommandDispatcher - Generic exception [" + this.ioIndex + "] - " + e10.getLocalizedMessage());
                    this.quit = true;
                }
            }
        } else if (type == 10) {
            Nuvo driver = new Nuvo();
            driver.commandDispatcher(this.ioIndex, this);
        } else if (type == 18) {
            KnxBaos driver = new KnxBaos();
            driver.commandDispatcher(this.ioIndex, this);
        } else if (type == 9) {
            MyHome driver = new MyHome();
            driver.commandDispatcher(this.ioIndex, this);
        } else if (type == 32) {
            FP2000 driver = new FP2000();
            SystemState.ioServersCommandDispatcherThreadSet(this.ioIndex, driver);
            driver.commandDispatcher(this.ioIndex, this);
            SystemState.ioServersCommandDispatcherThreadSet(this.ioIndex, null);
        } else if (type == 31) {
            RIO driver = new RIO();
            driver.commandDispatcher(this.ioIndex, this);
        } else if (type == 38) {
            SystemStatus driver = new SystemStatus();
            driver.commandDispatcher(this.ioIndex, this);
        }
    }
}

