/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import java.io.BufferedOutputStream;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

class ioCommWriter
extends Thread {
    public long heartbeat = 0L;
    public boolean quit;
    private int ioIndex;
    private Socket sock;
    private BufferedOutputStream out;
    private ArrayBlockingQueue<byte[]> commQueueTx = null;
    private final byte[] baudCommand;
    private final byte[] datasizeCommand;
    private final byte[] parityCommand;
    private final byte[] stopsizeCommand;
    private final byte[] controlCommand;

    public ioCommWriter(int ioIndex) {
        byte[] byArray = new byte[10];
        byArray[0] = -1;
        byArray[1] = -6;
        byArray[2] = 44;
        byArray[3] = 1;
        byArray[8] = -1;
        byArray[9] = -16;
        this.baudCommand = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[0] = -1;
        byArray2[1] = -6;
        byArray2[2] = 44;
        byArray2[3] = 2;
        byArray2[5] = -1;
        byArray2[6] = -16;
        this.datasizeCommand = byArray2;
        byte[] byArray3 = new byte[7];
        byArray3[0] = -1;
        byArray3[1] = -6;
        byArray3[2] = 44;
        byArray3[3] = 3;
        byArray3[5] = -1;
        byArray3[6] = -16;
        this.parityCommand = byArray3;
        byte[] byArray4 = new byte[7];
        byArray4[0] = -1;
        byArray4[1] = -6;
        byArray4[2] = 44;
        byArray4[3] = 4;
        byArray4[5] = -1;
        byArray4[6] = -16;
        this.stopsizeCommand = byArray4;
        byte[] byArray5 = new byte[7];
        byArray5[0] = -1;
        byArray5[1] = -6;
        byArray5[2] = 44;
        byArray5[3] = 5;
        byArray5[5] = -1;
        byArray5[6] = -16;
        this.controlCommand = byArray5;
        this.ioIndex = ioIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int type = Configuration.ioServersType.elementAt(this.ioIndex);
        if (type == 1) {
            int commIndex = Configuration.CommPortsId.indexOf("hwgio_" + Configuration.ioServers.elementAt(this.ioIndex));
            if (commIndex < 0) {
                return;
            }
            this.commQueueTx = Configuration.CommPortsQueueTx.elementAt(commIndex);
            try {
                this.sock = SystemState.ioServersSocket[this.ioIndex];
                this.out = new BufferedOutputStream(this.sock.getOutputStream());
                this.quit = false;
            }
            catch (Exception e2) {
                hsyco.errorLog("ioCommWriter - Generic exception [" + this.ioIndex + "] - " + e2.getLocalizedMessage());
                this.quit = true;
            }
            try {
                Integer[] params = Configuration.CommPortsParams.elementAt(commIndex);
                int baudrate = params[0];
                this.baudCommand[4] = (byte)(baudrate >>> 24);
                this.baudCommand[5] = (byte)(baudrate >>> 16);
                this.baudCommand[6] = (byte)(baudrate >>> 8);
                this.baudCommand[7] = (byte)baudrate;
                Socket socket = this.sock;
                synchronized (socket) {
                    this.out.write(this.baudCommand);
                }
                int dataBits = params[1];
                this.datasizeCommand[4] = (byte)dataBits;
                Socket socket2 = this.sock;
                synchronized (socket2) {
                    this.out.write(this.datasizeCommand);
                }
                int parity = params[3] + 1;
                this.parityCommand[4] = (byte)parity;
                Socket socket3 = this.sock;
                synchronized (socket3) {
                    this.out.write(this.parityCommand);
                }
                int stopBits = params[2];
                this.stopsizeCommand[4] = (byte)stopBits;
                Socket socket4 = this.sock;
                synchronized (socket4) {
                    this.out.write(this.stopsizeCommand);
                }
                int flow = params[4] + 1;
                this.controlCommand[4] = (byte)flow;
                Socket socket5 = this.sock;
                synchronized (socket5) {
                    this.out.write(this.controlCommand);
                }
            }
            catch (Exception e3) {
                hsyco.errorLog("ioCommWriter - Serial port configuration error [" + this.ioIndex + "] - " + e3.getLocalizedMessage());
                this.quit = true;
            }
            hsyco.messageLog("ioCommWriter [" + this.ioIndex + "] started");
            while (!this.quit) {
                try {
                    byte[] ba = this.commQueueTx.poll(10L, TimeUnit.SECONDS);
                    if (ba != null) {
                        int i2 = 0;
                        while (i2 < ba.length) {
                            Socket socket = this.sock;
                            synchronized (socket) {
                                if (ba[i2] == -1) {
                                    this.out.write(ba[i2]);
                                }
                                this.out.write(ba[i2]);
                            }
                            ++i2;
                        }
                        this.out.flush();
                    }
                    this.heartbeat = System.currentTimeMillis();
                }
                catch (Exception e4) {
                    hsyco.errorLog("ioCommWriter - Generic exception [" + this.ioIndex + "] - " + e4.getLocalizedMessage());
                    this.quit = true;
                }
            }
        }
    }
}

