/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.ByteArrayOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;

class dmxCommandDispatcher
extends Thread {
    public long heartbeat = 0L;
    public boolean quit = false;
    public boolean initialized = false;
    private String serverName;
    private int dmxIndex;
    private DatagramSocket kissSocket = null;
    private InetSocketAddress kissInetAddress = null;
    private ByteArrayOutputStream out = null;
    private int[] channels = new int[513];
    private byte[] data = new byte[513];
    private int offset;
    private int state;
    private int chstart;
    private int chstop;

    public dmxCommandDispatcher(int dmxIndex) {
        this.dmxIndex = dmxIndex;
        this.serverName = Configuration.dmxServers.elementAt(dmxIndex);
        this.offset = dmxIndex * 1000;
    }

    private void merge() throws Exception {
        int i2 = this.chstart;
        while (i2 <= this.chstop) {
            this.out.reset();
            this.out.write(168);
            this.out.write(i2 >>> 8);
            this.out.write(i2 & 0xFF);
            this.kissSocket.send(new DatagramPacket(this.out.toByteArray(), this.out.size(), this.kissInetAddress));
            this.channels[i2] = -3;
            SystemState.dmxSetMode(i2 + this.offset, -3);
            ++i2;
        }
    }

    private void unmerge() throws Exception {
        int i2 = this.chstart;
        while (i2 <= this.chstop) {
            this.out.reset();
            this.out.write(169);
            this.out.write(i2 >>> 8);
            this.out.write(i2 & 0xFF);
            this.kissSocket.send(new DatagramPacket(this.out.toByteArray(), this.out.size(), this.kissInetAddress));
            this.channels[i2] = -4;
            ++i2;
        }
        SystemState.dmxClearMergeStatus(this.chstart + this.offset, this.chstop + this.offset);
    }

    private void write() throws Exception {
        this.out.reset();
        this.out.write(171);
        this.out.write(this.chstart >>> 8);
        this.out.write(this.chstart & 0xFF);
        this.out.write(this.chstop - this.chstart + 1 >>> 8);
        this.out.write(this.chstop - this.chstart + 1 & 0xFF);
        int i2 = this.chstart;
        while (i2 <= this.chstop) {
            int c2 = i2 + this.offset;
            int l2 = SystemState.dmxGet(c2);
            if (l2 != this.channels[i2]) {
                this.channels[i2] = l2;
                this.data[i2] = (byte)(userCode.DmxFilter(c2, l2, false) & 0xFF);
            }
            this.out.write(this.data[i2]);
            ++i2;
        }
        this.kissSocket.send(new DatagramPacket(this.out.toByteArray(), this.out.size(), this.kissInetAddress));
    }

    @Override
    public void run() {
        String did = Configuration.dmxServersDeviceId.elementAt(this.dmxIndex);
        if (did == null) {
            if (Configuration.dmxServersComm.elementAt(this.dmxIndex) == null) {
                this.runKiss();
            } else {
                this.runEnttec();
            }
        } else if (did.equalsIgnoreCase("dummy") || did.equalsIgnoreCase("null")) {
            this.runDummy();
        } else {
            try {
                int p = did.indexOf(46);
                String name = did.substring(0, p);
                String dev = did.substring(p + 1);
                int type = Configuration.ioServersType.elementAt(Configuration.ioServersName.indexOf(name));
                if ((type == 8 || type == 16) && dev.length() > 0) {
                    this.runDuemmegi(did);
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("dmxCommandDispatcher - dmxServersId format error [" + this.serverName + "] - quit");
                this.quit = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void runEnttec() {
        ts = 0L;
        data = new byte[518];
        port = Configuration.dmxServersComm.elementAt(this.dmxIndex);
        serial = null;
        out = null;
        data[0] = 126;
        data[1] = 6;
        data[2] = 1;
        data[3] = 2;
        data[4] = 0;
        data[517] = -25;
        try {
            serial = util.openComm(port, 0, 0, 0, 0, 0, 2000);
            out = serial.getOutputStream();
            try {
                userCode.DmxStartupEvent(this.dmxIndex);
            }
            catch (Exception e) {
                hsyco.errorLog("dmxCommandDispatcher - Exception in user event call: DmxStartupEvent(" + this.serverName + ") - " + e);
            }
            if (this.dmxIndex > 0) {
                events.eventsExec("DMXSTART" + this.dmxIndex, 0, 0, null);
            } else {
                events.eventsExec("DMXSTART", 0, 0, null);
            }
            hsyco.messageLog("dmxCommandDispatcher [" + this.serverName + "] started");
            if (true) ** GOTO lbl57
        }
        catch (Exception e) {
            hsyco.errorLog("dmxCommandDispatcher - Initialization error [" + this.serverName + "]");
            return;
        }
        do {
            try {
                ts = SystemState.dmxDispatchWait(ts, 15000);
                i = 1;
                while (i <= 512) {
                    data[i + 4] = (byte)SystemState.dmxGet(i);
                    ++i;
                }
                out.write(data);
                out.flush();
                this.heartbeat = System.currentTimeMillis();
            }
            catch (Exception e) {
                hsyco.errorLog("dmxCommandDispatcher - Communication error [" + this.serverName + "]");
                try {
                    out.close();
                }
                catch (Exception var8_11) {
                    // empty catch block
                }
                try {
                    serial.closePort();
                }
                catch (Exception var8_12) {
                    // empty catch block
                }
                this.quit = true;
            }
lbl57:
            // 3 sources

        } while (!this.quit);
    }

    public void runDummy() {
        long ts = 0L;
        hsyco.messageLog("dmxCommandDispatcher [" + this.serverName + "] started");
        while (!this.quit) {
            try {
                ts = SystemState.dmxDispatchWait(ts, 30000);
                this.heartbeat = System.currentTimeMillis();
            }
            catch (Exception e2) {
                hsyco.errorLog("dmxCommandDispatcher - Generic exception [" + this.serverName + "] - " + e2.getLocalizedMessage());
                this.quit = true;
            }
        }
    }

    public void runDuemmegi(String ioDeviceId) {
        long ts = 0L;
        hsyco.messageLog("dmxCommandDispatcher [" + this.serverName + "] started");
        while (!this.quit) {
            try {
                ts = SystemState.dmxDispatchWait(ts, 30000);
                int i2 = 1;
                while (i2 <= 64) {
                    int l2 = SystemState.dmxGet(i2 + this.offset);
                    if (l2 != this.channels[i2]) {
                        this.channels[i2] = l2;
                        SystemState.ioSet(String.valueOf(ioDeviceId) + ".#" + i2, Integer.toString(l2));
                    }
                    ++i2;
                }
                this.heartbeat = System.currentTimeMillis();
            }
            catch (Exception e2) {
                hsyco.errorLog("dmxCommandDispatcher - Generic exception [" + this.serverName + "] - " + e2.getLocalizedMessage());
                this.quit = true;
            }
        }
    }

    public void runKiss() {
        long ts = 0L;
        try {
            this.kissInetAddress = Configuration.dmxServersUDPSocket.elementAt(this.dmxIndex);
            this.kissSocket = new DatagramSocket();
            this.out = new ByteArrayOutputStream();
        }
        catch (Exception e2) {
            hsyco.errorLog("dmxCommandDispatcher - Exception for DMX Server [" + this.serverName + "] - " + e2);
            return;
        }
        if (!SystemState.dmxBusStatus(this.dmxIndex)) {
            hsyco.errorLog("dmxCommandDispatcher - Unable to retrieve status for DMX Server [" + this.serverName + "]");
            return;
        }
        try {
            userCode.DmxStartupEvent(this.dmxIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("dmxCommandDispatcher - Exception in user event call: DmxStartupEvent(" + this.serverName + ") - " + e3);
        }
        if (this.dmxIndex > 0) {
            events.eventsExec("DMXSTART" + this.dmxIndex, 0, 0, null);
        } else {
            events.eventsExec("DMXSTART", 0, 0, null);
        }
        hsyco.messageLog("dmxCommandDispatcher [" + this.serverName + "] started");
        this.initialized = true;
        try {
            while (!this.quit) {
                ts = SystemState.dmxDispatchWait(ts, 10000);
                this.chstart = 0;
                this.chstop = 0;
                this.state = -1;
                boolean busmerged = false;
                int i2 = 1;
                while (i2 <= 513) {
                    int l2;
                    if (i2 <= 512) {
                        int c2 = i2 + this.offset;
                        l2 = SystemState.dmxGetMode(c2);
                    } else {
                        l2 = -9;
                    }
                    switch (l2) {
                        case -2: {
                            switch (this.state) {
                                case -1: {
                                    this.chstart = i2;
                                    this.state = -2;
                                    break;
                                }
                                case -2: {
                                    break;
                                }
                                case -3: {
                                    this.chstart = i2;
                                    this.state = -2;
                                    break;
                                }
                                case -4: {
                                    this.chstop = i2 - 1;
                                    this.unmerge();
                                    this.chstart = i2;
                                    this.state = -2;
                                    break;
                                }
                                default: {
                                    this.chstop = i2 - 1;
                                    this.write();
                                    this.chstart = i2;
                                    this.state = -2;
                                }
                            }
                            ++i2;
                            break;
                        }
                        case -3: {
                            busmerged = true;
                            switch (this.state) {
                                case -1: {
                                    this.state = -3;
                                    break;
                                }
                                case -2: {
                                    this.chstop = i2 - 1;
                                    this.merge();
                                    this.state = -3;
                                    break;
                                }
                                case -3: {
                                    break;
                                }
                                case -4: {
                                    this.chstop = i2 - 1;
                                    this.unmerge();
                                    this.state = -3;
                                    break;
                                }
                                default: {
                                    this.chstop = i2 - 1;
                                    this.write();
                                    this.state = -3;
                                }
                            }
                            ++i2;
                            break;
                        }
                        case -4: {
                            switch (this.state) {
                                case -1: {
                                    this.chstart = i2;
                                    this.state = -4;
                                    break;
                                }
                                case -2: {
                                    this.chstop = i2 - 1;
                                    this.merge();
                                    this.chstart = i2;
                                    this.state = -4;
                                    break;
                                }
                                case -3: {
                                    this.chstart = i2;
                                    this.state = -4;
                                    break;
                                }
                                case -4: {
                                    break;
                                }
                                default: {
                                    this.chstop = i2 - 1;
                                    this.write();
                                    this.chstart = i2;
                                    this.state = -4;
                                }
                            }
                            ++i2;
                            break;
                        }
                        case -9: {
                            switch (this.state) {
                                case -1: {
                                    break;
                                }
                                case -2: {
                                    this.chstop = i2 - 1;
                                    this.merge();
                                    break;
                                }
                                case -3: {
                                    break;
                                }
                                case -4: {
                                    this.chstop = i2 - 1;
                                    this.unmerge();
                                    break;
                                }
                                default: {
                                    this.chstop = i2 - 1;
                                    this.write();
                                }
                            }
                            ++i2;
                            break;
                        }
                        default: {
                            switch (this.state) {
                                case -1: {
                                    this.chstart = i2;
                                    this.state = l2;
                                    break;
                                }
                                case -2: {
                                    this.chstop = i2 - 1;
                                    this.merge();
                                    this.chstart = i2;
                                    this.state = l2;
                                    break;
                                }
                                case -3: {
                                    this.chstart = i2;
                                    this.state = l2;
                                    break;
                                }
                                case -4: {
                                    this.chstop = i2 - 1;
                                    this.unmerge();
                                    this.chstart = i2;
                                    this.state = l2;
                                }
                            }
                            ++i2;
                        }
                    }
                }
                Configuration.dmxBusMerged[this.dmxIndex] = busmerged;
                this.heartbeat = System.currentTimeMillis();
            }
        }
        catch (Exception e4) {
            hsyco.errorLog("dmxCommandDispatcher - Exception in main loop [" + this.serverName + "]");
        }
    }
}

