/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.FileServer;
import com.hsyco.hsyco;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class X509Certificates {
    private static final String PWD_STRING = "hsycopass";
    private static final char[] PWD = "hsycopass".toCharArray();
    private static final int RSA_KEY_LENGTH = 2048;
    private static final File CERT_DIR = new File("./hsyco.cert");

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    static int generateSelfSignedCert(String cn) {
        try {
            new File("hsyco.keys").delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date validityBeginDate = new Date(System.currentTimeMillis() - 86400000L);
        Date validityEndDate = new Date(System.currentTimeMillis() + 864000000000L);
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(2048, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
            X500Principal dName = new X500Principal("CN= " + cn + ", OU=HSYCO, O=HSYCO S.r.l., L=Rozzano, S=Milano, C=IT");
            certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
            certGen.setSubjectDN(dName);
            certGen.setIssuerDN(dName);
            certGen.setNotBefore(validityBeginDate);
            certGen.setNotAfter(validityEndDate);
            certGen.setPublicKey(keyPair.getPublic());
            certGen.setSignatureAlgorithm("SHA256WithRSAEncryption");
            certGen.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            certGen.addExtension(X509Extensions.KeyUsage, true, (ASN1Encodable)new KeyUsage(160));
            certGen.addExtension(X509Extensions.ExtendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
            X509Certificate cert = certGen.generateX509Certificate(keyPair.getPrivate(), "BC");
            KeyStore privateKS = KeyStore.getInstance("JKS");
            privateKS.load(null, PWD);
            privateKS.setKeyEntry("hsyco", keyPair.getPrivate(), PWD, new Certificate[]{cert});
            FileOutputStream fos = new FileOutputStream("hsyco.keys");
            privateKS.store(fos, PWD);
            fos.close();
            return 0;
        }
        catch (Exception e2) {
            hsyco.errorLog("SELF SIGNED CERTIFICATE GENERATION EXCEPTION: " + e2.getLocalizedMessage());
            return -1;
        }
    }

    static int importCert(String cn) {
        File caCertFile = new File(CERT_DIR, "ca_bundle.crt");
        File certFile = new File(CERT_DIR, "certificate.crt");
        File privateKeyFile = new File(CERT_DIR, "private.key");
        File tempKeystoreFile = new File(CERT_DIR, "temp.p12");
        File hsycoKeystoreFile = new File(CERT_DIR, "hsyco.keys");
        try {
            if (caCertFile.canRead() && certFile.canRead() && privateKeyFile.canRead()) {
                String[] cmda = new String[]{"sh", "-c", "cat hsyco.cert/certificate.crt hsyco.cert/ca_bundle.crt | openssl pkcs12 -export -inkey hsyco.cert/private.key -name hsyco -password pass:hsycopass -out hsyco.cert/temp.p12 && keytool -noprompt -importkeystore -alias hsyco -srckeystore hsyco.cert/temp.p12 -srcstoretype PKCS12 -destkeystore hsyco.cert/hsyco.keys -deststoretype JKS -srcstorepass hsycopass -deststorepass hsycopass"};
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(cmda);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                if (Configuration.verboseLog) {
                    String s;
                    while ((s = brerr.readLine()) != null) {
                        hsyco.messageLog("CERT[E]: " + s);
                    }
                    while ((s = brout.readLine()) != null) {
                        System.out.println("CERT[O]:" + s);
                    }
                } else {
                    while (brerr.readLine() != null) {
                    }
                    while (brout.readLine() != null) {
                    }
                }
                proc.waitFor();
                brerr.close();
                brout.close();
                if (X509Certificates.checkCert(hsycoKeystoreFile, cn)) {
                    hsycoKeystoreFile.renameTo(new File("hsyco.keys"));
                    FileServer.delete(CERT_DIR.getPath(), true);
                    return 1;
                }
                return -2;
            }
            return 0;
        }
        catch (Exception e2) {
            hsyco.errorLog("CERTIFICATE IMPORT EXCEPTION: " + e2.getLocalizedMessage());
            return -1;
        }
        finally {
            FileServer.delete(tempKeystoreFile.getPath());
            FileServer.delete(hsycoKeystoreFile.getPath());
        }
    }

    static String getSelfSignedPem() {
        StringWriter sw = new StringWriter();
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream("hsyco.keys"), PWD);
            X509Certificate cert = (X509Certificate)ks.getCertificate("hsyco");
            PEMWriter pemWriter = new PEMWriter(sw);
            pemWriter.writeObject(cert);
            pemWriter.flush();
            pemWriter.close();
            String s = sw.toString();
            return s.length() > 0 ? s : null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static boolean checkCert(String cn) {
        return X509Certificates.checkCert(new File("hsyco.keys"), cn);
    }

    private static boolean checkCert(File keystore, String cn) {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            char[] kspwd = PWD_STRING.toCharArray();
            ks.load(new FileInputStream(keystore), kspwd);
            X509Certificate cert = (X509Certificate)ks.getCertificate("hsyco");
            String dn = cert.getSubjectDN().toString().toLowerCase();
            return dn.indexOf("cn=" + cn) >= 0;
        }
        catch (Exception e2) {
            return false;
        }
    }
}

